# Stargazer

Welcome to Stargazer, the most advanced theme ever created for WordPress without compromising standards. This is the only theme in the world that you'll find that extends WordPress' built-in theme features so robustly but naturally. The theme is built on the rock-solid Hybrid Core theme framework. 

It's built with search-engine optimization (SEO) in mind by utilizing the most current HTML5 conventions and [Schema.org](http://schema.org) microdata. It also integrates with useful theme add-on plugins like [Custom Background Extended](http://wordpress.org/plugins/custom-background-extended), [Custom Header Extended](http://wordpress.org/plugins/custom-header-extended), [Whistles](http://wordpress.org/plugins/whistles), and more.

## About Stargazer

Stargazer isn't just any ol' WordPress theme.  I designed it specifically for several different groups of users:

* Regular Joe: This is the type of user who doesn't know the first thing about code.  All he wants to do is have a theme that works out of the box and maybe some customization options.
* DIY Jane: This is the user who's interested in tinkering with small bits of code to customizer her site and who may eventually become a future theme author.
* Non-English Speakers: This theme has been tested from Day 1 with non-English languages, including right-to-left languages like Arabic.  WordPress is used across the globe, and this theme will help further its reach.
* Designers: This theme has a specific and limited canvas that will allow designers to show off their skills by making quick and easy child themes.

Stargazer has loads of useful features though.  The best way to get to know them is to install the theme and play around with it.

Don't like the design?  No problem.  Go check out some of the alternate designs (child themes) available on the [Stargazer theme page](http://themehybrid.com/themes/stargazer).

## Copyright and License

The following resources are not included with the theme but are external resources linked to within the theme.

* [Droid Sans Font](http://www.google.com/fonts/specimen/Droid+Serif) by Steve Matteson - Licensed under the [Apache License, version 2.0](http://www.apache.org/licenses/LICENSE-2.0.html).
* [Open Sans Font](http://www.google.com/fonts/specimen/Open+Sans) by Steve Matteson - Licensed under the [Apache License, version 2.0](http://www.apache.org/licenses/LICENSE-2.0.html).

The following resources are included within the theme package.

* [Genericons](http://genericons.com/) by Joen Asmussen - Licensed under the [GPL, version 2 or later](http://www.gnu.org/licenses/old-licenses/gpl-2.0.html).
* [Theme Mediaelement](https://github.com/justintadlock/theme-mediaelement) by John Dyer, Justin Tadlock - Licensed under the [MIT License](http://opensource.org/licenses/MIT).

All other resources and theme elements are licensed under the [GNU GPL](http://www.gnu.org/licenses/old-licenses/gpl-2.0.html), version 2 or later.

2013&thinsp;&ndash;&thinsp;2014 &copy; [Justin Tadlock](http://justintadlock.com).

## Changelog

### Version 1.2.1

* Upgraded to Hybrid Core version 2.1.0-dev.
* Added the Hebrew translation files.

### Version 1.2.0

* Upgraded to Hybrid Core version 2.0.0-rc-1.
* Made sure styles for default WordPress widgets are handled since Hybrid Core dropped widgets.
* Major accessibility improvements across the entire theme. It's not ready for the `accessibility-ready` tag yet, but it's close.
* Changed the way the search form in the Primary menu behaves (slides out rather than opening below).
* Minor correction in inconsistent blockquote cite CSS.
* Added Spanish translation files.

### Version 1.1.1

* Updated to Hybrid Core version 2.0.0-beta-2.
* Fixed missing error text on 404 and error pages.
* Corrected typo with border style in `style.css`.
* Fixed flash of missing header image when removing the image in theme customizer.
* Use `.wp-caption .wp-caption-text` so that caption text styles don't mess up gallery captions in visual editor.
* Make sure sub-lists of the comments list use the `<ol>` element.
* Added Swedish translation files.
* Added support for the [Entry Views](http://wordpress.org/plugins/entry-views) plugin.
* Make sure there's a line break before showing categories on singular views of Quote and Status posts.
* Added an exception for Amazon embeds in the embed wrap JavaScript.
* Added the `left-sidebar`, `right-sidebar`, and `responsive-layout` tags to `style.css`.

### Version 1.1.0

* Updated to Hybrid Core version 2.0.0-beta-1.
* Only use `customize.min.css` when `SCRIPT_DEBUG` is disabled.
* Embed JavaScript only targets embeds within posts.
* Re-added Dribbble support in the Social menu, which was accidentally removed.
* Fixed Mediaelement.js CSS padding issue introduced in WP 3.9.
* Full support and styling for WP 3.9's playlist feature.
* Corrected missing color definitions in the visual editor, which was introduced in WP 3.9.
* Fixed broken method of getting media info, which was a bug introduced in WP 3.9.

### Version 1.0.1

* Updated to version 3.0.3 of Genericons.
	* Uses the new "fullscreen" icon for media player.
	* Dropbox supported in the Social menu.
* Fix for JS conflict with Gravity Forms embeds.
* Fixed Subsidiary sidebar column count when using a single widget.
* Better CSS for Japanese language (`css/ja.css`).
* Added French language files.
* Added Romanian language files.

### Version 1.0.0

* Everything's new!