<?php
/**
 * Maps Marker Plugin - MMPAPI
*/
//info prevent file from being accessed directly
if (basename($_SERVER['SCRIPT_FILENAME']) == 'class-mmpapi.php') { die ("Please do not access this file directly. Thanks!<br/><a href='https://www.mapsmarker.com/go'>www.mapsmarker.com</a>"); }

class MMPAPI {

	/**
    * Returns the marker object for a given Marker ID
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param int $marker_id The ID of the Marker
    *
    * @return mixed The marker object or false
    */
	public static function get_marker( $marker_id ){
		global $wpdb;
		//info:  to make sure that the marker_id is a number
		$marker_id = intval( $marker_id );
		if($marker_id === 0) return false;
		//info:  query the database
		$marker_result = $wpdb->get_row( $wpdb->prepare("SELECT * FROM `".self::table_name_markers()."` WHERE `id` = %d", $marker_id));
		//info:  to make sure that the marker_id exists in the database
		if($marker_result === null) return false;
		return $marker_result;
	}
	/**
    * Returns the markers objects for a given markers IDs
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param int $marker_ids The IDs of the Markers
    *
    * @return mixed The marker objects or false
    */
	public static function get_markers( $marker_ids ){
		global $wpdb;
		//info:  to make sure that the marker_id is a number
		if(!is_array($marker_ids)) return false;
		//info:  query the database
		$marker_ids = implode(',', $marker_ids);
		$markers_result = $wpdb->get_results( "SELECT * FROM `".self::table_name_markers()."` WHERE `id` IN (".$marker_ids .")");
		//info:  to make sure that the marker_id exists in the database
		if($markers_result === null) return false;
		return $markers_result;
	}
	/**
    * Add a marker based on given data array
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $marker_data Data of the marker
    *
    * @return mixed int|WP_Error
    */
	public static function add_marker( $marker_data ){
		if(!is_array($marker_data)){
			return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: add_marker() method only accepts arrays. Input was %s', 'lmm' ), gettype($marker_data)), $marker_data );
		}
		global $wpdb;
		$lmm_options = self::lmm_options();
		$markername = isset($marker_data['markername']) ? $marker_data['markername'] :  '';

		$markername_quotes = str_replace("\\\\","/", str_replace("\"", "'", $markername));
		$mpopuptext = isset($marker_data['popuptext']) ? str_replace('"', '\'', preg_replace('/(\015\012)|(\015)|(\012)/','<br/>',$marker_data['popuptext'])) : '';

		$basemap = isset($marker_data['basemap']) && in_array($marker_data['basemap'], array('osm_mapnik','mapquest_osm','mapquest_aerial','googleLayer_roadmap','googleLayer_satellite','googleLayer_hybrid','googleLayer_terrain','bingaerial','bingaerialwithlabels','bingroad','ogdwien_basemap','ogdwien_satellite','mapbox','mapbox2','mapbox3','custom_basemap','custom_basemap2','custom_basemap3','empty_basemap')) ? $marker_data['basemap'] :  $lmm_options[ 'standard_basemap' ];
		$layer = isset($marker_data['layer']) ? $marker_data['layer'] : (($lmm_options[ 'defaults_marker_default_layer' ] == '0') ? '0' : $lmm_options[ 'defaults_marker_default_layer' ]);
		//info:  convert the layer id to json and add the option to assign multiple layers.
		$layer =  array_map('intval', explode (',', $layer));
		$layer = json_encode( array_map('strval', $layer ) );

		$lat = isset($marker_data['lat']) ? floatval($marker_data['lat']) :  floatval($lmm_options[ 'defaults_marker_lat' ]);
		$lon = isset($marker_data['lon']) ? floatval($marker_data['lon']) :  floatval($lmm_options[ 'defaults_marker_lon' ]);
		$icon = isset($marker_data['icon']) ? $marker_data['icon']  : (($lmm_options[ 'defaults_marker_icon' ] == NULL) ? '' : $lmm_options[ 'defaults_marker_icon' ]);
		$popuptext = $mpopuptext;
		$zoom = isset($marker_data['zoom']) ? intval($marker_data['zoom'])  : intval($lmm_options[ 'defaults_marker_zoom' ]);
		$openpopup = ( isset($marker_data['openpopup']) && ( ($marker_data['openpopup'] == '0') || ($marker_data['openpopup'] == '1')) ) ? $marker_data['openpopup']  : $lmm_options[ 'defaults_marker_openpopup' ];
		$mapwidth = isset($marker_data['mapwidth']) ? $marker_data['mapwidth'] : intval($lmm_options[ 'defaults_marker_mapwidth' ]);
		$mapwidthunit = ( isset($marker_data['mapwidthunit']) && ( ($marker_data['mapwidthunit'] == 'px') || ($marker_data['mapwidthunit'] == '%') ) ) ? $marker_data['mapwidthunit']  : $lmm_options[ 'defaults_marker_mapwidthunit' ];
		$mapheight = isset($marker_data['mapheight']) ? $marker_data['mapheight'] : intval($lmm_options[ 'defaults_marker_mapheight' ]);
		$panel = ( isset($marker_data['panel']) && ( ($marker_data['panel'] == '0') || ($marker_data['panel'] == '1')) ) ? $marker_data['panel'] : $lmm_options[ 'defaults_marker_panel' ];
		$createdby = isset($marker_data['createdby']) ? $marker_data['createdby']: 'MapsMarker API';
		$createdon = isset($marker_data['createdon']) && ( $marker_data['createdon'] == date('Y-m-d H:i:s',strtotime($marker_data['createdon'])) ) ? $marker_data['createdon'] : current_time('mysql',0);
		$updatedby = isset($marker_data['updatedby']) ? $marker_data['updatedby'] : 'MapsMarker API';
		$updatedon = isset($marker_data['updatedon']) && ( $marker_data['createdon'] == date('Y-m-d H:i:s',strtotime($marker_data['createdon'])) ) ? $marker_data['updatedon'] : current_time('mysql',0);
		$controlbox = ( isset($marker_data['controlbox']) && ( ($marker_data['controlbox'] == '0') || ($marker_data['controlbox'] == '1') || ($marker_data['controlbox'] == '2')) ) ? $marker_data['controlbox'] : $lmm_options[ 'defaults_marker_controlbox' ];
		$overlays_custom = ( isset($marker_data['overlays_custom']) && ( ($marker_data['overlays_custom'] == '0') || ($marker_data['overlays_custom'] == '1')) ) ? $marker_data['overlays_custom'] : ( isset($lmm_options[ 'defaults_layer_overlays_custom_active' ]) && $lmm_options[ 'defaults_layer_overlays_custom_active' ] != null) ? '1' : '0';
		$overlays_custom2 = ( isset($marker_data['overlays_custom2']) && ( ($marker_data['overlays_custom2'] == '0') || ($marker_data['overlays_custom2'] == '1')) ) ? $marker_data['overlays_custom2'] : ( isset($lmm_options[ 'defaults_layer_overlays_custom2_active' ]) && $lmm_options[ 'defaults_layer_overlays_custom2_active' ] != null) ? '1' : '0';
		$overlays_custom3 = ( isset($marker_data['overlays_custom3']) && ( ($marker_data['overlays_custom3'] == '0') || ($marker_data['overlays_custom3'] == '1')) ) ? $marker_data['overlays_custom3'] : ( isset($lmm_options[ 'defaults_layer_overlays_custom3_active' ]) && $lmm_options[ 'defaults_layer_overlays_custom3_active' ] != null) ? '1' : '0';
		$overlays_custom4 = ( isset($marker_data['overlays_custom4']) && ( ($marker_data['overlays_custom4'] == '0') || ($marker_data['overlays_custom4'] == '1')) ) ? $marker_data['overlays_custom4'] : ( isset($lmm_options[ 'defaults_layer_overlays_custom4_active' ]) && $lmm_options[ 'defaults_layer_overlays_custom4_active' ] != null) ? '1' : '0';
		$wms = ( isset($marker_data['wms']) && ( ($marker_data['wms'] == '0') || ($marker_data['wms'] == '1')) ) ? $marker_data['wms'] : (  isset($lmm_options['defaults_layer_wms_active']) && $lmm_options[ 'defaults_layer_wms_active'] !==0 ) ? '1' : '0';
		$wms2 = ( isset($marker_data['wms2']) && ( ($marker_data['wms2'] == '0') || ($marker_data['wms2'] == '1')) ) ? $marker_data['wms2'] : ( isset($lmm_options['defaults_layer_wms2_active']) && $lmm_options[ 'defaults_layer_wms2_active'] !=null) ? '1' : '0';
		$wms3 = ( isset($marker_data['wms3']) && ( ($marker_data['wms3'] == '0') || ($marker_data['wms3'] == '1')) ) ? $marker_data['wms3'] : ( isset($lmm_options['defaults_layer_wms3_active']) && $lmm_options[ 'defaults_layer_wms3_active'] !=null ) ? '1' : '0';
		$wms4 = ( isset($marker_data['wms4']) && ( ($marker_data['wms4'] == '0') || ($marker_data['wms4'] == '1')) ) ? $marker_data['wms4'] : ( isset($lmm_options['defaults_layer_wms4_active']) && $lmm_options[ 'defaults_layer_wms4_active'] !=null ) ? '1' : '0';
		$wms5 = ( isset($marker_data['wms5']) && ( ($marker_data['wms5'] == '0') || ($marker_data['wms5'] == '1')) ) ? $marker_data['wms5'] : ( isset($lmm_options['defaults_layer_wms5_active']) && $lmm_options[ 'defaults_layer_wms5_active'] !=null ) ? '1' : '0';
		$wms6 = ( isset($marker_data['wms6']) && ( ($marker_data['wms6'] == '0') || ($marker_data['wms6'] == '1')) ) ? $marker_data['wms6'] : ( isset($lmm_options['defaults_layer_wms6_active']) && $lmm_options[ 'defaults_layer_wms6_active'] !=null ) ? '1' : '0';
		$wms7 = ( isset($marker_data['wms7']) && ( ($marker_data['wms7'] == '0') || ($marker_data['wms7'] == '1')) ) ? $marker_data['wms7'] : ( isset($lmm_options['defaults_layer_wms7_active']) && $lmm_options[ 'defaults_layer_wms7_active'] !=null ) ? '1' : '0';
		$wms8 = ( isset($marker_data['wms8']) && ( ($marker_data['wms8'] == '0') || ($marker_data['wms8'] == '1')) ) ? $marker_data['wms8'] : ( isset($lmm_options['defaults_layer_wms8_active']) && $lmm_options[ 'defaults_layer_wms8_active'] !=null ) ? '1' : '0';
		$wms9 = ( isset($marker_data['wms9']) && ( ($marker_data['wms9'] == '0') || ($marker_data['wms9'] == '1')) ) ? $marker_data['wms9'] : ( isset($lmm_options['defaults_layer_wms9_active']) && $lmm_options[ 'defaults_layer_wms9_active'] !=null ) ? '1' : '0';
		$wms10 = ( isset($marker_data['wms10']) && ( ($marker_data['wms10'] == '0') || ($marker_data['wms10'] == '1')) ) ? $marker_data['wms10'] : (isset($lmm_options['defaults_layer_wms10_active']) && $lmm_options[ 'defaults_layer_wms10_active'] !==0 ) ? '1' : '0';

		$kml_timestamp = isset($marker_data['kml_timestamp']) && ( $marker_data['kml_timestamp'] == date('Y-m-d H:i:s',strtotime($marker_data['kml_timestamp'])) ) ? $marker_data['kml_timestamp'] : '';
		$address = isset($marker_data['address']) ? $marker_data['address'] : '';
		$gpx_url = isset($marker_data['gpx_url']) ? $marker_data['gpx_url'] : '';
		$gpx_panel = ( isset($marker_data['gpx_panel']) && ( ($marker_data['gpx_panel'] == '0') || ($marker_data['gpx_panel'] == '1')) ) ? $marker_data['gpx_panel'] : '0';
		$geocode = isset($marker_data['geocode'])? $marker_data['geocode']: '';
		if ($geocode != '') {
				$do_geocoding = self::getLatLng($geocode);
			if ($do_geocoding['success'] == true) {
				$lat = $do_geocoding['lat'];
				$lon = $do_geocoding['lon'];
				$address = $do_geocoding['address'];
			}else{
				return new WP_Error( 'geocode_failed', sprintf( __( 'MMPAPI error: geocoding error: %1s', 'lmm' ), $do_geocoding['message'] ), $marker_data );
			}
		}
		if ($kml_timestamp == NULL) {
			$query_add = $wpdb->prepare( "INSERT INTO `".self::table_name_markers()."` (`markername`, `basemap`, `layer`, `lat`, `lon`, `icon`, `popuptext`, `zoom`, `openpopup`, `mapwidth`, `mapwidthunit`, `mapheight`, `panel`, `createdby`, `createdon`, `updatedby`, `updatedon`, `controlbox`, `overlays_custom`, `overlays_custom2`, `overlays_custom3`, `overlays_custom4`, `wms`, `wms2`, `wms3`, `wms4`, `wms5`, `wms6`, `wms7`, `wms8`, `wms9`, `wms10`, `address`, `gpx_url`, `gpx_panel`) VALUES (%s, %s, %s, %s, %s, %s, %s, %d, %d, %d, %s, %d, %d, %s, %s, %s, %s, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %s, %s, %d )", $markername_quotes, $basemap, $layer, str_replace(',', '.', $lat), str_replace(',', '.', $lon), $icon, $popuptext, $zoom, $openpopup, $mapwidth, $mapwidthunit, $mapheight, $panel, $createdby, $createdon, $updatedby, $updatedon, $controlbox, $overlays_custom, $overlays_custom2, $overlays_custom3, $overlays_custom4, $wms, $wms2, $wms3, $wms4, $wms5, $wms6, $wms7, $wms8, $wms9, $wms10, $address, $gpx_url, $gpx_panel );
		} else {
			$query_add = $wpdb->prepare( "INSERT INTO `".self::table_name_markers()."` (`markername`, `basemap`, `layer`, `lat`, `lon`, `icon`, `popuptext`, `zoom`, `openpopup`, `mapwidth`, `mapwidthunit`, `mapheight`, `panel`, `createdby`, `createdon`, `updatedby`, `updatedon`, `controlbox`, `overlays_custom`, `overlays_custom2`, `overlays_custom3`, `overlays_custom4`, `wms`, `wms2`, `wms3`, `wms4`, `wms5`, `wms6`, `wms7`, `wms8`, `wms9`, `wms10`, `kml_timestamp`, `address`, `gpx_url`, `gpx_panel`) VALUES (%s, %s, %s, %s, %s, %s, %s, %d, %d, %d, %s, %d, %d, %s, %s, %s, %s, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %s, %s, %s, %d )", $markername_quotes, $basemap, $layer, str_replace(',', '.', $lat), str_replace(',', '.', $lon), $icon, $popuptext, $zoom, $openpopup, $mapwidth, $mapwidthunit, $mapheight, $panel, $createdby, $createdon, $updatedby, $updatedon, $controlbox, $overlays_custom, $overlays_custom2, $overlays_custom3, $overlays_custom4, $wms, $wms2, $wms3, $wms4, $wms5, $wms6, $wms7, $wms8, $wms9, $wms10, $kml_timestamp, $address, $gpx_url, $gpx_panel );
		}
		$result_add = $wpdb->query( $query_add );
		return ($result_add === 1)?$wpdb->insert_id:FALSE;
	}

	/**
    * Add markers based on given data object
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $marker_data Data of the marker
    *
    * @return array|WP_Error IDs of added markers or an error object.
    */
	public static function add_markers( $markers_data ){

		if(! $markers_data || !is_array($markers_data)){
			return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: invalid marker objects. Input was %s', 'lmm' ), gettype($markers_data)), $markers_data );
		}
        $marker_ids = array();
        foreach ( $markers_data as $marker ) {
          $result = self::add_marker( $marker );
          if ( is_wp_error( $result ) ) {
              return $result;
          }
          $marker_ids[] = $result;
        }
        return $marker_ids;
	}

	/**
    * Update a marker based on given data object
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $marker_data Data of the marker
    *
    * @return boolean
    */
	public static function update_marker( $marker_data ){
			$lmm_options = self::lmm_options();
			global $wpdb;
			$id = isset($marker_data['id']) ? $marker_data['id'] : '';
			$query_view = $wpdb->get_row( $wpdb->prepare("SELECT * FROM `". self::table_name_markers() ."` WHERE `id` = %d", $id), ARRAY_A);
			if (count($query_view) >= 1) {
				$mpopuptext = stripslashes(str_replace('"', '\'', preg_replace('/(\015\012)|(\015)|(\012)/','<br/>',$query_view['popuptext'])));
				$address = stripslashes(str_replace('"', '\'', $query_view['address']));
				$markername = isset($marker_data['markername']) ? $marker_data['markername']  : $query_view['markername'];
				$markername_quotes = str_replace("\\\\","/", str_replace("\"", "'", $markername)); //info: backslash breaks GeoJSON
				$basemap = isset($marker_data['basemap']) && in_array($marker_data['basemap'], array('osm_mapnik','mapquest_osm','mapquest_aerial','googleLayer_roadmap','googleLayer_satellite','googleLayer_hybrid','googleLayer_terrain','bingaerial','bingaerialwithlabels','bingroad','ogdwien_basemap','ogdwien_satellite','mapbox','mapbox2','mapbox3','custom_basemap','custom_basemap2','custom_basemap3','empty_basemap')) ? $marker_data['basemap'] : $query_view['basemap'];

				$layer = isset($marker_data['layer']) ? $marker_data['layer'] : $query_view['layer'];
				if($layer !== $query_view['layer']){
					//info:  convert the layer id to json and add the option to assign multiple layers.
					$layer =  array_map('intval', explode (',', $layer));
					$layer = json_encode( array_map('strval', $layer ) );
				}
				$lat = isset($marker_data['lat']) ? floatval($marker_data['lat']): $query_view['lat'];
				$lon = isset($marker_data['lon']) ? floatval($marker_data['lon']): $query_view['lon'];
				$icon = isset($marker_data['icon']) ? $marker_data['icon']  : (($lmm_options[ 'defaults_marker_icon' ] == NULL) ? '' : $query_view['icon']);
				$popuptext = isset($marker_data['popuptext']) ? $marker_data['popuptext'] : $mpopuptext;
				$zoom = isset($marker_data['zoom']) ? intval($marker_data['zoom']) : $query_view['zoom'];
				$openpopup = ( isset($marker_data['openpopup']) && ( ($marker_data['openpopup'] == '0') || ($marker_data['openpopup'] == '1')) ) ? $marker_data['openpopup'] : $query_view['openpopup'];
				$mapwidth = isset($marker_data['mapwidth']) ? $marker_data['mapwidth'] :  $query_view['mapwidth'];
				$mapwidthunit = ( isset($marker_data['mapwidthunit']) && ( ($marker_data['mapwidthunit'] == 'px') || ($marker_data['mapwidthunit'] == '%') ) ) ? $marker_data['mapwidthunit'] : $query_view['mapwidthunit'];
				$mapheight = isset($marker_data['mapheight']) ? $marker_data['mapheight'] : $query_view['mapheight'];
				$panel = ( isset($marker_data['panel']) && ( ($marker_data['panel'] == '0') || ($marker_data['panel'] == '1')) ) ? $marker_data['panel'] :  $query_view['panel'];
				$createdby = isset($marker_data['createdby']) ? $marker_data['createdby'] : $query_view['createdby'];
				$createdon = isset($marker_data['createdon']) && ( $marker_data['createdon'] == date('Y-m-d H:i:s',strtotime($marker_data['createdon'])) ) ? $marker_data['createdon'] : $query_view['createdon'];
				$updatedby = isset($marker_data['updatedby']) ? $marker_data['updatedby'] : $query_view['updatedby'];
				$updatedon = isset($marker_data['updatedon']) && ( isset($marker_data['createdon']) && $marker_data['createdon'] == date('Y-m-d H:i:s',strtotime($marker_data['createdon'])) ) ? $marker_data['updatedon'] : current_time('mysql',0);
				$controlbox = ( isset($marker_data['controlbox']) && ( ($marker_data['controlbox'] == '0') || ($marker_data['controlbox'] == '1') || ($marker_data['controlbox'] == '2')) ) ? $marker_data['controlbox'] : $query_view['controlbox'];
				$overlays_custom = ( isset($marker_data['overlays_custom']) && ( ($marker_data['overlays_custom'] == '0') || ($marker_data['overlays_custom'] == '1')) ) ? $marker_data['overlays_custom'] : $query_view['overlays_custom'];
				$overlays_custom2 = ( isset($marker_data['overlays_custom2']) && ( ($marker_data['overlays_custom2'] == '0') || ($marker_data['overlays_custom2'] == '1')) ) ? $marker_data['overlays_custom2'] : $query_view['overlays_custom2'];
				$overlays_custom3 = ( isset($marker_data['overlays_custom3']) && ( ($marker_data['overlays_custom3'] == '0') || ($marker_data['overlays_custom3'] == '1')) ) ? $marker_data['overlays_custom3'] : $query_view['overlays_custom3'];
				$overlays_custom4 = ( isset($marker_data['overlays_custom4']) && ( ($marker_data['overlays_custom4'] == '0') || ($marker_data['overlays_custom4'] == '1')) ) ? $marker_data['overlays_custom4'] : $query_view['overlays_custom4'];
				$wms = ( isset($marker_data['wms']) && ( ($marker_data['wms'] == '0') || ($marker_data['wms'] == '1')) ) ? $marker_data['wms'] : $query_view['wms'];
				$wms2 = ( isset($marker_data['wms2']) && ( ($marker_data['wms2'] == '0') || ($marker_data['wms2'] == '1')) ) ? $marker_data['wms2'] : $query_view['wms2'];
				$wms3 = ( isset($marker_data['wms3']) && ( ($marker_data['wms3'] == '0') || ($marker_data['wms3'] == '1')) ) ? $marker_data['wms3'] : $query_view['wms3'];
				$wms4 = ( isset($marker_data['wms4']) && ( ($marker_data['wms4'] == '0') || ($marker_data['wms4'] == '1')) ) ? $marker_data['wms4'] : $query_view['wms4'];
				$wms5 = ( isset($marker_data['wms5']) && ( ($marker_data['wms5'] == '0') || ($marker_data['wms5'] == '1')) ) ? $marker_data['wms5'] : $query_view['wms5'];
				$wms6 = ( isset($marker_data['wms6']) && ( ($marker_data['wms6'] == '0') || ($marker_data['wms6'] == '1')) ) ? $marker_data['wms6'] : $query_view['wms6'];
				$wms7 = ( isset($marker_data['wms7']) && ( ($marker_data['wms7'] == '0') || ($marker_data['wms7'] == '1')) ) ? $marker_data['wms7'] : $query_view['wms7'];
				$wms8 = ( isset($marker_data['wms8']) && ( ($marker_data['wms8'] == '0') || ($marker_data['wms8'] == '1')) ) ? $marker_data['wms8'] : $query_view['wms8'];
				$wms9 = ( isset($marker_data['wms9']) && ( ($marker_data['wms9'] == '0') || ($marker_data['wms9'] == '1')) ) ? $marker_data['wms9'] : $query_view['wms9'];
				$wms10 = ( isset($marker_data['wms10']) && ( ($marker_data['wms10'] == '0') || ($marker_data['wms10'] == '1')) ) ? $marker_data['wms10'] : $query_view['wms10'];
				$kml_timestamp = isset($marker_data['kml_timestamp']) && ( $marker_data['kml_timestamp'] == date('Y-m-d H:i:s',strtotime($marker_data['kml_timestamp'])) ) ? $marker_data['kml_timestamp'] : $query_view['kml_timestamp'];
				$address = isset($marker_data['address']) ? $marker_data['address'] : $address;
				$gpx_url = isset($marker_data['gpx_url']) ? $marker_data['gpx_url'] : $query_view['gpx_url'];
				$gpx_panel = ( isset($marker_data['gpx_panel']) && ( ($marker_data['gpx_panel'] == '0') || ($marker_data['gpx_panel'] == '1')) ) ? $marker_data['gpx_panel'] : $query_view['gpx_panel'];
				$geocode = isset($marker_data['geocode'])? $marker_data['geocode']: '';
				if ($geocode != NULL) {
					$do_geocoding = self::getLatLng($geocode);

					if ($do_geocoding['success'] == true) {
						$lat = $do_geocoding['lat'];
						$lon = $do_geocoding['lon'];
						$address = $do_geocoding['address'];
					} else {
						return new WP_Error( 'geocode_failed', sprintf( __( 'MMPAPI error: geocoding error: %1s', 'lmm' ), $do_geocoding['message'] ), $marker_data );
					}
				}
				if ($kml_timestamp == NULL) {
					$query_update = $wpdb->prepare( "UPDATE `". self::table_name_markers() ."` SET `markername` = %s, `basemap` = %s, `layer` = %s, `lat` = %s, `lon` = %s, `icon` = %s, `popuptext` = %s, `zoom` = %d, `openpopup` = %d, `mapwidth` = %d, `mapwidthunit` = %s, `mapheight` = %d, `panel` = %d, `createdby` = %s, `createdon` = %s, `updatedby` = %s, `updatedon` = %s, `controlbox` = %d, `overlays_custom` = %s, `overlays_custom2` = %s, `overlays_custom3` = %s, `overlays_custom4` = %s, `wms` = %d, `wms2` = %d, `wms3` = %d, `wms4` = %d, `wms5` = %d, `wms6` = %d, `wms7` = %d, `wms8` = %d, `wms9` = %d, `wms10` = %d, `address` = %s, `gpx_url` = %s, `gpx_panel` = %d WHERE `id` = %d", $markername_quotes, $basemap, $layer, str_replace(',', '.', $lat), str_replace(',', '.', $lon), $icon, $popuptext, $zoom, $openpopup, $mapwidth, $mapwidthunit, $mapheight, $panel, $createdby, $createdon, $updatedby, $updatedon, $controlbox, $overlays_custom, $overlays_custom2, $overlays_custom3, $overlays_custom4, $wms, $wms2, $wms3, $wms4, $wms5, $wms6, $wms7, $wms8, $wms9, $wms10, $address, $gpx_url, $gpx_panel, $id );
				} else {
					$query_update = $wpdb->prepare( "UPDATE `". self::table_name_markers() ."` SET `markername` = %s, `basemap` = %s, `layer` = %s, `lat` = %s, `lon` = %s, `icon` = %s, `popuptext` = %s, `zoom` = %d, `openpopup` = %d, `mapwidth` = %d, `mapwidthunit` = %s, `mapheight` = %d, `panel` = %d, `createdby` = %s, `createdon` = %s, `updatedby` = %s, `updatedon` = %s, `controlbox` = %d, `overlays_custom` = %s, `overlays_custom2` = %s, `overlays_custom3` = %s, `overlays_custom4` = %s, `wms` = %d, `wms2` = %d, `wms3` = %d, `wms4` = %d, `wms5` = %d, `wms6` = %d, `wms7` = %d, `wms8` = %d, `wms9` = %d, `wms10` = %d, `kml_timestamp` = %s, `address` = %s, `gpx_url` = %s, `gpx_panel` = %d WHERE `id` = %d", $markername_quotes, $basemap, $layer, str_replace(',', '.', $lat), str_replace(',', '.', $lon), $icon, $popuptext, $zoom, $openpopup, $mapwidth, $mapwidthunit, $mapheight, $panel, $createdby, $createdon, $updatedby, $updatedon, $controlbox, $overlays_custom, $overlays_custom2, $overlays_custom3, $overlays_custom4, $wms, $wms2, $wms3, $wms4, $wms5, $wms6, $wms7, $wms8, $wms9, $wms10, $kml_timestamp, $address, $gpx_url, $gpx_panel, $id );
				}
				$result_update = $wpdb->query( $query_update );
				return ($result_update === 1)?TRUE:FALSE;
			}else{
				return new WP_Error( 'not_found', sprintf( __( 'MMPAPI error: marker ID %1s was not found', 'lmm' ), $id ), $marker_data );
			}
	}

	/**
    * Add markers based on given data object
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $marker_data Data of the marker
    *
    * @return array|WP_Error IDs of added markers or an error object.
    */
	public static function update_markers(  $markers_data  ){
		if(! $markers_data || !is_array($markers_data)){
			return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: invalid marker objects. Input was %s', 'lmm' ), gettype($markers_data)), $markers_data );
		}
        $marker_ids = array();
        foreach ( $markers_data as $marker ) {
          $result = self::update_marker( $marker );
          if ( is_wp_error( $result ) ) {
              return $result;
          }
          $marker_ids[$marker['id']] = $result;
        }
        return $marker_ids;
	}

	/**
    * Deletes the marker for a given Marker ID
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param int $marker_id The ID of the Marker
    *
    * @return mixed TRUE if the marker deleted successfully, WP_Error object if not
    */
	public static function delete_marker( $marker_id ){
		global $wpdb;
		//info:  to make sure that the marker_id is a number
		$marker_id = intval( $marker_id );
		if($marker_id === 0) return new WP_Error( 'invalid_parameter',  __( 'MMPAPI error: delete_marker method only accepts integers', 'lmm' ), $marker_id );
		//info:  query the database
		$marker_result = $wpdb->query( $wpdb->prepare("DELETE  FROM `".self::table_name_markers()."` WHERE `id` = %d", $marker_id));
		//info:  it will return false if the number of rows affected is zero, and it will return true otherwise.
		if($marker_result === 0){
			return new WP_Error( 'not_found', sprintf( __( 'MMPAPI error: marker with ID %s not found', 'lmm' ), $marker_id ), $marker_id );
		}else{
			return true;
		}

	}

	/**
    * Deletes the markers for a given Markers IDs
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $marker_ids The IDs of the Markers
    *
    * @return boolean true if the markers deleted successfully, WP_Error object if not
    */
	public static function delete_markers( $marker_ids = array() ){
		global $wpdb;
		//info:  to make sure that the marker_id is an array
		if(!is_array($marker_ids)){
			 return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: delete_markers method only accepts arrays. Input was %s', 'lmm' ), gettype($marker_ids)), $marker_ids );
		}
		//info:  to make sure that the marker_ids is not empty
		if(empty($marker_ids)) return new WP_Error( 'empty_parameter', __( 'MMPAPI error: delete_markers method does not accept empty arrays.', 'lmm' ), $marker_ids );
		//info:  in case of one or more elements of the array were not integers.
		$marker_ids = array_map('intval', $marker_ids);
		if(in_array(0, $marker_ids)){
			 return new WP_Error( 'invalid_parameter', __( 'MMPAPI error: all the elements of marker_ids array must be integers', 'lmm' ), $marker_ids );
		}
		//info:  query the database
		$marker_ids = implode(',', $marker_ids);

		$marker_result = $wpdb->query( "DELETE  FROM `".self::table_name_markers()."` WHERE `id` IN (".$marker_ids.")" );
		return ($marker_result !== 0);
	}

	/**
    * Returns the layer object for a given Layer ID
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param int $layer_id The ID of the Layer
    *
    * @return mixed The layer object or false
    */
	public static function get_layer( $layer_id ){
		global $wpdb;
		//info:  to make sure that the layer_id is a number
		$layer_id = intval( $layer_id );
		if($layer_id === 0) return false;
		//info:  query the database
		$layer_result = $wpdb->get_row( $wpdb->prepare("SELECT * FROM `".self::table_name_layers()."` WHERE `id` = %d", $layer_id));
		//info:  to make sure that the layer_id exists in the database
		if($layer_result === null) return false;
		return $layer_result;
	}

	/**
    * Add a layer based on given data array
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $layer_data Data of the layer
    *
    * @return mixed int|WP_Error
    */
	public static function add_layer( $layer_data ){
		global $wpdb;
		$lmm_options = self::lmm_options();
		$name = isset($layer_data['name']) ? $layer_data['name'] : '';
		$name_quotes = str_replace("\\\\","/", str_replace("\"", "'", $name));
		$basemap = isset($layer_data['basemap']) && in_array($layer_data['basemap'], array('osm_mapnik','mapquest_osm','mapquest_aerial','googleLayer_roadmap','googleLayer_satellite','googleLayer_hybrid','googleLayer_terrain','bingaerial','bingaerialwithlabels','bingroad','ogdwien_basemap','ogdwien_satellite','mapbox','mapbox2','mapbox3','custom_basemap','custom_basemap2','custom_basemap3','empty_basemap')) ? $layer_data['basemap'] : $lmm_options[ 'standard_basemap' ];
		$layerzoom = isset($layer_data['layerzoom']) ? intval($layer_data['layerzoom']) :  intval($lmm_options[ 'defaults_layer_zoom' ]);
		$mapwidth = isset($layer_data['mapwidth']) ? $layer_data['mapwidth'] : intval($lmm_options[ 'defaults_layer_mapwidth' ]);
		$mapwidthunit = ( isset($layer_data['mapwidthunit']) && ( ($layer_data['mapwidthunit'] == 'px') || ($layer_data['mapwidthunit'] == '%') ) ) ? $layer_data['mapwidthunit'] : $lmm_options[ 'defaults_layer_mapwidthunit' ];
		$mapheight = isset($layer_data['mapheight']) ? $layer_data['mapheight'] : intval($lmm_options[ 'defaults_layer_mapheight' ]);
		$panel = ( isset($layer_data['panel']) && ( ($layer_data['panel'] == '0') || ($layer_data['panel'] == '1')) ) ? $layer_data['panel'] :  $lmm_options[ 'defaults_layer_panel' ];
		$layerviewlat = isset($layer_data['layerviewlat']) ? floatval($layer_data['layerviewlat']) :  floatval($lmm_options[ 'defaults_layer_lat' ]);
		$layerviewlon = isset($layer_data['layerviewlon']) ? floatval($layer_data['layerviewlon']) : floatval($lmm_options[ 'defaults_layer_lon' ]);
		$createdby = isset($layer_data['createdby']) ? $layer_data['createdby'] : 'MapsMarker API';
		$createdon = isset($layer_data['createdon']) && ( $layer_data['createdon'] == date('Y-m-d H:i:s',strtotime($layer_data['createdon'])) ) ? $layer_data['createdon'] : current_time('mysql',0);
		$updatedby = isset($layer_data['updatedby']) ? $layer_data['updatedby'] : 'MapsMarker API';
		$updatedon = isset($layer_data['updatedon']) && ( $layer_data['createdon'] == date('Y-m-d H:i:s',strtotime($layer_data['createdon'])) ) ? $layer_data['updatedon'] :  current_time('mysql',0);
		$controlbox = ( isset($layer_data['controlbox']) && ( ($layer_data['controlbox'] == '0') || ($layer_data['controlbox'] == '1') || ($layer_data['controlbox'] == '2')) ) ? $layer_data['controlbox'] :  $lmm_options[ 'defaults_layer_controlbox' ];
		$overlays_custom = ( isset($layer_data['overlays_custom']) && ( ($layer_data['overlays_custom'] == '0') || ($layer_data['overlays_custom'] == '1')) ) ? $layer_data['overlays_custom'] : ($lmm_options[ 'defaults_layer_overlays_custom_active' ] !== 0) ? '1' : '0';
		$overlays_custom2 = ( isset($layer_data['overlays_custom2']) && ( ($layer_data['overlays_custom2'] == '0') || ($layer_data['overlays_custom2'] == '1')) ) ? $layer_data['overlays_custom2'] : ($lmm_options[ 'defaults_layer_overlays_custom2_active' ] !== 0) ? '1' : '0';
		$overlays_custom3 = ( isset($layer_data['overlays_custom3']) && ( ($layer_data['overlays_custom3'] == '0') || ($layer_data['overlays_custom3'] == '1')) ) ? $layer_data['overlays_custom3'] : ($lmm_options[ 'defaults_layer_overlays_custom3_active' ] !== 0) ? '1' : '0';
		$overlays_custom4 = ( isset($layer_data['overlays_custom4']) && ( ($layer_data['overlays_custom4'] == '0') || ($layer_data['overlays_custom4'] == '1')) ) ? $layer_data['overlays_custom4'] : ($lmm_options[ 'defaults_layer_overlays_custom4_active' ] !== 0) ? '1' : '0';
		$wms = ( isset($layer_data['wms']) && ( ($layer_data['wms'] == '0') || ($layer_data['wms'] == '1')) ) ? $layer_data['wms'] : ($lmm_options[ 'defaults_layer_wms_active'] !==0 ) ? '1' : '0';
		$wms2 = ( isset($layer_data['wms2']) && ( ($layer_data['wms2'] == '0') || ($layer_data['wms2'] == '1')) ) ? $layer_data['wms2'] : ($lmm_options[ 'defaults_layer_wms2_active'] !==0) ? '1' : '0';
		$wms3 = ( isset($layer_data['wms3']) && ( ($layer_data['wms3'] == '0') || ($layer_data['wms3'] == '1')) ) ? $layer_data['wms3'] : ($lmm_options[ 'defaults_layer_wms3_active'] !==0 ) ? '1' : '0';
		$wms4 = ( isset($layer_data['wms4']) && ( ($layer_data['wms4'] == '0') || ($layer_data['wms4'] == '1')) ) ? $layer_data['wms4'] : ($lmm_options[ 'defaults_layer_wms4_active'] !==0 ) ? '1' : '0';
		$wms5 = ( isset($layer_data['wms5']) && ( ($layer_data['wms5'] == '0') || ($layer_data['wms5'] == '1')) ) ? $layer_data['wms5'] : ($lmm_options[ 'defaults_layer_wms5_active'] !==0 ) ? '1' : '0';
		$wms6 = ( isset($layer_data['wms6']) && ( ($layer_data['wms6'] == '0') || ($layer_data['wms6'] == '1')) ) ? $layer_data['wms6'] : ($lmm_options[ 'defaults_layer_wms6_active'] !==0 ) ? '1' : '0';
		$wms7 = ( isset($layer_data['wms7']) && ( ($layer_data['wms7'] == '0') || ($layer_data['wms7'] == '1')) ) ? $layer_data['wms7'] : ($lmm_options[ 'defaults_layer_wms7_active'] !==0 ) ? '1' : '0';
		$wms8 = ( isset($layer_data['wms8']) && ( ($layer_data['wms8'] == '0') || ($layer_data['wms8'] == '1')) ) ? $layer_data['wms8'] : ($lmm_options[ 'defaults_layer_wms8_active'] !==0 ) ? '1' : '0';
		$wms9 = ( isset($layer_data['wms9']) && ( ($layer_data['wms9'] == '0') || ($layer_data['wms9'] == '1')) ) ? $layer_data['wms9'] : ($lmm_options[ 'defaults_layer_wms9_active'] !==0 ) ? '1' : '0';
		$wms10 = ( isset($layer_data['wms10']) && ( ($layer_data['wms10'] == '0') || ($layer_data['wms10'] == '1')) ) ? $layer_data['wms10'] : ($lmm_options[ 'defaults_layer_wms10_active'] !==0 ) ? '1' : '0';
		$listmarkers = ( isset($layer_data['listmarkers']) && ( ($layer_data['listmarkers'] == '0') || ($layer_data['listmarkers'] == '1')) ) ? $layer_data['listmarkers'] : (isset($lmm_options[ 'defaults_layer_listmarkers' ]) ? '1' : '0');
		$multi_layer_map = ( isset($layer_data['multi_layer_map']) && ( ($layer_data['multi_layer_map'] == '0') || ($layer_data['multi_layer_map'] == '1')) ) ? $layer_data['multi_layer_map'] : '0';
		$multi_layer_map_list = isset($layer_data['multi_layer_map_list']) ? $layer_data['multi_layer_map_list'] : '';
		$address = isset($layer_data['address']) ? $layer_data['address'] : '';
		$clustering = ( isset($layer_data['clustering']) && ( ($layer_data['clustering'] == '0') || ($layer_data['clustering'] == '1')) ) ? $layer_data['clustering'] : ($lmm_options[ 'defaults_layer_clustering' ] == 'enabled') ? '1' : '0';
		$gpx_url = isset($layer_data['gpx_url']) ? $layer_data['gpx_url'] : '';
		$gpx_panel = ( isset($layer_data['gpx_panel']) && ( ($layer_data['gpx_panel'] == '0') || ($layer_data['gpx_panel'] == '1')) ) ? $layer_data['gpx_panel'] :  '0';
		$geocode = isset($layer_data['geocode'])? $layer_data['geocode']: '';
		if ($geocode != '') {
				$do_geocoding = self::getLatLng($geocode);
			if ($do_geocoding['success'] == true) {
				$layerviewlat = $do_geocoding['lat'];
				$layerviewlon = $do_geocoding['lon'];
				$address = $do_geocoding['address'];
			}else{
				return new WP_Error( 'geocode_failed', sprintf( __( 'MMPAPI error: geocoding error: %1s', 'lmm' ), $do_geocoding['message'] ), $layer_data );
			}
		}

		$query_add = $wpdb->prepare( "INSERT INTO `". self::table_name_layers() ."` (`name`, `basemap`, `layerzoom`, `mapwidth`, `mapwidthunit`, `mapheight`, `panel`, `layerviewlat`, `layerviewlon`, `createdby`, `createdon`, `updatedby`, `updatedon`, `controlbox`, `overlays_custom`, `overlays_custom2`, `overlays_custom3`, `overlays_custom4`, `wms`, `wms2`, `wms3`, `wms4`, `wms5`, `wms6`, `wms7`, `wms8`, `wms9`, `wms10`, `listmarkers`, `multi_layer_map`, `multi_layer_map_list`, `address`, `clustering`, `gpx_url`, `gpx_panel` ) VALUES (%s, %s, %d, %d, %s, %d, %d, %s, %s, %s, %s, %s, %s, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %d, %s, %s, %d, %s, %d)", $name_quotes, $basemap, $layerzoom, $mapwidth, $mapwidthunit, $mapheight, $panel, str_replace(',', '.', $layerviewlat), str_replace(',', '.', $layerviewlon), $createdby, $createdon, $updatedby, $updatedon, $controlbox, $overlays_custom, $overlays_custom2, $overlays_custom3, $overlays_custom4, $wms, $wms2, $wms3, $wms4, $wms5, $wms6, $wms7, $wms8, $wms9, $wms10, $listmarkers, $multi_layer_map, $multi_layer_map_list, $address, $clustering, $gpx_url, $gpx_panel );
		$result_add = $wpdb->query( $query_add );

		return ($result_add === 1)?$wpdb->insert_id:FALSE;

	}

	/**
    * Add layers based on given data object
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $layers_data Data of the marker
    *
    * @return array int|WP_Error
    */
	public static function add_layers( $layers_data ){
		if(! $layers_data || !is_array($layers_data)){
			return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: invalid marker objects. Input was %s', 'lmm' ), gettype($layers_data)), $layers_data );
		}
        $layer_ids = array();
        foreach ( $layers_data as $layer ) {
          $result = self::add_layer( $layer );
          if ( is_wp_error( $result ) ) {
              return $result;
          }
          $layer_ids[] = $result;
        }
        return $layer_ids;
	}

	/**
    * Update a layer based on given data object
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $layer_data Data of the layer
    *
    * @return boolean
    */
	public static function update_layer(  $layer_data ){
		$lmm_options = self::lmm_options();
		global $wpdb;
		$id = isset($layer_data['id']) ? $layer_data['id'] : '';
		$query_view = $wpdb->get_row( $wpdb->prepare("SELECT * FROM `". self::table_name_layers() ."` WHERE `id` = %d", $id), ARRAY_A);
		if (count($query_view) >= 1) {
			$name = isset($layer_data['name']) ? $layer_data['name'] :  $query_view['name'];
			$name_quotes = str_replace("\\\\","/", str_replace("\"", "'", $name));
			$basemap = isset($layer_data['basemap']) && in_array($layer_data['basemap'], array('osm_mapnik','mapquest_osm','mapquest_aerial','googleLayer_roadmap','googleLayer_satellite','googleLayer_hybrid','googleLayer_terrain','bingaerial','bingaerialwithlabels','bingroad','ogdwien_basemap','ogdwien_satellite','mapbox','mapbox2','mapbox3','custom_basemap','custom_basemap2','custom_basemap3','empty_basemap')) ? $layer_data['basemap'] :  $query_view['basemap'];
			$layerzoom = isset($layer_data['layerzoom']) ? intval($layer_data['layerzoom']) : $query_view['layerzoom'];
			$mapwidth = isset($layer_data['mapwidth']) ? $layer_data['mapwidth'] : $query_view['mapwidth'];
			$mapwidthunit = ( isset($layer_data['mapwidthunit']) && ( ($layer_data['mapwidthunit'] == 'px') || ($layer_data['mapwidthunit'] == '%') ) ) ? $layer_data['mapwidthunit'] :  $query_view['mapwidthunit'];
			$mapheight = isset($layer_data['mapheight']) ? $layer_data['mapheight'] : $query_view['mapheight'];
			$panel = ( isset($layer_data['panel']) && ( ($layer_data['panel'] == '0') || ($layer_data['panel'] == '1')) ) ? $layer_data['panel'] : $query_view['panel'];
			$layerviewlat = isset($layer_data['layerviewlat']) ? floatval($layer_data['layerviewlat']) : $query_view['layerviewlat'];
			$layerviewlon = isset($layer_data['layerviewlon']) ? floatval($layer_data['layerviewlon']) : $query_view['layerviewlon'];
			$createdby = isset($layer_data['createdby']) ? $layer_data['createdby'] : $query_view['createdby'];
			$createdon = isset($layer_data['createdon']) && ( $layer_data['createdon'] == date('Y-m-d H:i:s',strtotime($layer_data['createdon'])) ) ? $layer_data['createdon'] : $query_view['createdon'];
			$updatedby = isset($layer_data['updatedby']) ? $layer_data['updatedby']  : $query_view['updatedby'];
			$updatedon = isset($layer_data['updatedon']) && ( $layer_data['createdon'] == date('Y-m-d H:i:s',strtotime($layer_data['createdon'])) ) ? $layer_data['updatedon'] : current_time('mysql',0);
			$controlbox = ( isset($layer_data['controlbox']) && ( ($layer_data['controlbox'] == '0') || ($layer_data['controlbox'] == '1') || ($layer_data['controlbox'] == '2')) ) ? $layer_data['controlbox'] :  $query_view['controlbox'];
			$overlays_custom = ( isset($layer_data['overlays_custom']) && ( ($layer_data['overlays_custom'] == '0') || ($layer_data['overlays_custom'] == '1')) ) ? $layer_data['overlays_custom'] : $query_view['overlays_custom'];
			$overlays_custom2 = ( isset($layer_data['overlays_custom2']) && ( ($layer_data['overlays_custom2'] == '0') || ($layer_data['overlays_custom2'] == '1')) ) ? $layer_data['overlays_custom2'] : $query_view['overlays_custom2'];
			$overlays_custom3 = ( isset($layer_data['overlays_custom3']) && ( ($layer_data['overlays_custom3'] == '0') || ($layer_data['overlays_custom3'] == '1')) ) ? $layer_data['overlays_custom3'] : $query_view['overlays_custom3'];
			$overlays_custom4 = ( isset($layer_data['overlays_custom4']) && ( ($layer_data['overlays_custom4'] == '0') || ($layer_data['overlays_custom4'] == '1')) ) ? $layer_data['overlays_custom4'] : $query_view['overlays_custom4'];
			$wms = ( isset($layer_data['wms']) && ( ($layer_data['wms'] == '0') || ($layer_data['wms'] == '1')) ) ? $layer_data['wms'] : $query_view['wms'];
			$wms2 = ( isset($layer_data['wms2']) && ( ($layer_data['wms2'] == '0') || ($layer_data['wms2'] == '1')) ) ? $layer_data['wms2'] : $query_view['wms2'];
			$wms3 = ( isset($layer_data['wms3']) && ( ($layer_data['wms3'] == '0') || ($layer_data['wms3'] == '1')) ) ? $layer_data['wms3'] : $query_view['wms3'];
			$wms4 = ( isset($layer_data['wms4']) && ( ($layer_data['wms4'] == '0') || ($layer_data['wms4'] == '1')) ) ? $layer_data['wms4'] : $query_view['wms4'];
			$wms5 = ( isset($layer_data['wms5']) && ( ($layer_data['wms5'] == '0') || ($layer_data['wms5'] == '1')) ) ? $layer_data['wms5'] : $query_view['wms5'];
			$wms6 = ( isset($layer_data['wms6']) && ( ($layer_data['wms6'] == '0') || ($layer_data['wms6'] == '1')) ) ? $layer_data['wms6'] : $query_view['wms6'];
			$wms7 = ( isset($layer_data['wms7']) && ( ($layer_data['wms7'] == '0') || ($layer_data['wms7'] == '1')) ) ? $layer_data['wms7'] : $query_view['wms7'];
			$wms8 = ( isset($layer_data['wms8']) && ( ($layer_data['wms8'] == '0') || ($layer_data['wms8'] == '1')) ) ? $layer_data['wms8'] : $query_view['wms8'];
			$wms9 = ( isset($layer_data['wms9']) && ( ($layer_data['wms9'] == '0') || ($layer_data['wms9'] == '1')) ) ? $layer_data['wms9'] : $query_view['wms9'];
			$wms10 = ( isset($layer_data['wms10']) && ( ($layer_data['wms10'] == '0') || ($layer_data['wms10'] == '1')) ) ? $layer_data['wms10'] : $query_view['wms10'];
			$listmarkers = ( isset($layer_data['listmarkers']) && ( ($layer_data['listmarkers'] == '0') || ($layer_data['listmarkers'] == '1')) ) ? $layer_data['listmarkers'] :  $query_view['listmarkers'];
			$multi_layer_map = ( isset($layer_data['multi_layer_map']) && ( ($layer_data['multi_layer_map'] == '0') || ($layer_data['multi_layer_map'] == '1')) ) ? $layer_data['multi_layer_map'] : $query_view['multi_layer_map'];
			$multi_layer_map_list = isset($layer_data['multi_layer_map_list']) ? $layer_data['multi_layer_map_list'] : $query_view['multi_layer_map_list'];
			$address = isset($layer_data['address']) ? $layer_data['address'] : $query_view['address'];
			$clustering = ( isset($layer_data['clustering']) && ( ($layer_data['clustering'] == '0') || ($layer_data['clustering'] == '1')) ) ? $layer_data['clustering'] :  $query_view['clustering'];
			$gpx_url = isset($layer_data['gpx_url']) ? $layer_data['gpx_url'] : $query_view['gpx_url'];
			$gpx_panel = ( isset($layer_data['gpx_panel']) && ( ($layer_data['gpx_panel'] == '0') || ($layer_data['gpx_panel'] == '1')) ) ? $layer_data['gpx_panel'] : $query_view['gpx_panel'];
			$geocode = isset($layer_data['geocode'])? $layer_data['geocode']: '';
			if ($geocode != NULL) {
				$do_geocoding = lmm_getLatLng($geocode);
				if ($do_geocoding['success'] == true) {
					$layerviewlat = $do_geocoding['lat'];
					$layerviewlon = $do_geocoding['lon'];
					$address = $do_geocoding['address'];
				} else {
					return new WP_Error( 'geocode_failed', sprintf( __( 'Geocoding error: %1s', 'lmm' ), $do_geocoding['message'] ), $layer_data );
				}
			}
			$query_update = $wpdb->prepare( "UPDATE `". self::table_name_layers() ."` SET `name` = %s, `basemap` = %s, `layerzoom` = %d, `mapwidth` = %d, `mapwidthunit` = %s, `mapheight` = %d, `panel` = %d, `layerviewlat` = %s, `layerviewlon` = %s, `createdby` = %s, `createdon` = %s, `updatedby` = %s, `updatedon` = %s, `controlbox` = %d, `overlays_custom` = %d, `overlays_custom2` = %d, `overlays_custom3` = %d, `overlays_custom4` = %d, `wms` = %d, `wms2` = %d, `wms3` = %d, `wms4` = %d, `wms5` = %d, `wms6` = %d, `wms7` = %d, `wms8` = %d, `wms9` = %d, `wms10` = %d, `listmarkers` = %d, `multi_layer_map` = %d, `multi_layer_map_list` = %s, `address` = %s, `clustering` = %d, `gpx_url` = %s, `gpx_panel` = %d WHERE `id` = %d", $name_quotes, $basemap, $layerzoom, $mapwidth, $mapwidthunit, $mapheight, $panel, str_replace(',', '.', $layerviewlat), str_replace(',', '.', $layerviewlon), $createdby, $createdon, $updatedby, $updatedon, $controlbox, $overlays_custom, $overlays_custom2, $overlays_custom3, $overlays_custom4, $wms, $wms2, $wms3, $wms4, $wms5, $wms6, $wms7, $wms8, $wms9, $wms10, $listmarkers, $multi_layer_map, $multi_layer_map_list, $address, $clustering, $gpx_url, $gpx_panel, $id );
			$result_update = $wpdb->query( $query_update );
			return ($result_update === 1)?TRUE:FALSE;
		}else{
				return new WP_Error( 'not_found', sprintf( __( 'MMPAPI error: marker ID %1s was not found', 'lmm' ), $id ), $layer_data );
		}
	}

	/**
    * Update layers based on given data object
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $layers_data Data of the layers
    *
    * @return array|WP_Error IDs of updated layers or an error object.
    */
	public static function update_layers(  $layers_data  ){
		if(! $layers_data || !is_array($layers_data)){
			return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: invalid layer objects. Input was %s', 'lmm' ), gettype($layers_data)), $layers_data );
		}
        $layers_ids = array();
        foreach ( $layers_data as $layer ) {
          $result = self::update_layer( $layer );
          if ( is_wp_error( $result ) ) {
              return $result;
          }
          $layers_ids[$layer['id']] = $result;
        }
        return $layers_ids;
	}

	/**
    * Deletes the layer for a given layer ID
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param int $layer_id The ID of the layer
    *
    * @return mixed TRUE if the layer deleted successfully, WP_Error object if not
    */
	public static function delete_layer( $layer_id ){
		global $wpdb;
		//info:  to make sure that the layer_id is a number
		$layer_id = intval( $layer_id );
		if($layer_id === 0) return new WP_Error( 'invalid_parameter',  __( 'MMPAPI error: delete_layer method only accepts integers', 'lmm' ), $layer_id );

		$associated_markers = $wpdb->get_results($wpdb->prepare("SELECT id,layer FROM `". self::table_name_markers() ."` WHERE layer LIKE '%%\"%d\"%%' ", $layer_id) );
		foreach($associated_markers as $marker){
			$layer = json_decode($marker->layer, true);
			$marker_key = array_search($layer_id, $layer);
			unset($layer[$marker_key]);
			//info: if not no layers left, make the marker unassigned.
			if(count($layer) == 0){
				$layer[] = "0";
				$layer = array_values($layer);
			}
			$wpdb->update(self::table_name_markers(),
						  array('layer'=> json_encode($layer)),
						  array('id' => $marker->id)
						  );
		}
		//info:  deleting the layer
		$layer_result = $wpdb->query( $wpdb->prepare("DELETE  FROM `".self::table_name_layers()."` WHERE `id` = %d", $layer_id));
		//info:  it will return false if the number of rows affected is zero, and it will return true otherwise.
		if($layer_result === 0){
			return new WP_Error( 'not_found', sprintf( __( 'MMPAPI error: layer with ID %s not found', 'lmm' ), $layer_id ), $layer_id );
		}else{
			return true;
		}
	}

	/**
    * Deletes the layers for a given Layers IDs
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $layer_ids The IDs of the Layers
    *
    * @return boolean true if the markers deleted successfully, WP_Error object if not
    */
	public static function delete_layers( $layer_ids = array() ){
		global $wpdb;
		//info:  to make sure that the marker_id is an array
		if(!is_array($layer_ids)){
			 return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: delete_layers method only accepts arrays. Input was %s', 'lmm' ), gettype($layer_ids)), $layer_ids );
		}
		//info:  to make sure that the layer_ids is not empty
		if(empty($layer_ids)) return new WP_Error( 'empty_parameter', __( 'MMPAPI error: delete_markers method does not accept empty arrays.', 'lmm' ), $layer_ids );
		//info:  in case of one or more elements of the array were not integers.
		$layer_ids = array_map('intval', $layer_ids);
		if(in_array(0, $layer_ids)){
			 return new WP_Error( 'invalid_parameter', __( 'MMPAPI error: all the elements of layer_ids array must be integers', 'lmm' ), $layer_ids );
		}

		foreach($layer_ids as $layer_id){
			$associated_markers = $wpdb->get_results($wpdb->prepare("SELECT id,layer FROM `". self::table_name_markers() ."` WHERE layer LIKE '%%\"%d\"%%' ", $layer_id) );
			foreach($associated_markers as $marker){
				$layer = json_decode($marker->layer, true);
				$marker_key = array_search($layer_id, $layer);
				unset($layer[$marker_key]);
				//info: if not no layers left, make the marker unassigned.
				if(count($layer) == 0){
					$layer[] = "0";
					$layer = array_values($layer);
				}
				$wpdb->update(self::table_name_markers(),
							  array('layer'=> json_encode($layer)),
							  array('id' => $marker->id)
							  );
			}
		}

		//info:  delete the layers
		$layer_ids = implode(',', $layer_ids);
		$layer_result = $wpdb->query( "DELETE  FROM `".self::table_name_layers()."` WHERE `id` IN (".$layer_ids.")" );
		return ($layer_result !== 0);
	}

	/**
    * returns the number of markers available
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @return int The markers count
    */
	public static function count_markers( ){
		global $wpdb;
		$count_result = $wpdb->get_row( 'SELECT COUNT(*) as markers_count FROM '.self::table_name_markers() );
		return (int)$count_result->markers_count;
	}

	/**
    * returns the number of layers available
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @return int The layers count
    */
	public static function count_layers( ){
		global $wpdb;
		$count_result = $wpdb->get_row( 'SELECT COUNT(*) as layers_count FROM ' .self::table_name_layers(). ' WHERE id <> 0' );
		return (int)$count_result->layers_count;
	}

	/**
    * Search markers object for a given args.
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $args The parameters of the search
    *
    * @return array The marker object or false
    */
	public static function search_markers( $args ){
		global $wpdb;
		//info:  to make sure that the args is an array
		if(!is_array($args)){
			 return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: search_markers method only accepts arrays. Input was %s', 'lmm' ), gettype($args)), $args );
		}

		if(!isset($args['searchkey'])){
			 return new WP_Error( 'invalid_parameter',  __( 'MMPAPI error: searchkey parameter is required.', 'lmm' ), $args );
		}
		if(!isset($args['searchvalue'])){
			 return new WP_Error( 'invalid_parameter', __( 'MMPAPI error: searchvalue parameter is required.', 'lmm' ), $args );
		}
		$allowed_keys = self::get_allowed_marker_searchkeys();
		if(!in_array($args['searchkey'], $allowed_keys )){
			 return new WP_Error( 'invalid_parameter', sprintf(__( 'MMPAPI error: searchkey is not valid, it must be one of the following keys: %s', 'lmm' ), implode(', ',$allowed_keys)), $args );
		}
		extract($args);

		switch ($searchkey) {
			case 'layer':
				$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_markers() ."` WHERE layer LIKE %s", '%' . intval($searchvalue) . '%'));
				break;
			case 'id':
			case 'zoom':
			case 'openpopup':
			case 'mapwidth':
			case 'mapheight':
			case 'panel':
			case 'controlbox':
			case 'overlays_custom':
			case 'overlays_custom2':
			case 'overlays_custom3':
			case 'overlays_custom4':
			case 'wms':
			case 'wms2':
			case 'wms3':
			case 'wms4':
			case 'wms5':
			case 'wms6':
			case 'wms7':
			case 'wms8':
			case 'wms9':
			case 'wms10':
			case 'gpx_panel':
				$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_markers() ."` WHERE `$searchkey` = %d",  $searchvalue ));
				break;
			case 'createdon':
			case 'updatedon':
			case 'kml_timestamp':
				$date_from = isset($date_from) ? strtotime($date_from) : '';
				$date_to = isset($date_to) ? strtotime($date_to) : '';
				if ( ($date_from != NULL) && ($date_to == NULL) ) {
					$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_markers() ."` WHERE `$searchkey` > FROM_UNIXTIME(%d)", $date_from));
				} else if ( ($date_from == NULL) && ($date_to != NULL) ) {
					$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_markers() ."` WHERE `$searchkey` < FROM_UNIXTIME(%d)", $date_to));
				} else if ( ($date_from != NULL) && ($date_to != NULL) ) {
					$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_markers() ."` WHERE `$searchkey` > FROM_UNIXTIME(%d) AND `$searchkey` < FROM_UNIXTIME(%d)", $date_from, $date_to));
				} else { //info: if ($date_from == NULL) && ($date_to == NULL)
					return new WP_Error( 'invalid_parameter', __( 'MMPAPI error: parameter date_from or date_to has be set when searching date fields', 'lmm' ), $args );
				}
				break;
			case 'boundingbox':
				$lat_top_left = isset($lat_top_left) ? floatval(str_replace(",",".", $lat_top_left)) :  '';
				$lon_top_left = isset($lon_top_left) ? floatval(str_replace(",",".", $lon_top_left)) :  '';
				$lat_bottom_right = isset($lat_bottom_right) ? floatval(str_replace(",",".", $lat_bottom_right)) :  '';
				$lon_bottom_right = isset($lon_bottom_right) ? floatval(str_replace(",",".", $lon_bottom_right)) :	'';
				if ( ($lat_top_left == NULL) || ($lon_top_left == NULL) || ($lat_bottom_right == NULL) || ($lon_bottom_right == NULL) ) {
					return new WP_Error( 'invalid_parameter', __( 'MMPAPI error: API parameters lat_top_left, lon_top_left, lat_bottom_right and lon_bottom_right have be set when performing a boundingbox search', 'lmm' ), $args['date_from'] );
				}
				$query_result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `". self::table_name_markers() ."` WHERE `lat` <= %s AND `lon` >= %s AND `lat` >= %s AND `lon` <= %s", $lat_top_left, $lon_top_left, $lat_bottom_right, $lon_bottom_right ) );
				break;
			default:
				$query_result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `". self::table_name_markers() ."` WHERE $searchkey LIKE %s", '%'.$searchvalue.'%' ) );
				break;
		}
		return $query_result;
	}

	/**
    * Search layers object for a given args.
    *
    * @since  2.5
    * @access public
    * @static
    *
    * @param array $args The parameters of the search
    *
    * @return array The layer objects.
    */
	public static function search_layers( $args ){
		global $wpdb;
		//info:  to make sure that the args is an array
		if(!is_array($args)){
			 return new WP_Error( 'invalid_parameter', sprintf( __( 'MMPAPI error: search_layers method only accepts arrays. Input was %s', 'lmm' ), gettype($args)), $args );
		}

		if(!isset($args['searchkey'])){
			 return new WP_Error( 'invalid_parameter',  __( 'MMPAPI error: searchkey parameter is required.', 'lmm' ), $args );
		}
		if(!isset($args['searchvalue'])){
			 return new WP_Error( 'invalid_parameter', __( 'MMPAPI error: searchvalue parameter is required.', 'lmm' ), $args );
		}
		$allowed_keys = self::get_allowed_layer_searchkeys();
		if(!in_array($args['searchkey'], $allowed_keys )){
			 return new WP_Error( 'invalid_parameter', sprintf(__( 'MMPAPI error: searchkey is not valid, it must be one of the following keys: %s', 'lmm' ), implode(', ',$allowed_keys)), $args );
		}
		extract($args);

		switch ($searchkey) {
			case 'id':
			case 'layerzoom':
			case 'mapwidth':
			case 'mapheight':
			case 'panel':
			case 'controlbox':
			case 'overlays_custom':
			case 'overlays_custom2':
			case 'overlays_custom3':
			case 'overlays_custom4':
			case 'wms':
			case 'wms2':
			case 'wms3':
			case 'wms4':
			case 'wms5':
			case 'wms6':
			case 'wms7':
			case 'wms8':
			case 'wms9':
			case 'wms10':
			case 'listmarkers':
			case 'multi_layer_map':
			case 'clustering':
			case 'gpx_panel':
				$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_layers() ."` WHERE `$searchkey` = %d AND `id` != 0", $searchvalue));
				break;
			case 'updatedon':
			case 'createdon':
				$date_from = isset($date_from) ? strtotime($date_from) : '';
				$date_to = isset($date_to) ? strtotime($date_to) : '';
				if ( ($date_from != NULL) && ($date_to == NULL) ) {
					$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_layers() ."` WHERE `$searchkey` > FROM_UNIXTIME(%d) AND `id` != 0", $date_from));
				} else if ( ($date_from == NULL) && ($date_to != NULL) ) {
					$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_layers() ."` WHERE `$searchkey` < FROM_UNIXTIME(%d) AND `id` != 0", $date_to));
				} else if ( ($date_from != NULL) && ($date_to != NULL) ) {
					$query_result = $wpdb->get_results( $wpdb->prepare("SELECT * FROM `". self::table_name_layers() ."` WHERE `$searchkey` > FROM_UNIXTIME(%d) AND `$searchkey` < FROM_UNIXTIME(%d) AND `id` != 0", $date_from, $date_to));
				} else { //info: if ($date_from == NULL) && ($date_to == NULL)
					return new WP_Error( 'invalid_parameter', __( 'MMPAPI error: API parameter date_from or date_to has be set when searching date fields', 'lmm' ), $args );
				}
				break;
			case 'boundingbox':
				$lat_top_left = isset($lat_top_left) ? floatval(str_replace(",",".", $lat_top_left)) :  '';
				$lon_top_left = isset($lon_top_left) ? floatval(str_replace(",",".", $lon_top_left)) :  '';
				$lat_bottom_right = isset($lat_bottom_right) ? floatval(str_replace(",",".", $lat_bottom_right)) :  '';
				$lon_bottom_right = isset($lon_bottom_right) ? floatval(str_replace(",",".", $lon_bottom_right)) :	'';
				if ( ($lat_top_left == NULL) || ($lon_top_left == NULL) || ($lat_bottom_right == NULL) || ($lon_bottom_right == NULL) ) {
					return new WP_Error( 'invalid_parameter', __( 'API parameters lat_top_left, lon_top_left, lat_bottom_right and lon_bottom_right have be set when performing a boundingbox search', 'lmm' ), $args['date_from'] );
				}
				$query_result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `". self::table_name_layers() ."` WHERE `layerviewlat` <= %s AND `layerviewlon` >= %s AND `layerviewlat` >= %s AND `layerviewlon` <= %s AND id != 0", $lat_top_left, $lon_top_left, $lat_bottom_right, $lon_bottom_right) );
				break;
			default:
				$query_result = $wpdb->get_results( $wpdb->prepare( "SELECT * FROM `". self::table_name_layers() ."` WHERE $searchkey LIKE %s AND id != 0", '%'.$searchvalue.'%'));
				break;
		}
		return $query_result;
	}

	// HELPERS ----------------------------------------------------

	/**
    * Returns the markers' table name
    *
    * @since  2.5
    * @access private
    * @static
	*
    * @return string The markers' table name.
    */
	private static function table_name_markers(){
		global $wpdb;
		return $wpdb->prefix.'leafletmapsmarker_markers';
	}

	/**
    * Returns the layer markers' table name
    *
    * @since  2.5
    * @access private
    * @static
	*
    * @return string The layers' table name.
    */
	private static function table_name_layers(){
		global $wpdb;
		return $wpdb->prefix.'leafletmapsmarker_layers';
	}

	/**
    * Returns the options of Maps Marker Pro
    *
    * @since  2.5
    * @access private
    * @static
	*
    * @return array The options of the plugin.
    */
	private static function lmm_options(){
		return get_option( 'leafletmapsmarker_options' );
	}

	/**
    * Returns the allowed search keys for markers
    *
    * @since  2.5
    * @access private
    * @static
	*
    * @return array The search keys
    */
	private static function get_allowed_marker_searchkeys(){

		return array(
				'id',
				'zoom',
				'layer',
				'openpopup',
				'mapwidth',
				'mapheight',
				'panel',
				'controlbox',
				'overlays_custom',
				'overlays_custom2',
				'overlays_custom3',
				'overlays_custom4',
				'wms',
				'wms2',
				'wms3',
				'wms4',
				'wms5',
				'wms6',
				'wms7',
				'wms8',
				'wms9',
				'wms10',
				'gpx_panel',
				'createdon',
				'updatedon',
				'kml_timestamp',
				'boundingbox',
				'markername',
				'basemap',
				'lat',
				'lon',
				'icon',
				'popuptext',
				'mapwidthunit',
				'createdby',
				'updatedby',
				'address',
				'gpx_url'
			);
	}

	/**
    * Returns the allowed search keys for layers
    *
    * @since  2.5
    * @access private
    * @static
	*
    * @return array The search keys
    */
	private static function get_allowed_layer_searchkeys(){

		return array(
				'id',
				'layerzoom',
				'mapwidth',
				'mapheight',
				'panel',
				'controlbox',
				'overlays_custom',
				'overlays_custom2',
				'overlays_custom3',
				'overlays_custom4',
				'wms',
				'wms2',
				'wms3',
				'wms4',
				'wms5',
				'wms6',
				'wms7',
				'wms8',
				'wms9',
				'wms10',
				'listmarkers',
				'multi_layer_map',
				'clustering',
				'gpx_panel',
				'updatedon',
				'createdon',
				'boundingbox',
				'name',
				'basemap',
				'layerviewlat',
				'layerviewlon',
				'mapwidthunit',
				'createdby',
				'updatedby',
				'multi_layer_map_list',
				'address',
				'gpx_url'
			);
	}

	 /**
	 * Returns a Lat and Lng from an Address using Google Geocoder API. It does not require any Google API Key
	 * originially based on allow_url_fopen-scripty by Abdullah Rubiyath
	 */
	private static function getLatLng($address) {
		$address_to_geocode = self::accent_folding($address);
		$url = 'http://maps.googleapis.com/maps/api/geocode/xml?address=' . urlencode($address_to_geocode) . '&sensor=false';
		$xml_raw = wp_remote_get( $url, array( 'sslverify' => false, 'timeout' => 10 ) );
		$xml = simplexml_load_string($xml_raw['body']);
		$response = array();
		$statusCode = $xml->status;
		if ( ($statusCode != false) && ($statusCode != NULL) ) {
			if ($statusCode == 'OK') {
				$latDom = $xml->result[0]->geometry->location->lat;
				$lonDom = $xml->result[0]->geometry->location->lng;
				$addressDom = $xml->result[0]->formatted_address;
				if ($latDom != NULL) {
					$response = array (
						'success' 	=> true,
						'lat' 		=> $latDom,
						'lon' 		=> $lonDom,
						'address'	=> $addressDom
					);
					return $response;
				}
			} else if ($statusCode == 'OVER_QUERY_LIMIT') { //info: wait 1.5sec and try again once
				usleep(1500000);
				$xml_raw = wp_remote_get( $url, array( 'sslverify' => false, 'timeout' => 10 ) );
				$xml = simplexml_load_string($xml_raw['body']);

				$response = array();
				$statusCode = $xml->status;

				if ( ($statusCode != false) && ($statusCode != NULL) ) {
					if ($statusCode == 'OK') {
						$latDom = $xml->result[0]->geometry->location->lat;
						$lonDom = $xml->result[0]->geometry->location->lng;
						$addressDom = $xml->result[0]->formatted_address;
						if ($latDom != NULL) {
							$response = array (
								'success' 	=> true,
								'lat' 		=> $latDom,
								'lon' 		=> $lonDom,
								'address'	=> $addressDom
							);
							return $response;
						}
					}
				}
			}
		}
		$response = array (
			'success' => false,
			'message' => $statusCode
		);
		return $response;
	}

	private static function accent_folding($address) {
		$accent_map = array('ẚ' => 'a', 'Á' => 'a', 'á' => 'a', 'À' => 'a', 'à' => 'a', 'Ă' => 'a', 'ă' => 'a', 'Ắ' => 'a', 'ắ' => 'a', 'Ằ' => 'a', 'ằ' => 'a', 'Ẵ' => 'a', 'ẵ' => 'a', 'Ẳ' => 'a', 'ẳ' => 'a', 'Â' => 'a', 'â' => 'a', 'Ấ' => 'a', 'ấ' => 'a', 'Ầ' => 'a', 'ầ' => 'a', 'Ẫ' => 'a', 'ẫ' => 'a', 'Ẩ' => 'a', 'ẩ' => 'a', 'Ǎ' => 'a', 'ǎ' => 'a', 'Å' => 'a', 'å' => 'a', 'Ǻ' => 'a', 'ǻ' => 'a', 'Ä' => 'a', 'ä' => 'a', 'Ǟ' => 'a', 'ǟ' => 'a', 'Ã' => 'a', 'ã' => 'a', 'Ȧ' => 'a', 'ȧ' => 'a', 'Ǡ' => 'a', 'ǡ' => 'a', 'Ą' => 'a', 'ą' => 'a', 'Ā' => 'a', 'ā' => 'a', 'Ả' => 'a', 'ả' => 'a', 'Ȁ' => 'a', 'ȁ' => 'a', 'Ȃ' => 'a', 'ȃ' => 'a', 'Ạ' => 'a', 'ạ' => 'a', 'Ặ' => 'a', 'ặ' => 'a', 'Ậ' => 'a', 'ậ' => 'a', 'Ḁ' => 'a', 'ḁ' => 'a', 'Ⱥ' => 'a', 'ⱥ' => 'a', 'Ǽ' => 'a', 'ǽ' => 'a', 'Ǣ' => 'a', 'ǣ' => 'a', 'Ḃ' => 'b', 'ḃ' => 'b', 'Ḅ' => 'b', 'ḅ' => 'b', 'Ḇ' => 'b', 'ḇ' => 'b', 'Ƀ' => 'b', 'ƀ' => 'b', 'ᵬ' => 'b', 'Ɓ' => 'b', 'ɓ' => 'b', 'Ƃ' => 'b', 'ƃ' => 'b', 'Ć' => 'c', 'ć' => 'c', 'Ĉ' => 'c', 'ĉ' => 'c', 'Č' => 'c', 'č' => 'c', 'Ċ' => 'c', 'ċ' => 'c', 'Ç' => 'c', 'ç' => 'c', 'Ḉ' => 'c', 'ḉ' => 'c', 'Ȼ' => 'c', 'ȼ' => 'c', 'Ƈ' => 'c', 'ƈ' => 'c', 'ɕ' => 'c', 'Ď' => 'd', 'ď' => 'd', 'Ḋ' => 'd', 'ḋ' => 'd', 'Ḑ' => 'd', 'ḑ' => 'd', 'Ḍ' => 'd', 'ḍ' => 'd', 'Ḓ' => 'd', 'ḓ' => 'd', 'Ḏ' => 'd', 'ḏ' => 'd', 'Đ' => 'd', 'đ' => 'd', 'ᵭ' => 'd', 'Ɖ' => 'd', 'ɖ' => 'd', 'Ɗ' => 'd', 'ɗ' => 'd', 'Ƌ' => 'd', 'ƌ' => 'd', 'ȡ' => 'd', 'ð' => 'd', 'É' => 'e', 'Ə' => 'e', 'Ǝ' => 'e', 'ǝ' => 'e', 'é' => 'e', 'È' => 'e', 'è' => 'e', 'Ĕ' => 'e', 'ĕ' => 'e', 'Ê' => 'e', 'ê' => 'e', 'Ế' => 'e', 'ế' => 'e', 'Ề' => 'e', 'ề' => 'e', 'Ễ' => 'e', 'ễ' => 'e', 'Ể' => 'e', 'ể' => 'e', 'Ě' => 'e', 'ě' => 'e', 'Ë' => 'e', 'ë' => 'e', 'Ẽ' => 'e', 'ẽ' => 'e', 'Ė' => 'e', 'ė' => 'e', 'Ȩ' => 'e', 'ȩ' => 'e', 'Ḝ' => 'e', 'ḝ' => 'e', 'Ę' => 'e', 'ę' => 'e', 'Ē' => 'e', 'ē' => 'e', 'Ḗ' => 'e', 'ḗ' => 'e', 'Ḕ' => 'e', 'ḕ' => 'e', 'Ẻ' => 'e', 'ẻ' => 'e', 'Ȅ' => 'e', 'ȅ' => 'e', 'Ȇ' => 'e', 'ȇ' => 'e', 'Ẹ' => 'e', 'ẹ' => 'e', 'Ệ' => 'e', 'ệ' => 'e', 'Ḙ' => 'e', 'ḙ' => 'e', 'Ḛ' => 'e', 'ḛ' => 'e', 'Ɇ' => 'e', 'ɇ' => 'e', 'ɚ' => 'e', 'ɝ' => 'e', 'Ḟ' => 'f', 'ḟ' => 'f', 'ᵮ' => 'f', 'Ƒ' => 'f', 'ƒ' => 'f', 'Ǵ' => 'g', 'ǵ' => 'g', 'Ğ' => 'g', 'ğ' => 'g', 'Ĝ' => 'g', 'ĝ' => 'g', 'Ǧ' => 'g', 'ǧ' => 'g', 'Ġ' => 'g', 'ġ' => 'g', 'Ģ' => 'g', 'ģ' => 'g', 'Ḡ' => 'g', 'ḡ' => 'g', 'Ǥ' => 'g', 'ǥ' => 'g', 'Ɠ' => 'g', 'ɠ' => 'g', 'Ĥ' => 'h', 'ĥ' => 'h', 'Ȟ' => 'h', 'ȟ' => 'h', 'Ḧ' => 'h', 'ḧ' => 'h', 'Ḣ' => 'h', 'ḣ' => 'h', 'Ḩ' => 'h', 'ḩ' => 'h', 'Ḥ' => 'h', 'ḥ' => 'h', 'Ḫ' => 'h', 'ḫ' => 'h', 'H' => 'h', '̱' => 'h', 'ẖ' => 'h', 'Ħ' => 'h', 'ħ' => 'h', 'Ⱨ' => 'h', 'ⱨ' => 'h', 'Í' => 'i', 'í' => 'i', 'Ì' => 'i', 'ì' => 'i', 'Ĭ' => 'i', 'ĭ' => 'i', 'Î' => 'i', 'î' => 'i', 'Ǐ' => 'i', 'ǐ' => 'i', 'Ï' => 'i', 'ï' => 'i', 'Ḯ' => 'i', 'ḯ' => 'i', 'Ĩ' => 'i', 'ĩ' => 'i', 'İ' => 'i', 'i' => 'i', 'Į' => 'i', 'į' => 'i', 'Ī' => 'i', 'ī' => 'i', 'Ỉ' => 'i', 'ỉ' => 'i', 'Ȉ' => 'i', 'ȉ' => 'i', 'Ȋ' => 'i', 'ȋ' => 'i', 'Ị' => 'i', 'ị' => 'i', 'Ḭ' => 'i', 'ḭ' => 'i', 'I' => 'i', 'ı' => 'i', 'Ɨ' => 'i', 'ɨ' => 'i', 'Ĵ' => 'j', 'ĵ' => 'j', 'J' => 'j', '̌' => 'j', 'ǰ' => 'j', 'ȷ' => 'j', 'Ɉ' => 'j', 'ɉ' => 'j', 'ʝ' => 'j', 'ɟ' => 'j', 'ʄ' => 'j', 'Ḱ' => 'k', 'ḱ' => 'k', 'Ǩ' => 'k', 'ǩ' => 'k', 'Ķ' => 'k', 'ķ' => 'k', 'Ḳ' => 'k', 'ḳ' => 'k', 'Ḵ' => 'k', 'ḵ' => 'k', 'Ƙ' => 'k', 'ƙ' => 'k', 'Ⱪ' => 'k', 'ⱪ' => 'k', 'Ĺ' => 'a', 'ĺ' => 'l', 'Ľ' => 'l', 'ľ' => 'l', 'Ļ' => 'l', 'ļ' => 'l', 'Ḷ' => 'l', 'ḷ' => 'l', 'Ḹ' => 'l', 'ḹ' => 'l', 'Ḽ' => 'l', 'ḽ' => 'l', 'Ḻ' => 'l', 'ḻ' => 'l', 'Ł' => 'l', 'ł' => 'l', 'Ł' => 'l', '̣' => 'l', 'ł' => 'l', '̣' => 'l', 'Ŀ' => 'l', 'ŀ' => 'l', 'Ƚ' => 'l', 'ƚ' => 'l', 'Ⱡ' => 'l', 'ⱡ' => 'l', 'Ɫ' => 'l', 'ɫ' => 'l', 'ɬ' => 'l', 'ɭ' => 'l', 'ȴ' => 'l', 'Ḿ' => 'm', 'ḿ' => 'm', 'Ṁ' => 'm', 'ṁ' => 'm', 'Ṃ' => 'm', 'ṃ' => 'm', 'ɱ' => 'm', 'Ń' => 'n', 'ń' => 'n', 'Ǹ' => 'n', 'ǹ' => 'n', 'Ň' => 'n', 'ň' => 'n', 'Ñ' => 'n', 'ñ' => 'n', 'Ṅ' => 'n', 'ṅ' => 'n', 'Ņ' => 'n', 'ņ' => 'n', 'Ṇ' => 'n', 'ṇ' => 'n', 'Ṋ' => 'n', 'ṋ' => 'n', 'Ṉ' => 'n', 'ṉ' => 'n', 'Ɲ' => 'n', 'ɲ' => 'n', 'Ƞ' => 'n', 'ƞ' => 'n', 'ɳ' => 'n', 'ȵ' => 'n', 'N' => 'n', '̈' => 'n', 'n' => 'n', '̈' => 'n', 'Ó' => 'o', 'ó' => 'o', 'Ò' => 'o', 'ò' => 'o', 'Ŏ' => 'o', 'ŏ' => 'o', 'Ô' => 'o', 'ô' => 'o', 'Ố' => 'o', 'ố' => 'o', 'Ồ' => 'o', 'ồ' => 'o', 'Ỗ' => 'o', 'ỗ' => 'o', 'Ổ' => 'o', 'ổ' => 'o', 'Ǒ' => 'o', 'ǒ' => 'o', 'Ö' => 'o', 'ö' => 'o', 'Ȫ' => 'o', 'ȫ' => 'o', 'Ő' => 'o', 'ő' => 'o', 'Õ' => 'o', 'õ' => 'o', 'Ṍ' => 'o', 'ṍ' => 'o', 'Ṏ' => 'o', 'ṏ' => 'o', 'Ȭ' => 'o', 'ȭ' => 'o', 'Ȯ' => 'o', 'ȯ' => 'o', 'Ȱ' => 'o', 'ȱ' => 'o', 'Ø' => 'o', 'ø' => 'o', 'Ǿ' => 'o', 'ǿ' => 'o', 'Ǫ' => 'o', 'ǫ' => 'o', 'Ǭ' => 'o', 'ǭ' => 'o', 'Ō' => 'o', 'ō' => 'o', 'Ṓ' => 'o', 'ṓ' => 'o', 'Ṑ' => 'o', 'ṑ' => 'o', 'Ỏ' => 'o', 'ỏ' => 'o', 'Ȍ' => 'o', 'ȍ' => 'o', 'Ȏ' => 'o', 'ȏ' => 'o', 'Ơ' => 'o', 'ơ' => 'o', 'Ớ' => 'o', 'ớ' => 'o', 'Ờ' => 'o', 'ờ' => 'o', 'Ỡ' => 'o', 'ỡ' => 'o', 'Ở' => 'o', 'ở' => 'o', 'Ợ' => 'o', 'ợ' => 'o', 'Ọ' => 'o', 'ọ' => 'o', 'Ộ' => 'o', 'ộ' => 'o', 'Ɵ' => 'o', 'ɵ' => 'o', 'Ṕ' => 'p', 'ṕ' => 'p', 'Ṗ' => 'p', 'ṗ' => 'p', 'Ᵽ' => 'p', 'Ƥ' => 'p', 'ƥ' => 'p', 'P' => 'p', '̃' => 'p', 'p' => 'p', '̃' => 'p', 'ʠ' => 'q', 'Ɋ' => 'q', 'ɋ' => 'q', 'Ŕ' => 'r', 'ŕ' => 'r', 'Ř' => 'r', 'ř' => 'r', 'Ṙ' => 'r', 'ṙ' => 'r', 'Ŗ' => 'r', 'ŗ' => 'r', 'Ȑ' => 'r', 'ȑ' => 'r', 'Ȓ' => 'r', 'ȓ' => 'r', 'Ṛ' => 'r', 'ṛ' => 'r', 'Ṝ' => 'r', 'ṝ' => 'r', 'Ṟ' => 'r', 'ṟ' => 'r', 'Ɍ' => 'r', 'ɍ' => 'r', 'ᵲ' => 'r', 'ɼ' => 'r', 'Ɽ' => 'r', 'ɽ' => 'r', 'ɾ' => 'r', 'ᵳ' => 'r', 'ß' => 's', 'Ś' => 's', 'ś' => 's', 'Ṥ' => 's', 'ṥ' => 's', 'Ŝ' => 's', 'ŝ' => 's', 'Š' => 's', 'š' => 's', 'Ṧ' => 's', 'ṧ' => 's', 'Ṡ' => 's', 'ṡ' => 's', 'ẛ' => 's', 'Ş' => 's', 'ş' => 's', 'Ṣ' => 's', 'ṣ' => 's', 'Ṩ' => 's', 'ṩ' => 's', 'Ș' => 's', 'ș' => 's', 'ʂ' => 's', 'S' => 's', '̩' => 's', 's' => 's', '̩' => 's', 'Þ' => 't', 'þ' => 't', 'Ť' => 't', 'ť' => 't', 'T' => 't', '̈' => 't', 'ẗ' => 't', 'Ṫ' => 't', 'ṫ' => 't', 'Ţ' => 't', 'ţ' => 't', 'Ṭ' => 't', 'ṭ' => 't', 'Ț' => 't', 'ț' => 't', 'Ṱ' => 't', 'ṱ' => 't', 'Ṯ' => 't', 'ṯ' => 't', 'Ŧ' => 't', 'ŧ' => 't', 'Ⱦ' => 't', 'ⱦ' => 't', 'ᵵ' => 't', 'ƫ' => 't', 'Ƭ' => 't', 'ƭ' => 't', 'Ʈ' => 't', 'ʈ' => 't', 'ȶ' => 't', 'Ú' => 'u', 'ú' => 'u', 'Ù' => 'u', 'ù' => 'u', 'Ŭ' => 'u', 'ŭ' => 'u', 'Û' => 'u', 'û' => 'u', 'Ǔ' => 'u', 'ǔ' => 'u', 'Ů' => 'u', 'ů' => 'u', 'Ü' => 'u', 'ü' => 'u', 'Ǘ' => 'u', 'ǘ' => 'u', 'Ǜ' => 'u', 'ǜ' => 'u', 'Ǚ' => 'u', 'ǚ' => 'u', 'Ǖ' => 'u', 'ǖ' => 'u', 'Ű' => 'u', 'ű' => 'u', 'Ũ' => 'u', 'ũ' => 'u', 'Ṹ' => 'u', 'ṹ' => 'u', 'Ų' => 'u', 'ų' => 'u', 'Ū' => 'u', 'ū' => 'u', 'Ṻ' => 'u', 'ṻ' => 'u', 'Ủ' => 'u', 'ủ' => 'u', 'Ȕ' => 'u', 'ȕ' => 'u', 'Ȗ' => 'u', 'ȗ' => 'u', 'Ư' => 'u', 'ư' => 'u', 'Ứ' => 'u', 'ứ' => 'u', 'Ừ' => 'u', 'ừ' => 'u', 'Ữ' => 'u', 'ữ' => 'u', 'Ử' => 'u', 'ử' => 'u', 'Ự' => 'u', 'ự' => 'u', 'Ụ' => 'u', 'ụ' => 'u', 'Ṳ' => 'u', 'ṳ' => 'u', 'Ṷ' => 'u', 'ṷ' => 'u', 'Ṵ' => 'u', 'ṵ' => 'u', 'Ʉ' => 'u', 'ʉ' => 'u', 'Ṽ' => 'v', 'ṽ' => 'v', 'Ṿ' => 'v', 'ṿ' => 'v', 'Ʋ' => 'v', 'ʋ' => 'v', 'Ẃ' => 'w', 'ẃ' => 'w', 'Ẁ' => 'w', 'ẁ' => 'w', 'Ŵ' => 'w', 'ŵ' => 'w', 'W' => 'w', '̊' => 'w', 'ẘ' => 'w', 'Ẅ' => 'w', 'ẅ' => 'w', 'Ẇ' => 'w', 'ẇ' => 'w', 'Ẉ' => 'w', 'ẉ' => 'w', 'Ẍ' => 'x', 'ẍ' => 'x', 'Ẋ' => 'x', 'ẋ' => 'x', 'Ý' => 'y', 'ý' => 'y', 'Ỳ' => 'y', 'ỳ' => 'y', 'Ŷ' => 'y', 'ŷ' => 'y', 'Y' => 'y', '̊' => 'y', 'ẙ' => 'y', 'Ÿ' => 'y', 'ÿ' => 'y', 'Ỹ' => 'y', 'ỹ' => 'y', 'Ẏ' => 'y', 'ẏ' => 'y', 'Ȳ' => 'y', 'ȳ' => 'y', 'Ỷ' => 'y', 'ỷ' => 'y', 'Ỵ' => 'y', 'ỵ' => 'y', 'ʏ' => 'y', 'Ɏ' => 'y', 'ɏ' => 'y', 'Ƴ' => 'y', 'ƴ' => 'y', 'Ź' => 'z', 'ź' => 'z', 'Ẑ' => 'z', 'ẑ' => 'z', 'Ž' => 'z', 'ž' => 'z', 'Ż' => 'z', 'ż' => 'z', 'Ẓ' => 'z', 'ẓ' => 'z', 'Ẕ' => 'z', 'ẕ' => 'z', 'Ƶ' => 'z', 'ƶ' => 'z', 'Ȥ' => 'z', 'ȥ' => 'z', 'ʐ' => 'z', 'ʑ' => 'z', 'Ⱬ' => 'z', 'ⱬ' => 'z', 'Ǯ' => 'z', 'ǯ' => 'z', 'ƺ' => 'z',
		// Roman fullwidth ascii equivalents =>  0xff00 to 0xff5e
		'２' => '2', '６' => '6', 'Ｂ' => 'B', 'Ｆ' => 'F', 'Ｊ' => 'J', 'Ｎ' => 'N', 'Ｒ' => 'R', 'Ｖ' => 'V', 'Ｚ' => 'Z', 'ｂ' => 'b', 'ｆ' => 'f', 'ｊ' => 'j', 'ｎ' => 'n', 'ｒ' => 'r', 'ｖ' => 'v', 'ｚ' => 'z', '１' => '1', '５' => '5', '９' => '9', 'Ａ' => 'A', 'Ｅ' => 'E', 'Ｉ' => 'I', 'Ｍ' => 'M', 'Ｑ' => 'Q', 'Ｕ' => 'U', 'Ｙ' => 'Y', 'ａ' => 'a', 'ｅ' => 'e', 'ｉ' => 'i', 'ｍ' => 'm', 'ｑ' => 'q', 'ｕ' => 'u', 'ｙ' => 'y', '０' => '0', '４' => '4', '８' => '8', 'Ｄ' => 'D', 'Ｈ' => 'H', 'Ｌ' => 'L', 'Ｐ' => 'P', 'Ｔ' => 'T', 'Ｘ' => 'X', 'ｄ' => 'd', 'ｈ' => 'h', 'ｌ' => 'l', 'ｐ' => 'p', 'ｔ' => 't', 'ｘ' => 'x', '３' => '3', '７' => '7', 'Ｃ' => 'C', 'Ｇ' => 'G', 'Ｋ' => 'K', 'Ｏ' => 'O', 'Ｓ' => 'S', 'Ｗ' => 'W', 'ｃ' => 'c', 'ｇ' => 'g', 'ｋ' => 'k', 'ｏ' => 'o', 'ｓ' => 's', 'ｗ' => 'w');
		return str_replace(array_keys($accent_map), array_values($accent_map), $address);
	}

	/**
	* Checks the permissions for the current user. Returns true if the current user has any of the specified capabilities.
	* IMPORTANT: Call this before calling any of the other API Functions as permission checks are not performed at lower levels.
	*
	* @since  2.5
	* @access public
	* @static
	*
	* @param array|string $capabilities An array of capabilities, or a single capability
	*
	* @return bool Returns true if the current user has any of the specified capabilities
	*/
	public static function current_user_can_any( $capabilities ) {
	 	if ( ! is_array( $caps ) ) {
			$has_cap = current_user_can( $caps ) || current_user_can( 'administrator' );
			return $has_cap;
		}
		foreach ( $caps as $cap ) {
			if ( current_user_can( $cap ) ) {
				return true;
			}
		}
		$has_full_access = current_user_can( 'administrator' );
		return $has_full_access;
	}

 }//info: END class MMPAPI
?>