/* DUPLICATOR MYSQL SCRIPT CREATED ON : 2015-12-05 11:52:34 */

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_root_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_fileaway_downloads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` varchar(255) DEFAULT NULL,
  `file` varchar(1000) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `agent` varchar(255) DEFAULT NULL,
  `notified` bit(1) DEFAULT b'0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_fileaway_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file` varchar(1000) DEFAULT NULL,
  `metadata` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=678 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=253 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=116 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_root_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_album_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `album_id` bigint(20) NOT NULL,
  `is_album` tinyint(1) NOT NULL,
  `alb_gal_id` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_gallery` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `description` mediumtext NOT NULL,
  `page_link` mediumtext NOT NULL,
  `preview_image` mediumtext NOT NULL,
  `random_preview_image` mediumtext NOT NULL,
  `order` bigint(20) NOT NULL,
  `author` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `gallery_type` varchar(32) NOT NULL,
  `gallery_source` varchar(256) NOT NULL,
  `autogallery_image_number` int(4) NOT NULL,
  `update_flag` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_image` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `gallery_id` bigint(20) NOT NULL,
  `slug` longtext NOT NULL,
  `filename` varchar(255) NOT NULL,
  `image_url` mediumtext NOT NULL,
  `thumb_url` mediumtext NOT NULL,
  `description` mediumtext NOT NULL,
  `alt` mediumtext NOT NULL,
  `date` varchar(128) NOT NULL,
  `size` varchar(128) NOT NULL,
  `filetype` varchar(128) NOT NULL,
  `resolution` varchar(128) NOT NULL,
  `author` bigint(20) NOT NULL,
  `order` bigint(20) NOT NULL,
  `published` tinyint(1) NOT NULL,
  `comment_count` bigint(20) NOT NULL,
  `avg_rating` float NOT NULL,
  `rate_count` bigint(20) NOT NULL,
  `hit_count` bigint(20) NOT NULL,
  `redirect_url` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=175 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_image_comment` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `name` varchar(255) NOT NULL,
  `date` varchar(64) NOT NULL,
  `comment` mediumtext NOT NULL,
  `url` mediumtext NOT NULL,
  `mail` mediumtext NOT NULL,
  `published` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_image_rate` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_id` bigint(20) NOT NULL,
  `rate` float NOT NULL,
  `ip` varchar(64) NOT NULL,
  `date` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_image_tag` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `tag_id` bigint(20) NOT NULL,
  `image_id` bigint(20) NOT NULL,
  `gallery_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_option` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `images_directory` mediumtext NOT NULL,
  `masonry` varchar(255) NOT NULL,
  `mosaic` varchar(255) NOT NULL,
  `resizable_mosaic` tinyint(1) NOT NULL,
  `mosaic_total_width` int(4) NOT NULL,
  `image_column_number` int(4) NOT NULL,
  `images_per_page` int(4) NOT NULL,
  `thumb_width` int(4) NOT NULL,
  `thumb_height` int(4) NOT NULL,
  `upload_thumb_width` int(4) NOT NULL,
  `upload_thumb_height` int(4) NOT NULL,
  `image_enable_page` tinyint(1) NOT NULL,
  `image_title_show_hover` varchar(20) NOT NULL,
  `album_column_number` int(4) NOT NULL,
  `albums_per_page` int(4) NOT NULL,
  `album_title_show_hover` varchar(8) NOT NULL,
  `album_thumb_width` int(4) NOT NULL,
  `album_thumb_height` int(4) NOT NULL,
  `album_enable_page` tinyint(1) NOT NULL,
  `extended_album_height` int(4) NOT NULL,
  `extended_album_description_enable` tinyint(1) NOT NULL,
  `image_browser_width` int(4) NOT NULL,
  `image_browser_title_enable` tinyint(1) NOT NULL,
  `image_browser_description_enable` tinyint(1) NOT NULL,
  `blog_style_width` int(4) NOT NULL,
  `blog_style_title_enable` tinyint(1) NOT NULL,
  `blog_style_images_per_page` int(4) NOT NULL,
  `blog_style_enable_page` tinyint(1) NOT NULL,
  `slideshow_type` varchar(16) NOT NULL,
  `slideshow_interval` int(4) NOT NULL,
  `slideshow_width` int(4) NOT NULL,
  `slideshow_height` int(4) NOT NULL,
  `slideshow_enable_autoplay` tinyint(1) NOT NULL,
  `slideshow_enable_shuffle` tinyint(1) NOT NULL,
  `slideshow_enable_ctrl` tinyint(1) NOT NULL,
  `slideshow_enable_filmstrip` tinyint(1) NOT NULL,
  `slideshow_filmstrip_height` int(4) NOT NULL,
  `slideshow_enable_title` tinyint(1) NOT NULL,
  `slideshow_title_position` varchar(16) NOT NULL,
  `slideshow_enable_description` tinyint(1) NOT NULL,
  `slideshow_description_position` varchar(16) NOT NULL,
  `slideshow_enable_music` tinyint(1) NOT NULL,
  `slideshow_audio_url` varchar(255) NOT NULL,
  `popup_width` int(4) NOT NULL,
  `popup_height` int(4) NOT NULL,
  `popup_type` varchar(16) NOT NULL,
  `popup_interval` int(4) NOT NULL,
  `popup_enable_filmstrip` tinyint(1) NOT NULL,
  `popup_filmstrip_height` int(4) NOT NULL,
  `popup_enable_ctrl_btn` tinyint(1) NOT NULL,
  `popup_enable_fullscreen` tinyint(1) NOT NULL,
  `popup_enable_info` tinyint(1) NOT NULL,
  `popup_info_always_show` tinyint(1) NOT NULL,
  `popup_enable_rate` tinyint(1) NOT NULL,
  `popup_enable_comment` tinyint(1) NOT NULL,
  `popup_enable_email` tinyint(1) NOT NULL,
  `popup_enable_captcha` tinyint(1) NOT NULL,
  `popup_enable_download` tinyint(1) NOT NULL,
  `popup_enable_fullsize_image` tinyint(1) NOT NULL,
  `popup_enable_facebook` tinyint(1) NOT NULL,
  `popup_enable_twitter` tinyint(1) NOT NULL,
  `popup_enable_google` tinyint(1) NOT NULL,
  `watermark_type` varchar(8) NOT NULL,
  `watermark_position` varchar(16) NOT NULL,
  `watermark_width` int(4) NOT NULL,
  `watermark_height` int(4) NOT NULL,
  `watermark_url` mediumtext NOT NULL,
  `watermark_text` mediumtext NOT NULL,
  `watermark_link` mediumtext NOT NULL,
  `watermark_font_size` int(4) NOT NULL,
  `watermark_font` varchar(16) NOT NULL,
  `watermark_color` varchar(8) NOT NULL,
  `watermark_opacity` int(4) NOT NULL,
  `built_in_watermark_type` varchar(16) NOT NULL,
  `built_in_watermark_position` varchar(16) NOT NULL,
  `built_in_watermark_size` int(4) NOT NULL,
  `built_in_watermark_url` mediumtext NOT NULL,
  `built_in_watermark_text` mediumtext NOT NULL,
  `built_in_watermark_font_size` int(4) NOT NULL,
  `built_in_watermark_font` varchar(16) NOT NULL,
  `built_in_watermark_color` varchar(8) NOT NULL,
  `built_in_watermark_opacity` int(4) NOT NULL,
  `image_right_click` tinyint(1) NOT NULL,
  `popup_fullscreen` tinyint(1) NOT NULL,
  `gallery_role` tinyint(1) NOT NULL,
  `album_role` tinyint(1) NOT NULL,
  `image_role` tinyint(1) NOT NULL,
  `popup_autoplay` tinyint(1) NOT NULL,
  `album_view_type` varchar(16) NOT NULL,
  `popup_enable_pinterest` tinyint(1) NOT NULL,
  `popup_enable_tumblr` tinyint(1) NOT NULL,
  `show_search_box` tinyint(1) NOT NULL,
  `search_box_width` int(4) NOT NULL,
  `preload_images` tinyint(1) NOT NULL,
  `preload_images_count` int(4) NOT NULL,
  `thumb_click_action` varchar(16) NOT NULL,
  `thumb_link_target` tinyint(1) NOT NULL,
  `comment_moderation` tinyint(1) NOT NULL,
  `popup_hit_counter` tinyint(1) NOT NULL,
  `enable_ML_import` tinyint(1) NOT NULL,
  `showthumbs_name` tinyint(1) NOT NULL,
  `show_album_name` tinyint(1) NOT NULL,
  `show_image_counts` tinyint(1) NOT NULL,
  `upload_img_width` int(4) NOT NULL,
  `upload_img_height` int(4) NOT NULL,
  `play_icon` tinyint(1) NOT NULL,
  `show_masonry_thumb_description` tinyint(1) NOT NULL,
  `slideshow_title_full_width` tinyint(1) NOT NULL,
  `popup_info_full_width` tinyint(1) NOT NULL,
  `show_sort_images` tinyint(1) NOT NULL,
  `autoupdate_interval` int(4) NOT NULL,
  `instagram_client_id` varchar(40) NOT NULL,
  `description_tb` tinyint(1) NOT NULL,
  `enable_seo` tinyint(1) NOT NULL,
  `autohide_lightbox_navigation` tinyint(1) NOT NULL,
  `autohide_slideshow_navigation` tinyint(1) NOT NULL,
  `read_metadata` tinyint(1) NOT NULL,
  `enable_loop` tinyint(1) NOT NULL,
  `enable_addthis` tinyint(1) NOT NULL,
  `addthis_profile_id` varchar(66) NOT NULL,
  `carousel_interval` int(4) NOT NULL,
  `carousel_width` int(4) NOT NULL,
  `carousel_height` int(4) NOT NULL,
  `carousel_image_column_number` int(4) NOT NULL,
  `carousel_image_par` varchar(32) NOT NULL,
  `carousel_enable_title` tinyint(1) NOT NULL,
  `carousel_enable_autoplay` tinyint(1) NOT NULL,
  `carousel_r_width` int(4) NOT NULL,
  `carousel_fit_containerWidth` tinyint(1) NOT NULL,
  `carousel_prev_next_butt` tinyint(1) NOT NULL,
  `carousel_play_pause_butt` tinyint(1) NOT NULL,
  `permissions` varchar(20) NOT NULL,
  `facebook_app_id` varchar(64) NOT NULL,
  `facebook_app_secret` varchar(64) NOT NULL,
  `show_tag_box` tinyint(1) NOT NULL,
  `show_hide_custom_post` tinyint(1) NOT NULL,
  `show_hide_post_meta` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_shortcode` (
  `id` bigint(20) NOT NULL,
  `tagtext` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_bwg_theme` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `thumb_margin` int(4) NOT NULL,
  `thumb_padding` int(4) NOT NULL,
  `thumb_border_radius` varchar(32) NOT NULL,
  `thumb_border_width` int(4) NOT NULL,
  `thumb_border_style` varchar(16) NOT NULL,
  `thumb_border_color` varchar(8) NOT NULL,
  `thumb_bg_color` varchar(8) NOT NULL,
  `thumbs_bg_color` varchar(8) NOT NULL,
  `thumb_bg_transparent` int(4) NOT NULL,
  `thumb_box_shadow` varchar(32) NOT NULL,
  `thumb_transparent` int(4) NOT NULL,
  `thumb_align` varchar(8) NOT NULL,
  `thumb_hover_effect` varchar(128) NOT NULL,
  `thumb_hover_effect_value` varchar(128) NOT NULL,
  `thumb_transition` tinyint(1) NOT NULL,
  `thumb_title_font_color` varchar(8) NOT NULL,
  `thumb_title_font_style` varchar(16) NOT NULL,
  `thumb_title_pos` varchar(8) NOT NULL,
  `thumb_title_font_size` int(4) NOT NULL,
  `thumb_title_font_weight` varchar(8) NOT NULL,
  `thumb_title_margin` varchar(32) NOT NULL,
  `thumb_title_shadow` varchar(32) NOT NULL,
  `page_nav_position` varchar(8) NOT NULL,
  `page_nav_align` varchar(8) NOT NULL,
  `page_nav_number` tinyint(1) NOT NULL,
  `page_nav_font_size` int(4) NOT NULL,
  `page_nav_font_style` varchar(32) NOT NULL,
  `page_nav_font_color` varchar(8) NOT NULL,
  `page_nav_font_weight` varchar(8) NOT NULL,
  `page_nav_border_width` int(4) NOT NULL,
  `page_nav_border_style` varchar(16) NOT NULL,
  `page_nav_border_color` varchar(8) NOT NULL,
  `page_nav_border_radius` varchar(32) NOT NULL,
  `page_nav_margin` varchar(32) NOT NULL,
  `page_nav_padding` varchar(32) NOT NULL,
  `page_nav_button_bg_color` varchar(8) NOT NULL,
  `page_nav_button_bg_transparent` int(4) NOT NULL,
  `page_nav_box_shadow` varchar(32) NOT NULL,
  `page_nav_button_transition` tinyint(1) NOT NULL,
  `page_nav_button_text` tinyint(1) NOT NULL,
  `lightbox_overlay_bg_color` varchar(8) NOT NULL,
  `lightbox_overlay_bg_transparent` int(4) NOT NULL,
  `lightbox_bg_color` varchar(8) NOT NULL,
  `lightbox_ctrl_btn_pos` varchar(8) NOT NULL,
  `lightbox_ctrl_btn_align` varchar(8) NOT NULL,
  `lightbox_ctrl_btn_height` int(4) NOT NULL,
  `lightbox_ctrl_btn_margin_top` int(4) NOT NULL,
  `lightbox_ctrl_btn_margin_left` int(4) NOT NULL,
  `lightbox_ctrl_btn_transparent` int(4) NOT NULL,
  `lightbox_ctrl_btn_color` varchar(8) NOT NULL,
  `lightbox_toggle_btn_height` int(4) NOT NULL,
  `lightbox_toggle_btn_width` int(4) NOT NULL,
  `lightbox_ctrl_cont_bg_color` varchar(8) NOT NULL,
  `lightbox_ctrl_cont_transparent` int(4) NOT NULL,
  `lightbox_ctrl_cont_border_radius` int(4) NOT NULL,
  `lightbox_close_btn_transparent` int(4) NOT NULL,
  `lightbox_close_btn_bg_color` varchar(8) NOT NULL,
  `lightbox_close_btn_border_width` int(4) NOT NULL,
  `lightbox_close_btn_border_radius` varchar(32) NOT NULL,
  `lightbox_close_btn_border_style` varchar(16) NOT NULL,
  `lightbox_close_btn_border_color` varchar(8) NOT NULL,
  `lightbox_close_btn_box_shadow` varchar(32) NOT NULL,
  `lightbox_close_btn_color` varchar(8) NOT NULL,
  `lightbox_close_btn_size` int(4) NOT NULL,
  `lightbox_close_btn_width` int(4) NOT NULL,
  `lightbox_close_btn_height` int(4) NOT NULL,
  `lightbox_close_btn_top` varchar(8) NOT NULL,
  `lightbox_close_btn_right` varchar(8) NOT NULL,
  `lightbox_close_btn_full_color` varchar(8) NOT NULL,
  `lightbox_rl_btn_bg_color` varchar(8) NOT NULL,
  `lightbox_rl_btn_transparent` int(4) NOT NULL,
  `lightbox_rl_btn_border_radius` varchar(32) NOT NULL,
  `lightbox_rl_btn_border_width` int(4) NOT NULL,
  `lightbox_rl_btn_border_style` varchar(32) NOT NULL,
  `lightbox_rl_btn_border_color` varchar(8) NOT NULL,
  `lightbox_rl_btn_box_shadow` varchar(32) NOT NULL,
  `lightbox_rl_btn_color` varchar(8) NOT NULL,
  `lightbox_rl_btn_height` int(4) NOT NULL,
  `lightbox_rl_btn_width` int(4) NOT NULL,
  `lightbox_rl_btn_size` int(4) NOT NULL,
  `lightbox_close_rl_btn_hover_color` varchar(8) NOT NULL,
  `lightbox_comment_pos` varchar(8) NOT NULL,
  `lightbox_comment_width` int(4) NOT NULL,
  `lightbox_comment_bg_color` varchar(8) NOT NULL,
  `lightbox_comment_font_color` varchar(8) NOT NULL,
  `lightbox_comment_font_style` varchar(16) NOT NULL,
  `lightbox_comment_font_size` int(4) NOT NULL,
  `lightbox_comment_button_bg_color` varchar(8) NOT NULL,
  `lightbox_comment_button_border_color` varchar(8) NOT NULL,
  `lightbox_comment_button_border_width` int(4) NOT NULL,
  `lightbox_comment_button_border_style` varchar(16) NOT NULL,
  `lightbox_comment_button_border_radius` varchar(32) NOT NULL,
  `lightbox_comment_button_padding` varchar(32) NOT NULL,
  `lightbox_comment_input_bg_color` varchar(8) NOT NULL,
  `lightbox_comment_input_border_color` varchar(8) NOT NULL,
  `lightbox_comment_input_border_width` int(4) NOT NULL,
  `lightbox_comment_input_border_style` varchar(16) NOT NULL,
  `lightbox_comment_input_border_radius` varchar(32) NOT NULL,
  `lightbox_comment_input_padding` varchar(32) NOT NULL,
  `lightbox_comment_separator_width` int(4) NOT NULL,
  `lightbox_comment_separator_style` varchar(16) NOT NULL,
  `lightbox_comment_separator_color` varchar(8) NOT NULL,
  `lightbox_comment_author_font_size` int(4) NOT NULL,
  `lightbox_comment_date_font_size` int(4) NOT NULL,
  `lightbox_comment_body_font_size` int(4) NOT NULL,
  `lightbox_comment_share_button_color` varchar(8) NOT NULL,
  `lightbox_filmstrip_pos` varchar(8) NOT NULL,
  `lightbox_filmstrip_rl_bg_color` varchar(8) NOT NULL,
  `lightbox_filmstrip_rl_btn_size` int(4) NOT NULL,
  `lightbox_filmstrip_rl_btn_color` varchar(8) NOT NULL,
  `lightbox_filmstrip_thumb_margin` varchar(32) NOT NULL,
  `lightbox_filmstrip_thumb_border_width` int(4) NOT NULL,
  `lightbox_filmstrip_thumb_border_style` varchar(16) NOT NULL,
  `lightbox_filmstrip_thumb_border_color` varchar(8) NOT NULL,
  `lightbox_filmstrip_thumb_border_radius` varchar(32) NOT NULL,
  `lightbox_filmstrip_thumb_deactive_transparent` int(4) NOT NULL,
  `lightbox_filmstrip_thumb_active_border_width` int(4) NOT NULL,
  `lightbox_filmstrip_thumb_active_border_color` varchar(8) NOT NULL,
  `lightbox_rl_btn_style` varchar(16) NOT NULL,
  `album_compact_back_font_color` varchar(8) NOT NULL,
  `album_compact_back_font_style` varchar(16) NOT NULL,
  `album_compact_back_font_size` int(4) NOT NULL,
  `album_compact_back_font_weight` varchar(8) NOT NULL,
  `album_compact_back_padding` varchar(32) NOT NULL,
  `album_compact_title_font_color` varchar(8) NOT NULL,
  `album_compact_title_font_style` varchar(16) NOT NULL,
  `album_compact_thumb_title_pos` varchar(8) NOT NULL,
  `album_compact_title_font_size` int(4) NOT NULL,
  `album_compact_title_font_weight` varchar(8) NOT NULL,
  `album_compact_title_margin` varchar(32) NOT NULL,
  `album_compact_title_shadow` varchar(32) NOT NULL,
  `album_compact_thumb_margin` int(4) NOT NULL,
  `album_compact_thumb_padding` int(4) NOT NULL,
  `album_compact_thumb_border_radius` varchar(32) NOT NULL,
  `album_compact_thumb_border_width` int(4) NOT NULL,
  `album_compact_thumb_border_style` varchar(8) NOT NULL,
  `album_compact_thumb_border_color` varchar(8) NOT NULL,
  `album_compact_thumb_bg_color` varchar(8) NOT NULL,
  `album_compact_thumbs_bg_color` varchar(8) NOT NULL,
  `album_compact_thumb_bg_transparent` int(4) NOT NULL,
  `album_compact_thumb_box_shadow` varchar(32) NOT NULL,
  `album_compact_thumb_transparent` int(4) NOT NULL,
  `album_compact_thumb_align` varchar(8) NOT NULL,
  `album_compact_thumb_hover_effect` varchar(64) NOT NULL,
  `album_compact_thumb_hover_effect_value` varchar(64) NOT NULL,
  `album_compact_thumb_transition` tinyint(1) NOT NULL,
  `album_extended_thumb_margin` int(4) NOT NULL,
  `album_extended_thumb_padding` int(4) NOT NULL,
  `album_extended_thumb_border_radius` varchar(32) NOT NULL,
  `album_extended_thumb_border_width` int(4) NOT NULL,
  `album_extended_thumb_border_style` varchar(8) NOT NULL,
  `album_extended_thumb_border_color` varchar(8) NOT NULL,
  `album_extended_thumb_bg_color` varchar(8) NOT NULL,
  `album_extended_thumbs_bg_color` varchar(8) NOT NULL,
  `album_extended_thumb_bg_transparent` int(4) NOT NULL,
  `album_extended_thumb_box_shadow` varchar(32) NOT NULL,
  `album_extended_thumb_transparent` int(4) NOT NULL,
  `album_extended_thumb_align` varchar(8) NOT NULL,
  `album_extended_thumb_hover_effect` varchar(64) NOT NULL,
  `album_extended_thumb_hover_effect_value` varchar(64) NOT NULL,
  `album_extended_thumb_transition` tinyint(1) NOT NULL,
  `album_extended_back_font_color` varchar(8) NOT NULL,
  `album_extended_back_font_style` varchar(16) NOT NULL,
  `album_extended_back_font_size` int(4) NOT NULL,
  `album_extended_back_font_weight` varchar(8) NOT NULL,
  `album_extended_back_padding` varchar(32) NOT NULL,
  `album_extended_div_bg_color` varchar(8) NOT NULL,
  `album_extended_div_bg_transparent` int(4) NOT NULL,
  `album_extended_div_border_radius` varchar(32) NOT NULL,
  `album_extended_div_margin` varchar(32) NOT NULL,
  `album_extended_div_padding` int(4) NOT NULL,
  `album_extended_div_separator_width` int(4) NOT NULL,
  `album_extended_div_separator_style` varchar(8) NOT NULL,
  `album_extended_div_separator_color` varchar(8) NOT NULL,
  `album_extended_thumb_div_bg_color` varchar(8) NOT NULL,
  `album_extended_thumb_div_border_radius` varchar(32) NOT NULL,
  `album_extended_thumb_div_border_width` int(4) NOT NULL,
  `album_extended_thumb_div_border_style` varchar(8) NOT NULL,
  `album_extended_thumb_div_border_color` varchar(8) NOT NULL,
  `album_extended_thumb_div_padding` varchar(32) NOT NULL,
  `album_extended_text_div_bg_color` varchar(8) NOT NULL,
  `album_extended_text_div_border_radius` varchar(32) NOT NULL,
  `album_extended_text_div_border_width` int(4) NOT NULL,
  `album_extended_text_div_border_style` varchar(8) NOT NULL,
  `album_extended_text_div_border_color` varchar(8) NOT NULL,
  `album_extended_text_div_padding` varchar(32) NOT NULL,
  `album_extended_title_span_border_width` int(4) NOT NULL,
  `album_extended_title_span_border_style` varchar(8) NOT NULL,
  `album_extended_title_span_border_color` varchar(8) NOT NULL,
  `album_extended_title_font_color` varchar(8) NOT NULL,
  `album_extended_title_font_style` varchar(16) NOT NULL,
  `album_extended_title_font_size` int(4) NOT NULL,
  `album_extended_title_font_weight` varchar(8) NOT NULL,
  `album_extended_title_margin_bottom` int(4) NOT NULL,
  `album_extended_title_padding` varchar(32) NOT NULL,
  `album_extended_desc_span_border_width` int(4) NOT NULL,
  `album_extended_desc_span_border_style` varchar(8) NOT NULL,
  `album_extended_desc_span_border_color` varchar(8) NOT NULL,
  `album_extended_desc_font_color` varchar(8) NOT NULL,
  `album_extended_desc_font_style` varchar(16) NOT NULL,
  `album_extended_desc_font_size` int(4) NOT NULL,
  `album_extended_desc_font_weight` varchar(8) NOT NULL,
  `album_extended_desc_padding` varchar(32) NOT NULL,
  `album_extended_desc_more_color` varchar(8) NOT NULL,
  `album_extended_desc_more_size` int(4) NOT NULL,
  `masonry_thumb_padding` int(4) NOT NULL,
  `masonry_thumb_border_radius` varchar(32) NOT NULL,
  `masonry_thumb_border_width` int(4) NOT NULL,
  `masonry_thumb_border_style` varchar(8) NOT NULL,
  `masonry_thumb_border_color` varchar(8) NOT NULL,
  `masonry_thumbs_bg_color` varchar(8) NOT NULL,
  `masonry_thumb_bg_transparent` int(4) NOT NULL,
  `masonry_thumb_transparent` int(4) NOT NULL,
  `masonry_thumb_align` varchar(8) NOT NULL,
  `masonry_thumb_hover_effect` varchar(64) NOT NULL,
  `masonry_thumb_hover_effect_value` varchar(64) NOT NULL,
  `masonry_thumb_transition` tinyint(1) NOT NULL,
  `mosaic_thumb_padding` int(4) NOT NULL,
  `mosaic_thumb_border_radius` varchar(32) NOT NULL,
  `mosaic_thumb_border_width` int(4) NOT NULL,
  `mosaic_thumb_border_style` varchar(8) NOT NULL,
  `mosaic_thumb_border_color` varchar(8) NOT NULL,
  `mosaic_thumbs_bg_color` varchar(8) NOT NULL,
  `mosaic_thumb_bg_transparent` int(4) NOT NULL,
  `mosaic_thumb_transparent` int(4) NOT NULL,
  `mosaic_thumb_align` varchar(8) NOT NULL,
  `mosaic_thumb_hover_effect` varchar(64) NOT NULL,
  `mosaic_thumb_hover_effect_value` varchar(64) NOT NULL,
  `mosaic_thumb_title_font_color` varchar(8) NOT NULL,
  `mosaic_thumb_title_font_style` varchar(16) NOT NULL,
  `mosaic_thumb_title_font_size` int(4) NOT NULL,
  `mosaic_thumb_title_font_weight` varchar(8) NOT NULL,
  `mosaic_thumb_title_margin` varchar(32) NOT NULL,
  `mosaic_thumb_title_shadow` varchar(32) NOT NULL,
  `slideshow_cont_bg_color` varchar(8) NOT NULL,
  `slideshow_close_btn_transparent` int(4) NOT NULL,
  `slideshow_rl_btn_bg_color` varchar(8) NOT NULL,
  `slideshow_rl_btn_border_radius` varchar(32) NOT NULL,
  `slideshow_rl_btn_border_width` int(4) NOT NULL,
  `slideshow_rl_btn_border_style` varchar(8) NOT NULL,
  `slideshow_rl_btn_border_color` varchar(8) NOT NULL,
  `slideshow_rl_btn_box_shadow` varchar(32) NOT NULL,
  `slideshow_rl_btn_color` varchar(8) NOT NULL,
  `slideshow_rl_btn_height` int(4) NOT NULL,
  `slideshow_rl_btn_size` int(4) NOT NULL,
  `slideshow_rl_btn_width` int(4) NOT NULL,
  `slideshow_close_rl_btn_hover_color` varchar(8) NOT NULL,
  `slideshow_filmstrip_pos` varchar(8) NOT NULL,
  `slideshow_filmstrip_thumb_border_width` int(4) NOT NULL,
  `slideshow_filmstrip_thumb_border_style` varchar(8) NOT NULL,
  `slideshow_filmstrip_thumb_border_color` varchar(8) NOT NULL,
  `slideshow_filmstrip_thumb_border_radius` varchar(32) NOT NULL,
  `slideshow_filmstrip_thumb_margin` varchar(32) NOT NULL,
  `slideshow_filmstrip_thumb_active_border_width` int(4) NOT NULL,
  `slideshow_filmstrip_thumb_active_border_color` varchar(8) NOT NULL,
  `slideshow_filmstrip_thumb_deactive_transparent` int(4) NOT NULL,
  `slideshow_filmstrip_rl_bg_color` varchar(8) NOT NULL,
  `slideshow_filmstrip_rl_btn_color` varchar(8) NOT NULL,
  `slideshow_filmstrip_rl_btn_size` int(4) NOT NULL,
  `slideshow_title_font_size` int(4) NOT NULL,
  `slideshow_title_font` varchar(16) NOT NULL,
  `slideshow_title_color` varchar(8) NOT NULL,
  `slideshow_title_opacity` int(4) NOT NULL,
  `slideshow_title_border_radius` varchar(32) NOT NULL,
  `slideshow_title_background_color` varchar(8) NOT NULL,
  `slideshow_title_padding` varchar(32) NOT NULL,
  `slideshow_description_font_size` int(4) NOT NULL,
  `slideshow_description_font` varchar(16) NOT NULL,
  `slideshow_description_color` varchar(8) NOT NULL,
  `slideshow_description_opacity` int(4) NOT NULL,
  `slideshow_description_border_radius` varchar(32) NOT NULL,
  `slideshow_description_background_color` varchar(8) NOT NULL,
  `slideshow_description_padding` varchar(32) NOT NULL,
  `slideshow_dots_width` int(4) NOT NULL,
  `slideshow_dots_height` int(4) NOT NULL,
  `slideshow_dots_border_radius` varchar(32) NOT NULL,
  `slideshow_dots_background_color` varchar(8) NOT NULL,
  `slideshow_dots_margin` int(4) NOT NULL,
  `slideshow_dots_active_background_color` varchar(8) NOT NULL,
  `slideshow_dots_active_border_width` int(4) NOT NULL,
  `slideshow_dots_active_border_color` varchar(8) NOT NULL,
  `slideshow_play_pause_btn_size` int(4) NOT NULL,
  `slideshow_rl_btn_style` varchar(16) NOT NULL,
  `blog_style_margin` varchar(32) NOT NULL,
  `blog_style_padding` varchar(32) NOT NULL,
  `blog_style_border_radius` varchar(32) NOT NULL,
  `blog_style_border_width` int(4) NOT NULL,
  `blog_style_border_style` varchar(16) NOT NULL,
  `blog_style_border_color` varchar(8) NOT NULL,
  `blog_style_bg_color` varchar(8) NOT NULL,
  `blog_style_box_shadow` varchar(32) NOT NULL,
  `blog_style_transparent` int(4) NOT NULL,
  `blog_style_align` varchar(8) NOT NULL,
  `blog_style_share_buttons_bg_color` varchar(8) NOT NULL,
  `blog_style_share_buttons_margin` varchar(32) NOT NULL,
  `blog_style_share_buttons_border_radius` varchar(32) NOT NULL,
  `blog_style_share_buttons_border_width` int(4) NOT NULL,
  `blog_style_share_buttons_border_style` varchar(16) NOT NULL,
  `blog_style_share_buttons_border_color` varchar(8) NOT NULL,
  `blog_style_share_buttons_align` varchar(8) NOT NULL,
  `blog_style_img_font_size` int(4) NOT NULL,
  `blog_style_img_font_family` varchar(16) NOT NULL,
  `blog_style_img_font_color` varchar(8) NOT NULL,
  `blog_style_share_buttons_color` varchar(8) NOT NULL,
  `blog_style_share_buttons_bg_transparent` int(4) NOT NULL,
  `blog_style_share_buttons_font_size` int(4) NOT NULL,
  `image_browser_margin` varchar(32) NOT NULL,
  `image_browser_padding` varchar(32) NOT NULL,
  `image_browser_border_radius` varchar(32) NOT NULL,
  `image_browser_border_width` int(4) NOT NULL,
  `image_browser_border_style` varchar(16) NOT NULL,
  `image_browser_border_color` varchar(8) NOT NULL,
  `image_browser_bg_color` varchar(8) NOT NULL,
  `image_browser_box_shadow` varchar(32) NOT NULL,
  `image_browser_transparent` int(4) NOT NULL,
  `image_browser_align` varchar(8) NOT NULL,
  `image_browser_image_description_margin` varchar(32) NOT NULL,
  `image_browser_image_description_padding` varchar(32) NOT NULL,
  `image_browser_image_description_border_radius` varchar(32) NOT NULL,
  `image_browser_image_description_border_width` int(4) NOT NULL,
  `image_browser_image_description_border_style` varchar(16) NOT NULL,
  `image_browser_image_description_border_color` varchar(8) NOT NULL,
  `image_browser_image_description_bg_color` varchar(8) NOT NULL,
  `image_browser_image_description_align` varchar(8) NOT NULL,
  `image_browser_img_font_size` int(4) NOT NULL,
  `image_browser_img_font_family` varchar(16) NOT NULL,
  `image_browser_img_font_color` varchar(8) NOT NULL,
  `image_browser_full_padding` varchar(32) NOT NULL,
  `image_browser_full_border_radius` varchar(32) NOT NULL,
  `image_browser_full_border_width` int(4) NOT NULL,
  `image_browser_full_border_style` varchar(16) NOT NULL,
  `image_browser_full_border_color` varchar(8) NOT NULL,
  `image_browser_full_bg_color` varchar(8) NOT NULL,
  `image_browser_full_transparent` int(4) NOT NULL,
  `lightbox_info_pos` varchar(8) NOT NULL,
  `lightbox_info_align` varchar(8) NOT NULL,
  `lightbox_info_bg_color` varchar(8) NOT NULL,
  `lightbox_info_bg_transparent` int(4) NOT NULL,
  `lightbox_info_border_width` int(4) NOT NULL,
  `lightbox_info_border_style` varchar(16) NOT NULL,
  `lightbox_info_border_color` varchar(8) NOT NULL,
  `lightbox_info_border_radius` varchar(32) NOT NULL,
  `lightbox_info_padding` varchar(32) NOT NULL,
  `lightbox_info_margin` varchar(32) NOT NULL,
  `lightbox_title_color` varchar(8) NOT NULL,
  `lightbox_title_font_style` varchar(16) NOT NULL,
  `lightbox_title_font_weight` varchar(8) NOT NULL,
  `lightbox_title_font_size` int(4) NOT NULL,
  `lightbox_description_color` varchar(8) NOT NULL,
  `lightbox_description_font_style` varchar(16) NOT NULL,
  `lightbox_description_font_weight` varchar(8) NOT NULL,
  `lightbox_description_font_size` int(4) NOT NULL,
  `lightbox_rate_pos` varchar(8) NOT NULL,
  `lightbox_rate_align` varchar(8) NOT NULL,
  `lightbox_rate_icon` varchar(16) NOT NULL,
  `lightbox_rate_color` varchar(8) NOT NULL,
  `lightbox_rate_size` int(4) NOT NULL,
  `lightbox_rate_stars_count` int(4) NOT NULL,
  `lightbox_rate_padding` varchar(32) NOT NULL,
  `lightbox_rate_hover_color` varchar(8) NOT NULL,
  `lightbox_hit_pos` varchar(8) NOT NULL,
  `lightbox_hit_align` varchar(8) NOT NULL,
  `lightbox_hit_bg_color` varchar(8) NOT NULL,
  `lightbox_hit_bg_transparent` int(4) NOT NULL,
  `lightbox_hit_border_width` int(4) NOT NULL,
  `lightbox_hit_border_style` varchar(16) NOT NULL,
  `lightbox_hit_border_color` varchar(8) NOT NULL,
  `lightbox_hit_border_radius` varchar(32) NOT NULL,
  `lightbox_hit_padding` varchar(32) NOT NULL,
  `lightbox_hit_margin` varchar(32) NOT NULL,
  `lightbox_hit_color` varchar(8) NOT NULL,
  `lightbox_hit_font_style` varchar(16) NOT NULL,
  `lightbox_hit_font_weight` varchar(8) NOT NULL,
  `lightbox_hit_font_size` int(4) NOT NULL,
  `masonry_description_font_size` int(4) NOT NULL,
  `masonry_description_color` varchar(8) NOT NULL,
  `masonry_description_font_style` varchar(16) NOT NULL,
  `album_masonry_back_font_color` varchar(8) NOT NULL,
  `album_masonry_back_font_style` varchar(16) NOT NULL,
  `album_masonry_back_font_size` int(4) NOT NULL,
  `album_masonry_back_font_weight` varchar(8) NOT NULL,
  `album_masonry_back_padding` varchar(32) NOT NULL,
  `album_masonry_title_font_color` varchar(8) NOT NULL,
  `album_masonry_title_font_style` varchar(16) NOT NULL,
  `album_masonry_thumb_title_pos` varchar(8) NOT NULL,
  `album_masonry_title_font_size` int(4) NOT NULL,
  `album_masonry_title_font_weight` varchar(8) NOT NULL,
  `album_masonry_title_margin` varchar(32) NOT NULL,
  `album_masonry_title_shadow` varchar(32) NOT NULL,
  `album_masonry_thumb_margin` int(4) NOT NULL,
  `album_masonry_thumb_padding` int(4) NOT NULL,
  `album_masonry_thumb_border_radius` varchar(32) NOT NULL,
  `album_masonry_thumb_border_width` int(4) NOT NULL,
  `album_masonry_thumb_border_style` varchar(8) NOT NULL,
  `album_masonry_thumb_border_color` varchar(8) NOT NULL,
  `album_masonry_thumb_bg_color` varchar(8) NOT NULL,
  `album_masonry_thumbs_bg_color` varchar(8) NOT NULL,
  `album_masonry_thumb_bg_transparent` int(4) NOT NULL,
  `album_masonry_thumb_box_shadow` varchar(32) NOT NULL,
  `album_masonry_thumb_transparent` int(4) NOT NULL,
  `album_masonry_thumb_align` varchar(8) NOT NULL,
  `album_masonry_thumb_hover_effect` varchar(64) NOT NULL,
  `album_masonry_thumb_hover_effect_value` varchar(64) NOT NULL,
  `album_masonry_thumb_transition` tinyint(1) NOT NULL,
  `carousel_cont_bg_color` varchar(8) NOT NULL,
  `carousel_cont_btn_transparent` int(4) NOT NULL,
  `carousel_close_btn_transparent` int(4) NOT NULL,
  `carousel_rl_btn_bg_color` varchar(8) NOT NULL,
  `carousel_rl_btn_border_radius` varchar(32) NOT NULL,
  `carousel_rl_btn_border_width` int(4) NOT NULL,
  `carousel_rl_btn_border_style` varchar(8) NOT NULL,
  `carousel_rl_btn_border_color` varchar(8) NOT NULL,
  `carousel_rl_btn_color` varchar(8) NOT NULL,
  `carousel_rl_btn_height` int(4) NOT NULL,
  `carousel_rl_btn_size` int(4) NOT NULL,
  `carousel_play_pause_btn_size` int(4) NOT NULL,
  `carousel_rl_btn_width` int(4) NOT NULL,
  `carousel_close_rl_btn_hover_color` varchar(8) NOT NULL,
  `carousel_rl_btn_style` varchar(16) NOT NULL,
  `carousel_mergin_bottom` varchar(8) NOT NULL,
  `carousel_font_family` varchar(8) NOT NULL,
  `carousel_feature_border_width` int(4) NOT NULL,
  `carousel_feature_border_style` varchar(8) NOT NULL,
  `carousel_feature_border_color` varchar(8) NOT NULL,
  `carousel_caption_background_color` varchar(8) NOT NULL,
  `carousel_caption_bottom` int(4) NOT NULL,
  `carousel_caption_p_mergin` int(4) NOT NULL,
  `carousel_caption_p_pedding` int(4) NOT NULL,
  `carousel_caption_p_font_weight` varchar(8) NOT NULL,
  `carousel_caption_p_font_size` int(4) NOT NULL,
  `carousel_caption_p_color` varchar(8) NOT NULL,
  `carousel_title_opacity` int(4) NOT NULL,
  `carousel_title_border_radius` varchar(8) NOT NULL,
  `default_theme` tinyint(1) NOT NULL,
  `mosaic_thumb_transition` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT '',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_contactformmaker` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(127) NOT NULL,
  `mail` varchar(256) NOT NULL,
  `form_front` longtext NOT NULL,
  `theme` int(4) NOT NULL,
  `submit_text` longtext NOT NULL,
  `url` varchar(256) NOT NULL,
  `submit_text_type` tinyint(4) NOT NULL,
  `script_mail` text NOT NULL,
  `script_mail_user` text NOT NULL,
  `counter` int(11) NOT NULL,
  `published` int(11) NOT NULL DEFAULT '1',
  `label_order` text NOT NULL,
  `label_order_current` text NOT NULL,
  `article_id` varchar(500) NOT NULL,
  `public_key` varchar(50) NOT NULL,
  `private_key` varchar(50) NOT NULL,
  `recaptcha_theme` varchar(20) NOT NULL,
  `form_fields` text NOT NULL,
  `savedb` tinyint(4) NOT NULL DEFAULT '1',
  `sendemail` tinyint(4) NOT NULL DEFAULT '1',
  `requiredmark` varchar(20) NOT NULL DEFAULT '*',
  `mail_from` varchar(128) NOT NULL,
  `mail_from_name` varchar(128) NOT NULL,
  `reply_to` varchar(128) NOT NULL,
  `send_to` varchar(128) NOT NULL,
  `autogen_layout` tinyint(4) NOT NULL DEFAULT '1',
  `custom_front` longtext NOT NULL,
  `mail_from_user` varchar(128) NOT NULL,
  `mail_from_name_user` varchar(128) NOT NULL,
  `reply_to_user` varchar(128) NOT NULL,
  `disabled_fields` varchar(200) NOT NULL,
  `mail_cc` varchar(128) NOT NULL,
  `mail_cc_user` varchar(128) NOT NULL,
  `mail_bcc` varchar(128) NOT NULL,
  `mail_bcc_user` varchar(128) NOT NULL,
  `mail_subject` varchar(128) NOT NULL,
  `mail_subject_user` varchar(128) NOT NULL,
  `mail_mode` tinyint(4) NOT NULL DEFAULT '1',
  `mail_mode_user` tinyint(4) NOT NULL DEFAULT '1',
  `wpmail` tinyint(1) NOT NULL DEFAULT '1',
  `sortable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_contactformmaker_blocked` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_contactformmaker_submits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `form_id` int(11) NOT NULL,
  `element_label` varchar(128) NOT NULL,
  `element_value` varchar(600) NOT NULL,
  `group_id` int(11) NOT NULL,
  `date` datetime NOT NULL,
  `ip` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_contactformmaker_themes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(200) NOT NULL,
  `css` text NOT NULL,
  `default` tinyint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=38 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_contactformmaker_views` (
  `form_id` int(11) NOT NULL,
  `views` int(50) NOT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` mediumblob NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_fileaway_downloads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timestamp` varchar(255) DEFAULT NULL,
  `file` varchar(1000) DEFAULT NULL,
  `uid` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `ip` varchar(255) DEFAULT NULL,
  `agent` varchar(255) DEFAULT NULL,
  `notified` bit(1) DEFAULT b'0',
  PRIMARY KEY (`id`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_fileaway_metadata` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file` varchar(1000) DEFAULT NULL,
  `metadata` longtext,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_leafletmapsmarker_layers` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `basemap` varchar(25) NOT NULL,
  `layerzoom` int(2) NOT NULL,
  `mapwidth` int(4) NOT NULL,
  `mapwidthunit` varchar(2) NOT NULL,
  `mapheight` int(4) NOT NULL,
  `panel` tinyint(1) NOT NULL,
  `layerviewlat` decimal(9,6) NOT NULL,
  `layerviewlon` decimal(9,6) NOT NULL,
  `createdby` varchar(60) NOT NULL,
  `createdon` datetime NOT NULL,
  `updatedby` varchar(60) DEFAULT NULL,
  `updatedon` datetime DEFAULT NULL,
  `controlbox` int(1) NOT NULL,
  `overlays_custom` int(1) NOT NULL,
  `overlays_custom2` int(1) NOT NULL,
  `overlays_custom3` int(1) NOT NULL,
  `overlays_custom4` int(1) NOT NULL,
  `wms` tinyint(1) NOT NULL,
  `wms2` tinyint(1) NOT NULL,
  `wms3` tinyint(1) NOT NULL,
  `wms4` tinyint(1) NOT NULL,
  `wms5` tinyint(1) NOT NULL,
  `wms6` tinyint(1) NOT NULL,
  `wms7` tinyint(1) NOT NULL,
  `wms8` tinyint(1) NOT NULL,
  `wms9` tinyint(1) NOT NULL,
  `wms10` tinyint(1) NOT NULL,
  `listmarkers` tinyint(1) NOT NULL,
  `multi_layer_map` tinyint(1) NOT NULL,
  `multi_layer_map_list` varchar(4000) DEFAULT NULL,
  `address` varchar(255) NOT NULL,
  `clustering` tinyint(1) unsigned NOT NULL,
  `gpx_url` varchar(2083) NOT NULL,
  `gpx_panel` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_leafletmapsmarker_markers` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `markername` varchar(255) NOT NULL,
  `basemap` varchar(25) NOT NULL,
  `layer` varchar(4000) NOT NULL,
  `lat` decimal(9,6) NOT NULL,
  `lon` decimal(9,6) NOT NULL,
  `icon` varchar(255) NOT NULL,
  `popuptext` text NOT NULL,
  `zoom` int(2) NOT NULL,
  `openpopup` tinyint(1) NOT NULL,
  `mapwidth` int(4) NOT NULL,
  `mapwidthunit` varchar(2) NOT NULL,
  `mapheight` int(4) NOT NULL,
  `panel` tinyint(1) NOT NULL,
  `createdby` varchar(60) NOT NULL,
  `createdon` datetime NOT NULL,
  `updatedby` varchar(60) DEFAULT NULL,
  `updatedon` datetime DEFAULT NULL,
  `controlbox` int(1) NOT NULL,
  `overlays_custom` int(1) NOT NULL,
  `overlays_custom2` int(1) NOT NULL,
  `overlays_custom3` int(1) NOT NULL,
  `overlays_custom4` int(1) NOT NULL,
  `wms` tinyint(1) NOT NULL,
  `wms2` tinyint(1) NOT NULL,
  `wms3` tinyint(1) NOT NULL,
  `wms4` tinyint(1) NOT NULL,
  `wms5` tinyint(1) NOT NULL,
  `wms6` tinyint(1) NOT NULL,
  `wms7` tinyint(1) NOT NULL,
  `wms8` tinyint(1) NOT NULL,
  `wms9` tinyint(1) NOT NULL,
  `wms10` tinyint(1) NOT NULL,
  `kml_timestamp` datetime DEFAULT NULL,
  `address` varchar(255) NOT NULL,
  `gpx_url` varchar(2083) NOT NULL,
  `gpx_panel` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT '1',
  `link_rating` int(11) NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_ngg_album` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `albumdesc` mediumtext,
  `sortorder` longtext NOT NULL,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_ngg_gallery` (
  `gid` bigint(20) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `path` mediumtext,
  `title` mediumtext,
  `galdesc` mediumtext,
  `pageid` bigint(20) NOT NULL DEFAULT '0',
  `previewpic` bigint(20) NOT NULL DEFAULT '0',
  `author` bigint(20) NOT NULL DEFAULT '0',
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`gid`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_ngg_pictures` (
  `pid` bigint(20) NOT NULL AUTO_INCREMENT,
  `image_slug` varchar(255) NOT NULL,
  `post_id` bigint(20) NOT NULL DEFAULT '0',
  `galleryid` bigint(20) NOT NULL DEFAULT '0',
  `filename` varchar(255) NOT NULL,
  `description` mediumtext,
  `alttext` mediumtext,
  `imagedate` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `exclude` tinyint(4) DEFAULT '0',
  `sortorder` bigint(20) NOT NULL DEFAULT '0',
  `meta_data` longtext,
  `extras_post_id` bigint(20) NOT NULL DEFAULT '0',
  `updated_at` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`pid`),
  KEY `extras_post_id_key` (`extras_post_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(64) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`)
) ENGINE=MyISAM AUTO_INCREMENT=940 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=610 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(20) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT '0',
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=183 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_psn_rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) COLLATE utf8_unicode_ci NOT NULL,
  `posttype` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `status_before` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `status_after` varchar(100) COLLATE utf8_unicode_ci NOT NULL,
  `notification_subject` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `notification_body` text COLLATE utf8_unicode_ci NOT NULL,
  `recipient` varchar(200) COLLATE utf8_unicode_ci NOT NULL,
  `to` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `to_dyn` text COLLATE utf8_unicode_ci,
  `cc_select` text COLLATE utf8_unicode_ci,
  `cc` text COLLATE utf8_unicode_ci,
  `bcc_select` text COLLATE utf8_unicode_ci,
  `bcc` text COLLATE utf8_unicode_ci,
  `active` tinyint(1) NOT NULL DEFAULT '1',
  `service_email` tinyint(1) NOT NULL DEFAULT '0',
  `service_log` tinyint(1) NOT NULL DEFAULT '0',
  `categories` text COLLATE utf8_unicode_ci,
  `from` varchar(255) COLLATE utf8_unicode_ci DEFAULT NULL,
  `mail_tpl` int(11) DEFAULT NULL,
  `editor_restriction` text COLLATE utf8_unicode_ci,
  `to_loop` tinyint(1) NOT NULL DEFAULT '0',
  `limit_type` tinyint(1) DEFAULT NULL,
  `limit_count` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Plugin: Post Status Notifier';

CREATE TABLE `wp_udange_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `term_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT '0',
  `count` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(64) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT '0',
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_wpgmza` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `address` varchar(700) NOT NULL,
  `description` mediumtext NOT NULL,
  `pic` varchar(700) NOT NULL,
  `link` varchar(700) NOT NULL,
  `icon` varchar(700) NOT NULL,
  `lat` varchar(100) NOT NULL,
  `lng` varchar(100) NOT NULL,
  `anim` varchar(3) NOT NULL,
  `title` varchar(700) NOT NULL,
  `infoopen` varchar(3) NOT NULL,
  `category` varchar(500) NOT NULL,
  `approved` tinyint(1) DEFAULT '1',
  `retina` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_wpgmza_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `active` tinyint(1) NOT NULL,
  `category_name` varchar(50) NOT NULL,
  `category_icon` varchar(700) NOT NULL,
  `retina` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_wpgmza_category_maps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat_id` int(11) NOT NULL,
  `map_id` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_wpgmza_maps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_title` varchar(50) NOT NULL,
  `map_width` varchar(6) NOT NULL,
  `map_height` varchar(6) NOT NULL,
  `map_start_lat` varchar(700) NOT NULL,
  `map_start_lng` varchar(700) NOT NULL,
  `map_start_location` varchar(700) NOT NULL,
  `map_start_zoom` int(10) NOT NULL,
  `default_marker` varchar(700) NOT NULL,
  `type` int(10) NOT NULL,
  `alignment` int(10) NOT NULL,
  `directions_enabled` int(10) NOT NULL,
  `styling_enabled` int(10) NOT NULL,
  `styling_json` mediumtext NOT NULL,
  `active` int(1) NOT NULL,
  `kml` varchar(700) NOT NULL,
  `bicycle` int(10) NOT NULL,
  `traffic` int(10) NOT NULL,
  `dbox` int(10) NOT NULL,
  `dbox_width` varchar(10) NOT NULL,
  `listmarkers` int(10) NOT NULL,
  `listmarkers_advanced` int(10) NOT NULL,
  `filterbycat` tinyint(1) NOT NULL,
  `ugm_enabled` int(10) NOT NULL,
  `ugm_category_enabled` tinyint(1) NOT NULL,
  `fusion` varchar(100) NOT NULL,
  `map_width_type` varchar(3) NOT NULL,
  `map_height_type` varchar(3) NOT NULL,
  `mass_marker_support` int(10) NOT NULL,
  `ugm_access` int(10) NOT NULL,
  `order_markers_by` int(10) NOT NULL,
  `order_markers_choice` int(10) NOT NULL,
  `show_user_location` int(3) NOT NULL,
  `default_to` varchar(700) NOT NULL,
  `other_settings` longtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE `wp_udange_wpgmza_polygon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `polydata` longtext NOT NULL,
  `linecolor` varchar(7) NOT NULL,
  `lineopacity` varchar(7) NOT NULL,
  `fillcolor` varchar(7) NOT NULL,
  `opacity` varchar(3) NOT NULL,
  `title` varchar(250) NOT NULL,
  `link` varchar(700) NOT NULL,
  `ohfillcolor` varchar(7) NOT NULL,
  `ohlinecolor` varchar(7) NOT NULL,
  `ohopacity` varchar(3) NOT NULL,
  `polyname` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

CREATE TABLE `wp_udange_wpgmza_polylines` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `map_id` int(11) NOT NULL,
  `polydata` longtext NOT NULL,
  `linecolor` varchar(7) NOT NULL,
  `linethickness` varchar(3) NOT NULL,
  `opacity` varchar(3) NOT NULL,
  `polyname` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;


/* INSERT TABLE DATA: wp_root_comments */
INSERT INTO `wp_root_comments` VALUES("1", "1", "Monsieur WordPress", "", "https://wordpress.org/", "", "2015-11-06 18:49:30", "2015-11-06 17:49:30", "Bonjour, ceci est un commentaire.\nPour supprimer un commentaire, connectez-vous et affichez les commentaires de cet article. Vous pourrez alors les modifier ou les supprimer.", "0", "post-trashed", "", "", "0", "0");

/* INSERT TABLE DATA: wp_root_options */
INSERT INTO `wp_root_options` VALUES("1", "siteurl", "http://demo.ec-arlon.be", "yes");
INSERT INTO `wp_root_options` VALUES("2", "home", "http://demo.ec-arlon.be", "yes");
INSERT INTO `wp_root_options` VALUES("3", "blogname", "Les écoles communales d’Arlon", "yes");
INSERT INTO `wp_root_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_root_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_root_options` VALUES("6", "admin_email", "administrator@ec-arlon.be", "yes");
INSERT INTO `wp_root_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_root_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_root_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_root_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_root_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_root_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_root_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_root_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_root_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_root_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_root_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_root_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_root_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_root_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_root_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_root_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_root_options` VALUES("23", "date_format", "j F Y", "yes");
INSERT INTO `wp_root_options` VALUES("24", "time_format", "G \\h i \\m\\i\\n", "yes");
INSERT INTO `wp_root_options` VALUES("25", "links_updated_date_format", "j F Y G \\h i \\m\\i\\n", "yes");
INSERT INTO `wp_root_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_root_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_root_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_root_options` VALUES("29", "gzipcompression", "0", "yes");
INSERT INTO `wp_root_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_root_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_root_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_root_options` VALUES("33", "active_plugins", "a:7:{i:0;s:23:\"file-away/file-away.php\";i:1;s:35:\"private-content/private-content.php\";i:2;s:31:\"sidebar-login/sidebar-login.php\";i:3;s:39:\"simple-custom-css/simple-custom-css.php\";i:4;s:25:\"tablepress/tablepress.php\";i:5;s:43:\"the-events-calendar/the-events-calendar.php\";i:6;s:37:\"tinymce-advanced/tinymce-advanced.php\";}", "yes");
INSERT INTO `wp_root_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_root_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_root_options` VALUES("36", "advanced_edit", "0", "yes");
INSERT INTO `wp_root_options` VALUES("37", "comment_max_links", "2", "yes");
INSERT INTO `wp_root_options` VALUES("38", "gmt_offset", "1", "yes");
INSERT INTO `wp_root_options` VALUES("39", "default_email_category", "1", "yes");
INSERT INTO `wp_root_options` VALUES("40", "recently_edited", "", "no");
INSERT INTO `wp_root_options` VALUES("41", "template", "stargazer", "yes");
INSERT INTO `wp_root_options` VALUES("42", "stylesheet", "polymer", "yes");
INSERT INTO `wp_root_options` VALUES("43", "comment_whitelist", "1", "yes");
INSERT INTO `wp_root_options` VALUES("44", "blacklist_keys", "", "no");
INSERT INTO `wp_root_options` VALUES("45", "comment_registration", "0", "yes");
INSERT INTO `wp_root_options` VALUES("46", "html_type", "text/html", "yes");
INSERT INTO `wp_root_options` VALUES("47", "use_trackback", "0", "yes");
INSERT INTO `wp_root_options` VALUES("48", "default_role", "subscriber", "yes");
INSERT INTO `wp_root_options` VALUES("49", "db_version", "33056", "yes");
INSERT INTO `wp_root_options` VALUES("50", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_root_options` VALUES("51", "upload_path", "", "yes");
INSERT INTO `wp_root_options` VALUES("52", "blog_public", "1", "yes");
INSERT INTO `wp_root_options` VALUES("53", "default_link_category", "2", "yes");
INSERT INTO `wp_root_options` VALUES("54", "show_on_front", "page", "yes");
INSERT INTO `wp_root_options` VALUES("55", "tag_base", "", "yes");
INSERT INTO `wp_root_options` VALUES("56", "show_avatars", "1", "yes");
INSERT INTO `wp_root_options` VALUES("57", "avatar_rating", "G", "yes");
INSERT INTO `wp_root_options` VALUES("58", "upload_url_path", "", "yes");
INSERT INTO `wp_root_options` VALUES("59", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_root_options` VALUES("60", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_root_options` VALUES("61", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_root_options` VALUES("62", "medium_size_w", "300", "yes");
INSERT INTO `wp_root_options` VALUES("63", "medium_size_h", "300", "yes");
INSERT INTO `wp_root_options` VALUES("64", "avatar_default", "mystery", "yes");
INSERT INTO `wp_root_options` VALUES("65", "large_size_w", "1024", "yes");
INSERT INTO `wp_root_options` VALUES("66", "large_size_h", "1024", "yes");
INSERT INTO `wp_root_options` VALUES("67", "image_default_link_type", "file", "yes");
INSERT INTO `wp_root_options` VALUES("68", "image_default_size", "", "yes");
INSERT INTO `wp_root_options` VALUES("69", "image_default_align", "", "yes");
INSERT INTO `wp_root_options` VALUES("70", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_root_options` VALUES("71", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_root_options` VALUES("72", "thread_comments", "1", "yes");
INSERT INTO `wp_root_options` VALUES("73", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_root_options` VALUES("74", "page_comments", "0", "yes");
INSERT INTO `wp_root_options` VALUES("75", "comments_per_page", "50", "yes");
INSERT INTO `wp_root_options` VALUES("76", "default_comments_page", "newest", "yes");
INSERT INTO `wp_root_options` VALUES("77", "comment_order", "asc", "yes");
INSERT INTO `wp_root_options` VALUES("78", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_root_options` VALUES("79", "widget_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("80", "widget_text", "a:3:{i:1;a:0:{}i:2;a:3:{s:5:\"title\";s:22:\"Les écoles communales\";s:4:\"text\";s:566:\"<ul>\r\n<li><a href=\"#\">Centre</a></li>\r\n<li><a href=\"#\">Fouches</a></li>\r\n<li><a href=\"#\">Frassem</a></li>\r\n<li><a href=\"#\">Freylange</a></li>\r\n<li><a href=\"#\">Galgenberg</a></li>\r\n<li><a href=\"#\">Heinsch</a></li>\r\n<li><a href=\"#\">Lilas</a></li>\r\n<li><a href=\"#\">Neufchâteau</a></li>\r\n<li><a href=\"#\">Schoppach</a></li>\r\n<li><a href=\"#\">Sterpenich/Barnich</a></li>\r\n<li><a href=\"#\">Stockem</a></li>\r\n<li><a href=\"#\">Toernich</a></li>\r\n<li><a href=\"http://udange2.ec-arlon.be\">Udange</a></li>\r\n<li><a href=\"#\">Waltzing</a></li>\r\n<li><a href=\"#\">Weyler</a></li>\r\n</ul>\";s:6:\"filter\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("81", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("82", "uninstall_plugins", "a:1:{s:39:\"simple-custom-css/simple-custom-css.php\";s:15:\"sccss_uninstall\";}", "no");
INSERT INTO `wp_root_options` VALUES("83", "timezone_string", "", "yes");
INSERT INTO `wp_root_options` VALUES("84", "page_for_posts", "0", "yes");
INSERT INTO `wp_root_options` VALUES("85", "page_on_front", "6", "yes");
INSERT INTO `wp_root_options` VALUES("86", "default_post_format", "0", "yes");
INSERT INTO `wp_root_options` VALUES("87", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_root_options` VALUES("88", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_root_options` VALUES("89", "initial_db_version", "33056", "yes");
INSERT INTO `wp_root_options` VALUES("90", "wp_root_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:103:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:9:\"add_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:29:\"tablepress_import_tables_wptr\";b:1;s:23:\"tablepress_edit_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:74:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:25:\"read_private_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:21:\"read_ubn_editor_notes\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:35:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:22:\"tablepress_edit_tables\";b:1;s:24:\"tablepress_delete_tables\";b:1;s:22:\"tablepress_list_tables\";b:1;s:21:\"tablepress_add_tables\";b:1;s:22:\"tablepress_copy_tables\";b:1;s:24:\"tablepress_import_tables\";b:1;s:24:\"tablepress_export_tables\";b:1;s:32:\"tablepress_access_options_screen\";b:1;s:30:\"tablepress_access_about_screen\";b:1;s:21:\"read_ubn_author_notes\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:12:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:17:\"edit_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"read_ubn_contributor_notes\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;s:25:\"read_ubn_subscriber_notes\";b:1;}}}", "yes");
INSERT INTO `wp_root_options` VALUES("91", "WPLANG", "fr_FR", "yes");
INSERT INTO `wp_root_options` VALUES("92", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("93", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("94", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("95", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("164", "tablepress_tables", "{\"last_id\":4,\"table_post\":{\"1\":22,\"2\":35,\"3\":39,\"4\":77}}", "yes");
INSERT INTO `wp_root_options` VALUES("96", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("97", "sidebars_widgets", "a:4:{s:19:\"wp_inactive_widgets\";a:0:{}s:7:\"primary\";a:4:{i:0;s:8:\"search-2\";i:1;s:6:\"text-2\";i:2;s:26:\"tribe-events-list-widget-2\";i:3;s:17:\"wp_sidebarlogin-2\";}s:10:\"subsidiary\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_root_options` VALUES("99", "cron", "a:7:{i:1449317867;a:1:{s:26:\"fileaway_scheduled_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1449337770;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1449337789;a:1:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1449337834;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1449339840;a:1:{s:20:\"wp_maybe_auto_update\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1449667135;a:1:{s:18:\"wpseo_onpage_fetch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}s:7:\"version\";i:2;}", "yes");
INSERT INTO `wp_root_options` VALUES("666", "_transient_timeout_feed_mod_96281909e104f3c547a3bba0b6d36ad5", "1449354569", "no");
INSERT INTO `wp_root_options` VALUES("526", "widget_wp_sidebarlogin", "a:2:{i:2;a:10:{s:16:\"logged_out_title\";s:9:\"Connexion\";s:16:\"logged_out_links\";s:0:\"\";s:23:\"show_lost_password_link\";s:0:\"\";s:18:\"show_register_link\";s:0:\"\";s:15:\"show_rememberme\";s:1:\"1\";s:18:\"login_redirect_url\";s:0:\"\";s:15:\"logged_in_title\";s:20:\"Bienvenue %username%\";s:15:\"logged_in_links\";s:56:\"Tableau de bord| %admin_url%\r\nDeconnexion | %logout_url%\";s:11:\"show_avatar\";s:0:\"\";s:19:\"logout_redirect_url\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("651", "_site_transient_timeout_theme_roots", "1449313062", "yes");
INSERT INTO `wp_root_options` VALUES("652", "_site_transient_theme_roots", "a:3:{s:7:\"polymer\";s:7:\"/themes\";s:9:\"sparkling\";s:7:\"/themes\";s:9:\"stargazer\";s:7:\"/themes\";}", "yes");
INSERT INTO `wp_root_options` VALUES("656", "_site_transient_timeout_browser_a92d8832ceed418bc832e3fecb5d5ce1", "1449916166", "yes");
INSERT INTO `wp_root_options` VALUES("657", "_site_transient_browser_a92d8832ceed418bc832e3fecb5d5ce1", "a:9:{s:8:\"platform\";s:7:\"Windows\";s:4:\"name\";s:7:\"Firefox\";s:7:\"version\";s:4:\"42.0\";s:10:\"update_url\";s:23:\"http://www.firefox.com/\";s:7:\"img_src\";s:50:\"http://s.wordpress.org/images/browsers/firefox.png\";s:11:\"img_src_ssl\";s:49:\"https://wordpress.org/images/browsers/firefox.png\";s:15:\"current_version\";s:2:\"16\";s:7:\"upgrade\";b:0;s:8:\"insecure\";b:0;}", "yes");
INSERT INTO `wp_root_options` VALUES("663", "_transient_timeout_feed_mod_66a70e9599b658d5cc038e8074597e7c", "1449354569", "no");
INSERT INTO `wp_root_options` VALUES("664", "_transient_feed_mod_66a70e9599b658d5cc038e8074597e7c", "1449311369", "no");
INSERT INTO `wp_root_options` VALUES("662", "_transient_timeout_feed_66a70e9599b658d5cc038e8074597e7c", "1449354569", "no");
INSERT INTO `wp_root_options` VALUES("248", "widget_sparkling-cats", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("219", "widget_calendar", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("220", "widget_tag_cloud", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("113", "_transient_random_seed", "918e3c439bbed426447b031dacd89888", "yes");
INSERT INTO `wp_root_options` VALUES("667", "_transient_feed_mod_96281909e104f3c547a3bba0b6d36ad5", "1449311369", "no");
INSERT INTO `wp_root_options` VALUES("665", "_transient_timeout_feed_96281909e104f3c547a3bba0b6d36ad5", "1449354569", "no");
INSERT INTO `wp_root_options` VALUES("123", "can_compress_scripts", "0", "yes");
INSERT INTO `wp_root_options` VALUES("674", "_transient_timeout_dash_bd94b8f41e74bae2f4dc72e9bd8379af", "1449354570", "no");
INSERT INTO `wp_root_options` VALUES("675", "_transient_dash_bd94b8f41e74bae2f4dc72e9bd8379af", "<div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/WordpressFrancophone/~3/WIL51xhSWSw/\'>WordPress fait tourner 25% du web</a> <span class=\"rss-date\">9 novembre 2015</span><div class=\"rssSummary\">Le nombre tant attendu a été atteint ce week-end : selon le site W3Techs, qui présente de nombreuses statistiques et études chiffrées sur les technologies du web, WordPress est aujourd’hui utilisé par 25% des sites web — et pas seulement 1/4 des sites qui ont utilisent un outil de gestion de contenu (CMS), non : [&hellip;]</div></li></ul></div><div class=\"rss-widget\"><ul><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/XCP7gZ8WS9w/\'>WordPress fait tourner 25% du web</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/Og4g9561NEU/\'>L’Hebdo WordPress n°263 du 10e anniversaire</a></li><li><a class=\'rsswidget\' href=\'http://feedproxy.google.com/~r/feedburner/cjgL/~3/D2YW8pSwmLs/\'>Sortie de  WordPress 4.3 « Billie »</a></li></ul></div><div class=\"rss-widget\"><ul><li class=\'dashboard-news-plugin\'><span>Extensions populaires:</span> <a href=\'https://wordpress.org/plugins/google-analytics-dashboard-for-wp/\' class=\'dashboard-news-plugin-link\'>Google Analytics Dashboard for WP</a>&nbsp;<span>(<a href=\'plugin-install.php?tab=plugin-information&amp;plugin=google-analytics-dashboard-for-wp&amp;_wpnonce=82db91cd83&amp;TB_iframe=true&amp;width=600&amp;height=800\' class=\'thickbox\' title=\'Google Analytics Dashboard for WP\'>Installer</a>)</span></li></ul></div>", "no");
INSERT INTO `wp_root_options` VALUES("668", "_transient_timeout_feed_b9388c83948825c1edaef0d856b7b109", "1449354570", "no");
INSERT INTO `wp_root_options` VALUES("669", "_transient_feed_b9388c83948825c1edaef0d856b7b109", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n	\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:117:\"\n		\n		\n		\n		\n		\n		\n				\n\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n		\n\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:45:\"https://wordpress.org/plugins/browse/popular/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"WordPress Plugins » View: Popular\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 05 Dec 2015 10:27:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"http://bbpress.org/?v=1.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:30:{i:0;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"All in One SEO Pack\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/all-in-one-seo-pack/#post-753\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 30 Mar 2007 20:08:18 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"753@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:126:\"All in One SEO Pack is a WordPress SEO plugin to automatically optimize your WordPress blog for Search Engines such as Google.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"uberdose\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"WP-PageNavi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wp-pagenavi/#post-363\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 23:17:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"363@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"Adds a more advanced paging navigation interface.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Lester Chan\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Advanced Custom Fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/advanced-custom-fields/#post-25254\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 17 Mar 2011 04:07:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"25254@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"Customise WordPress with powerful, professional and intuitive fields\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"elliotcondon\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:7:\"Akismet\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"https://wordpress.org/plugins/akismet/#post-15\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:11:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"15@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Akismet checks your comments against the Akismet Web service to see if they look like spam or not.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Google XML Sitemaps\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:64:\"https://wordpress.org/plugins/google-sitemap-generator/#post-132\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Mar 2007 22:31:32 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"132@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"This plugin will generate a special XML sitemap which will help search engines to better index your blog.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Arne Brachhold\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"Jetpack by WordPress.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"https://wordpress.org/plugins/jetpack/#post-23862\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 Jan 2011 02:21:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"23862@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Your WordPress, Simplified.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Tim Moore\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"TinyMCE Advanced\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"https://wordpress.org/plugins/tinymce-advanced/#post-2082\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 27 Jun 2007 15:00:26 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2082@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Enables the advanced features of TinyMCE, the WordPress WYSIWYG editor.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Andrew Ozz\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Wordfence Security\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/wordfence/#post-29832\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 04 Sep 2011 03:13:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29832@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"The Wordfence WordPress security plugin provides free enterprise-class WordPress security, protecting your website from hacks and malware.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Wordfence\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Regenerate Thumbnails\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/regenerate-thumbnails/#post-6743\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 23 Aug 2008 14:38:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"6743@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"Allows you to regenerate your thumbnails after changing the thumbnail sizes.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Alex Mills (Viper007Bond)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"W3 Total Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/w3-total-cache/#post-12073\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 29 Jul 2009 18:46:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"12073@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:132:\"Easy Web Performance Optimization (WPO) using caching: browser, page, object, database, minify and content delivery network support.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Frederick Townes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:10;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"WooCommerce - excelling eCommerce\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/woocommerce/#post-29860\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Sep 2011 08:13:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"29860@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:97:\"WooCommerce is a powerful, extendable eCommerce plugin that helps you sell anything. Beautifully.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"WooThemes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:11;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WordPress Importer\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wordpress-importer/#post-18101\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 20 May 2010 17:42:45 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"18101@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:101:\"Import posts, pages, comments, custom fields, categories, tags and more from a WordPress export file.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Brian Colinger\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:12;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"WP Super Cache\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/wp-super-cache/#post-2572\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 05 Nov 2007 11:40:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2572@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:73:\"A very fast caching engine for WordPress that produces static html files.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Donncha O Caoimh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:13;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Contact Form 7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/contact-form-7/#post-2141\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 02 Aug 2007 12:45:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2141@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Just another contact form plugin. Simple but flexible.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:14;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:21:\"Really Simple CAPTCHA\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://wordpress.org/plugins/really-simple-captcha/#post-9542\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 09 Mar 2009 02:17:35 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"9542@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Really Simple CAPTCHA is a CAPTCHA module intended to be called from other plugins. It is originally created for my Contact Form 7 plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Takayuki Miyoshi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:15;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:15:\"NextGEN Gallery\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:56:\"https://wordpress.org/plugins/nextgen-gallery/#post-1169\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Apr 2007 20:08:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"1169@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"The most popular WordPress gallery plugin and one of the most popular plugins of all time with over 13 million downloads.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Alex Rabe\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:16;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Hello Dolly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/hello-dolly/#post-5790\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 29 May 2008 22:11:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"5790@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"This is not just a plugin, it symbolizes the hope and enthusiasm of an entire generation summed up in two words sung most famously by Louis Armstrong.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Matt Mullenweg\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:17;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Yoast SEO\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"https://wordpress.org/plugins/wordpress-seo/#post-8321\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 01 Jan 2009 20:34:44 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"8321@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:114:\"Improve your WordPress SEO: Write better content and have a fully optimized WordPress site using Yoast SEO plugin.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:18;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:25:\"Google Analytics by Yoast\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://wordpress.org/plugins/google-analytics-for-wordpress/#post-2316\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Sep 2007 12:15:27 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2316@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:124:\"Track your WordPress site easily with the latest tracking codes and lots added data for search result pages and error pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Joost de Valk\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:19;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Duplicate Post\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://wordpress.org/plugins/duplicate-post/#post-2646\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Dec 2007 17:40:03 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"2646@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:22:\"Clone posts and pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Lopo\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:20;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"Disable Comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:58:\"https://wordpress.org/plugins/disable-comments/#post-26907\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 27 May 2011 04:42:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26907@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:134:\"Allows administrators to globally disable comments on their site. Comments can be disabled according to post type. Multisite friendly.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Samir Shah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:21;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"WP Multibyte Patch\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/wp-multibyte-patch/#post-28395\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Jul 2011 12:22:53 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"28395@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"Multibyte functionality enhancement for the WordPress Japanese package.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"plugin-master\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:22;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:27:\"Black Studio TinyMCE Widget\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://wordpress.org/plugins/black-studio-tinymce-widget/#post-31973\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 10 Nov 2011 15:06:14 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"31973@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"The visual editor widget for Wordpress.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:12:\"Marco Chiesi\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:23;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:46:\"iThemes Security (formerly Better WP Security)\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://wordpress.org/plugins/better-wp-security/#post-21738\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 22 Oct 2010 22:06:05 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"21738@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:150:\"Protect your WordPress site by hiding vital areas of your site, protecting access to important files, preventing brute-force login attempts, detecting\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Chris Wiegman\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:24;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:26:\"Page Builder by SiteOrigin\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://wordpress.org/plugins/siteorigin-panels/#post-51888\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 11 Apr 2013 10:36:42 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"51888@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:111:\"Build responsive page layouts using the widgets you know and love using this simple drag and drop page builder.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Greg Priday\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:25;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Google Analytics Dashboard for WP\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://wordpress.org/plugins/google-analytics-dashboard-for-wp/#post-50539\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 10 Mar 2013 17:07:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"50539@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:127:\"Displays Google Analytics reports in your WordPress Dashboard. Inserts the latest Google Analytics tracking code in your pages.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Alin Marcu\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:26;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Meta Slider\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"https://wordpress.org/plugins/ml-slider/#post-49521\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 14 Feb 2013 16:56:31 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"49521@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:145:\"Easy to use WordPress slider plugin. Create SEO optimised responsive slideshows with Nivo Slider, Flex Slider, Coin Slider and Responsive Slides.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:11:\"Matcha Labs\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:27;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:30:\"Clef Two-Factor Authentication\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:48:\"https://wordpress.org/plugins/wpclef/#post-47509\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 27 Dec 2012 01:25:57 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"47509@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:138:\"Modern two-factor that people love to use: strong authentication without passwords or tokens; single sign on/off; magical user experience.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Dave Ross\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:28;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:34:\"UpdraftPlus Backup and Restoration\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:53:\"https://wordpress.org/plugins/updraftplus/#post-38058\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 21 May 2012 15:14:11 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"38058@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:148:\"Backup and restoration made easy. Complete backups; manual or scheduled (backup to S3, Dropbox, Google Drive, Rackspace, FTP, SFTP, email + others).\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"David Anderson\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:29;a:6:{s:4:\"data\";s:30:\"\n			\n			\n			\n			\n			\n			\n					\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:2:{s:0:\"\";a:5:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Duplicator\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"https://wordpress.org/plugins/duplicator/#post-26607\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 16 May 2011 12:15:41 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"26607@https://wordpress.org/plugins/\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:88:\"Duplicate, clone, backup, move and transfer an entire site from one location to another.\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Cory Lamle\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:46:\"https://wordpress.org/plugins/rss/view/popular\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:12:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 05 Dec 2015 10:29:30 GMT\";s:12:\"content-type\";s:23:\"text/xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:4:\"vary\";s:15:\"Accept-Encoding\";s:25:\"strict-transport-security\";s:11:\"max-age=360\";s:7:\"expires\";s:29:\"Sat, 05 Dec 2015 11:02:42 GMT\";s:13:\"cache-control\";s:0:\"\";s:6:\"pragma\";s:0:\"\";s:13:\"last-modified\";s:31:\"Sat, 05 Dec 2015 10:27:42 +0000\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:4:\"x-nc\";s:11:\"HIT lax 249\";}s:5:\"build\";s:14:\"20151106171109\";}", "no");
INSERT INTO `wp_root_options` VALUES("672", "_transient_timeout_plugin_slugs", "1449399618", "no");
INSERT INTO `wp_root_options` VALUES("673", "_transient_plugin_slugs", "a:9:{i:0;s:19:\"akismet/akismet.php\";i:1;s:23:\"file-away/file-away.php\";i:2;s:9:\"hello.php\";i:3;s:35:\"private-content/private-content.php\";i:4;s:31:\"sidebar-login/sidebar-login.php\";i:5;s:39:\"simple-custom-css/simple-custom-css.php\";i:6;s:25:\"tablepress/tablepress.php\";i:7;s:43:\"the-events-calendar/the-events-calendar.php\";i:8;s:37:\"tinymce-advanced/tinymce-advanced.php\";}", "no");
INSERT INTO `wp_root_options` VALUES("670", "_transient_timeout_feed_mod_b9388c83948825c1edaef0d856b7b109", "1449354570", "no");
INSERT INTO `wp_root_options` VALUES("671", "_transient_feed_mod_b9388c83948825c1edaef0d856b7b109", "1449311370", "no");
INSERT INTO `wp_root_options` VALUES("399", "_site_transient_timeout_wporg_theme_feature_list", "1447965925", "yes");
INSERT INTO `wp_root_options` VALUES("400", "_site_transient_wporg_theme_feature_list", "a:4:{s:6:\"Colors\";a:15:{i:0;s:5:\"black\";i:1;s:4:\"blue\";i:2;s:5:\"brown\";i:3;s:4:\"gray\";i:4;s:5:\"green\";i:5;s:6:\"orange\";i:6;s:4:\"pink\";i:7;s:6:\"purple\";i:8;s:3:\"red\";i:9;s:6:\"silver\";i:10;s:3:\"tan\";i:11;s:5:\"white\";i:12;s:6:\"yellow\";i:13;s:4:\"dark\";i:14;s:5:\"light\";}s:6:\"Layout\";a:9:{i:0;s:12:\"fixed-layout\";i:1;s:12:\"fluid-layout\";i:2;s:17:\"responsive-layout\";i:3;s:10:\"one-column\";i:4;s:11:\"two-columns\";i:5;s:13:\"three-columns\";i:6;s:12:\"four-columns\";i:7;s:12:\"left-sidebar\";i:8;s:13:\"right-sidebar\";}s:8:\"Features\";a:20:{i:0;s:19:\"accessibility-ready\";i:1;s:8:\"blavatar\";i:2;s:10:\"buddypress\";i:3;s:17:\"custom-background\";i:4;s:13:\"custom-colors\";i:5;s:13:\"custom-header\";i:6;s:11:\"custom-menu\";i:7;s:12:\"editor-style\";i:8;s:21:\"featured-image-header\";i:9;s:15:\"featured-images\";i:10;s:15:\"flexible-header\";i:11;s:20:\"front-page-post-form\";i:12;s:19:\"full-width-template\";i:13;s:12:\"microformats\";i:14;s:12:\"post-formats\";i:15;s:20:\"rtl-language-support\";i:16;s:11:\"sticky-post\";i:17;s:13:\"theme-options\";i:18;s:17:\"threaded-comments\";i:19;s:17:\"translation-ready\";}s:7:\"Subject\";a:3:{i:0;s:7:\"holiday\";i:1;s:13:\"photoblogging\";i:2;s:8:\"seasonal\";}}", "yes");
INSERT INTO `wp_root_options` VALUES("221", "widget_pages", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("136", "theme_mods_twentyfifteen", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1446832463;s:4:\"data\";a:2:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}}}}", "yes");
INSERT INTO `wp_root_options` VALUES("137", "current_theme", "Polymer", "yes");
INSERT INTO `wp_root_options` VALUES("138", "theme_mods_sparkling", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:7:\"primary\";i:2;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1447955145;s:4:\"data\";a:8:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:10:\"nav_menu-2\";i:2;s:26:\"tribe-events-list-widget-2\";}s:13:\"home-widget-1\";a:0:{}s:13:\"home-widget-2\";a:0:{}s:13:\"home-widget-3\";a:0:{}s:15:\"footer-widget-1\";a:0:{}s:15:\"footer-widget-2\";a:0:{}s:15:\"footer-widget-3\";a:0:{}}}}", "yes");
INSERT INTO `wp_root_options` VALUES("139", "theme_switched", "", "yes");
INSERT INTO `wp_root_options` VALUES("140", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_root_options` VALUES("149", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("142", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "yes");
INSERT INTO `wp_root_options` VALUES("527", "_site_transient_timeout_available_translations", "1448466898", "yes");
INSERT INTO `wp_root_options` VALUES("528", "_site_transient_available_translations", "a:69:{s:2:\"ar\";a:8:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-18 00:32:07\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/ar.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ar\";i:2;s:3:\"ara\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:3:\"ary\";a:8:{s:8:\"language\";s:3:\"ary\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-27 20:45:33\";s:12:\"english_name\";s:15:\"Moroccan Arabic\";s:11:\"native_name\";s:31:\"العربية المغربية\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.3.1/ary.zip\";s:3:\"iso\";a:2:{i:1;s:5:\"ar_MA\";i:3;s:3:\"ary\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"المتابعة\";}}s:2:\"az\";a:8:{s:8:\"language\";s:2:\"az\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-22 14:16:17\";s:12:\"english_name\";s:11:\"Azerbaijani\";s:11:\"native_name\";s:16:\"Azərbaycan dili\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/az.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"az\";i:2;s:3:\"aze\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Davam\";}}s:5:\"bg_BG\";a:8:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-25 14:32:58\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/bg_BG.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bg\";i:2;s:3:\"bul\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:22:\"Продължение\";}}s:5:\"bn_BD\";a:8:{s:8:\"language\";s:5:\"bn_BD\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-16 05:09:40\";s:12:\"english_name\";s:7:\"Bengali\";s:11:\"native_name\";s:15:\"বাংলা\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/bn_BD.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"bn\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:23:\"এগিয়ে চল.\";}}s:5:\"bs_BA\";a:8:{s:8:\"language\";s:5:\"bs_BA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-18 21:20:44\";s:12:\"english_name\";s:7:\"Bosnian\";s:11:\"native_name\";s:8:\"Bosanski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/bs_BA.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"bs\";i:2;s:3:\"bos\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:2:\"ca\";a:8:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-07 03:25:59\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/ca.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ca\";i:2;s:3:\"cat\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"cy\";a:8:{s:8:\"language\";s:2:\"cy\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-19 09:17:13\";s:12:\"english_name\";s:5:\"Welsh\";s:11:\"native_name\";s:7:\"Cymraeg\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/cy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"cy\";i:2;s:3:\"cym\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Parhau\";}}s:5:\"da_DK\";a:8:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-18 19:34:34\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/da_DK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"da\";i:2;s:3:\"dan\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Forts&#230;t\";}}s:5:\"de_CH\";a:8:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-02 05:19:03\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/de_CH.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:12:\"de_DE_formal\";a:8:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-14 15:24:20\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/translation/core/4.3.1/de_DE_formal.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:5:\"de_DE\";a:8:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-10 10:48:02\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/de_DE.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"de\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Fortfahren\";}}s:2:\"el\";a:8:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-16 22:03:32\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/el.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"el\";i:2;s:3:\"ell\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:16:\"Συνέχεια\";}}s:5:\"en_CA\";a:8:{s:8:\"language\";s:5:\"en_CA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-14 00:38:16\";s:12:\"english_name\";s:16:\"English (Canada)\";s:11:\"native_name\";s:16:\"English (Canada)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/en_CA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_GB\";a:8:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-17 20:57:21\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/en_GB.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_AU\";a:8:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-13 23:56:05\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/en_AU.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_NZ\";a:8:{s:8:\"language\";s:5:\"en_NZ\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-17 22:20:50\";s:12:\"english_name\";s:21:\"English (New Zealand)\";s:11:\"native_name\";s:21:\"English (New Zealand)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/en_NZ.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:5:\"en_ZA\";a:8:{s:8:\"language\";s:5:\"en_ZA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-24 06:32:23\";s:12:\"english_name\";s:22:\"English (South Africa)\";s:11:\"native_name\";s:22:\"English (South Africa)\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/en_ZA.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"en\";i:2;s:3:\"eng\";i:3;s:3:\"eng\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continue\";}}s:2:\"eo\";a:8:{s:8:\"language\";s:2:\"eo\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-16 10:50:33\";s:12:\"english_name\";s:9:\"Esperanto\";s:11:\"native_name\";s:9:\"Esperanto\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/eo.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eo\";i:2;s:3:\"epo\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Daŭrigi\";}}s:5:\"es_ES\";a:8:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-26 22:31:40\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/es_ES.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"es\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_MX\";a:8:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-30 19:20:19\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/es_MX.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_PE\";a:8:{s:8:\"language\";s:5:\"es_PE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-19 14:33:57\";s:12:\"english_name\";s:14:\"Spanish (Peru)\";s:11:\"native_name\";s:17:\"Español de Perú\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/es_PE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CL\";a:8:{s:8:\"language\";s:5:\"es_CL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-26 19:53:52\";s:12:\"english_name\";s:15:\"Spanish (Chile)\";s:11:\"native_name\";s:17:\"Español de Chile\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/es_CL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_CO\";a:8:{s:8:\"language\";s:5:\"es_CO\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-04 06:10:33\";s:12:\"english_name\";s:18:\"Spanish (Colombia)\";s:11:\"native_name\";s:20:\"Español de Colombia\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/translation/core/4.3-RC/es_CO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"es_VE\";a:8:{s:8:\"language\";s:5:\"es_VE\";s:7:\"version\";s:5:\"4.2.5\";s:7:\"updated\";s:19:\"2015-10-29 16:32:18\";s:12:\"english_name\";s:19:\"Spanish (Venezuela)\";s:11:\"native_name\";s:21:\"Español de Venezuela\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.2.5/es_VE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"es\";i:2;s:3:\"spa\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:2:\"et\";a:8:{s:8:\"language\";s:2:\"et\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-05 16:34:02\";s:12:\"english_name\";s:8:\"Estonian\";s:11:\"native_name\";s:5:\"Eesti\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/et.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"et\";i:2;s:3:\"est\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Jätka\";}}s:2:\"eu\";a:8:{s:8:\"language\";s:2:\"eu\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-12 17:21:08\";s:12:\"english_name\";s:6:\"Basque\";s:11:\"native_name\";s:7:\"Euskara\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/eu.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"eu\";i:2;s:3:\"eus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Jarraitu\";}}s:5:\"fa_IR\";a:8:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-20 13:36:08\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/fa_IR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fa\";i:2;s:3:\"fas\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:2:\"fi\";a:8:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-15 15:41:04\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/fi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fi\";i:2;s:3:\"fin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Jatka\";}}s:5:\"fr_BE\";a:8:{s:8:\"language\";s:5:\"fr_BE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-06 20:37:24\";s:12:\"english_name\";s:16:\"French (Belgium)\";s:11:\"native_name\";s:21:\"Français de Belgique\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/fr_BE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"fr\";i:2;s:3:\"fra\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:5:\"fr_FR\";a:8:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-09 14:35:27\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/fr_FR.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"fr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuer\";}}s:2:\"gd\";a:8:{s:8:\"language\";s:2:\"gd\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-24 15:25:30\";s:12:\"english_name\";s:15:\"Scottish Gaelic\";s:11:\"native_name\";s:9:\"Gàidhlig\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/gd.zip\";s:3:\"iso\";a:3:{i:1;s:2:\"gd\";i:2;s:3:\"gla\";i:3;s:3:\"gla\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"Lean air adhart\";}}s:5:\"gl_ES\";a:8:{s:8:\"language\";s:5:\"gl_ES\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-18 23:34:00\";s:12:\"english_name\";s:8:\"Galician\";s:11:\"native_name\";s:6:\"Galego\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/gl_ES.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"gl\";i:2;s:3:\"glg\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:3:\"haz\";a:8:{s:8:\"language\";s:3:\"haz\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 15:20:27\";s:12:\"english_name\";s:8:\"Hazaragi\";s:11:\"native_name\";s:15:\"هزاره گی\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/translation/core/4.1.8/haz.zip\";s:3:\"iso\";a:1:{i:3;s:3:\"haz\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"ادامه\";}}s:5:\"he_IL\";a:8:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-22 08:59:41\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/he_IL.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"he\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"להמשיך\";}}s:5:\"hi_IN\";a:8:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-20 14:39:18\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/hi_IN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hi\";i:2;s:3:\"hin\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"जारी\";}}s:2:\"hr\";a:8:{s:8:\"language\";s:2:\"hr\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-04 22:14:16\";s:12:\"english_name\";s:8:\"Croatian\";s:11:\"native_name\";s:8:\"Hrvatski\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/hr.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hr\";i:2;s:3:\"hrv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Nastavi\";}}s:5:\"hu_HU\";a:8:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-15 12:00:25\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/hu_HU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hu\";i:2;s:3:\"hun\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:7:\"Tovább\";}}s:2:\"hy\";a:8:{s:8:\"language\";s:2:\"hy\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-17 13:36:47\";s:12:\"english_name\";s:8:\"Armenian\";s:11:\"native_name\";s:14:\"Հայերեն\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/hy.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"hy\";i:2;s:3:\"hye\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Շարունակել\";}}s:5:\"id_ID\";a:8:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-24 08:17:28\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/id_ID.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"id\";i:2;s:3:\"ind\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Lanjutkan\";}}s:5:\"is_IS\";a:8:{s:8:\"language\";s:5:\"is_IS\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-22 13:47:37\";s:12:\"english_name\";s:9:\"Icelandic\";s:11:\"native_name\";s:9:\"Íslenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/is_IS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"is\";i:2;s:3:\"isl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Áfram\";}}s:5:\"it_IT\";a:8:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-06 06:16:37\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/it_IT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"it\";i:2;s:3:\"ita\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Continua\";}}s:2:\"ja\";a:8:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-30 16:23:05\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/ja.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"ja\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"続ける\";}}s:5:\"ko_KR\";a:8:{s:8:\"language\";s:5:\"ko_KR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-06 04:24:53\";s:12:\"english_name\";s:6:\"Korean\";s:11:\"native_name\";s:9:\"한국어\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/ko_KR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ko\";i:2;s:3:\"kor\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"계속\";}}s:5:\"lt_LT\";a:8:{s:8:\"language\";s:5:\"lt_LT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-18 07:48:28\";s:12:\"english_name\";s:10:\"Lithuanian\";s:11:\"native_name\";s:15:\"Lietuvių kalba\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/lt_LT.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"lt\";i:2;s:3:\"lit\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Tęsti\";}}s:5:\"my_MM\";a:8:{s:8:\"language\";s:5:\"my_MM\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 15:57:42\";s:12:\"english_name\";s:17:\"Myanmar (Burmese)\";s:11:\"native_name\";s:15:\"ဗမာစာ\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.8/my_MM.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"my\";i:2;s:3:\"mya\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:54:\"ဆက်လက်လုပ်ေဆာင်ပါ။\";}}s:5:\"nb_NO\";a:8:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-23 10:49:34\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/nb_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nb\";i:2;s:3:\"nob\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Fortsett\";}}s:5:\"nl_NL\";a:8:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-28 15:14:19\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/nl_NL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nl\";i:2;s:3:\"nld\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"Doorgaan\";}}s:5:\"nn_NO\";a:8:{s:8:\"language\";s:5:\"nn_NO\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-17 18:56:13\";s:12:\"english_name\";s:19:\"Norwegian (Nynorsk)\";s:11:\"native_name\";s:13:\"Norsk nynorsk\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/nn_NO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"nn\";i:2;s:3:\"nno\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Hald fram\";}}s:3:\"oci\";a:8:{s:8:\"language\";s:3:\"oci\";s:7:\"version\";s:6:\"4.3-RC\";s:7:\"updated\";s:19:\"2015-08-02 07:53:33\";s:12:\"english_name\";s:7:\"Occitan\";s:11:\"native_name\";s:7:\"Occitan\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/translation/core/4.3-RC/oci.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"oc\";i:2;s:3:\"oci\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Contunhar\";}}s:5:\"pl_PL\";a:8:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-27 13:38:57\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/pl_PL.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pl\";i:2;s:3:\"pol\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Kontynuuj\";}}s:2:\"ps\";a:8:{s:8:\"language\";s:2:\"ps\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-29 22:19:48\";s:12:\"english_name\";s:6:\"Pashto\";s:11:\"native_name\";s:8:\"پښتو\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.1.8/ps.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ps\";i:2;s:3:\"pus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:8:\"دوام\";}}s:5:\"pt_BR\";a:8:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-05 03:15:53\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/pt_BR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"pt\";i:2;s:3:\"por\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"pt_PT\";a:8:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-10 16:45:56\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/pt_PT.zip\";s:3:\"iso\";a:1:{i:1;s:2:\"pt\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuar\";}}s:5:\"ro_RO\";a:8:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-18 16:44:05\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/ro_RO.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ro\";i:2;s:3:\"ron\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Continuă\";}}s:5:\"ru_RU\";a:8:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-03 10:08:50\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/ru_RU.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ru\";i:2;s:3:\"rus\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продолжить\";}}s:5:\"sk_SK\";a:8:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-20 09:27:40\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/sk_SK.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sk\";i:2;s:3:\"slk\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Pokračovať\";}}s:5:\"sl_SI\";a:8:{s:8:\"language\";s:5:\"sl_SI\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-06 16:10:24\";s:12:\"english_name\";s:9:\"Slovenian\";s:11:\"native_name\";s:13:\"Slovenščina\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/sl_SI.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sl\";i:2;s:3:\"slv\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Nadaljujte\";}}s:2:\"sq\";a:8:{s:8:\"language\";s:2:\"sq\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-27 07:05:44\";s:12:\"english_name\";s:8:\"Albanian\";s:11:\"native_name\";s:5:\"Shqip\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/sq.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sq\";i:2;s:3:\"sqi\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"Vazhdo\";}}s:5:\"sr_RS\";a:8:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-17 18:31:56\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/sr_RS.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sr\";i:2;s:3:\"srp\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:14:\"Настави\";}}s:5:\"sv_SE\";a:8:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-19 10:43:45\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/sv_SE.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"sv\";i:2;s:3:\"swe\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:9:\"Fortsätt\";}}s:2:\"th\";a:8:{s:8:\"language\";s:2:\"th\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-11-08 12:30:32\";s:12:\"english_name\";s:4:\"Thai\";s:11:\"native_name\";s:9:\"ไทย\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/th.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"th\";i:2;s:3:\"tha\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:15:\"ต่อไป\";}}s:2:\"tl\";a:8:{s:8:\"language\";s:2:\"tl\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-20 03:52:15\";s:12:\"english_name\";s:7:\"Tagalog\";s:11:\"native_name\";s:7:\"Tagalog\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/tl.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tl\";i:2;s:3:\"tgl\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:10:\"Magpatuloy\";}}s:5:\"tr_TR\";a:8:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-19 13:55:59\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/tr_TR.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"tr\";i:2;s:3:\"tur\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:5:\"Devam\";}}s:5:\"ug_CN\";a:8:{s:8:\"language\";s:5:\"ug_CN\";s:7:\"version\";s:5:\"4.1.8\";s:7:\"updated\";s:19:\"2015-03-26 16:45:38\";s:12:\"english_name\";s:6:\"Uighur\";s:11:\"native_name\";s:9:\"Uyƣurqə\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.1.8/ug_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"ug\";i:2;s:3:\"uig\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:26:\"داۋاملاشتۇرۇش\";}}s:2:\"uk\";a:8:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-08 09:34:14\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/uk.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"uk\";i:2;s:3:\"ukr\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:20:\"Продовжити\";}}s:2:\"vi\";a:8:{s:8:\"language\";s:2:\"vi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-10-28 06:20:02\";s:12:\"english_name\";s:10:\"Vietnamese\";s:11:\"native_name\";s:14:\"Tiếng Việt\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/translation/core/4.3.1/vi.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"vi\";i:2;s:3:\"vie\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:12:\"Tiếp tục\";}}s:5:\"zh_TW\";a:8:{s:8:\"language\";s:5:\"zh_TW\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-09-21 11:18:12\";s:12:\"english_name\";s:16:\"Chinese (Taiwan)\";s:11:\"native_name\";s:12:\"繁體中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/zh_TW.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"繼續\";}}s:5:\"zh_CN\";a:8:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:19:\"2015-08-20 19:10:20\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:64:\"https://downloads.wordpress.org/translation/core/4.3.1/zh_CN.zip\";s:3:\"iso\";a:2:{i:1;s:2:\"zh\";i:2;s:3:\"zho\";}s:7:\"strings\";a:1:{s:8:\"continue\";s:6:\"继续\";}}}", "yes");
INSERT INTO `wp_root_options` VALUES("151", "recently_activated", "a:0:{}", "yes");
INSERT INTO `wp_root_options` VALUES("523", "_site_transient_timeout_poptags_40cd750bba9870f18aada2478b24840a", "1448466637", "yes");
INSERT INTO `wp_root_options` VALUES("524", "_site_transient_poptags_40cd750bba9870f18aada2478b24840a", "a:100:{s:6:\"widget\";a:3:{s:4:\"name\";s:6:\"widget\";s:4:\"slug\";s:6:\"widget\";s:5:\"count\";s:4:\"5581\";}s:4:\"post\";a:3:{s:4:\"name\";s:4:\"Post\";s:4:\"slug\";s:4:\"post\";s:5:\"count\";s:4:\"3497\";}s:6:\"plugin\";a:3:{s:4:\"name\";s:6:\"plugin\";s:4:\"slug\";s:6:\"plugin\";s:5:\"count\";s:4:\"3449\";}s:5:\"admin\";a:3:{s:4:\"name\";s:5:\"admin\";s:4:\"slug\";s:5:\"admin\";s:5:\"count\";s:4:\"2960\";}s:5:\"posts\";a:3:{s:4:\"name\";s:5:\"posts\";s:4:\"slug\";s:5:\"posts\";s:5:\"count\";s:4:\"2696\";}s:9:\"shortcode\";a:3:{s:4:\"name\";s:9:\"shortcode\";s:4:\"slug\";s:9:\"shortcode\";s:5:\"count\";s:4:\"2149\";}s:7:\"sidebar\";a:3:{s:4:\"name\";s:7:\"sidebar\";s:4:\"slug\";s:7:\"sidebar\";s:5:\"count\";s:4:\"2142\";}s:6:\"google\";a:3:{s:4:\"name\";s:6:\"google\";s:4:\"slug\";s:6:\"google\";s:5:\"count\";s:4:\"1967\";}s:7:\"twitter\";a:3:{s:4:\"name\";s:7:\"twitter\";s:4:\"slug\";s:7:\"twitter\";s:5:\"count\";s:4:\"1929\";}s:6:\"images\";a:3:{s:4:\"name\";s:6:\"images\";s:4:\"slug\";s:6:\"images\";s:5:\"count\";s:4:\"1909\";}s:4:\"page\";a:3:{s:4:\"name\";s:4:\"page\";s:4:\"slug\";s:4:\"page\";s:5:\"count\";s:4:\"1906\";}s:8:\"comments\";a:3:{s:4:\"name\";s:8:\"comments\";s:4:\"slug\";s:8:\"comments\";s:5:\"count\";s:4:\"1855\";}s:5:\"image\";a:3:{s:4:\"name\";s:5:\"image\";s:4:\"slug\";s:5:\"image\";s:5:\"count\";s:4:\"1757\";}s:8:\"facebook\";a:3:{s:4:\"name\";s:8:\"Facebook\";s:4:\"slug\";s:8:\"facebook\";s:5:\"count\";s:4:\"1558\";}s:3:\"seo\";a:3:{s:4:\"name\";s:3:\"seo\";s:4:\"slug\";s:3:\"seo\";s:5:\"count\";s:4:\"1481\";}s:9:\"wordpress\";a:3:{s:4:\"name\";s:9:\"wordpress\";s:4:\"slug\";s:9:\"wordpress\";s:5:\"count\";s:4:\"1453\";}s:11:\"woocommerce\";a:3:{s:4:\"name\";s:11:\"woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:5:\"count\";s:4:\"1318\";}s:6:\"social\";a:3:{s:4:\"name\";s:6:\"social\";s:4:\"slug\";s:6:\"social\";s:5:\"count\";s:4:\"1269\";}s:5:\"links\";a:3:{s:4:\"name\";s:5:\"links\";s:4:\"slug\";s:5:\"links\";s:5:\"count\";s:4:\"1251\";}s:7:\"gallery\";a:3:{s:4:\"name\";s:7:\"gallery\";s:4:\"slug\";s:7:\"gallery\";s:5:\"count\";s:4:\"1222\";}s:5:\"email\";a:3:{s:4:\"name\";s:5:\"email\";s:4:\"slug\";s:5:\"email\";s:5:\"count\";s:4:\"1116\";}s:7:\"widgets\";a:3:{s:4:\"name\";s:7:\"widgets\";s:4:\"slug\";s:7:\"widgets\";s:5:\"count\";s:4:\"1047\";}s:5:\"pages\";a:3:{s:4:\"name\";s:5:\"pages\";s:4:\"slug\";s:5:\"pages\";s:5:\"count\";s:4:\"1017\";}s:6:\"jquery\";a:3:{s:4:\"name\";s:6:\"jquery\";s:4:\"slug\";s:6:\"jquery\";s:5:\"count\";s:3:\"969\";}s:5:\"media\";a:3:{s:4:\"name\";s:5:\"media\";s:4:\"slug\";s:5:\"media\";s:5:\"count\";s:3:\"927\";}s:3:\"rss\";a:3:{s:4:\"name\";s:3:\"rss\";s:4:\"slug\";s:3:\"rss\";s:5:\"count\";s:3:\"898\";}s:4:\"ajax\";a:3:{s:4:\"name\";s:4:\"AJAX\";s:4:\"slug\";s:4:\"ajax\";s:5:\"count\";s:3:\"863\";}s:5:\"video\";a:3:{s:4:\"name\";s:5:\"video\";s:4:\"slug\";s:5:\"video\";s:5:\"count\";s:3:\"856\";}s:7:\"content\";a:3:{s:4:\"name\";s:7:\"content\";s:4:\"slug\";s:7:\"content\";s:5:\"count\";s:3:\"853\";}s:9:\"ecommerce\";a:3:{s:4:\"name\";s:9:\"ecommerce\";s:4:\"slug\";s:9:\"ecommerce\";s:5:\"count\";s:3:\"850\";}s:5:\"login\";a:3:{s:4:\"name\";s:5:\"login\";s:4:\"slug\";s:5:\"login\";s:5:\"count\";s:3:\"829\";}s:10:\"javascript\";a:3:{s:4:\"name\";s:10:\"javascript\";s:4:\"slug\";s:10:\"javascript\";s:5:\"count\";s:3:\"788\";}s:10:\"buddypress\";a:3:{s:4:\"name\";s:10:\"buddypress\";s:4:\"slug\";s:10:\"buddypress\";s:5:\"count\";s:3:\"752\";}s:5:\"photo\";a:3:{s:4:\"name\";s:5:\"photo\";s:4:\"slug\";s:5:\"photo\";s:5:\"count\";s:3:\"723\";}s:7:\"youtube\";a:3:{s:4:\"name\";s:7:\"youtube\";s:4:\"slug\";s:7:\"youtube\";s:5:\"count\";s:3:\"717\";}s:4:\"feed\";a:3:{s:4:\"name\";s:4:\"feed\";s:4:\"slug\";s:4:\"feed\";s:5:\"count\";s:3:\"716\";}s:8:\"security\";a:3:{s:4:\"name\";s:8:\"security\";s:4:\"slug\";s:8:\"security\";s:5:\"count\";s:3:\"715\";}s:4:\"link\";a:3:{s:4:\"name\";s:4:\"link\";s:4:\"slug\";s:4:\"link\";s:5:\"count\";s:3:\"710\";}s:10:\"responsive\";a:3:{s:4:\"name\";s:10:\"responsive\";s:4:\"slug\";s:10:\"responsive\";s:5:\"count\";s:3:\"701\";}s:5:\"share\";a:3:{s:4:\"name\";s:5:\"Share\";s:4:\"slug\";s:5:\"share\";s:5:\"count\";s:3:\"694\";}s:4:\"spam\";a:3:{s:4:\"name\";s:4:\"spam\";s:4:\"slug\";s:4:\"spam\";s:5:\"count\";s:3:\"693\";}s:10:\"e-commerce\";a:3:{s:4:\"name\";s:10:\"e-commerce\";s:4:\"slug\";s:10:\"e-commerce\";s:5:\"count\";s:3:\"675\";}s:6:\"photos\";a:3:{s:4:\"name\";s:6:\"photos\";s:4:\"slug\";s:6:\"photos\";s:5:\"count\";s:3:\"668\";}s:8:\"category\";a:3:{s:4:\"name\";s:8:\"category\";s:4:\"slug\";s:8:\"category\";s:5:\"count\";s:3:\"667\";}s:5:\"embed\";a:3:{s:4:\"name\";s:5:\"embed\";s:4:\"slug\";s:5:\"embed\";s:5:\"count\";s:3:\"638\";}s:9:\"analytics\";a:3:{s:4:\"name\";s:9:\"analytics\";s:4:\"slug\";s:9:\"analytics\";s:5:\"count\";s:3:\"636\";}s:4:\"form\";a:3:{s:4:\"name\";s:4:\"form\";s:4:\"slug\";s:4:\"form\";s:5:\"count\";s:3:\"624\";}s:3:\"css\";a:3:{s:4:\"name\";s:3:\"CSS\";s:4:\"slug\";s:3:\"css\";s:5:\"count\";s:3:\"622\";}s:6:\"search\";a:3:{s:4:\"name\";s:6:\"search\";s:4:\"slug\";s:6:\"search\";s:5:\"count\";s:3:\"620\";}s:9:\"slideshow\";a:3:{s:4:\"name\";s:9:\"slideshow\";s:4:\"slug\";s:9:\"slideshow\";s:5:\"count\";s:3:\"617\";}s:6:\"custom\";a:3:{s:4:\"name\";s:6:\"custom\";s:4:\"slug\";s:6:\"custom\";s:5:\"count\";s:3:\"590\";}s:5:\"stats\";a:3:{s:4:\"name\";s:5:\"stats\";s:4:\"slug\";s:5:\"stats\";s:5:\"count\";s:3:\"589\";}s:6:\"slider\";a:3:{s:4:\"name\";s:6:\"slider\";s:4:\"slug\";s:6:\"slider\";s:5:\"count\";s:3:\"580\";}s:7:\"comment\";a:3:{s:4:\"name\";s:7:\"comment\";s:4:\"slug\";s:7:\"comment\";s:5:\"count\";s:3:\"575\";}s:6:\"button\";a:3:{s:4:\"name\";s:6:\"button\";s:4:\"slug\";s:6:\"button\";s:5:\"count\";s:3:\"570\";}s:4:\"menu\";a:3:{s:4:\"name\";s:4:\"menu\";s:4:\"slug\";s:4:\"menu\";s:5:\"count\";s:3:\"565\";}s:5:\"theme\";a:3:{s:4:\"name\";s:5:\"theme\";s:4:\"slug\";s:5:\"theme\";s:5:\"count\";s:3:\"565\";}s:4:\"tags\";a:3:{s:4:\"name\";s:4:\"tags\";s:4:\"slug\";s:4:\"tags\";s:5:\"count\";s:3:\"560\";}s:9:\"dashboard\";a:3:{s:4:\"name\";s:9:\"dashboard\";s:4:\"slug\";s:9:\"dashboard\";s:5:\"count\";s:3:\"559\";}s:10:\"categories\";a:3:{s:4:\"name\";s:10:\"categories\";s:4:\"slug\";s:10:\"categories\";s:5:\"count\";s:3:\"551\";}s:10:\"statistics\";a:3:{s:4:\"name\";s:10:\"statistics\";s:4:\"slug\";s:10:\"statistics\";s:5:\"count\";s:3:\"538\";}s:6:\"mobile\";a:3:{s:4:\"name\";s:6:\"mobile\";s:4:\"slug\";s:6:\"mobile\";s:5:\"count\";s:3:\"519\";}s:3:\"ads\";a:3:{s:4:\"name\";s:3:\"ads\";s:4:\"slug\";s:3:\"ads\";s:5:\"count\";s:3:\"518\";}s:4:\"user\";a:3:{s:4:\"name\";s:4:\"user\";s:4:\"slug\";s:4:\"user\";s:5:\"count\";s:3:\"514\";}s:6:\"editor\";a:3:{s:4:\"name\";s:6:\"editor\";s:4:\"slug\";s:6:\"editor\";s:5:\"count\";s:3:\"506\";}s:5:\"users\";a:3:{s:4:\"name\";s:5:\"users\";s:4:\"slug\";s:5:\"users\";s:5:\"count\";s:3:\"501\";}s:7:\"picture\";a:3:{s:4:\"name\";s:7:\"picture\";s:4:\"slug\";s:7:\"picture\";s:5:\"count\";s:3:\"499\";}s:4:\"list\";a:3:{s:4:\"name\";s:4:\"list\";s:4:\"slug\";s:4:\"list\";s:5:\"count\";s:3:\"495\";}s:7:\"plugins\";a:3:{s:4:\"name\";s:7:\"plugins\";s:4:\"slug\";s:7:\"plugins\";s:5:\"count\";s:3:\"493\";}s:9:\"affiliate\";a:3:{s:4:\"name\";s:9:\"affiliate\";s:4:\"slug\";s:9:\"affiliate\";s:5:\"count\";s:3:\"487\";}s:9:\"multisite\";a:3:{s:4:\"name\";s:9:\"multisite\";s:4:\"slug\";s:9:\"multisite\";s:5:\"count\";s:3:\"464\";}s:6:\"simple\";a:3:{s:4:\"name\";s:6:\"simple\";s:4:\"slug\";s:6:\"simple\";s:5:\"count\";s:3:\"459\";}s:8:\"pictures\";a:3:{s:4:\"name\";s:8:\"pictures\";s:4:\"slug\";s:8:\"pictures\";s:5:\"count\";s:3:\"450\";}s:12:\"contact-form\";a:3:{s:4:\"name\";s:12:\"contact form\";s:4:\"slug\";s:12:\"contact-form\";s:5:\"count\";s:3:\"450\";}s:12:\"social-media\";a:3:{s:4:\"name\";s:12:\"social media\";s:4:\"slug\";s:12:\"social-media\";s:5:\"count\";s:3:\"442\";}s:7:\"contact\";a:3:{s:4:\"name\";s:7:\"contact\";s:4:\"slug\";s:7:\"contact\";s:5:\"count\";s:3:\"441\";}s:10:\"navigation\";a:3:{s:4:\"name\";s:10:\"navigation\";s:4:\"slug\";s:10:\"navigation\";s:5:\"count\";s:3:\"426\";}s:5:\"flash\";a:3:{s:4:\"name\";s:5:\"flash\";s:4:\"slug\";s:5:\"flash\";s:5:\"count\";s:3:\"420\";}s:3:\"url\";a:3:{s:4:\"name\";s:3:\"url\";s:4:\"slug\";s:3:\"url\";s:5:\"count\";s:3:\"415\";}s:4:\"html\";a:3:{s:4:\"name\";s:4:\"html\";s:4:\"slug\";s:4:\"html\";s:5:\"count\";s:3:\"412\";}s:10:\"newsletter\";a:3:{s:4:\"name\";s:10:\"newsletter\";s:4:\"slug\";s:10:\"newsletter\";s:5:\"count\";s:3:\"403\";}s:3:\"api\";a:3:{s:4:\"name\";s:3:\"api\";s:4:\"slug\";s:3:\"api\";s:5:\"count\";s:3:\"403\";}s:4:\"meta\";a:3:{s:4:\"name\";s:4:\"meta\";s:4:\"slug\";s:4:\"meta\";s:5:\"count\";s:3:\"397\";}s:4:\"shop\";a:3:{s:4:\"name\";s:4:\"shop\";s:4:\"slug\";s:4:\"shop\";s:5:\"count\";s:3:\"396\";}s:4:\"news\";a:3:{s:4:\"name\";s:4:\"News\";s:4:\"slug\";s:4:\"news\";s:5:\"count\";s:3:\"394\";}s:9:\"marketing\";a:3:{s:4:\"name\";s:9:\"marketing\";s:4:\"slug\";s:9:\"marketing\";s:5:\"count\";s:3:\"392\";}s:3:\"tag\";a:3:{s:4:\"name\";s:3:\"tag\";s:4:\"slug\";s:3:\"tag\";s:5:\"count\";s:3:\"390\";}s:6:\"events\";a:3:{s:4:\"name\";s:6:\"events\";s:4:\"slug\";s:6:\"events\";s:5:\"count\";s:3:\"385\";}s:9:\"thumbnail\";a:3:{s:4:\"name\";s:9:\"thumbnail\";s:4:\"slug\";s:9:\"thumbnail\";s:5:\"count\";s:3:\"380\";}s:8:\"tracking\";a:3:{s:4:\"name\";s:8:\"tracking\";s:4:\"slug\";s:8:\"tracking\";s:5:\"count\";s:3:\"379\";}s:8:\"calendar\";a:3:{s:4:\"name\";s:8:\"calendar\";s:4:\"slug\";s:8:\"calendar\";s:5:\"count\";s:3:\"379\";}s:11:\"advertising\";a:3:{s:4:\"name\";s:11:\"advertising\";s:4:\"slug\";s:11:\"advertising\";s:5:\"count\";s:3:\"376\";}s:4:\"text\";a:3:{s:4:\"name\";s:4:\"text\";s:4:\"slug\";s:4:\"text\";s:5:\"count\";s:3:\"376\";}s:4:\"code\";a:3:{s:4:\"name\";s:4:\"code\";s:4:\"slug\";s:4:\"code\";s:5:\"count\";s:3:\"372\";}s:6:\"upload\";a:3:{s:4:\"name\";s:6:\"upload\";s:4:\"slug\";s:6:\"upload\";s:5:\"count\";s:3:\"368\";}s:8:\"lightbox\";a:3:{s:4:\"name\";s:8:\"lightbox\";s:4:\"slug\";s:8:\"lightbox\";s:5:\"count\";s:3:\"367\";}s:10:\"shortcodes\";a:3:{s:4:\"name\";s:10:\"shortcodes\";s:4:\"slug\";s:10:\"shortcodes\";s:5:\"count\";s:3:\"365\";}s:9:\"automatic\";a:3:{s:4:\"name\";s:9:\"automatic\";s:4:\"slug\";s:9:\"automatic\";s:5:\"count\";s:3:\"365\";}s:7:\"sharing\";a:3:{s:4:\"name\";s:7:\"sharing\";s:4:\"slug\";s:7:\"sharing\";s:5:\"count\";s:3:\"363\";}s:7:\"profile\";a:3:{s:4:\"name\";s:7:\"profile\";s:4:\"slug\";s:7:\"profile\";s:5:\"count\";s:3:\"363\";}}", "yes");
INSERT INTO `wp_root_options` VALUES("161", "widget_tribe-events-list-widget", "a:2:{i:2;a:3:{s:5:\"title\";s:22:\"Prochains événements\";s:5:\"limit\";s:1:\"5\";s:18:\"no_upcoming_events\";s:1:\"1\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("158", "tribe_events_calendar_options", "a:6:{s:16:\"tribeEnableViews\";a:3:{i:0;s:4:\"list\";i:1;s:5:\"month\";i:2;s:3:\"day\";}s:14:\"schema-version\";s:3:\"4.0\";s:27:\"recurring_events_are_hidden\";s:6:\"hidden\";s:21:\"previous_ecp_versions\";a:3:{i:0;s:1:\"0\";i:1;s:6:\"3.12.5\";i:2;s:6:\"3.12.6\";}s:18:\"latest_ecp_version\";s:3:\"4.0\";s:19:\"last-update-message\";s:6:\"3.12.5\";}", "yes");
INSERT INTO `wp_root_options` VALUES("159", "tribe_last_save_post", "1449314359", "yes");
INSERT INTO `wp_root_options` VALUES("163", "tablepress_plugin_options", "{\"plugin_options_db_version\":31,\"table_scheme_db_version\":3,\"prev_tablepress_version\":\"0\",\"tablepress_version\":\"1.6.1\",\"first_activation\":1446836868,\"message_plugin_update\":false,\"message_donation_nag\":true,\"use_custom_css\":true,\"use_custom_css_file\":true,\"custom_css\":\"\",\"custom_css_minified\":\"\",\"custom_css_version\":0}", "yes");
INSERT INTO `wp_root_options` VALUES("482", "_transient_timeout_tablepress_c_c4ca4238a0b923820dcc509a6f75849b", "1448562254", "no");
INSERT INTO `wp_root_options` VALUES("483", "_transient_tablepress_c_c4ca4238a0b923820dcc509a6f75849b", "[\"tablepress_10c5d7c96c5911e9aecf0e183095b6dd\"]", "no");
INSERT INTO `wp_root_options` VALUES("480", "_transient_timeout_tablepress_10c5d7c96c5911e9aecf0e183095b6dd", "1448475854", "no");
INSERT INTO `wp_root_options` VALUES("481", "_transient_tablepress_10c5d7c96c5911e9aecf0e183095b6dd", "\n<table id=\"tablepress-1\" class=\"tablepress tablepress-id-1\">\n<thead>\n<tr class=\"row-1 odd\">\n	<th class=\"column-1\">&nbsp;</th><th class=\"column-2\">Matin</th><th class=\"column-3\">Après-midi</th>\n</tr>\n</thead>\n<tbody class=\"row-hover\">\n<tr class=\"row-2 even\">\n	<td class=\"column-1\"><strong>Lundi</strong></td><td class=\"column-2\">08:30 	à 	12:05</td><td class=\"column-3\">13:30 	à 	15:30</td>\n</tr>\n<tr class=\"row-3 odd\">\n	<td class=\"column-1\"><strong>Mardi</strong></td><td class=\"column-2\">08:30 	à 	12:05</td><td class=\"column-3\">13:30 	à 	15:30</td>\n</tr>\n<tr class=\"row-4 even\">\n	<td class=\"column-1\"><strong>Mercredi</strong></td><td class=\"column-2\">08:30 	à 	12:05</td><td class=\"column-3\"></td>\n</tr>\n<tr class=\"row-5 odd\">\n	<td class=\"column-1\"><strong>Jeudi</strong></td><td class=\"column-2\">08:30 	à 	12:05</td><td class=\"column-3\">13:30 	à 	15:30</td>\n</tr>\n<tr class=\"row-6 even\">\n	<td class=\"column-1\"><strong>Vendredi</strong></td><td class=\"column-2\">08:30 	à 	12:05</td><td class=\"column-3\">13:30 	à 	15:30</td>\n</tr>\n</tbody>\n</table>\n", "no");
INSERT INTO `wp_root_options` VALUES("495", "_transient_tablepress_9d59d115a8a304ed5e67208f508738c5", "<h2 class=\"tablepress-table-name tablepress-table-name-id-3\">Semaine du 9 au 13 novembre</h2>\n\n<table id=\"tablepress-3\" class=\"tablepress tablepress-id-3\">\n<thead>\n<tr class=\"row-1 odd\">\n	<th class=\"column-1\">&nbsp;</th><th class=\"column-2\">Potage</th><th class=\"column-3\">Plat</th><th class=\"column-4\">Dessert</th>\n</tr>\n</thead>\n<tbody class=\"row-hover\">\n<tr class=\"row-2 even\">\n	<td class=\"column-1\"><strong>Lundi</strong></td><td class=\"column-2\">Bouillon</td><td class=\"column-3\">Rôti de porc<br />\nPommes de terre<br />\nHaricots au beurre</td><td class=\"column-4\">Fruit</td>\n</tr>\n<tr class=\"row-3 odd\">\n	<td class=\"column-1\"><strong>Mardi</strong></td><td class=\"column-2\">Mange-tout</td><td class=\"column-3\">Saucisse de poulet sauce provençale<br />\nPâtes</td><td class=\"column-4\">Yaourt</td>\n</tr>\n<tr class=\"row-4 even\">\n	<td class=\"column-1\"><strong>Mercredi</strong></td><td class=\"column-2\">Oignon</td><td class=\"column-3\">Poisson pané<br />\nRiz pilaf aux petits légumes</td><td class=\"column-4\">Friandise</td>\n</tr>\n<tr class=\"row-5 odd\">\n	<td class=\"column-1\"><strong>Jeudi</strong></td><td class=\"column-2\">Brocoli</td><td class=\"column-3\">Escalope de poulet croquante<br />\nPetits pois et maïs<br />\nPommes de terre</td><td class=\"column-4\">Friandise</td>\n</tr>\n<tr class=\"row-6 even\">\n	<td class=\"column-1\"><strong>Vendredi</strong></td><td class=\"column-2\">Poireaux</td><td class=\"column-3\">Oiseau sans tête (porc)<br />\nPurée<br />\nSalade</td><td class=\"column-4\">Fruit</td>\n</tr>\n</tbody>\n</table>\n", "no");
INSERT INTO `wp_root_options` VALUES("185", "fileaway_options", "a:71:{s:13:\"rootdirectory\";s:7:\"install\";s:11:\"strictlogin\";s:5:\"false\";s:5:\"base1\";s:26:\"files/projetsEtablissement\";s:7:\"bs1name\";s:25:\"Projets d\\\'établissement\";s:5:\"base2\";s:0:\"\";s:7:\"bs2name\";s:0:\"\";s:5:\"base3\";s:0:\"\";s:7:\"bs3name\";s:0:\"\";s:5:\"base4\";s:0:\"\";s:7:\"bs4name\";s:0:\"\";s:5:\"base5\";s:0:\"\";s:7:\"bs5name\";s:0:\"\";s:7:\"baseurl\";s:23:\"http://demo.ec-arlon.be\";s:8:\"redirect\";s:0:\"\";s:10:\"exclusions\";s:0:\"\";s:13:\"direxclusions\";s:0:\"\";s:9:\"newwindow\";s:0:\"\";s:14:\"encryption_key\";s:32:\"96bbc82a54aebed9d8ec4fa0eac18a3d\";s:16:\"banner_directory\";s:0:\"\";s:15:\"download_prefix\";s:0:\"\";s:11:\"modalaccess\";s:10:\"edit_posts\";s:8:\"tmcerows\";s:2:\"_2\";s:10:\"stylesheet\";s:6:\"footer\";s:10:\"javascript\";s:6:\"header\";s:8:\"pathinfo\";s:8:\"disabled\";s:8:\"daymonth\";s:2:\"dm\";s:12:\"postidcolumn\";s:7:\"enabled\";s:9:\"loadusers\";s:5:\"false\";s:10:\"adminstyle\";s:7:\"minimal\";s:19:\"custom_list_classes\";s:0:\"\";s:20:\"custom_table_classes\";s:0:\"\";s:24:\"custom_flightbox_classes\";s:0:\"\";s:20:\"custom_color_classes\";s:0:\"\";s:21:\"custom_accent_classes\";s:0:\"\";s:17:\"custom_stylesheet\";s:0:\"\";s:9:\"customcss\";s:0:\"\";s:10:\"css_editor\";s:6:\"syntax\";s:19:\"manager_role_access\";s:0:\"\";s:19:\"manager_user_access\";s:13:\"Administrator\";s:15:\"managerpassword\";s:9:\"AGU168kls\";s:5:\"stats\";s:5:\"false\";s:12:\"ignore_roles\";s:0:\"\";s:12:\"ignore_users\";s:0:\"\";s:11:\"recordlimit\";s:0:\"\";s:14:\"recordlifespan\";s:6:\"1 week\";s:13:\"instant_stats\";s:5:\"false\";s:19:\"instant_sender_name\";s:32:\"Les écoles communales d’Arlon\";s:14:\"instant_sender\";s:25:\"administrator@ec-arlon.be\";s:18:\"instant_recipients\";s:0:\"\";s:15:\"instant_subject\";s:40:\"%blog% - %file% downloaded at %datetime%\";s:14:\"compiled_stats\";s:5:\"false\";s:20:\"compiled_sender_name\";s:32:\"Les écoles communales d’Arlon\";s:15:\"compiled_sender\";s:25:\"administrator@ec-arlon.be\";s:19:\"compiled_recipients\";s:0:\"\";s:16:\"compiled_subject\";s:35:\"%blog% - Download Stats for %dates%\";s:5:\"feeds\";s:0:\"\";s:11:\"basefeeds_0\";s:0:\"\";s:18:\"feed_excluded_exts\";s:0:\"\";s:19:\"feed_excluded_files\";s:0:\"\";s:9:\"feedlimit\";s:0:\"\";s:9:\"feeddates\";s:4:\"true\";s:8:\"feedsize\";s:4:\"true\";s:9:\"feedlinks\";s:4:\"true\";s:14:\"recursivefeeds\";s:4:\"true\";s:12:\"feedinterval\";s:6:\"hourly\";s:11:\"updatefeeds\";s:4:\"true\";s:13:\"reset_options\";s:0:\"\";s:16:\"preserve_options\";s:8:\"preserve\";s:7:\"version\";s:7:\"3.9.6.1\";s:14:\"excluded_feeds\";a:0:{}s:9:\"basefeeds\";a:0:{}}", "yes");
INSERT INTO `wp_root_options` VALUES("187", "fileaway_db_version", "1.0", "yes");
INSERT INTO `wp_root_options` VALUES("188", "fileaway_db2_version", "1.0", "yes");
INSERT INTO `wp_root_options` VALUES("492", "_transient_timeout_tablepress_c_c81e728d9d4c2f636f067f89cc14862c", "1448562676", "no");
INSERT INTO `wp_root_options` VALUES("490", "_transient_timeout_tablepress_098c61e97af0032337a7d72a8b35917e", "1448476276", "no");
INSERT INTO `wp_root_options` VALUES("491", "_transient_tablepress_098c61e97af0032337a7d72a8b35917e", "<h2 class=\"tablepress-table-name tablepress-table-name-id-2\">Semaine du 26 au 30 octobre</h2>\n\n<table id=\"tablepress-2\" class=\"tablepress tablepress-id-2\">\n<thead>\n<tr class=\"row-1 odd\">\n	<th class=\"column-1\">&nbsp;</th><th class=\"column-2\">Potage</th><th class=\"column-3\">Plat</th><th class=\"column-4\">Dessert</th>\n</tr>\n</thead>\n<tbody class=\"row-hover\">\n<tr class=\"row-2 even\">\n	<td class=\"column-1\"><strong>Lundi</strong></td><td class=\"column-2\">Bouillon</td><td class=\"column-3\">Rôti de porc<br />\nPommes de terre<br />\nHaricots au beurre</td><td class=\"column-4\">Fruit</td>\n</tr>\n<tr class=\"row-3 odd\">\n	<td class=\"column-1\"><strong>Mardi</strong></td><td class=\"column-2\">Mange-tout</td><td class=\"column-3\">Saucisse de poulet sauce provençale<br />\nPâtes</td><td class=\"column-4\">Yaourt</td>\n</tr>\n<tr class=\"row-4 even\">\n	<td class=\"column-1\"><strong>Mercredi</strong></td><td class=\"column-2\">Oignon</td><td class=\"column-3\">Poisson pané<br />\nRiz pilaf aux petits légumes</td><td class=\"column-4\">Friandise</td>\n</tr>\n<tr class=\"row-5 odd\">\n	<td class=\"column-1\"><strong>Jeudi</strong></td><td class=\"column-2\">Brocoli</td><td class=\"column-3\">Escalope de poulet croquante<br />\nPetits pois et maïs<br />\nPommes de terre</td><td class=\"column-4\">Friandise</td>\n</tr>\n<tr class=\"row-6 even\">\n	<td class=\"column-1\"><strong>Vendredi</strong></td><td class=\"column-2\">Poireaux</td><td class=\"column-3\">Oiseau sans tête (porc)<br />\nPurée<br />\nSalade</td><td class=\"column-4\">Fruit</td>\n</tr>\n</tbody>\n</table>\n", "no");
INSERT INTO `wp_root_options` VALUES("224", "inkthemes_backup_data", "1", "yes");
INSERT INTO `wp_root_options` VALUES("247", "widget_sparkling_popular_posts", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("493", "_transient_tablepress_c_c81e728d9d4c2f636f067f89cc14862c", "[\"tablepress_098c61e97af0032337a7d72a8b35917e\"]", "no");
INSERT INTO `wp_root_options` VALUES("494", "_transient_timeout_tablepress_9d59d115a8a304ed5e67208f508738c5", "1448476276", "no");
INSERT INTO `wp_root_options` VALUES("496", "_transient_timeout_tablepress_c_eccbc87e4b5ce2fe28308fd9f2a7baf3", "1448562676", "no");
INSERT INTO `wp_root_options` VALUES("497", "_transient_tablepress_c_eccbc87e4b5ce2fe28308fd9f2a7baf3", "[\"tablepress_9d59d115a8a304ed5e67208f508738c5\"]", "no");
INSERT INTO `wp_root_options` VALUES("249", "widget_sparkling-social", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_root_options` VALUES("532", "wpseo_permalinks", "a:13:{s:15:\"cleanpermalinks\";b:0;s:24:\"cleanpermalink-extravars\";s:0:\"\";s:29:\"cleanpermalink-googlecampaign\";b:0;s:31:\"cleanpermalink-googlesitesearch\";b:0;s:15:\"cleanreplytocom\";b:0;s:10:\"cleanslugs\";b:1;s:14:\"hide-feedlinks\";b:0;s:12:\"hide-rsdlink\";b:0;s:14:\"hide-shortlink\";b:0;s:16:\"hide-wlwmanifest\";b:0;s:18:\"redirectattachment\";b:0;s:17:\"stripcategorybase\";b:0;s:13:\"trailingslash\";b:0;}", "yes");
INSERT INTO `wp_root_options` VALUES("533", "wpseo_titles", "a:70:{s:10:\"title_test\";i:0;s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:5:\"noodp\";b:0;s:6:\"noydir\";b:0;s:15:\"usemetakeywords\";b:0;s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Auteur à %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:65:\"Vous avez cherché %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:44:\"La page est introuvable %%sep%% %%sitename%%\";s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:18:\"metakey-home-wpseo\";s:0:\"\";s:20:\"metakey-author-wpseo\";s:0:\"\";s:22:\"noindex-subpages-wpseo\";b:0;s:20:\"noindex-author-wpseo\";b:0;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"metakey-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:13:\"showdate-post\";b:0;s:16:\"hideeditbox-post\";b:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"metakey-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:13:\"showdate-page\";b:0;s:16:\"hideeditbox-page\";b:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"metakey-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:19:\"showdate-attachment\";b:0;s:22:\"hideeditbox-attachment\";b:0;s:18:\"title-tribe_events\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tribe_events\";s:0:\"\";s:20:\"metakey-tribe_events\";s:0:\"\";s:20:\"noindex-tribe_events\";b:0;s:21:\"showdate-tribe_events\";b:0;s:24:\"hideeditbox-tribe_events\";b:0;s:28:\"title-ptarchive-tribe_events\";s:51:\"%%pt_plural%% Archive %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-ptarchive-tribe_events\";s:0:\"\";s:30:\"metakey-ptarchive-tribe_events\";s:0:\"\";s:30:\"bctitle-ptarchive-tribe_events\";s:0:\"\";s:30:\"noindex-ptarchive-tribe_events\";b:0;s:18:\"title-tax-category\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:20:\"metakey-tax-category\";s:0:\"\";s:24:\"hideeditbox-tax-category\";b:0;s:20:\"noindex-tax-category\";b:0;s:18:\"title-tax-post_tag\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:20:\"metakey-tax-post_tag\";s:0:\"\";s:24:\"hideeditbox-tax-post_tag\";b:0;s:20:\"noindex-tax-post_tag\";b:0;s:21:\"title-tax-post_format\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:23:\"metakey-tax-post_format\";s:0:\"\";s:27:\"hideeditbox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:26:\"title-tax-tribe_events_cat\";s:53:\"%%term_title%% Archives %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-tribe_events_cat\";s:0:\"\";s:28:\"metakey-tax-tribe_events_cat\";s:0:\"\";s:32:\"hideeditbox-tax-tribe_events_cat\";b:0;s:28:\"noindex-tax-tribe_events_cat\";b:0;}", "yes");
INSERT INTO `wp_root_options` VALUES("531", "wpseo", "a:20:{s:14:\"blocking_files\";a:0:{}s:26:\"ignore_blog_public_warning\";b:0;s:31:\"ignore_meta_description_warning\";b:0;s:20:\"ignore_page_comments\";b:0;s:16:\"ignore_permalink\";b:0;s:15:\"ms_defaults_set\";b:0;s:23:\"theme_description_found\";s:0:\"\";s:21:\"theme_has_description\";b:0;s:7:\"version\";s:5:\"3.0.4\";s:11:\"alexaverify\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:0:\"\";s:20:\"disableadvanced_meta\";b:1;s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";}", "yes");
INSERT INTO `wp_root_options` VALUES("639", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.3.1.zip\";s:6:\"locale\";s:5:\"fr_FR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fr_FR/wordpress-4.3.1.zip\";s:10:\"no_content\";b:0;s:11:\"new_bundled\";b:0;s:7:\"partial\";b:0;s:8:\"rollback\";b:0;}s:7:\"current\";s:5:\"4.3.1\";s:7:\"version\";s:5:\"4.3.1\";s:11:\"php_version\";s:5:\"5.2.4\";s:13:\"mysql_version\";s:3:\"5.0\";s:11:\"new_bundled\";s:3:\"4.1\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1449311389;s:15:\"version_checked\";s:5:\"4.3.1\";s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_root_options` VALUES("402", "theme_mods_polymer", "a:4:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"secondary\";i:2;}s:12:\"header_image\";s:69:\"http://demo.ec-arlon.be/wp-content/uploads/2015/11/cropped-header.jpg\";s:17:\"header_image_data\";O:8:\"stdClass\":5:{s:13:\"attachment_id\";i:90;s:3:\"url\";s:69:\"http://demo.ec-arlon.be/wp-content/uploads/2015/11/cropped-header.jpg\";s:13:\"thumbnail_url\";s:69:\"http://demo.ec-arlon.be/wp-content/uploads/2015/11/cropped-header.jpg\";s:6:\"height\";i:191;s:5:\"width\";i:1175;}}", "yes");
INSERT INTO `wp_root_options` VALUES("658", "_transient_timeout_feed_0d102f2a1f4d6bc90eb8c6ffe18e56ed", "1449354568", "no");
INSERT INTO `wp_root_options` VALUES("659", "_transient_feed_0d102f2a1f4d6bc90eb8c6ffe18e56ed", "a:4:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:49:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:3:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"The Events Calendar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://theeventscalendar.com\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"WordPress event plugins for people who kick ass\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 05 Dec 2015 09:09:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"en-US\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:45:\"\n		\n		\n		\n		\n		\n				\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:54:\"Release: The Events Calendar Version 4.0 + all add-ons\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:82:\"https://theeventscalendar.com/release-the-events-calendar-version-4-0-all-add-ons/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"https://theeventscalendar.com/release-the-events-calendar-version-4-0-all-add-ons/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Dec 2015 00:05:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:2:{i:0;a:5:{s:4:\"data\";s:8:\"Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Release Notes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1033237\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:614:\"<p>Dear Triberians, today is a great one. The Events Calendar 4.0 is finally here and we&#8217;re thrilled for you to have it. Version 4.0 is a huge milestone for all of us here at Modern Tribe. Consider what&#8217;s happened in the two years since Version 3.0 was released: The plugin surpassed 1 million downloads, then&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/release-the-events-calendar-version-4-0-all-add-ons/\">Release: The Events Calendar Version 4.0 + all add-ons</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Geoff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:25295:\"<p>Dear Triberians, today is a great one. <strong>The Events Calendar 4.0 is finally here</strong> and we&#8217;re thrilled for you to have it.</p>\n<p>Version 4.0 is a huge milestone for all of us here at Modern Tribe. Consider what&#8217;s happened in the <a href=\"https://wordpress.org/support/topic/release-the-events-calendar-30\">two years since Version 3.0 was released</a>:</p>\n<ul>\n<li>The plugin surpassed 1 million downloads, then 2 million shortly after</li>\n<li>We completed nearly 900 new features</li>\n<li>We squashed more than 1,000 bugs over 33 releases</li>\n<li>We fielded over 35,000 topics in our forums</li>\n<li>We shared countless cat gifs in with each other over Slack</li>\n</ul>\n<p>Needless to say, we&#8217;ve poured a lot of love into The Events Calendar heading into Version 4.0. We hope you love it as much as we do.</p>\n<p>There&#8217;s a whole lot of awesomeness to cover here and we&#8217;ll outline every single change here in this post, including those in the premium add-ons. On that same note, it&#8217;s important to know that <strong>The Events Calendar 4.0 is a radical departure from the previous version and, as such, you will want to test the latest plugins in a test environment before updating.</strong> If you have customized the plugin or any of the add-ons in the past, then you will most definitely want to exercise caution and test this update against your changes before updating on a live site.</p>\n<p><strong>Please Note:</strong> Use the Bulk Update option in WordPress if you are running The Events Calendar with multiple add-ons. We have encountered an issue where activating The Events Calendar 4.0 and Community Events separately can cause a fatal error and are working on a fix in the meantime.</p>\n<p>Alright, let&#8217;s dig into what&#8217;s new:</p>\n<ul>\n<li><a href=\"#core\"><strong>The Events Calendar</strong></a></li>\n<li><a href=\"#pro\"><strong>Events Calendar PRO</strong></a></li>\n<li><a href=\"#filter\"><strong>Filter Bar</strong></a></li>\n<li><a href=\"#community\"><strong>Community Events</strong></a></li>\n<li><a href=\"#community-tickets\"><strong>Community Tickets</strong></a></li>\n<li><a href=\"#ical\"><strong>iCal Importer</strong></a></li>\n<li><a href=\"#eventbrite\"><strong>Eventbrite Tickets</strong></a></li>\n<li><a href=\"#facebook\"><strong>Facebook Events</strong></a></li>\n<li><strong><a href=\"#apm\">Advanced Post Manager</a></strong></li>\n</ul>\n<hr />\n<h3 id=\"core\">The Events Calendar 4.0</h3>\n<ul>\n<li><strong>Security</strong> &#8211; A TON of escaping was added to our codebase thanks to the efforts of the always-helpful Andy Fragen (@afragen)</li>\n<li><strong>Feature</strong> &#8211; Moved the Ticket framework code into its own plugin (event-tickets)</li>\n<li><strong>Feature</strong> &#8211; The event cost now supports more international formats with the addition of the tribe_events_cost_separators filter (Thank you remokrol for bringing this to our attention!)</li>\n<li><strong>Feature</strong> &#8211; Added support for the twentysixteen theme</li>\n<li><strong>Feature</strong> &#8211; Created a new Add-Ons tab in Settings so that TEC add-ons can have a consolidated settings tab</li>\n<li><strong>Feature</strong> &#8211; Improve the date formats UI by providing example output for each selected format</li>\n<li><strong>Tweak</strong> &#8211; Restructured TEC&#8217;s core settings code for reusability with other standalone plugins like Event Tickets</li>\n<li><strong>Tweak</strong> &#8211; Deprecate old JS event names in favor of a new JS event naming standard. Example: deprecated tribe_ev_runAjax in favor of run-ajax.tribe</li>\n<li><strong>Tweak</strong> &#8211; Consolidated import pages for TEC and add-ons</li>\n<li><strong>Tweak</strong> &#8211; When suggesting a UTF-8 compatibility CSV formatting tool, point to one that still exists</li>\n<li><strong>Tweak</strong> &#8211; Added the ability to filter attendees CSV items via tribe_events_tickets_attendees_csv_items (Props to @bostondv on GitHub for this patch!)</li>\n<li><strong>Tweak</strong> &#8211; Updated all excerpt output to use tribe_events_get_the_excerpt() to ensure a consistent display of excerpt content (Cheers to Joseph to pointing this out!)</li>\n<li><strong>Tweak</strong> &#8211; Add support for wp_get_document_title in response to the WordPress 4.4 deprecation of wp_title</li>\n<li><strong>Tweak</strong> &#8211; Check post creation permissions before letting users create venues and organizers from the event meta box</li>\n<li><strong>Tweak</strong> &#8211; Only display data separators between fields that have data when rendering organizers (Thank you Bud for highlighting this issue!)</li>\n<li><strong>Tweak</strong> &#8211; When a user cannot create organizers, prevent the auto-selection of organizers when editing an event</li>\n<li><strong>Tweak</strong> &#8211; Remove microformat CSS classes from templates and replace with namespaced content-relevant CSS classes</li>\n<li><strong>Tweak</strong> &#8211; Changed the &#8220;updated&#8221; CSS class to &#8220;tribe-updated&#8221; so that it is properly namespaced (Thank you vijayrajesh!)</li>\n<li><strong>Tweak</strong> &#8211; The Plugin Update Checker will now auto-save valid plugin keys (Thanks to Denon for originally bringing this up!)</li>\n<li><strong>Tweak</strong> &#8211; Cleaned up the output of JSON-LD data. Filterable via the new tribe_google_data_markup_json filter</li>\n<li><strong>Tweak</strong> &#8211; Drop the use of the generic CSS class &#8220;placeholder&#8221; in favor of &#8220;tribe-event-placeholder&#8221; (Thanks to Marc on the forums!)</li>\n<li><strong>Tweak</strong> &#8211; Adjusted the CSS padding on Admin Menu items for Events</li>\n<li><strong>Tweak</strong> &#8211; Various codesniffer fixes</li>\n<li><strong>Tweak</strong> &#8211; Error messages for empty Venue names</li>\n<li><strong>Tweak</strong> &#8211; Improve our responsiveness for the widget mini calendar, allowing smaller sidebars.</li>\n<li><strong>Tweak</strong> &#8211; tribe_get_venue_link() no longer echoes if you ask it to return an &lt;a&gt; element</li>\n<li><strong>Tweak</strong> &#8211; No longer retrieve empty costs when fetching all costs for all events</li>\n<li><strong>Tweak</strong> &#8211; Change the priority of bootstrapping the-events-calendar to ensure it occurs before any of the TEC addons in the event some addons are upgraded to v4.0 later than TEC</li>\n<li><strong>Tweak</strong> &#8211; Adjust the logic used for adding a noindex/follow tag to event views</li>\n<li><strong>Tweak</strong> &#8211; No longer hiding default address fields when default venues are selected when Pro is active</li>\n<li><strong>Fix</strong> &#8211; Resolved issue where the iCal feed did not provide an appropriately formatted timezone in some cases (Cheers to Matt for the report!)</li>\n<li><strong>Fix</strong> &#8211; Added support for translating some previously untranslatable strings (Props to tititou36, media325, and Stef!)</li>\n<li><strong>Fix</strong> &#8211; Prevented duplicate CSS IDs on the mini calendars (Cheers to Corrado for the help!)</li>\n<li><strong>Fix</strong> &#8211; Fixed bug causing tribe_get_single_ical_link() and tribe_get_ical_link() to use the same URL when it shouldn&#8217;t (Props to Ben Byrne @drywall on Twitter for the heads up!)</li>\n<li><strong>Fix</strong> &#8211; Fixed issue where the &#8220;Add another organizer&#8221; text wasn&#8217;t using the correct singular label (Thank you MIKE for the report!)</li>\n<li><strong>Fix</strong> &#8211; Various CSS fixes for twenty(ten-fifteen)</li>\n<li><strong>Fix</strong> &#8211; Improved our handling of `get_current_screen()` across the plugin, avoiding notices and warnings (Thank you Mike for the help!)</li>\n<li><strong>Fix</strong> &#8211; Fixed bug where accessing object properties on a non object errored out when saving event meta (props to @dalethedeveloper on GitHub for this fix!)</li>\n<li><strong>Fix</strong> &#8211; Fixed bug where organizer ID meta attached sometimes included a blank record. That blank record is no longer returned in tribe_get_organizer_ids()</li>\n<li><strong>Fix</strong> &#8211; Fixed error message returned when tabbing away from a blank event name meta box so that it properly indicates that an event name is required (Our thanks to @tapan29bd for this fix!)</li>\n<li><strong>Fix</strong> &#8211; Resolved issue where Timezone event start/end date property name strings were malformed which guaranteed a call to get_post_meta for Timezone date strings</li>\n<li><strong>Fix</strong> &#8211; Fixed CSS issue where the month view calendar could sometimes extend beyond the edge of the page when Skeleton Styles were enabled</li>\n<li><strong>Fix</strong> &#8211; Fixed a problem where iCal data was generated with incorrect dates in the case of some all days events (thanks to Matt for highlighting this)</li>\n<li><strong>Fix</strong> &#8211; Resolved a problem causing the previous month view to appear when it should not</li>\n<li><strong>Fix</strong> &#8211; Fixed issue in mobile month view where date was missing from heading</li>\n<li><strong>Fix</strong> &#8211; Resolved issue that caused /events/ to 404 if it was visited on a new install before hitting &#8220;Save&#8221; on the Events &gt; Settings &gt; Display page</li>\n<li><strong>Deprecated</strong> &#8211; The Tribe__Events__Main::defaultValueReplaceEnabled() method is being deprecated in favor of tribe_get_option(&#8216;defaultValueReplace&#8217;). Schedules for removal in v4.5</li>\n<li><strong>Deprecated</strong> &#8211; The tribe_event_link() has been deprecated in favor of tribe_get_event_link(). Scheduled for removal in 5.0</li>\n<li><strong>Deprecated</strong> &#8211; The third parameter of tribe_get_organizer_link() (the $echo parameter) has been deprecated and is scheduled for removal in 5.0</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Abstract_Deactivation in favor of Tribe__Abstract_Deactivation</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Admin__Helpers in favor of Tribe__Admin__Helpers</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__App_Shop in favor of Tribe__App_Shop</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Autoloader in favor of Tribe__Autoloader</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Cache in favor of Tribe__Cache</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Cache_Listener in favor of Tribe__Cache_Listener</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Changelog_Reader in favor of Tribe__Changelog_Reader</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Credits in favor of Tribe__Credits</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Date_Utils in favor of Tribe__Date_Utils</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Field in favor of Tribe__Field</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Settings in favor of Tribe__Settings</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Settings_Tab in favor of Tribe__Settings_Tab</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Support in favor of Tribe__Support</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Template_Part_Cache in favor of Tribe__Template_Part_Cache</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Attendees_Table in favor of Tribe__Tickets__Attendees_Table in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Metabox in favor of Tribe__Tickets__Metabox in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Ticket_Object in favor of Tribe__Tickets__Ticket_Object in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Tickets in favor of Tribe__Tickets__Tickets in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Tickets_Pro in favor of Tribe__Tickets__Tickets_Handler in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Validate in favor of Tribe__Validate</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__View_Helpers in favor of Tribe__View_Helpers</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::OPTIONNAME in favor of Tribe__Main::OPTIONNAME</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::OPTIONNAMENETWORK in favor of Tribe__Main::OPTIONNAMENETWORK</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::addHelpAdminMenuItem() in favor of Tribe__Settings_Manager::add_help_admin_menu_item()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::addNetworkOptionsPage() in favor of Tribe__Settings_Manager::add_network_options_page()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::array_insert_after_key() in favor of Tribe__Main::array_insert_after_key()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::array_insert_before_key() in favor of Tribe__Main::array_insert_before_key()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::debug() in favor of Tribe__Debug::debug()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::defaultValueReplaceEnabled() in favor of tribe_get_option( &#8216;defaultValueReplace&#8217; )</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::doHelpTab() in favor of Tribe__Settings_Manager::do_help_tab()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::doNetworkSettingTab() in favor of Tribe__Settings_Manager::do_network_settings_tab()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::doSettingTabs() in favor of Tribe__Settings_Manager::do_setting_tabs()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::do_licenses_tab() in favor of Tribe__Settings_Manager::do_licenses_tab()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getNetworkOption() in favor of Tribe__Settings_Manager::get_network_option()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getNetworkOptions() in favor of Tribe__Settings_Manager::get_network_options()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getNotices() in favor of Tribe__Notices::get()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getOption() in favor of Tribe__Settings_Manager::get_option()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getOptions() in favor of Tribe__Settings_Manager::get_options()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::have_addons() in favor of Tribe__Settings_Manager::have_addons()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::isNotice() in favor of Tribe__Notices::is_notice()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::pluginDir in favor of Tribe__Events__Main::plugin_dir</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::pluginName in favor of Tribe__Events__Main::plugin_name</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::pluginPath in favor of Tribe__Events__Main::plugin_path</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::pluginUrl in favor of Tribe__Events__Main::plugin_url</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::removeNotice() in favor of Tribe__Notices::remove_notice()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::renderDebug() in favor of Tribe__Debug::render()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::saveAllTabsHidden() in favor of Tribe__Settings_Manager::save_all_tabs_hidden()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::setNetworkOptions() in favor of Tribe__Settings_Manager::set_network_options()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::setNotice() in favor of Tribe__Notices::set_notice()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::truncate() in favor of tribe_events_get_the_excerpt()</li>\n<li><strong>Deprecated</strong> &#8211; tribe_event_beginning_of_day() in favor of tribe_beginning_of_day()</li>\n<li><strong>Deprecated</strong> &#8211; tribe_event_end_of_day() in favor of tribe_end_of_day()</li>\n<li><strong>Deprecated</strong> &#8211; tribe_event_format_date() in favor of tribe_format_date()</li>\n<li><strong>Deprecated</strong> &#8211; tribe_events_the_notices() in favor of tribe_the_notices()</li>\n</ul>\n<h3 id=\"pro\">The Events Calendar PRO 4.0</h3>\n<ul>\n<li><strong>Feature</strong> &#8211; <a href=\"https://theeventscalendar.com/knowledgebase/pro-color-customizer/\">Added Customizer support</a> for altering the colors of The Events Calendar (Cheers to the anonymous user who posted the original idea on UserVoice!)</li>\n<li><strong>Feature</strong> &#8211; Added a <a href=\"https://theeventscalendar.com/knowledgebase/configuring-the-this-week-widget/\">new widget and shortcode</a> called &#8220;This Week&#8221; that displays a events for a given week (with pagination). Short code is [tribe_this_week]</li>\n<li><strong>Feature</strong> &#8211; Add support for a countdown to the next upcoming event in the Countdown Widget (Thank you Phil de Gruchy for posting this idea on UserVoice!)</li>\n<li><strong>Feature</strong> &#8211; Add support for twentysixteen</li>\n<li><strong>Feature</strong> &#8211; Add support for an iCal export link for all events in a series of recurring events via: tribe_get_recurrence_ical_link()</li>\n<li><strong>Tweak</strong> &#8211; Major tweaks to support the newly genericized tribe-common libraries</li>\n<li><strong>Tweak</strong> &#8211; Deprecate old JS event names in favor of a new JS event naming standard. Example: deprecated tribe_ev_runAjax in favor of run-ajax.tribe</li>\n<li><strong>Tweak</strong> &#8211; Altered the storage of selected multichoice values for custom fields so they can be queried more effectively</li>\n<li><strong>Tweak</strong> &#8211; Add JSON-LD markup to single venus and organizers</li>\n<li><strong>Tweak</strong> &#8211; Only pre-populate address data for venues when the venue metabox appears on the venue post editor &#8211; NOT the event post editor</li>\n<li><strong>Tweak</strong> &#8211; Simplify the machine-generated recurrence rule descriptions for simple rules (Thank you jberg1 for the help!)</li>\n<li><strong>Tweak</strong> &#8211; Add support for multiple organizers to the List Widget (Thank media325 for the report!)</li>\n<li><strong>Tweak</strong> &#8211; Remove microformat CSS classes from templates and replace with namespaced content-relevant CSS classes</li>\n<li><strong>Tweak</strong> &#8211; Add support for a count argument to the mini calendar shortcode</li>\n<li><strong>Tweak</strong> &#8211; Refactored part of recurrence code to make testing it easier</li>\n<li><strong>Fix</strong> &#8211; Resolved bug where recurrence exclusions were not getting respected while generating events</li>\n<li><strong>Fix</strong> &#8211; Resolved bug where extra spaces were added to the body_class return value (Props to @garrettjohnson for this fix!)</li>\n<li><strong>Fix</strong> &#8211; Resolved issue where tribe_all_occurences_link() sometimes returned an incorrect URL when an explicit ID was passed</li>\n<li><strong>Fix</strong> &#8211; Don&#8217;t escape HTML on additional fields that hold URLs (Thank you Gwenyth for bringing this to our attention!)</li>\n<li><strong>Fix</strong> &#8211; Updated comment in Week View tooltip and mobile templates to point at the right file for customization instructions</li>\n<li><strong>Fix</strong> &#8211; Fixed CSS issues with the responsiveness of the Calendar Widget &amp; Countdown Widget</li>\n<li><strong>Fix</strong> &#8211; Prevent notices in the Venue Widget by declaring default settings</li>\n<li><strong>Fix</strong> &#8211; Resolved HTML validation issue with the Countdown Widget (Thank you rverduin for reporting this issue!)</li>\n<li><strong>Fix</strong> &#8211; Various twenty(ten-sixteen) CSS fixes</li>\n<li><strong>Fix</strong> &#8211; Fixed bug where pre-3.12 recurrence events were returning false when tribe_is_recurring_event() was called</li>\n<li><strong>Fix</strong> &#8211; Fixed issue where a recurring event&#8217;s &#8220;all&#8221; view would not display past instances</li>\n<li><strong>Fix</strong> &#8211; Fixed bug with APM where sorting some columns caused post filtering to clear</li>\n<li><strong>Fix</strong> &#8211; Fixed various notices</li>\n<li><strong>Fix</strong> &#8211; Fixed issue where some strings were trying to use the wrong textdomain for translations (Props to Valu for the help!)</li>\n<li><strong>Fix</strong> &#8211; Fixed date issue with the List Widget where the fancy date box was always displaying today&#8217;s date</li>\n<li><strong>Fix</strong> &#8211; Resolved a problem preventing some category views from working as expected when a non-default language was in use (Thank you Cristina for highlighting this issue!)</li>\n<li><strong>Fix</strong> &#8211; Resolved a problem whereby mini calendars could incorrectly render some days as populated when set to display events in a specific category (Our thanks to oniregoc for highlighting this!)</li>\n<li><strong>Fix</strong> &#8211; Fixed some strings that were not getting translated (thanks to Hans-Gerd for reporting this issue!)</li>\n<li><strong>Fix</strong> &#8211; Fixed monthly exclusion not being respected when creating recurring events</li>\n<li><strong>Deprecated</strong> &#8211; Deprecating the &#8220;defaultValueReplace&#8221; option in the Default Content settings tab</li>\n</ul>\n<h3 id=\"filter\">Filter Bar 4.0</h3>\n<ul>\n<li><strong>Feature</strong> &#8211; Additional fields created with Events Calendar PRO can now be used as filters (Thank you Lars for originally suggesting this on UserVoice!)</li>\n<li><strong>Tweak</strong> &#8211; Revise the way category filters work to improve compatibility with custom filter implementations etc (Props to Nancy Barraza for this one!)</li>\n<li><strong>Tweak</strong> &#8211; Update JS event names to match the changes in the-events-calendar</li>\n</ul>\n<h3 id=\"community\">Community Events 4.0</h3>\n<ul>\n<li><strong>Feature</strong> &#8211; Added new Filter on Community Events related pages (`tribe_ce_i18n_page_titles`) (Thank you Mad Dog!)</li>\n<li><strong>Tweak</strong> &#8211; Add support for wp_get_document_title in response to the WordPress 4.4 deprecation of wp_title</li>\n<li><strong>Tweak</strong> &#8211; Output the &#8220;Advanced Template Settings&#8221; custom HTML before and after the event list and event add form (Thank you Benjamin for the heads up!)</li>\n<li><strong>Fix</strong> &#8211; My Events ordered now reverse chronologically, as it was intended (earlier first)</li>\n<li><strong>Fix</strong> &#8211; Better CSS for when My Events page Navigation has multiple pages</li>\n<li><strong>Fix</strong> &#8211; Make some strings translatable that were not (Props to Oliver for bringing it to our attention)</li>\n<li><strong>Fix</strong> &#8211; Resolved an issue where translations sometimes failed to load (Thanks for the report and the fix Murat!)</li>\n</ul>\n<h3 id=\"community-tickets\">Community Tickets 4.0</h3>\n<ul>\n<li><strong>Fix</strong> &#8211; Compatibility fix with PHP 5.2 when accessing the WooCommerce cart</li>\n</ul>\n<h3 id=\"ical\">iCal Importer 4.0</h3>\n<ul>\n<li><strong>Feature</strong> &#8211; Added support for \\n as linebreaks in event content (Thank you Steve for bringing this to our attention!)</li>\n<li><strong>Tweak</strong> &#8211; Modify the handling of recurring events so that they are consistently saved as individual (though non-recurring) events (Props to Justin for reporting this!)</li>\n<li><strong>Tweak</strong> &#8211; Standardize spinner styles and behaviors to match those of WP core</li>\n<li><strong>Tweak</strong> &#8211; Always import latitude and longitude coordinates if the address is findable via Google&#8217;s geocoding API</li>\n</ul>\n<h3 id=\"eventbrite\">Eventbrite Tickets 4.0</h3>\n<ul>\n<li><strong>Feature</strong> &#8211; add filters making it possible to prevent image synchronization (Thanks to capacitycanada for the help!)</li>\n<li><strong>Fix</strong> &#8211; No more Empty notices when activating the plugin</li>\n</ul>\n<h3 id=\"facebook\">Facebook Events 4.0</h3>\n<ul>\n<li><strong>Feature</strong> &#8211; Added the option to re-synchronize an imported event by pulling in the latest information from the matching Facebook event (Thanks to Jon Martin for proposing this on UserVoice!)</li>\n<li><strong>Tweak</strong> &#8211; Added tribe_events_facebook_event_created hook (provides Event ID, Organizer ID, and Venue ID as parameters) when an event is imported from Facebook</li>\n</ul>\n<h3 id=\"apm\">Advanced Post Manager</h3>\n<ul>\n<li><strong>Fix</strong> &#8211; improved code standardization to bring this up to Modern Tribe standards</li>\n<li><strong>Feature</strong> &#8211; increased language support including Catalan, Czech, French, and Portuguese (Portugal)</li>\n</ul>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/release-the-events-calendar-version-4-0-all-add-ons/\">Release: The Events Calendar Version 4.0 + all add-ons</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:87:\"https://theeventscalendar.com/release-the-events-calendar-version-4-0-all-add-ons/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:98:\"Things to be aware of in version 4.0 of The Events Calendar, The Events Calendar PRO + all add-ons\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://theeventscalendar.com/things-to-be-aware-of-in-version-4-0/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://theeventscalendar.com/things-to-be-aware-of-in-version-4-0/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 02 Dec 2015 18:33:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:8:\"Products\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:13:\"Release Notes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:3:\"4.0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:8:\"features\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1033194\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:617:\"<p>Version 4.0 of The Events Calendar and all the associated add-ons is a big update. We are introducing some new plugins, which are just the beginning of some big new things to come. We also have a myriad of fixes and tweaks that make all sorts of things better. To get you pumped up, here are&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/things-to-be-aware-of-in-version-4-0/\">Things to be aware of in version 4.0 of The Events Calendar, The Events Calendar PRO + all add-ons</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Zach\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:19779:\"<p>Version 4.0 of The Events Calendar and all the associated add-ons is a big update. We are introducing some new plugins, which are just the beginning of some big new things to come. We also have a myriad of fixes and tweaks that make all sorts of things better.</p>\n<p>To get you pumped up, here are the top things we think you should be aware of before jumping into 4.0!</p>\n<h3>1. Introducing Event Tickets and Event Tickets Plus</h3>\n<p>Event Tickets is a brand new free plugin that is <a>available on WordPress.org</a>. This plugin allows you to collect RSVPs and manage event registration with ease. You can run Event Tickets as a standalone plugin or combine it with The Events Calendar for simple, powerful event registration &amp; ticketing functionality.</p>\n<p>Event Tickets Plus is a premium add-on to Event Tickets that provides commerce integration for WooCommerce, Shopp, EDD, and WP eCommerce. This plugin will be replacing our four existing plugins: WooCommerce Tickets, WP e-Commerce Tickets, Easy Digital Downloads Tickets, and Shopp Tickets. It matches all their functionality and allows you to buy a single plugin without being locked into only one commerce provider.</p>\n<p>All existing license holders for those four plugins will automatically be granted a license for Event Tickets Plus! We will also continue to support (but not update) the existing Tickets plugins.</p>\n<h3>2. QR codes added to tickets for easy check-in</h3>\n<p>Event Tickets Plus users will have QR codes added to the tickets for simplified check-in at your events. This is the first new feature coming to Event Tickets Plus, but the new year will bring more long desired features! We are encouraging everyone to get transitioned to Event Tickets and Event Tickets Plus as soon as possible to take advantage of new features as we release them.</p>\n<h3>3. Easy color adjustments with the theme customizer</h3>\n<p>With <a href=\"https://theeventscalendar.com/product/wordpress-events-calendar-pro/\">Events Calendar PRO</a> you will now be able to change calendar colors directly within the WordPress theme customizer–no more code snippets needed! We are pretty excited about this and hope you will be too! Check out more info on the <a href=\"https://theeventscalendar.com/knowledgebase/pro-color-customizer/\">PRO Color Customize here</a>.</p>\n<h3>4. New widget: This Week</h3>\n<p>Events Calendar PRO is also bringing a new widget that will show the week&#8217;s events. This was a passion project for one of our developers and you are sure to love it. (This will also be available as a shortcode: tribe_this_week). Find info on <a href=\"https://theeventscalendar.com/knowledgebase/configuring-the-this-week-widget/\">configuring the This Week widget here</a>.</p>\n<h3>5. Additional fields added in PRO are now compatible with Filter Bar</h3>\n<p>Custom additional fields that you create in PRO will now be available to <a href=\"https://theeventscalendar.com/product/wordpress-events-filterbar/\">Filter Bar</a>! This has been a long desired feature that should really amp up your searches.</p>\n<h3>6. Compatibility with Twenty Sixteen theme</h3>\n<p><a href=\"https://wordpress.org/themes/twentysixteen/\">Twenty Sixteen</a> is a gorgeous new base theme that we are proud to be using as our new reference theme.</p>\n<h3>7. Facebook events can now be re-synchronized</h3>\n<p>The <a href=\"https://theeventscalendar.com/product/facebook-events/\">Facebook Events</a> plugin will allow imported events to be re-synchronized with new details from Facebook. This is another long-time requested feature that should help a lot of people.</p>\n<h3>8. A pile of bug fixes and tweaks</h3>\n<p>When I look at the full changelog for this release, I&#8217;m <a href=\"https://www.youtube.com/watch?v=0KveVegHI94\">nervoucited</a>. We have packed a bunch of things in here and one (or more!) of them is sure to delight you.</p>\n<h3>9. New actions</h3>\n<h4 style=\"padding-left: 30px;\">Tribe Common &#8211; available in The Events Calendar and Event Tickets</h4>\n<ul>\n<li><samp>tribe_help_sidebar_before</samp></li>\n<li><samp>tribe_help_sidebar_after</samp></li>\n<li><samp>tribe_help_pre_get_sections</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Facebook actions</h4>\n<ul>\n<li><samp>tribe_events_facebook_event_created</samp></li>\n</ul>\n<h3>10. New filters</h3>\n<h4 style=\"padding-left: 30px;\">The Events Calendar</h4>\n<ul>\n<li><samp>tribe_events_cost_separators</samp></li>\n<li><samp>tribe_events_cost_regex</samp></li>\n<li><samp>tribe_importer_url</samp></li>\n<li><samp>tribe_import_tabs</samp> (deprecated tribe-import-tabs)</li>\n<li><samp>tribe_import_available_options</samp> (deprecated tribe-import-available-options)</li>\n<li><samp>tribe_import_default_post_status_non_saved</samp></li>\n<li><samp>tribe_import_default_post_status</samp></li>\n<li><samp>tribe_import_possible_stati</samp></li>\n<li><samp>tribe_events_category_slug</samp></li>\n<li><samp>tribe_events_tag_slug</samp></li>\n<li><samp>tribe_events_excerpt_allowed_html</samp></li>\n<li><samp>tribe_events_excerpt_allow_shortcode</samp></li>\n<li><samp>tribe_import_general_settings</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Tribe Common &#8211; available in The Events Calendar and Event Tickets</h4>\n<ul>\n<li><samp>tribe_beginning_of_day</samp></li>\n<li><samp>tribe_common_event_page_capability</samp></li>\n<li><samp>tribe_currency_symbol</samp></li>\n<li><samp>tribe_formatted_date</samp></li>\n<li><samp>tribe_help_addons</samp></li>\n<li><samp>tribe_help_api_data</samp></li>\n<li><samp>tribe_help_api_data_timeout</samp></li>\n<li><samp>tribe_help_available_section_types</samp></li>\n<li><samp>tribe_help_must_escape_fields</samp></li>\n<li><samp>tribe_help_plugins</samp></li>\n<li><samp>tribe_help_rss_max_items</samp></li>\n<li><samp>tribe_help_section_</samp></li>\n<li><samp>tribe_help_sections</samp></li>\n<li><samp>tribe_help_sections_html</samp></li>\n<li><samp>tribe_is_post_type_screen_post_types</samp></li>\n<li><samp>tribe_post_types</samp></li>\n<li><samp>tribe_resource_url</samp></li>\n<li><samp>tribe_reverse_currency_position</samp></li>\n<li><samp>tribe_settings_date_preview_fields</samp></li>\n<li><samp>tribe_the_notices</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">PRO</h4>\n<ul>\n<li><samp>tribe_google_data_markup_json</samp></li>\n<li><samp>tribe_enable_default_value_replace_checkbox</samp></li>\n<li><samp>tribe_this_week_widget_class</samp></li>\n<li><samp>tribe_events_pro_multichoice_field_types</samp></li>\n<li><samp>tribe_events_pro_field_is_multichoice</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Community</h4>\n<ul>\n<li><samp>tribe_ce_i18n_page_titles</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Eventbrite</h4>\n<ul>\n<li><samp>tribe_eb_push_image</samp></li>\n<li><samp>tribe_eb_pull_image</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Filterbar</h4>\n<ul>\n<li><samp>tribe_events_filter_taxonomy_relationship</samp></li>\n<li><samp>tribe_events_filter_nest_taxonomy_queries</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">iCal Importer</h4>\n<ul>\n<li><samp>tribe_events_ical_importer_support_recurrence</samp></li>\n</ul>\n<h3>11. There is newly deprecated code</h3>\n<p>We have reorganized a lot of code in this release, which in turn has led us to deprecate a lot of functions. They will all continue to work (just with notices in your logs) and have really simple substitution functions if you want to bring your customizations up to the latest.</p>\n<h4 id=\"core\" style=\"padding-left: 30px;\">The Events Calendar 4.0</h4>\n<ul>\n<li><strong>Deprecated</strong> &#8211; The Tribe__Events__Main::defaultValueReplaceEnabled() method is being deprecated in favor of tribe_get_option(&#8216;defaultValueReplace&#8217;). Schedules for removal in v4.5</li>\n<li><strong>Deprecated</strong> &#8211; The tribe_event_link() has been deprecated in favor of tribe_get_event_link(). Scheduled for removal in 5.0</li>\n<li><strong>Deprecated</strong> &#8211; The third parameter of tribe_get_organizer_link() (the $echo parameter) has been deprecated and is scheduled for removal in 5.0</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Abstract_Deactivation in favor of Tribe__Abstract_Deactivation</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Admin__Helpers in favor of Tribe__Admin__Helpers</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__App_Shop in favor of Tribe__App_Shop</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Autoloader in favor of Tribe__Autoloader</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Cache in favor of Tribe__Cache</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Cache_Listener in favor of Tribe__Cache_Listener</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Changelog_Reader in favor of Tribe__Changelog_Reader</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Credits in favor of Tribe__Credits</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Date_Utils in favor of Tribe__Date_Utils</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Field in favor of Tribe__Field</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Settings in favor of Tribe__Settings</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Settings_Tab in favor of Tribe__Settings_Tab</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Support in favor of Tribe__Support</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Template_Part_Cache in favor of Tribe__Template_Part_Cache</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Attendees_Table in favor of Tribe__Tickets__Attendees_Table in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Metabox in favor of Tribe__Tickets__Metabox in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Ticket_Object in favor of Tribe__Tickets__Ticket_Object in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Tickets in favor of Tribe__Tickets__Tickets in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Tickets__Tickets_Pro in favor of Tribe__Tickets__Tickets_Handler in the event-tickets plugin</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Validate in favor of Tribe__Validate</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__View_Helpers in favor of Tribe__View_Helpers</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::OPTIONNAME in favor of Tribe__Main::OPTIONNAME</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::OPTIONNAMENETWORK in favor of Tribe__Main::OPTIONNAMENETWORK</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::addHelpAdminMenuItem() in favor of Tribe__Settings_Manager::add_help_admin_menu_item()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::addNetworkOptionsPage() in favor of Tribe__Settings_Manager::add_network_options_page()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::array_insert_after_key() in favor of Tribe__Main::array_insert_after_key()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::array_insert_before_key() in favor of Tribe__Main::array_insert_before_key()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::debug() in favor of Tribe__Debug::debug()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::defaultValueReplaceEnabled() in favor of tribe_get_option( &#8216;defaultValueReplace&#8217; )</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::doHelpTab() in favor of Tribe__Settings_Manager::do_help_tab()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::doNetworkSettingTab() in favor of Tribe__Settings_Manager::do_network_settings_tab()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::doSettingTabs() in favor of Tribe__Settings_Manager::do_setting_tabs()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::do_licenses_tab() in favor of Tribe__Settings_Manager::do_licenses_tab()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getNetworkOption() in favor of Tribe__Settings_Manager::get_network_option()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getNetworkOptions() in favor of Tribe__Settings_Manager::get_network_options()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getNotices() in favor of Tribe__Notices::get()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getOption() in favor of Tribe__Settings_Manager::get_option()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::getOptions() in favor of Tribe__Settings_Manager::get_options()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::have_addons() in favor of Tribe__Settings_Manager::have_addons()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::isNotice() in favor of Tribe__Notices::is_notice()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::pluginDir in favor of Tribe__Events__Main::plugin_dir</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::pluginName in favor of Tribe__Events__Main::plugin_name</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::pluginPath in favor of Tribe__Events__Main::plugin_path</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::pluginUrl in favor of Tribe__Events__Main::plugin_url</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::removeNotice() in favor of Tribe__Notices::remove_notice()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::renderDebug() in favor of Tribe__Debug::render()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::saveAllTabsHidden() in favor of Tribe__Settings_Manager::save_all_tabs_hidden()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::setNetworkOptions() in favor of Tribe__Settings_Manager::set_network_options()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::setNotice() in favor of Tribe__Notices::set_notice()</li>\n<li><strong>Deprecated</strong> &#8211; Tribe__Events__Main::truncate() in favor of tribe_events_get_the_excerpt()</li>\n<li><strong>Deprecated</strong> &#8211; tribe_event_beginning_of_day() in favor of tribe_beginning_of_day()</li>\n<li><strong>Deprecated</strong> &#8211; tribe_event_end_of_day() in favor of tribe_end_of_day()</li>\n<li><strong>Deprecated</strong> &#8211; tribe_event_format_date() in favor of tribe_format_date()</li>\n<li><strong>Deprecated</strong> &#8211; tribe_events_the_notices() in favor of tribe_the_notices()</li>\n</ul>\n<h4 id=\"pro\" style=\"padding-left: 30px;\">The Events Calendar PRO 4.0</h4>\n<ul>\n<li><strong>Deprecated</strong> &#8211; Deprecating the &#8220;defaultValueReplace&#8221; option in the Default Content settings tab</li>\n</ul>\n<h3>12. Updated Views</h3>\n<h4 style=\"padding-left: 30px;\">The Events Calendar</h4>\n<ul>\n<li><samp>src/views/day/content.php</samp></li>\n<li><samp>src/views/day/loop.php</samp></li>\n<li><samp>src/views/day/single-event.php</samp></li>\n<li><samp>src/views/list/content.php</samp></li>\n<li><samp>src/views/list/loop.php</samp></li>\n<li><samp>src/views/list/nav.php</samp></li>\n<li><samp>src/views/list/single-event.php</samp></li>\n<li><samp>src/views/modules/address.php</samp></li>\n<li><samp>src/views/modules/bar.php</samp></li>\n<li><samp>src/views/modules/meta/details.php</samp></li>\n<li><samp>src/views/modules/meta/organizer.php</samp></li>\n<li><samp>src/views/modules/meta/venue.php</samp></li>\n<li><samp>src/views/month.php</samp></li>\n<li><samp>src/views/month/content.php</samp></li>\n<li><samp>src/views/month/loop-grid.php</samp></li>\n<li><samp>src/views/month/mobile.php</samp></li>\n<li><samp>src/views/month/single-day.php</samp></li>\n<li><samp>src/views/month/single-event.php</samp></li>\n<li><samp>src/views/month/tooltip.php</samp></li>\n<li><samp>src/views/single-event.php</samp></li>\n<li><samp>src/views/tickets/attendees-email.php</samp> &#8211; moved to event-tickets</li>\n<li><samp>src/views/tickets/email.php</samp> &#8211; moved to event-tickets</li>\n<li><samp>src/views/widgets/list-widget.php</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">PRO</h4>\n<ul>\n<li><samp>src/views/pro/map/content.php</samp></li>\n<li><samp>src/views/pro/map/loop.php</samp></li>\n<li><samp>src/views/pro/map/single-event.php</samp></li>\n<li><samp>src/views/pro/modules/meta/additional-fields.php</samp></li>\n<li><samp>src/views/pro/photo/content.php</samp></li>\n<li><samp>src/views/pro/photo/loop.php</samp></li>\n<li><samp>src/views/pro/photo/single-event.php</samp></li>\n<li><samp>src/views/pro/related-events.php</samp></li>\n<li><samp>src/views/pro/single-organizer.php</samp></li>\n<li><samp>src/views/pro/single-venue.php</samp></li>\n<li><samp>src/views/pro/week/content.php</samp></li>\n<li><samp>src/views/pro/week/loop-grid.php</samp></li>\n<li><samp>src/views/pro/week/mobile.php</samp></li>\n<li><samp>src/views/pro/week/single-event.php</samp></li>\n<li><samp>src/views/pro/week/tooltip.php</samp></li>\n<li><samp>src/views/pro/widgets/list-widget.php</samp></li>\n<li><samp>src/views/pro/widgets/mini-calendar/grid.php</samp></li>\n<li><samp>src/views/pro/widgets/mini-calendar/list.php</samp></li>\n<li><samp>src/views/pro/widgets/mini-calendar/single-day.php</samp></li>\n<li><samp>src/views/pro/widgets/modules/single-event.php</samp></li>\n<li><samp>src/views/pro/widgets/venue-widget.php</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Community Events</h4>\n<ul>\n<li><samp>src/views/community/event-list.php</samp></li>\n<li><samp>src/views/community/modules/cost.php</samp></li>\n<li><samp>src/views/community/modules/venue.php</samp></li>\n<li><samp>src/views/community/modules/website.php</samp> *</li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Community Tickets</h4>\n<ul>\n<li><samp>src/views/community-tickets/modules/tickets.php</samp> *</li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Eventbrite</h4>\n<ul>\n<li><samp>src/views/eventbrite/eventbrite-meta-box-extension.php</samp></li>\n<li><samp>src/views/eventbrite/import-eventbrite-events.php</samp></li>\n<li><samp>src/views/eventbrite/options.php</samp> &#8211; deleted</li>\n</ul>\n<h4 style=\"padding-left: 30px;\">iCal Importer</h4>\n<ul>\n<li><samp>src/views/edit-saved-recurring.php</samp></li>\n<li><samp>src/views/import-form.php</samp></li>\n<li><samp>src/views/one-time-buttons.php</samp></li>\n<li><samp>src/views/recurring-buttons.php</samp></li>\n<li><samp>src/views/saved-imports-table.php</samp></li>\n<li><samp>src/views/status-category-selector.php</samp></li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Event Tickets</h4>\n<ul>\n<li><samp>src/views/attendees-email.php</samp> &#8211; moved here from The Events Calendar</li>\n<li><samp>src/views/email.php</samp> &#8211; moved here from The Events Calendar</li>\n</ul>\n<h4 style=\"padding-left: 30px;\">Event Tickets Plus</h4>\n<ul>\n<li><samp>src/views/eddtickets/tickets.php</samp> &#8211; moved here from EDD Tickets and altered</li>\n<li><samp>src/views/shopptickets/tickets.php</samp> &#8211; moved here from Shopp Tickets and altered</li>\n<li><samp>src/views/wootickets/tickets.php</samp> &#8211; moved here from WooTickets and altered</li>\n<li><samp>src/views/wpectickets/tickets.php</samp> &#8211; moved here from WPEC Tickets and altered</li>\n</ul>\n<p>Pretty good stuff, right? We hope you&#8217;re as psyched about these updates as we are!</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/things-to-be-aware-of-in-version-4-0/\">Things to be aware of in version 4.0 of The Events Calendar, The Events Calendar PRO + all add-ons</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://theeventscalendar.com/things-to-be-aware-of-in-version-4-0/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:51:\"Event Planning: Defining Event Goals and Objectives\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:66:\"https://theeventscalendar.com/defining-event-goals-and-objectives/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:75:\"https://theeventscalendar.com/defining-event-goals-and-objectives/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Dec 2015 14:30:20 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:8:\"Articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:14:\"event planning\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:6:\"events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:10:\"objectives\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1019149\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:568:\"<p>No one likes to spin their wheels or leave money on the table, which is why the first step in planning an event is defining your event goals and objectives. When you add up all the events our users host using The Events Calendar and Events Calendar PRO each year, the numbers reach well into&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/defining-event-goals-and-objectives/\">Event Planning: Defining Event Goals and Objectives</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jen Jamar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4952:\"<p>No one likes to spin their wheels or leave money on the table, which is why the first step in planning an event is defining your event goals and objectives.</p>\n<p>When you add up all the events our users host using <a href=\"https://theeventscalendar.com/product/wordpress-events-calendar/\">The Events Calendar</a> and <a href=\"https://theeventscalendar.com/product/wordpress-events-calendar-pro/\">Events Calendar PRO</a> each year, the numbers reach well into the millions. The most successful ones we see (and the ones that sell the most tickets) all have the same thing in common &#8211; they&#8217;re very clear on their event goals and objectives.</p>\n<p>Good event planning means you know up front what you’re trying to accomplish. Otherwise, why have the event in the first place? Clearly defined goals and objectives help keep you on target throughout the event planning process. They also help you avoid wasting resources, since every decision involving time and money for your event can be related back to your guiding purpose.</p>\n<h2>Event Goals &amp; Objectives</h2>\n<p>Think of your goals as your event’s purpose. Your purpose is the big picture reason your event exists &#8211; where you want to be vs where you are now. Event goals are the reason your event exists &#8211; to inform, to include, to celebrate, to persuade, etc… If your company is a university with the goal of wooing new incoming freshman to apply, your event purpose might be to educate potential applicants about your program offerings and campus vibe.</p>\n<p>Your objectives are the roadmap to achieving those goal(s). Objectives should be written in detail, defining the narrow, measurable, and tangible results your event will produce.</p>\n<h3>What&#8217;s *Not* a Good Event Objective?</h3>\n<p>Goodwill is a term that gets thrown around a lot when it comes to event goals &amp; objectives. Why are you hosting this big party? To create goodwill with our clients, of course!</p>\n<p>Nope. Don’t do that. That’s taking the easy route and it won’t help you plan a great event. Does creating goodwill with clients relate to your company’s goals? Maybe. But we’re going to go out on a limb that your real goal is something along the lines of increasing sales or customer retention.</p>\n<p>Another example is giving back to the community. That’s a fantastic idea, but you still need to figure out how that relates to your organization’s goals. Once you know your purpose and how it relates to your company’s goals, you can begin to develop consistent messaging related to the event.</p>\n<h3>SMART Objectives Are, Well&#8230;Smart</h3>\n<p>You’ve probably heard of SMART goals before. For the purpose of event planning, we’re going to talk about SMART objectives instead of SMART goals. Remember, our event goals are our “pie in the sky” purpose for hosting the event. Our objectives are how we get there.</p>\n<p>Event goals should be:</p>\n<p><strong>S &#8211; Specific:</strong> What outcome, by when. For example, enrolling 30% of visiting high school students for the 2016 semester by July 15th.</p>\n<p><strong>M &#8211; Measurable:</strong> How much &#8211; the hard numbers we can measure, such as 100 students visited our campus and 30 of them enrolled in fall classes.</p>\n<p><strong>A &#8211; Achievable:</strong> Not only is the objective achievable, we’re also relatively likely to accomplish it. This isn&#8217;t a stretch incentive on Kickstarter, after all. This is an objective we&#8217;re confident telling our boss we can achieve.</p>\n<p><strong>R &#8211; Relevant:</strong> The objective relates back to our company’s goals. If it doesn&#8217;t, it isn&#8217;t our objective anymore.</p>\n<p><strong>T &#8211; Time-bound:</strong> Timebound means we can create a timeline that defines the beginning and the end of the period in which we are measuring. There&#8217;s a start and stop point, and we can measure the change between the two.</p>\n<p>Smart objectives that relate back to your organization&#8217;s goals will stick with you throughout your entire event planning process. Once you have buy-in from the top down, these event goals and objectives will guide your entire process from venue selection through your post-event survey questions.</p>\n<p>When you have well-defined goals and objectives for your event, planning, promoting, and sticking to your budget all become much easier. Messaging aligned with those goals comes through loud and clear, increasing attendee interest, RSVPs, and <a href=\"https://theeventscalendar.com/tickets/\">ticket sales</a>.</p>\n<p>A WordPress calendar full of events like this? That&#8217;s a beautiful thing.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/defining-event-goals-and-objectives/\">Event Planning: Defining Event Goals and Objectives</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://theeventscalendar.com/defining-event-goals-and-objectives/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"Giving Thanks and Giving Back\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:60:\"https://theeventscalendar.com/giving-thanks-and-giving-back/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"https://theeventscalendar.com/giving-thanks-and-giving-back/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 25 Nov 2015 14:30:15 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:8:\"Articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:9:\"community\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"WordCamp\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:9:\"WordPress\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1030423\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:561:\"<p>We&#8217;ve got a lot to be thankful for here at Modern Tribe, so we wanted to take a moment to publicly share appreciation for our team, our users, and the WordPress community at large. It&#8217;s been a hell of a journey, and we&#8217;ve worked hard to pay things forward along the way. Giving Thanks 2015 was&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/giving-thanks-and-giving-back/\">Giving Thanks and Giving Back</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jen Jamar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5391:\"<p>We&#8217;ve got a lot to be thankful for here at <a href=\"http://tri.be/about/\" target=\"_blank\">Modern Tribe</a>, so we wanted to take a moment to publicly share appreciation for our team, our users, and the WordPress community at large. It&#8217;s been a hell of a journey, and we&#8217;ve worked hard to pay things forward along the way.</p>\n<h2>Giving Thanks</h2>\n<p>2015 was a big year for us.</p>\n<p><a href=\"https://theeventscalendar.com/2-million-downloads-the-events-calendar/\">We surpassed 2 million downloads</a> of The Events Calendar and continue to serve over 300,000 active users.  Our incredible support team has helped answer over 8,000 questions through our premium support forums, plus assisted with resolving another 2,000+ tickets in the WordPress.org forums.</p>\n<p>We&#8217;re incredibly thankful to <a href=\"https://theeventscalendar.com/the-team/\">our team members</a>. They are Tribe. Their multitude of talents and dedication to quality is the backbone of our reputation.</p>\n<p>We&#8217;re also thankful for our community. You guys support us, challenge us, and push us to continuously innovate and improve. Without you, we wouldn&#8217;t be where we are today, and for that, we are deeply appreciative.</p>\n<h2>Giving Back</h2>\n<p>For us, a big part of participating in the WordPress community is giving back. Not just during special holidays, but continuously throughout the year.</p>\n<p>Helping out organizations that help others has been one of our focuses this year. We&#8217;re proud to share that to date, we&#8217;ve donated over $200,000 in plugin licenses through our <a href=\"https://theeventscalendar.com/apply-for-nppp/\">Non-Profit Partnership Program</a>.</p>\n<p>Like most top WordPress agencies, we encourage and support our team&#8217;s efforts to contribute to the community on a personal level. Throughout 2015, they have spent countless hours volunteering, contributing to core, releasing free plugins, speaking at WordCamps or meetups, and getting involved in other ways.</p>\n<p>Recognition is important to us, so we want to take a moment to call out some of their individual contributions to the community:</p>\n<p>-Zach &amp; Matt released <a href=\"https://wordpress.org/plugins/headlineenvy/\" target=\"_blank\">HeadlineEnvy</a>, an A/B headline testing plugin that integrates with Optimizely.</p>\n<p>-Nico volunteered for <a href=\"https://buenosaires.wordcamp.org/2015/\" target=\"_blank\">WordCamp Buenos Aires</a>, the first official WordPress event to be held in that location in the past 5 years.</p>\n<p>-Gustavo helped organize <a href=\"https://riodejaneiro.wordcamp.org/\" target=\"_blank\">WordCamp Rio de Janeiro</a> and <a href=\"https://riodejaneiro.wordcamp.org/2015/speaker/gustavo-bordoni/\" target=\"_blank\">spoke there</a>. He was also a speaker at <a href=\"https://belohorizonte.wordcamp.org/2015/tabela-de-programacao/\" target=\"_blank\">WordCamp Belo Horizonte</a>. His core contributions to WordPress this year include tickets <a href=\"https://core.trac.wordpress.org/ticket/28529\" target=\"_blank\">28529</a>, <a href=\"https://core.trac.wordpress.org/ticket/34594\" target=\"_blank\">34594</a>, &amp; <a href=\"https://core.trac.wordpress.org/ticket/34607\" target=\"_blank\">34607</a>, as well as meta contribution <a href=\"https://meta.trac.wordpress.org/ticket/1386\" target=\"_blank\">ticket 1386</a>.</p>\n<p>-Jonathan gave a few WordCamp talks this year, including &#8220;<a href=\"http://wordpress.tv/2015/06/19/jonathan-brinley-build-your-dev-environment-with-docker/\" target=\"_blank\">Build Your Dev Environment With Docker</a>&#8221; at WordCamp Miami, &#8220;<a href=\"http://flightless.us/slides/tampa-2015/\" target=\"_blank\">Smaller, Faster PHP: An Introduction to Backend Performance Optimization</a>&#8221; at WordCamp Tampa, and &#8220;<a href=\"http://flightless.us/slides/orlando-2015/\" target=\"_blank\">Defense Against the Dark Arts: Writing Secure WordPress Plugins and Themes</a>&#8221; at WordCamp Orlando.</p>\n<p>-Peter &amp; Rob both spoke at the inaugural WordCamp Sacramento. Peter&#8217;s talk centered on <a href=\"http://www.slideshare.net/peterchester/coding-together-a-dev-workflow\" target=\"_blank\">Coding With A Team</a>, while Rob&#8217;s presentation later in the day covered <a href=\"http://www.slideshare.net/robattribe/the-art-of-replying-to-reviews-on-wordpressorg-wordcamp-sacramento-2015\" target=\"_blank\">The Art of Replying to Reviews on WordPress.org</a>.</p>\n<p>-Reid gave his take on <a href=\"http://wordpress.tv/2015/10/26/reid-peifer-reimagining-content-creation/\" target=\"_blank\">Reimaging Content Creation</a> at WordCamp Vancouver.</p>\n<p>There were many other contributions made by our team members to WordPress that we haven&#8217;t listed, but are no less important or deserving of recognition (they just didn&#8217;t necessarily want to be called out in a blog post, which we totally respect).</p>\n<p>Like we said at the beginning, we have a lot to be thankful for. We&#8217;re thankful for our success. And we&#8217;re thankful for the ability to give back to the WordPress community that supports us, both as a company and as individual members of Tribe.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/giving-thanks-and-giving-back/\">Giving Thanks and Giving Back</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://theeventscalendar.com/giving-thanks-and-giving-back/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:54:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"Community Tickets: Sell Tickets Online Through Your Community Calendar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:100:\"https://theeventscalendar.com/community-tickets-sell-tickets-online-through-your-community-calendar/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:109:\"https://theeventscalendar.com/community-tickets-sell-tickets-online-through-your-community-calendar/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Mon, 23 Nov 2015 13:47:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:8:\"Articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:16:\"Community Events\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:17:\"Community Tickets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:7:\"tickets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:19:\"WooCommerce Tickets\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1028162\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:678:\"<p>Our latest product, Community Tickets, adds a layer of awesomeness to your events calendar by enabling event organizers to sell tickets online from the front end of your website. That’s right &#8211; they never have to touch your dashboard. Community Tickets: Layers of Functionality The easiest way to explain the benefit of Community Tickets is&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/community-tickets-sell-tickets-online-through-your-community-calendar/\">Community Tickets: Sell Tickets Online Through Your Community Calendar</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"Jen Jamar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4756:\"<p>Our latest product, Community Tickets, adds a layer of awesomeness to your events calendar by enabling event organizers to sell tickets online from the front end of your website.</p>\n<p>That’s right &#8211; they never have to touch your dashboard.</p>\n<h2>Community Tickets: Layers of Functionality</h2>\n<p>The easiest way to explain the benefit of Community Tickets is by treating each of our premium plugins as a layer over our core product: <a href=\"https://theeventscalendar.com/product/wordpress-events-calendar/\">The Events Calendar</a>.</p>\n<h3>Start With The Events Calendar</h3>\n<p>Our flagship plugin gives you the ability to create events through the back end of your site and display them through a gorgeous calendar on the front end. With The Events Calendar, we include all the basics you need, without dragging down your site with options you don&#8217;t. Of course, if you need additional views, recurring events, advanced widgets, we also have <a href=\"https://theeventscalendar.com/product/wordpress-events-calendar-pro/\">our PRO version</a> available.</p>\n<p>For many site owners, they&#8217;re golden just running The Events Calendar or Events Calendar PRO.</p>\n<p>But your site is different. You have events listed on your calendar that are designed to generate revenue, so you want to be able to sell tickets online without going through a 3rd party ticketing agent.</p>\n<p>We can help you with that.</p>\n<h3>Layer #1: WooCommerce Tickets</h3>\n<p>Enter your first layer: <a href=\"https://theeventscalendar.com/tickets/\">WooCommerce Tickets</a>.</p>\n<p>Boom.</p>\n<p>Now you can sell tickets online directly from your event page without having to send visitors off to a 3rd party site.</p>\n<p>But hold up &#8211; that’s not the only thing you want your calendar to do.</p>\n<p>In addition to your own events, you also want other people to be able to add their events to your site’s calendar. Maybe you’re a school and you want each department to manage their own events. Or a real estate office with many agents that need to be able to list all of their upcoming open houses. Or you run an interest group and want people to contribute to your community calendar. Basically, any scenario where you want user-generated events to be added to your calendar without them needing access to your admin.</p>\n<p>Time to add another layer.</p>\n<h3>Layer #2: Community Events</h3>\n<p><a href=\"https://theeventscalendar.com/product/wordpress-community-events/\">Community Events</a> gives you the ability to accept front end submissions from users without giving them access to your dashboard. They input all the info for each event, then submit the event for addition to your calendar. (<a href=\"http://wpshindig.com/events/\" target=\"_blank\">You can see this in action on our demo site.</a>)</p>\n<p>But wait. Some of the events people are adding have a ticket fee associated with them. Wouldn’t it be cool if we could allow those people to sell tickets to THEIR event on OUR website?</p>\n<p>That’s where our final layer comes into play.</p>\n<h3>Layer #3: Community Tickets</h3>\n<p><a href=\"https://theeventscalendar.com/product/community-tickets/\">Community Tickets</a> harnesses the power of Community Events and WooCommerce Tickets, plus adds functionality to create an interactive calendar that enables event organizers to post their own events, create tickets for those events, and receive payments for ticket sales. Organizers even have access to basic ticket sales reporting &#8211; all without touching your WordPress admin dashboard.</p>\n<p>Best of all, as the site owner, you can decide if you want to charge a fee or split the ticket sale revenue with the event organizers. Community Tickets doesn&#8217;t just allow you to sell tickets online through your community calendar &#8211; it also opens up a whole new revenue model for your WordPress site.</p>\n<h3>Community Tickets: A Trifecta of WordPress Ticketing Functionality</h3>\n<p>Check out our demo video and let us know what you think. We can’t wait to hear how you’re using <a href=\"https://theeventscalendar.com/product/community-tickets/\">Community Tickets</a> to increase ticket sales and increase revenue on your WordPress site.</p>\n<p><iframe src=\"https://player.vimeo.com/video/144653641\" width=\"500\" height=\"281\" frameborder=\"0\" title=\"Community Tickets: An Overview\" webkitallowfullscreen mozallowfullscreen allowfullscreen></iframe></p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/community-tickets-sell-tickets-online-through-your-community-calendar/\">Community Tickets: Sell Tickets Online Through Your Community Calendar</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:105:\"https://theeventscalendar.com/community-tickets-sell-tickets-online-through-your-community-calendar/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:51:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:19:\"Lost in Translation\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://theeventscalendar.com/lost-in-translation/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"https://theeventscalendar.com/lost-in-translation/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 20 Nov 2015 14:30:06 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:4:{i:0;a:5:{s:4:\"data\";s:4:\"News\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:19:\"The Events Calendar\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:12:\"translations\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:13:\"wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1012849\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:619:\"<p>In July, we announced that we were moving all our translations to GlotPress&#8211; a big step towards improving our localization and empowering our international users. Last month, we followed the WordPress community&#8217;s lead and moved the translations for our free plugin, The Events Calendar, to translate.wordpress.org. We realize that two moves in the span of a few months could&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/lost-in-translation/\">Lost in Translation</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"Leah\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5967:\"<p>In July, <a href=\"https://theeventscalendar.com/moving-to-glotpress/\">we announced</a> that we were moving all our translations to <a href=\"http://translations.theeventscalendar.com/projects\">GlotPress</a>&#8211; a big step towards improving our localization and empowering our international users. Last month, we followed the WordPress community&#8217;s lead and moved the translations for our free plugin, The Events Calendar, to <a href=\"https://translate.wordpress.org/\">translate.wordpress.org</a>.</p>\n<p>We realize that two moves in the span of a few months could be frustrating or confusing for our users. So we wanted to take some time to explain what went into this decision and what it means for the future.</p>\n<h3>2015: The Year of the Translation</h3>\n<p>Since we planned our roadmap last year, we knew we wanted to prioritize localization features during our 2015 development work. More and more of our users are outside of North America, and we wanted to respond to that change in demographic. With that in mind, we added time zone support and <a href=\"https://theeventscalendar.com/what-weve-learned-from-integrating-with-wpml/\">improved compatibility with WPML</a>.</p>\n<p>The biggest change for the team was our move to GlotPress for managing plugin translations. Previously, we&#8217;d accepted translations from volunteers via our forum, and then (after testing the submissions) manually added the new files to each plugin&#8217;s /lang folder, to be available in the next release.</p>\n<p>As the number of people using translations grew, it became clear that we needed a system that was easier for both our team and our users. GlotPress is the perfect solution- it gave us a centralized place for all our translations and made it easier for volunteers to contribute, whether a single string update or a new full translation. We deputized several of our long-time translators as validators, which meant that we had native speakers approving new translations. Additionally, it became easier for folks to download the very latest translations, without having to wait for the next release. Perhaps best of all, all of our translations were organized on the nifty new <a href=\"http://translations.theeventscalendar.com\">translations.theeventscalendar.com</a>.</p>\n<h3>WordPress.org announces language packs for plugins</h3>\n<p>After several months of enjoying our new GlotPress site, <a href=\"https://make.wordpress.org/plugins/2015/09/01/plugin-translations-on-wordpress-org/\">WordPress.org announced</a> that they were extending their language pack service to WP plugins. This service is also run using GlotPress, but with translations for all plugins gathered at <a href=\"https://translate.wordpress.org/\">translate.wordpress.org</a>.</p>\n<p>Managing the translations for The Events Calendar via translate.wordpress.org means enjoying many of the same handy features from our original GlotPress site. Users can make and update translations via their browser, and translations are easily downloadable.</p>\n<p>However, some aspects of this system are not so advantageous for our users. For one, using this new system separates the translations for our core plugin (The Events Calendar) from our premium plugins (Events Calendar PRO, Community Events, etc.). While WordPress.org&#8217;s system is meant to be used by all <em>free</em> WP plugins, it&#8217;s extremely unlikely to ever include premium plugins. Thus, premium users will need to download translations from two different places in order to get a fully translated site.</p>\n<p>The other disadvantage to moving the TEC translations is that our team is no longer able to approve submitted strings. With our original GlotPress set-up, members of our support team or one of our approved validators could approve a new or updated string within the plugin. We reviewed submitted changes regularly so translators didn&#8217;t have to wait long to see their work added to the official translation.</p>\n<p>With the WordPress.org-based system, only official Translation Editors can approve strings. This means that when one of our users submits a change, we are not able to review or approve it. The user must wait until a Translation Editor from their language&#8217;s <a href=\"https://make.wordpress.org/polyglots/handbook/about/teams/\">WordPress.org translation team</a> can approve the change.</p>\n<h3>Tough Choices</h3>\n<p>We strive to make our plugin straightforward to use, while still being full of great features. We liked having a simple, centralized translation site and being able to quickly approve submitted translation changes. However, we also want to be an upstanding member of the WordPress community. This is the way that WP translations are moving, and we want to adapt alongside.</p>\n<p>Ultimately we decided to move the translations for The Events Calendar to the new set up at <a href=\"https://translate.wordpress.org/\">translate.wordpress.org</a>. We rolled out a new <a href=\"https://theeventscalendar.com/knowledgebase/translating-the-events-calendar/\">knowledgebase article</a> to help guide users to the new location for TEC translations and (hopefully) prevent confusion over the two translation systems. This blog post will hopefully provide transparency and explanation for all the recent changes.</p>\n<p>We&#8217;d like to extend a heartfelt thank you to all of our translators who have helped us make our Events plugins available to a wider world of users. And thank you to the hard working folks at WordPress.org for their work to improve and expand our favorite open-source platform. We will continue our efforts to add value and compatibility to our plugins- and keep our users informed of our decisions along the way.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/lost-in-translation/\">Lost in Translation</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:55:\"https://theeventscalendar.com/lost-in-translation/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"4.0 Release Candidate is now available for testing\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:81:\"https://theeventscalendar.com/4-0-release-candidate-is-now-available-for-testing/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:90:\"https://theeventscalendar.com/4-0-release-candidate-is-now-available-for-testing/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Nov 2015 23:56:23 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Release Notes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1027765\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:646:\"<p>We&#8217;ve been hard at work on getting The Events Calendar 4.0 in your hands. A lot of progress has been made—so much, that we&#8217;re happy to announce that a release candidate is now available! (What, you didn&#8217;t know about 4.0? Here&#8217;s a preview.) You&#8217;re in for a real treat. We&#8217;ve packed in a slew of new features we are&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/4-0-release-candidate-is-now-available-for-testing/\">4.0 Release Candidate is now available for testing</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Geoff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1867:\"<p>We&#8217;ve been hard at work on getting <strong>The Events Calendar 4.0</strong> in your hands. A lot of progress has been made—so much, that we&#8217;re happy to announce that a <strong>release candidate is now available!</strong></p>\n<p>(What, you didn&#8217;t know about 4.0? <a href=\"https://theeventscalendar.com/some-favorite-features-in-the-upcoming-4-0-release/\">Here&#8217;s a preview.</a>)</p>\n<p>You&#8217;re in for a real treat. We&#8217;ve packed in a slew of new features we are really proud of and can&#8217;t wait to show you. We&#8217;re making this release candidate available now for the sake of testing and getting a feel for what&#8217;s fresh in 4.0 and prepare for any possible impact it may have on your site. The Events Calendar is super extendable and we know many of you have customized the plugin, so this early access will help you and your team test things out in a safe environment before pushing everything to production. Safety first!</p>\n<p>The release candidate is available to all premium license holders. And, yes, this includes release candidates for all of our premium plugins as well. In fact, you can snag them all by logging into this site and heading to <strong>My Account → Downloads</strong>. The downloaded ZIP files can be uploaded to your site like any other plugin and tested from there.</p>\n<p>Please enjoy the sneak peak responsibly! In other words, we would suggest installing the updates in a test environment and only after you&#8217;ve throughly backed up your site as you would with any other WordPress update.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/4-0-release-candidate-is-now-available-for-testing/\">4.0 Release Candidate is now available for testing</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:86:\"https://theeventscalendar.com/4-0-release-candidate-is-now-available-for-testing/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:54:\"\n		\n		\n		\n		\n		\n				\n		\n		\n		\n		\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"The Importance of User Feedback\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:62:\"https://theeventscalendar.com/the-importance-of-user-feedback/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://theeventscalendar.com/the-importance-of-user-feedback/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 18 Nov 2015 14:30:22 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:5:{i:0;a:5:{s:4:\"data\";s:8:\"Articles\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:1;a:5:{s:4:\"data\";s:8:\"comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:2;a:5:{s:4:\"data\";s:8:\"feedback\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:3;a:5:{s:4:\"data\";s:7:\"reviews\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}i:4;a:5:{s:4:\"data\";s:15:\"user experience\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1025437\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:628:\"<p>One of the most valuable contributions to any piece of software is user feedback. We love the extremely open communication in our community, and we work hard to utilize the feedback it provides. We receive over 500 comments, emails, and forum posts every week- and many of them contain feedback on the calendar. There are even more votes each week on feature requests&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/the-importance-of-user-feedback/\">The Importance of User Feedback</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Brook\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5188:\"<p>One of the most valuable contributions to any piece of software is user feedback. We love the extremely open communication in our community, and we work hard to utilize the feedback it provides. We receive over 500 comments, emails, and forum posts every week- and many of them contain feedback on the calendar. There are even more votes each week on <a href=\"https://tribe.uservoice.com/forums/195723-feature-ideas\">feature requests in our UserVoice tracker</a>.</p>\n<p>If you are one of the countless folks who has provided feedback, we first of all want to say: Thank you!! We also want to use this article to explain what we do with your feedback, how we measure it, and how we act on it.</p>\n<p>There are two major categories of user feedback: bug reports and feature requests. We are going to dive further into both of these.</p>\n<h3 id=\"bug-reports\">Bug Reports</h3>\n<p>Once a bug is reported and confirmed, we then log it in our internal issue tracker. Each bug is given a priority based on how much it impacts the average site.</p>\n<p>However, the priority that we first give those bugs is subject to change; and that&#8217;s where you come in. Each comment we receive that describes a similar issue is noted and logged. We use these logs to reprioritize things as needed. The more users who chime in, the higher we prioritize something. Some comments detail use-cases and scenarios in which the bug might be more severe than usual, and we factor that in as well.</p>\n<h3 id=\"feature-requests\">Feature Requests</h3>\n<p>Quantifying feature requests is surprisingly difficult. We read every comment we get via email, forum threads, or UserVoice. But describing a feature you want is challenging to do clearly, particularly if you don&#8217;t know technical terms or are less experienced with the nuts and bolts of WordPress. Sometimes feature request can be difficult to interpret correctly.</p>\n<p>Furthermore, it&#8217;s hard for anyone (on either side of the conversation) to visualize all of the details that a certain feature entails. Often times small changes in those details can fundamentally alter a feature, determining its usefulness to the user. For that reason, our support staff takes the time to fully understand the issues, discuss them with the user, and then log the detailed comments in our feature tracker.</p>\n<p>We tally up our list of comment feature requests alongside the UserVoice vote count, and use this as our metric for measuring user demand. However, it does not always make sense to build the most requested features first. We also have to weigh this against how long the feature takes to build. You might have 500 users request one feature, yet in the time it takes to build it you can build 10 other feature requests which thousands have collectively requested. We have to deliberate and decide the best way to spend our development resources.</p>\n<h3 id=\"planning-releases\">Planning Releases Based on Feedback</h3>\n<p>Now that you know how we collect and quantify feedback, you are probably wondering how we act on it.</p>\n<p>We plan our releases many months in advance; sometimes nearly a year out. We leave a little room in every release, for as long as we can, to slip in last minute priorities that might arise. Bugs are a priority category of their own, and can easily fill up the space allotted. They are typically addressed within 1-2 releases. Sometimes they are addressed even sooner in a hotfix.</p>\n<p>New features, on the other hand, are often on our roadmap for many months before we have time to build them. We have often said we would love having infinite resources to plan, build, test, and polish all of these features immediately. But of course such a thing is not possible. Instead, we build a careful roadmap detailing when we will plan, develop, and test a new feature. This means that when we shift priorities on a feature request, such as moving it to an earlier release date, often times another feature request must be bumped back to a later date.</p>\n<p>The closer we get to a release, the harder it gets to shuffle around which new features get included. Often we have begun laying the groundwork for a feature 1-2 releases prior. So adding new features to an upcoming release becomes exceedingly problematic. This is why when someone requests a new feature and asks if it can be implemented next week to meet their client deadline, or perhaps requests that it be implemented in the next release, we almost always have to say: It&#8217;s simply not possible. But that doesn&#8217;t mean we aren&#8217;t listening. We&#8217;re always processing feedback and working it back into our feature planning.</p>\n<p>We hope this article helped shed some light on how much we value your input, and how it shapes the future of our plugins. From all of us at Modern Tribe: Thank you very much for using our plugins. And here&#8217;s to the next release!</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/the-importance-of-user-feedback/\">The Importance of User Feedback</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:67:\"https://theeventscalendar.com/the-importance-of-user-feedback/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"Release: The Events Calendar 3.12.6\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:65:\"https://theeventscalendar.com/release-the-events-calendar-3-12-6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:74:\"https://theeventscalendar.com/release-the-events-calendar-3-12-6/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Nov 2015 23:16:58 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Release Notes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1024837\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:577:\"<p>Hey everyone! The Events Calendar 3.12.6 is hot off the presses. You should see it soon in your WordPress updates, or you can grab it over at the plugin site. This is yet another releases that attempts to clear out some cobwebs ahead of our major 4.0 release. Here&#8217;s what is new: Fix &#8211; Remove constraints&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/release-the-events-calendar-3-12-6/\">Release: The Events Calendar 3.12.6</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Geoff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1830:\"<p>Hey everyone! <strong>The Events Calendar 3.12.6</strong> is hot off the presses. You should see it soon in your WordPress updates, or you can grab it over at the plugin site.</p>\n<p>This is yet another releases that attempts to clear out some cobwebs ahead of <a href=\"https://theeventscalendar.com/upcoming-release-events-calendar-4-0/\">our major 4.0 release</a>. Here&#8217;s what is new:</p>\n<ul>\n<li><strong>Fix &#8211;</strong> Remove constraints on defining new venues and organizers that were added prematurely (our thanks to Jeramey for highlighting this)</li>\n<li><strong>Fix &#8211;</strong> Resolve error encountered by users of some ticketing addons when accessing the orders report (our thanks to Sean for highlighting this)</li>\n<li><strong>Fix &#8211;</strong> Restore live reload functionality which was failing to function in some cases (our thanks to cityofroundrock for highlighting this)</li>\n<li><strong>Tweak &#8211;</strong> Alter month view logic for better isolation of different month views (such as when the calendar widget and main calendar view co-exist)</li>\n</ul>\n<p>We recommend diving into this update if you&#8217;re already running The Events Calendar 3.12 or greater. If you&#8217;re running an earlier version, then please do check out the <a href=\"https://theeventscalendar.com/category/products/release-notes/\">release notes</a> to see what&#8217;s changed in the most recent versions and make sure to back up your files before updating.</p>\n<p>As always, happy calendaring from all of us at Modern Tribe! Thanks a ton for your support.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/release-the-events-calendar-3-12-6/\">Release: The Events Calendar 3.12.6</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:70:\"https://theeventscalendar.com/release-the-events-calendar-3-12-6/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:42:\"\n		\n		\n		\n		\n		\n				\n\n		\n		\n				\n			\n		\n		\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:5:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:33:\"Release: Community Tickets 3.12.1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:63:\"https://theeventscalendar.com/release-community-tickets-3-12-1/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:72:\"https://theeventscalendar.com/release-community-tickets-3-12-1/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 12 Nov 2015 20:37:30 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:13:\"Release Notes\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:39:\"http://theeventscalendar.com/?p=1024841\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:591:\"<p>We released Community Tickets last week and are happy to be rolling out the first update for it. Community Tickets 3.12.1 is now available and squashes a couple bugs. Here&#8217;s what we updated: Fix &#8211; Ensure translations are loaded as expected (our thanks to Dirk for highlighting this issue) Fix &#8211; Update some strings to&#8230;</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/release-community-tickets-3-12-1/\">Release: Community Tickets 3.12.1</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"Geoff\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1269:\"<p>We released <a href=\"https://theeventscalendar.com/product/community-tickets/\">Community Tickets</a> last week and are happy to be rolling out the first update for it. <strong>Community Tickets 3.12.1</strong> is now available and squashes a couple bugs.</p>\n<p>Here&#8217;s what we updated:</p>\n<ul>\n<li><strong>Fix &#8211;</strong> Ensure translations are loaded as expected (our thanks to Dirk for highlighting this issue)</li>\n<li><strong>Fix &#8211;</strong> Update some strings to ensure they can be translated as expected</li>\n</ul>\n<p>If you have Community Tickets, then we encourage you to update and expect smooth sailing when you do. As always, please do back up your WordPress files and database as you would with any update.</p>\n<p>If you don&#8217;t have Community Ticket yet, what are you waiting for? <a href=\"https://theeventscalendar.com/product/community-tickets/\">Check it out</a> because it&#8217;s an awesome way to build a social calendar with the potential for you to create a new revenue stream.</p>\n<p>The post <a rel=\"nofollow\" href=\"https://theeventscalendar.com/release-community-tickets-3-12-1/\">Release: Community Tickets 3.12.1</a> appeared first on <a rel=\"nofollow\" href=\"https://theeventscalendar.com\">The Events Calendar</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"https://theeventscalendar.com/release-community-tickets-3-12-1/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://theeventscalendar.com/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:6:\"hourly\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"1\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Sat, 05 Dec 2015 10:29:28 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:10:\"connection\";s:5:\"close\";s:13:\"cache-control\";s:29:\"max-age=2323, must-revalidate\";s:12:\"x-powered-by\";s:21:\"PHP/5.4.33-1~dotdeb.1\";s:4:\"vary\";s:6:\"Cookie\";s:10:\"x-pingback\";s:40:\"https://theeventscalendar.com/xmlrpc.php\";s:13:\"last-modified\";s:29:\"Sat, 05 Dec 2015 09:09:06 GMT\";s:4:\"etag\";s:34:\"\"62fd3349186ec42e5cd0ca0af1449e1b\"\";s:12:\"x-robots-tag\";s:15:\"noindex, follow\";}s:5:\"build\";s:14:\"20151106171109\";}", "no");
INSERT INTO `wp_root_options` VALUES("640", "_site_transient_update_themes", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1449311391;s:7:\"checked\";a:3:{s:7:\"polymer\";s:5:\"0.3.1\";s:9:\"sparkling\";s:5:\"2.0.1\";s:9:\"stargazer\";s:5:\"1.2.1\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}}", "yes");
INSERT INTO `wp_root_options` VALUES("677", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1449312187;s:7:\"checked\";a:9:{s:19:\"akismet/akismet.php\";s:5:\"3.1.5\";s:23:\"file-away/file-away.php\";s:7:\"3.9.6.1\";s:9:\"hello.php\";s:3:\"1.6\";s:35:\"private-content/private-content.php\";s:3:\"3.0\";s:31:\"sidebar-login/sidebar-login.php\";s:5:\"2.7.3\";s:39:\"simple-custom-css/simple-custom-css.php\";s:3:\"3.2\";s:25:\"tablepress/tablepress.php\";s:5:\"1.6.1\";s:43:\"the-events-calendar/the-events-calendar.php\";s:3:\"4.0\";s:37:\"tinymce-advanced/tinymce-advanced.php\";s:5:\"4.2.5\";}s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:9:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"3.1.5\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.3.1.5.zip\";}s:23:\"file-away/file-away.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"45365\";s:4:\"slug\";s:9:\"file-away\";s:6:\"plugin\";s:23:\"file-away/file-away.php\";s:11:\"new_version\";s:7:\"3.9.6.1\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/file-away/\";s:7:\"package\";s:52:\"https://downloads.wordpress.org/plugin/file-away.zip\";}s:9:\"hello.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"3564\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/hello-dolly.1.6.zip\";}s:35:\"private-content/private-content.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"36507\";s:4:\"slug\";s:15:\"private-content\";s:6:\"plugin\";s:35:\"private-content/private-content.php\";s:11:\"new_version\";s:3:\"3.0\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/private-content/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/private-content.3.0.zip\";}s:31:\"sidebar-login/sidebar-login.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:4:\"4105\";s:4:\"slug\";s:13:\"sidebar-login\";s:6:\"plugin\";s:31:\"sidebar-login/sidebar-login.php\";s:11:\"new_version\";s:5:\"2.7.3\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/sidebar-login/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/sidebar-login.2.7.3.zip\";}s:39:\"simple-custom-css/simple-custom-css.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"43065\";s:4:\"slug\";s:17:\"simple-custom-css\";s:6:\"plugin\";s:39:\"simple-custom-css/simple-custom-css.php\";s:11:\"new_version\";s:3:\"3.2\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/simple-custom-css/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/simple-custom-css.zip\";s:14:\"upgrade_notice\";s:92:\"Tested for compatibility with WP 4.1.  Improved architecture to reduce the number of queries\";}s:25:\"tablepress/tablepress.php\";O:8:\"stdClass\":7:{s:2:\"id\";s:5:\"32125\";s:4:\"slug\";s:10:\"tablepress\";s:6:\"plugin\";s:25:\"tablepress/tablepress.php\";s:11:\"new_version\";s:5:\"1.6.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/tablepress/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/tablepress.1.6.1.zip\";s:14:\"upgrade_notice\";s:90:\"This update fixes an issue with the JavaScript features after the update to WordPress 4.3.\";}s:43:\"the-events-calendar/the-events-calendar.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:5:\"11861\";s:4:\"slug\";s:19:\"the-events-calendar\";s:6:\"plugin\";s:43:\"the-events-calendar/the-events-calendar.php\";s:11:\"new_version\";s:3:\"4.0\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/the-events-calendar/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/the-events-calendar.4.0.zip\";}s:37:\"tinymce-advanced/tinymce-advanced.php\";O:8:\"stdClass\":6:{s:2:\"id\";s:3:\"731\";s:4:\"slug\";s:16:\"tinymce-advanced\";s:6:\"plugin\";s:37:\"tinymce-advanced/tinymce-advanced.php\";s:11:\"new_version\";s:5:\"4.2.5\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/tinymce-advanced/\";s:7:\"package\";s:65:\"https://downloads.wordpress.org/plugin/tinymce-advanced.4.2.5.zip\";}}}", "yes");
INSERT INTO `wp_root_options` VALUES("534", "wpseo_social", "a:21:{s:9:\"fb_admins\";a:0:{}s:12:\"fbconnectkey\";s:32:\"ae461b98ea2f68bbfd8f4609a4277025\";s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:9:\"opengraph\";b:1;s:10:\"googleplus\";b:0;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:14:\"plus-publisher\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:7:\"summary\";s:11:\"youtube_url\";s:0:\"\";s:15:\"google_plus_url\";s:0:\"\";s:10:\"fbadminapp\";s:0:\"\";}", "yes");
INSERT INTO `wp_root_options` VALUES("535", "wpseo_rss", "a:2:{s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:64:\"Cet article %%POSTLINK%% est apparu en premier sur %%BLOGLINK%%.\";}", "yes");
INSERT INTO `wp_root_options` VALUES("536", "wpseo_internallinks", "a:12:{s:20:\"breadcrumbs-404crumb\";s:28:\"Erreur 404: Page introuvable\";s:23:\"breadcrumbs-blog-remove\";b:0;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:13:\"Archives pour\";s:18:\"breadcrumbs-enable\";b:0;s:16:\"breadcrumbs-home\";s:7:\"Accueil\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:18:\"Vous avez cherché\";s:15:\"breadcrumbs-sep\";s:7:\"&raquo;\";s:23:\"post_types-post-maintax\";i:0;s:31:\"post_types-tribe_events-maintax\";i:0;s:34:\"taxonomy-tribe_events_cat-ptparent\";i:0;}", "yes");
INSERT INTO `wp_root_options` VALUES("537", "wpseo_xml", "a:18:{s:22:\"disable_author_sitemap\";b:1;s:22:\"disable_author_noposts\";b:1;s:16:\"enablexmlsitemap\";b:1;s:16:\"entries-per-page\";i:1000;s:14:\"excluded-posts\";s:0:\"\";s:38:\"user_role-administrator-not_in_sitemap\";b:0;s:31:\"user_role-editor-not_in_sitemap\";b:0;s:31:\"user_role-author-not_in_sitemap\";b:0;s:36:\"user_role-contributor-not_in_sitemap\";b:0;s:35:\"user_role-subscriber-not_in_sitemap\";b:0;s:30:\"post_types-post-not_in_sitemap\";b:0;s:30:\"post_types-page-not_in_sitemap\";b:0;s:36:\"post_types-attachment-not_in_sitemap\";b:1;s:38:\"post_types-tribe_events-not_in_sitemap\";b:0;s:34:\"taxonomies-category-not_in_sitemap\";b:0;s:34:\"taxonomies-post_tag-not_in_sitemap\";b:0;s:37:\"taxonomies-post_format-not_in_sitemap\";b:0;s:42:\"taxonomies-tribe_events_cat-not_in_sitemap\";b:0;}", "yes");
INSERT INTO `wp_root_options` VALUES("539", "_transient_timeout_yoast_i18n_wordpress-seo_fr_FR", "1448544004", "no");
INSERT INTO `wp_root_options` VALUES("540", "_transient_yoast_i18n_wordpress-seo_fr_FR", "", "no");
INSERT INTO `wp_root_options` VALUES("541", "_transient_timeout_tablepress_c51d47015d1cc5afe2e3b760cb3b35fd", "1448543983", "no");
INSERT INTO `wp_root_options` VALUES("542", "_transient_tablepress_c51d47015d1cc5afe2e3b760cb3b35fd", "\n<table id=\"tablepress-4\" class=\"tablepress tablepress-id-4\">\n<tbody>\n<tr class=\"row-1\">\n	<td class=\"column-1\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole rue de Neufchâteau</a><br />\n063/22.62.64<br />\nDir.: Me SKA</td><td class=\"column-2\"><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a><br />\n063/22.62.58<br />\nDir.: Me SKA</td><td class=\"column-3\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a><br />\n063/22.52.40<br />\nDir.: Mr NEY</td><td class=\"column-4\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a><br />\n063/22.52.40<br />\nDir.: Mr NEY</td>\n</tr>\n<tr class=\"row-2\">\n	<td class=\"column-1\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a><br />\n063/22.52.40<br />\nDir.: Me DUMONT</td><td class=\"column-2\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a><br />\n063/22.52.40<br />\nDir.: Me DUMONT</td><td class=\"column-3\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a><br />\n063/22.52.40<br />\nDir.: Mr SIMON</td><td class=\"column-4\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a><br />\n063/22.52.40<br />\nDir.: Mr SIMON</td>\n</tr>\n<tr class=\"row-3\">\n	<td class=\"column-1\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a><br />\n063/22.52.40<br />\nDir.: Mr BILLO</td><td class=\"column-2\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a><br />\n063/22.52.40<br />\nDir.: Mr BILLO</td><td class=\"column-3\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a><br />\n063/22.52.40<br />\nDir.: Mr BILLO</td><td class=\"column-4\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a><br />\n063/22.52.40<br />\nDir.: Mr Thilmany</td>\n</tr>\n<tr class=\"row-4\">\n	<td class=\"column-1\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a><br />\n063/22.62.58<br />\nDir.: Me COLLIN</td><td class=\"column-2\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a><br />\n063/22.52.40<br />\nDir.: Me COLLIN</td><td class=\"column-3\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a><br />\n063/22.52.40<br />\nDir.: Me COLLIN</td><td class=\"column-4\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a><br />\n063/22.52.40<br />\nDir.: Me BOURTON</td>\n</tr>\n</tbody>\n</table>\n", "no");
INSERT INTO `wp_root_options` VALUES("543", "_transient_timeout_tablepress_c_a87ff679a2f3e71d9181a67b7542122c", "1448630383", "no");
INSERT INTO `wp_root_options` VALUES("544", "_transient_tablepress_c_a87ff679a2f3e71d9181a67b7542122c", "[\"tablepress_c51d47015d1cc5afe2e3b760cb3b35fd\"]", "no");
INSERT INTO `wp_root_options` VALUES("545", "wpseo_onpage", "a:2:{s:6:\"status\";i:1;s:10:\"last_fetch\";i:1448457583;}", "yes");
INSERT INTO `wp_root_options` VALUES("553", "tadv_settings", "a:6:{s:7:\"options\";s:15:\"menubar,advlist\";s:9:\"toolbar_1\";s:117:\"bold,italic,blockquote,bullist,numlist,alignleft,aligncenter,alignright,link,unlink,table,fullscreen,undo,redo,wp_adv\";s:9:\"toolbar_2\";s:121:\"formatselect,alignjustify,strikethrough,outdent,indent,pastetext,removeformat,charmap,wp_more,emoticons,forecolor,wp_help\";s:9:\"toolbar_3\";s:0:\"\";s:9:\"toolbar_4\";s:0:\"\";s:7:\"plugins\";s:107:\"anchor,code,insertdatetime,nonbreaking,print,searchreplace,table,visualblocks,visualchars,emoticons,advlist\";}", "yes");
INSERT INTO `wp_root_options` VALUES("554", "tadv_admin_settings", "a:1:{s:7:\"options\";a:0:{}}", "yes");
INSERT INTO `wp_root_options` VALUES("555", "tadv_version", "4000", "yes");
INSERT INTO `wp_root_options` VALUES("606", "sccss_settings", "a:1:{s:13:\"sccss-content\";s:69:\"/* Enter Your Custom CSS Here */\r\n.main {\r\n  -moz-hyphens: none;\r\n}\r\n\";}", "yes");
INSERT INTO `wp_root_options` VALUES("607", "_transient_timeout_settings_errors", "1449312158", "no");
INSERT INTO `wp_root_options` VALUES("616", "_transient_doing_cron", "1449314359.0035390853881835937500", "yes");
INSERT INTO `wp_root_options` VALUES("676", "rewrite_rules", "a:163:{s:40:\"(?:event)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:56:\"index.php?tribe_events=$matches[1]&eventDate=$matches[2]\";s:28:\"(?:event)/([^/]+)/(?:all)/?$\";s:74:\"index.php?tribe_events=$matches[1]&post_type=tribe_events&eventDisplay=all\";s:45:\"(?:event)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/ical/?$\";s:63:\"index.php?tribe_events=$matches[1]&eventDate=$matches[2]&ical=1\";s:25:\"(?:event)/([^/]+)/ical/?$\";s:56:\"index.php?ical=1&name=$matches[1]&post_type=tribe_events\";s:28:\"(?:events)/(?:page)/(\\d+)/?$\";s:68:\"index.php?post_type=tribe_events&eventDisplay=list&paged=$matches[1]\";s:38:\"(?:events)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?post_type=tribe_events&eventDisplay=list&feed=$matches[1]\";s:28:\"(?:events)/(?:month|mois)/?$\";s:51:\"index.php?post_type=tribe_events&eventDisplay=month\";s:43:\"(?:events)/(?:list|liste)/(?:page)/(\\d+)/?$\";s:68:\"index.php?post_type=tribe_events&eventDisplay=list&paged=$matches[1]\";s:28:\"(?:events)/(?:list|liste)/?$\";s:50:\"index.php?post_type=tribe_events&eventDisplay=list\";s:34:\"(?:events)/(?:today|aujourdhui)/?$\";s:49:\"index.php?post_type=tribe_events&eventDisplay=day\";s:27:\"(?:events)/(\\d{4}-\\d{2})/?$\";s:73:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]\";s:33:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:71:\"index.php?post_type=tribe_events&eventDisplay=day&eventDate=$matches[1]\";s:13:\"(?:events)/?$\";s:53:\"index.php?post_type=tribe_events&eventDisplay=default\";s:18:\"(?:events)/ical/?$\";s:39:\"index.php?post_type=tribe_events&ical=1\";s:38:\"(?:events)/(\\d{4}-\\d{2}-\\d{2})/ical/?$\";s:78:\"index.php?post_type=tribe_events&ical=1&eventDisplay=day&eventDate=$matches[1]\";s:70:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/(?:page)/(\\d+)/?$\";s:97:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:70:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/(?:month|mois)/?$\";s:80:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month\";s:85:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/(?:list|liste)/(?:page)/(\\d+)/?$\";s:97:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:70:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/(?:list|liste)/?$\";s:79:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list\";s:76:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/(?:today|aujourdhui)/?$\";s:78:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day\";s:88:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/(?:day|jour)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:69:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2})/?$\";s:102:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&eventDate=$matches[2]\";s:75:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:60:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/feed/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&feed=rss2\";s:60:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/ical/?$\";s:68:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&ical=1\";s:85:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:78:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&feed=$matches[2]\";s:55:\"(?:events)/(?:category|categorie)/(?:[^/]+/)*([^/]+)/?$\";s:80:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month\";s:53:\"(?:events)/(?:tag|mot-clef)/([^/]+)/(?:page)/(\\d+)/?$\";s:84:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:53:\"(?:events)/(?:tag|mot-clef)/([^/]+)/(?:month|mois)/?$\";s:67:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month\";s:68:\"(?:events)/(?:tag|mot-clef)/([^/]+)/(?:list|liste)/(?:page)/(\\d+)/?$\";s:84:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:53:\"(?:events)/(?:tag|mot-clef)/([^/]+)/(?:list|liste)/?$\";s:66:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list\";s:59:\"(?:events)/(?:tag|mot-clef)/([^/]+)/(?:today|aujourdhui)/?$\";s:65:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day\";s:71:\"(?:events)/(?:tag|mot-clef)/([^/]+)/(?:day|jour)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:52:\"(?:events)/(?:tag|mot-clef)/([^/]+)/(\\d{4}-\\d{2})/?$\";s:89:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&eventDate=$matches[2]\";s:58:\"(?:events)/(?:tag|mot-clef)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:43:\"(?:events)/(?:tag|mot-clef)/([^/]+)/feed/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&feed=rss2\";s:43:\"(?:events)/(?:tag|mot-clef)/([^/]+)/ical/?$\";s:55:\"index.php?post_type=tribe_events&tag=$matches[1]&ical=1\";s:68:\"(?:events)/(?:tag|mot-clef)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?post_type=tribe_events&tag=$matches[1]&feed=$matches[2]\";s:38:\"(?:events)/(?:tag|mot-clef)/([^/]+)/?$\";s:67:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month\";s:8:\"event/?$\";s:32:\"index.php?post_type=tribe_events\";s:38:\"event/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=tribe_events&feed=$matches[1]\";s:33:\"event/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=tribe_events&feed=$matches[1]\";s:25:\"event/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=tribe_events&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:33:\"event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:26:\"event/([^/]+)/trackback/?$\";s:39:\"index.php?tribe_events=$matches[1]&tb=1\";s:46:\"event/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tribe_events=$matches[1]&feed=$matches[2]\";s:41:\"event/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tribe_events=$matches[1]&feed=$matches[2]\";s:34:\"event/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?tribe_events=$matches[1]&paged=$matches[2]\";s:41:\"event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?tribe_events=$matches[1]&cpage=$matches[2]\";s:26:\"event/([^/]+)(/[0-9]+)?/?$\";s:51:\"index.php?tribe_events=$matches[1]&page=$matches[2]\";s:22:\"event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"lieu/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"lieu/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"lieu/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"lieu/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"lieu/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:25:\"lieu/([^/]+)/trackback/?$\";s:38:\"index.php?tribe_venue=$matches[1]&tb=1\";s:33:\"lieu/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?tribe_venue=$matches[1]&paged=$matches[2]\";s:40:\"lieu/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?tribe_venue=$matches[1]&cpage=$matches[2]\";s:25:\"lieu/([^/]+)(/[0-9]+)?/?$\";s:50:\"index.php?tribe_venue=$matches[1]&page=$matches[2]\";s:21:\"lieu/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:31:\"lieu/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:51:\"lieu/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"lieu/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:46:\"lieu/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"organisateur/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"organisateur/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"organisateur/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"organisateur/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"organisateur/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"organisateur/([^/]+)/trackback/?$\";s:42:\"index.php?tribe_organizer=$matches[1]&tb=1\";s:41:\"organisateur/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tribe_organizer=$matches[1]&paged=$matches[2]\";s:48:\"organisateur/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?tribe_organizer=$matches[1]&cpage=$matches[2]\";s:33:\"organisateur/([^/]+)(/[0-9]+)?/?$\";s:54:\"index.php?tribe_organizer=$matches[1]&page=$matches[2]\";s:29:\"organisateur/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"organisateur/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"organisateur/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"organisateur/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"organisateur/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:55:\"events/categorie/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tribe_events_cat=$matches[1]&feed=$matches[2]\";s:50:\"events/categorie/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tribe_events_cat=$matches[1]&feed=$matches[2]\";s:43:\"events/categorie/(.+?)/page/?([0-9]{1,})/?$\";s:56:\"index.php?tribe_events_cat=$matches[1]&paged=$matches[2]\";s:25:\"events/categorie/(.+?)/?$\";s:38:\"index.php?tribe_events_cat=$matches[1]\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=6&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(/[0-9]+)?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:20:\"(.?.+?)(/[0-9]+)?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_root_options` VALUES("608", "_transient_settings_errors", "a:1:{i:0;a:4:{s:7:\"setting\";s:7:\"general\";s:4:\"code\";s:16:\"settings_updated\";s:7:\"message\";s:22:\"Options enregistrées.\";s:4:\"type\";s:7:\"updated\";}}", "no");
INSERT INTO `wp_root_options` VALUES("660", "_transient_timeout_feed_mod_0d102f2a1f4d6bc90eb8c6ffe18e56ed", "1449354568", "no");
INSERT INTO `wp_root_options` VALUES("661", "_transient_feed_mod_0d102f2a1f4d6bc90eb8c6ffe18e56ed", "1449311368", "no");

/* INSERT TABLE DATA: wp_root_postmeta */
INSERT INTO `wp_root_postmeta` VALUES("1", "2", "_wp_page_template", "default");
INSERT INTO `wp_root_postmeta` VALUES("2", "1", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_root_postmeta` VALUES("3", "1", "_wp_trash_meta_time", "1446832217");
INSERT INTO `wp_root_postmeta` VALUES("4", "1", "_wp_trash_meta_comments_status", "a:1:{i:1;s:1:\"1\";}");
INSERT INTO `wp_root_postmeta` VALUES("5", "2", "_wp_trash_meta_status", "publish");
INSERT INTO `wp_root_postmeta` VALUES("6", "2", "_wp_trash_meta_time", "1446832227");
INSERT INTO `wp_root_postmeta` VALUES("7", "6", "_edit_last", "1");
INSERT INTO `wp_root_postmeta` VALUES("8", "6", "_edit_lock", "1449312635:1");
INSERT INTO `wp_root_postmeta` VALUES("9", "8", "_edit_last", "1");
INSERT INTO `wp_root_postmeta` VALUES("10", "8", "_edit_lock", "1446833643:1");
INSERT INTO `wp_root_postmeta` VALUES("11", "10", "_edit_last", "1");
INSERT INTO `wp_root_postmeta` VALUES("12", "10", "_edit_lock", "1446836790:1");
INSERT INTO `wp_root_postmeta` VALUES("13", "12", "_edit_last", "1");
INSERT INTO `wp_root_postmeta` VALUES("14", "12", "_edit_lock", "1448459719:1");
INSERT INTO `wp_root_postmeta` VALUES("15", "14", "_edit_last", "1");
INSERT INTO `wp_root_postmeta` VALUES("16", "14", "_edit_lock", "1449312033:1");
INSERT INTO `wp_root_postmeta` VALUES("17", "16", "_menu_item_type", "post_type");
INSERT INTO `wp_root_postmeta` VALUES("18", "16", "_menu_item_menu_item_parent", "17");
INSERT INTO `wp_root_postmeta` VALUES("19", "16", "_menu_item_object_id", "14");
INSERT INTO `wp_root_postmeta` VALUES("20", "16", "_menu_item_object", "page");
INSERT INTO `wp_root_postmeta` VALUES("21", "16", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("22", "16", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("23", "16", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("24", "16", "_menu_item_url", "");
INSERT INTO `wp_root_postmeta` VALUES("62", "21", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("26", "17", "_menu_item_type", "post_type");
INSERT INTO `wp_root_postmeta` VALUES("27", "17", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("28", "17", "_menu_item_object_id", "12");
INSERT INTO `wp_root_postmeta` VALUES("29", "17", "_menu_item_object", "page");
INSERT INTO `wp_root_postmeta` VALUES("30", "17", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("31", "17", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("32", "17", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("33", "17", "_menu_item_url", "");
INSERT INTO `wp_root_postmeta` VALUES("63", "21", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("35", "18", "_menu_item_type", "post_type");
INSERT INTO `wp_root_postmeta` VALUES("36", "18", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("37", "18", "_menu_item_object_id", "10");
INSERT INTO `wp_root_postmeta` VALUES("38", "18", "_menu_item_object", "page");
INSERT INTO `wp_root_postmeta` VALUES("39", "18", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("40", "18", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("41", "18", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("42", "18", "_menu_item_url", "");
INSERT INTO `wp_root_postmeta` VALUES("64", "21", "_menu_item_object_id", "21");
INSERT INTO `wp_root_postmeta` VALUES("44", "19", "_menu_item_type", "post_type");
INSERT INTO `wp_root_postmeta` VALUES("45", "19", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("46", "19", "_menu_item_object_id", "8");
INSERT INTO `wp_root_postmeta` VALUES("47", "19", "_menu_item_object", "page");
INSERT INTO `wp_root_postmeta` VALUES("48", "19", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("49", "19", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("50", "19", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("51", "19", "_menu_item_url", "");
INSERT INTO `wp_root_postmeta` VALUES("65", "21", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("53", "20", "_menu_item_type", "post_type");
INSERT INTO `wp_root_postmeta` VALUES("54", "20", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("55", "20", "_menu_item_object_id", "6");
INSERT INTO `wp_root_postmeta` VALUES("56", "20", "_menu_item_object", "page");
INSERT INTO `wp_root_postmeta` VALUES("57", "20", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("58", "20", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("59", "20", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("60", "20", "_menu_item_url", "");
INSERT INTO `wp_root_postmeta` VALUES("66", "21", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("67", "21", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("68", "21", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("69", "21", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("71", "22", "_tablepress_table_options", "{\"last_editor\":1,\"table_head\":true,\"table_foot\":false,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":false,\"datatables_filter\":false,\"datatables_paginate\":false,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":false,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_root_postmeta` VALUES("72", "22", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1,1],\"columns\":[1,1,1]}");
INSERT INTO `wp_root_postmeta` VALUES("73", "8", "_wp_page_template", "default");
INSERT INTO `wp_root_postmeta` VALUES("74", "12", "_wp_page_template", "default");
INSERT INTO `wp_root_postmeta` VALUES("75", "14", "_wp_page_template", "default");
INSERT INTO `wp_root_postmeta` VALUES("76", "10", "_wp_page_template", "default");
INSERT INTO `wp_root_postmeta` VALUES("77", "35", "_tablepress_table_options", "{\"last_editor\":1,\"table_head\":true,\"table_foot\":false,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":true,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":false,\"datatables_filter\":false,\"datatables_paginate\":false,\"datatables_lengthchange\":false,\"datatables_paginate_entries\":10,\"datatables_info\":false,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_root_postmeta` VALUES("78", "35", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1,1],\"columns\":[1,1,1,1]}");
INSERT INTO `wp_root_postmeta` VALUES("79", "39", "_tablepress_table_options", "{\"last_editor\":1,\"table_head\":true,\"table_foot\":false,\"alternating_row_colors\":true,\"row_hover\":true,\"print_name\":true,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":false,\"datatables_filter\":false,\"datatables_paginate\":false,\"datatables_lengthchange\":false,\"datatables_paginate_entries\":10,\"datatables_info\":false,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_root_postmeta` VALUES("80", "39", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1,1,1],\"columns\":[1,1,1,1]}");
INSERT INTO `wp_root_postmeta` VALUES("81", "42", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("82", "42", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("83", "42", "_menu_item_object_id", "42");
INSERT INTO `wp_root_postmeta` VALUES("84", "42", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("85", "42", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("86", "42", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("87", "42", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("88", "42", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("239", "68", "_wp_trash_meta_time", "1446837766");
INSERT INTO `wp_root_postmeta` VALUES("90", "43", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("91", "43", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("92", "43", "_menu_item_object_id", "43");
INSERT INTO `wp_root_postmeta` VALUES("93", "43", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("94", "43", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("95", "43", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("96", "43", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("97", "43", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("238", "68", "_wp_trash_meta_status", "private");
INSERT INTO `wp_root_postmeta` VALUES("99", "44", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("100", "44", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("101", "44", "_menu_item_object_id", "44");
INSERT INTO `wp_root_postmeta` VALUES("102", "44", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("103", "44", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("104", "44", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("105", "44", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("106", "44", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("108", "45", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("109", "45", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("110", "45", "_menu_item_object_id", "45");
INSERT INTO `wp_root_postmeta` VALUES("111", "45", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("112", "45", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("113", "45", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("114", "45", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("115", "45", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("117", "46", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("118", "46", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("119", "46", "_menu_item_object_id", "46");
INSERT INTO `wp_root_postmeta` VALUES("120", "46", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("121", "46", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("122", "46", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("123", "46", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("124", "46", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("126", "47", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("127", "47", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("128", "47", "_menu_item_object_id", "47");
INSERT INTO `wp_root_postmeta` VALUES("129", "47", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("130", "47", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("131", "47", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("132", "47", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("133", "47", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("135", "48", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("136", "48", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("137", "48", "_menu_item_object_id", "48");
INSERT INTO `wp_root_postmeta` VALUES("138", "48", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("139", "48", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("140", "48", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("141", "48", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("142", "48", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("144", "49", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("145", "49", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("146", "49", "_menu_item_object_id", "49");
INSERT INTO `wp_root_postmeta` VALUES("147", "49", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("148", "49", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("149", "49", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("150", "49", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("151", "49", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("153", "50", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("154", "50", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("155", "50", "_menu_item_object_id", "50");
INSERT INTO `wp_root_postmeta` VALUES("156", "50", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("157", "50", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("158", "50", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("159", "50", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("160", "50", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("162", "51", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("163", "51", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("164", "51", "_menu_item_object_id", "51");
INSERT INTO `wp_root_postmeta` VALUES("165", "51", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("166", "51", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("167", "51", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("168", "51", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("169", "51", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("171", "52", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("172", "52", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("173", "52", "_menu_item_object_id", "52");
INSERT INTO `wp_root_postmeta` VALUES("174", "52", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("175", "52", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("176", "52", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("177", "52", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("178", "52", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("240", "77", "_tablepress_table_options", "{\"last_editor\":1,\"table_head\":false,\"table_foot\":false,\"alternating_row_colors\":false,\"row_hover\":false,\"print_name\":false,\"print_name_position\":\"above\",\"print_description\":false,\"print_description_position\":\"below\",\"extra_css_classes\":\"\",\"use_datatables\":true,\"datatables_sort\":true,\"datatables_filter\":true,\"datatables_paginate\":true,\"datatables_lengthchange\":true,\"datatables_paginate_entries\":10,\"datatables_info\":true,\"datatables_scrollx\":false,\"datatables_custom_commands\":\"\"}");
INSERT INTO `wp_root_postmeta` VALUES("180", "53", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("181", "53", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("182", "53", "_menu_item_object_id", "53");
INSERT INTO `wp_root_postmeta` VALUES("183", "53", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("184", "53", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("185", "53", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("186", "53", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("187", "53", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("219", "68", "_wp_page_template", "default");
INSERT INTO `wp_root_postmeta` VALUES("189", "54", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("190", "54", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("191", "54", "_menu_item_object_id", "54");
INSERT INTO `wp_root_postmeta` VALUES("192", "54", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("193", "54", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("194", "54", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("195", "54", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("196", "54", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("218", "68", "_edit_lock", "1446837611:1");
INSERT INTO `wp_root_postmeta` VALUES("198", "55", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("199", "55", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("200", "55", "_menu_item_object_id", "55");
INSERT INTO `wp_root_postmeta` VALUES("201", "55", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("202", "55", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("203", "55", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("204", "55", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("205", "55", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("217", "68", "_edit_last", "1");
INSERT INTO `wp_root_postmeta` VALUES("207", "56", "_menu_item_type", "custom");
INSERT INTO `wp_root_postmeta` VALUES("208", "56", "_menu_item_menu_item_parent", "0");
INSERT INTO `wp_root_postmeta` VALUES("209", "56", "_menu_item_object_id", "56");
INSERT INTO `wp_root_postmeta` VALUES("210", "56", "_menu_item_object", "custom");
INSERT INTO `wp_root_postmeta` VALUES("211", "56", "_menu_item_target", "");
INSERT INTO `wp_root_postmeta` VALUES("212", "56", "_menu_item_classes", "a:1:{i:0;s:0:\"\";}");
INSERT INTO `wp_root_postmeta` VALUES("213", "56", "_menu_item_xfn", "");
INSERT INTO `wp_root_postmeta` VALUES("214", "56", "_menu_item_url", "http://udange2.ec-arlon.be/");
INSERT INTO `wp_root_postmeta` VALUES("216", "6", "_wp_page_template", "default");
INSERT INTO `wp_root_postmeta` VALUES("241", "77", "_tablepress_table_visibility", "{\"rows\":[1,1,1,1],\"columns\":[1,1,1,1]}");
INSERT INTO `wp_root_postmeta` VALUES("242", "83", "_edit_last", "1");
INSERT INTO `wp_root_postmeta` VALUES("243", "83", "_edit_lock", "1446841476:1");
INSERT INTO `wp_root_postmeta` VALUES("244", "83", "_wp_page_template", "default");
INSERT INTO `wp_root_postmeta` VALUES("245", "89", "_wp_attached_file", "2015/11/header.jpg");
INSERT INTO `wp_root_postmeta` VALUES("246", "89", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1175;s:6:\"height\";i:191;s:4:\"file\";s:18:\"2015/11/header.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:18:\"header-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:17:\"header-300x49.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:49;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:19:\"header-1024x166.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:18:\"header-175x131.jpg\";s:5:\"width\";i:175;s:6:\"height\";i:131;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"stargazer-full\";a:4:{s:4:\"file\";s:19:\"header-1025x167.jpg\";s:5:\"width\";i:1025;s:6:\"height\";i:167;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:1;}}");
INSERT INTO `wp_root_postmeta` VALUES("247", "90", "_wp_attached_file", "2015/11/cropped-header.jpg");
INSERT INTO `wp_root_postmeta` VALUES("248", "90", "_wp_attachment_context", "custom-header");
INSERT INTO `wp_root_postmeta` VALUES("249", "90", "_wp_attachment_metadata", "a:5:{s:5:\"width\";i:1175;s:6:\"height\";i:191;s:4:\"file\";s:26:\"2015/11/cropped-header.jpg\";s:5:\"sizes\";a:5:{s:9:\"thumbnail\";a:4:{s:4:\"file\";s:26:\"cropped-header-150x150.jpg\";s:5:\"width\";i:150;s:6:\"height\";i:150;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:6:\"medium\";a:4:{s:4:\"file\";s:25:\"cropped-header-300x49.jpg\";s:5:\"width\";i:300;s:6:\"height\";i:49;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:5:\"large\";a:4:{s:4:\"file\";s:27:\"cropped-header-1024x166.jpg\";s:5:\"width\";i:1024;s:6:\"height\";i:166;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"post-thumbnail\";a:4:{s:4:\"file\";s:26:\"cropped-header-175x131.jpg\";s:5:\"width\";i:175;s:6:\"height\";i:131;s:9:\"mime-type\";s:10:\"image/jpeg\";}s:14:\"stargazer-full\";a:4:{s:4:\"file\";s:27:\"cropped-header-1025x167.jpg\";s:5:\"width\";i:1025;s:6:\"height\";i:167;s:9:\"mime-type\";s:10:\"image/jpeg\";}}s:10:\"image_meta\";a:11:{s:8:\"aperture\";i:0;s:6:\"credit\";s:0:\"\";s:6:\"camera\";s:0:\"\";s:7:\"caption\";s:0:\"\";s:17:\"created_timestamp\";i:0;s:9:\"copyright\";s:0:\"\";s:12:\"focal_length\";i:0;s:3:\"iso\";i:0;s:13:\"shutter_speed\";i:0;s:5:\"title\";s:0:\"\";s:11:\"orientation\";i:0;}}");
INSERT INTO `wp_root_postmeta` VALUES("250", "90", "_wp_attachment_custom_header_last_used_polymer", "1447955326");
INSERT INTO `wp_root_postmeta` VALUES("251", "90", "_wp_attachment_is_custom_header", "polymer");
INSERT INTO `wp_root_postmeta` VALUES("252", "115", "_EventOrigin", "events-calendar");

/* INSERT TABLE DATA: wp_root_posts */
INSERT INTO `wp_root_posts` VALUES("1", "1", "2015-11-06 18:49:30", "2015-11-06 17:49:30", "Bienvenue dans WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis lancez-vous&nbsp;!", "Bonjour tout le monde&nbsp;!", "", "trash", "open", "open", "", "bonjour-tout-le-monde", "", "", "2015-11-06 18:50:17", "2015-11-06 17:50:17", "", "0", "http://demo.ec-arlon.be/?p=1", "0", "post", "", "1");
INSERT INTO `wp_root_posts` VALUES("2", "1", "2015-11-06 18:49:30", "2015-11-06 17:49:30", "Voici un exemple de page. Elle est différente d\'un article de blog, en cela qu\'elle restera à la même place, et s\'affichera dans le menu de navigation de votre site (en fonction de votre thème). La plupart des gens commencent par écrire une page « À Propos » qui les présente aux visiteurs potentiels du site. Vous pourriez y écrire quelque chose de ce tenant :\n\n<blockquote>Bonjour ! Je suis un mécanicien qui aspire à devenir un acteur, et voici mon blog. J\'habite à Bordeaux, j\'ai un super chien baptisé Russell, et j\'aime la vodka-ananas (ainsi que regarder la pluie tomber).</blockquote>\n\n...ou bien quelque chose comme ça :\n\n<blockquote>La société 123 Machin Truc a été créée en 1971, et n\'a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules super pour la communauté bouzemontoise.</blockquote>\n\nÉtant donné que vous êtes un nouvel utilisateur de WordPress, vous devriez vous rendre sur votre <a href=\"http://demo.ec-arlon.be/wp-admin/\">tableau de bord</a> pour effacer la présente page, et créer de nouvelles pages avec votre propre contenu. Amusez-vous bien !", "Page d&rsquo;exemple", "", "trash", "closed", "open", "", "page-d-exemple", "", "", "2015-11-06 18:50:27", "2015-11-06 17:50:27", "", "0", "http://demo.ec-arlon.be/?page_id=2", "0", "page", "", "0");
INSERT INTO `wp_root_posts` VALUES("109", "1", "2015-12-05 11:29:28", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "open", "open", "", "", "", "", "2015-12-05 11:29:28", "0000-00-00 00:00:00", "", "0", "http://demo.ec-arlon.be/?p=109", "0", "post", "", "0");
INSERT INTO `wp_root_posts` VALUES("4", "1", "2015-11-06 18:50:17", "2015-11-06 17:50:17", "Bienvenue dans WordPress. Ceci est votre premier article. Modifiez-le ou supprimez-le, puis lancez-vous&nbsp;!", "Bonjour tout le monde&nbsp;!", "", "inherit", "closed", "closed", "", "1-revision-v1", "", "", "2015-11-06 18:50:17", "2015-11-06 17:50:17", "", "1", "http://demo.ec-arlon.be/2015/11/06/1-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("5", "1", "2015-11-06 18:50:27", "2015-11-06 17:50:27", "Voici un exemple de page. Elle est différente d\'un article de blog, en cela qu\'elle restera à la même place, et s\'affichera dans le menu de navigation de votre site (en fonction de votre thème). La plupart des gens commencent par écrire une page « À Propos » qui les présente aux visiteurs potentiels du site. Vous pourriez y écrire quelque chose de ce tenant :\n\n<blockquote>Bonjour ! Je suis un mécanicien qui aspire à devenir un acteur, et voici mon blog. J\'habite à Bordeaux, j\'ai un super chien baptisé Russell, et j\'aime la vodka-ananas (ainsi que regarder la pluie tomber).</blockquote>\n\n...ou bien quelque chose comme ça :\n\n<blockquote>La société 123 Machin Truc a été créée en 1971, et n\'a cessé de proposer au public des machins-trucs de qualité depuis lors. Située à Saint-Remy-en-Bouzemont-Saint-Genest-et-Isson, 123 Machin Truc emploie 2 000 personnes, et fabrique toutes sortes de bidules super pour la communauté bouzemontoise.</blockquote>\n\nÉtant donné que vous êtes un nouvel utilisateur de WordPress, vous devriez vous rendre sur votre <a href=\"http://demo.ec-arlon.be/wp-admin/\">tableau de bord</a> pour effacer la présente page, et créer de nouvelles pages avec votre propre contenu. Amusez-vous bien !", "Page d&rsquo;exemple", "", "inherit", "closed", "closed", "", "2-revision-v1", "", "", "2015-11-06 18:50:27", "2015-11-06 17:50:27", "", "2", "http://demo.ec-arlon.be/2015/11/06/2-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("6", "1", "2015-11-06 18:50:46", "2015-11-06 17:50:46", "<table>\r\n<thead>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td style=\"text-align: center;\"><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.14.94\r\nDir.: Me SKA</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.17.94\r\nDir.: Mr NEY</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\nPrimaire: 063/21.80.08 Maternelle: 063/22.22.74\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.58.35\r\nDir.: Me DUMONT</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/23.71.84\r\nDir.: Me DUMONT</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.44.21\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/21.91.06\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/21.81.34\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.50.35\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.14.95\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/21.79.77\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.62.58\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "publish", "closed", "closed", "", "accueil", "", "", "2015-11-25 14:40:34", "2015-11-25 13:40:34", "", "0", "http://demo.ec-arlon.be/?page_id=6", "0", "page", "", "0");
INSERT INTO `wp_root_posts` VALUES("7", "1", "2015-11-06 18:50:46", "2015-11-06 17:50:46", "Page d\'accueil", "Accueil", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 18:50:46", "2015-11-06 17:50:46", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("8", "1", "2015-11-06 18:51:11", "2015-11-06 17:51:11", "Les cours se donnent comme suit :\r\n\r\n[table id=1 /]\r\n\r\nL\'accès et la surveillance de la cour de l\'école se font à partir de 08:15 le matin et 13:15 l\'après midi.\r\n\r\nSi les enfants arrivent avant 08:15, ils doivent <strong>obligatoirement</strong> se rendre à la garderie.\r\n\r\nS\'ils ne sont pas inscrits à la cantine, <strong>ils ne peuvent pas se présenter</strong> à l\'école avant 13:15.", "Horaires", "", "publish", "closed", "closed", "", "horaires", "", "", "2015-11-06 19:13:34", "2015-11-06 18:13:34", "", "0", "http://demo.ec-arlon.be/?page_id=8", "0", "page", "", "0");
INSERT INTO `wp_root_posts` VALUES("9", "1", "2015-11-06 18:51:11", "2015-11-06 17:51:11", "Page avec les horaires", "Horaires", "", "inherit", "closed", "closed", "", "8-revision-v1", "", "", "2015-11-06 18:51:11", "2015-11-06 17:51:11", "", "8", "http://demo.ec-arlon.be/2015/11/06/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("10", "1", "2015-11-06 18:51:23", "2015-11-06 17:51:23", "Chers parents, nous avons de temps à autre des problèmes de serveur pour mettre les repas à jour. N\'oubliez pas que vous pouvez également consulter la version \"papier\" des menus aux valves de chaque école.\r\n\r\nEn vous remerciant pour votre compréhension.<strong><strong>\r\n</strong></strong>\r\n\r\n&nbsp;\r\n\r\n[table id=2 /]\r\n\r\n&nbsp;\r\n\r\n[table id=3 /]", "Menu de la semaine", "", "publish", "closed", "closed", "", "menu-de-la-semaine", "", "", "2015-11-06 20:05:57", "2015-11-06 19:05:57", "", "0", "http://demo.ec-arlon.be/?page_id=10", "0", "page", "", "0");
INSERT INTO `wp_root_posts` VALUES("11", "1", "2015-11-06 18:51:23", "2015-11-06 17:51:23", "Menu de la semaine", "Menu de la semaine", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2015-11-06 18:51:23", "2015-11-06 17:51:23", "", "10", "http://demo.ec-arlon.be/2015/11/06/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("12", "1", "2015-11-06 18:51:36", "2015-11-06 17:51:36", "Documents\r\n\r\n[fileaway type=\"table\"]", "Documents", "", "publish", "closed", "closed", "", "documents", "", "", "2015-11-06 19:19:12", "2015-11-06 18:19:12", "", "0", "http://demo.ec-arlon.be/?page_id=12", "0", "page", "", "0");
INSERT INTO `wp_root_posts` VALUES("13", "1", "2015-11-06 18:51:36", "2015-11-06 17:51:36", "Documents", "Documents", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2015-11-06 18:51:36", "2015-11-06 17:51:36", "", "12", "http://demo.ec-arlon.be/2015/11/06/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("14", "1", "2015-11-06 18:51:51", "2015-11-06 17:51:51", "[fileaway type=\"table\" makedir=\"true\" size=\"no\" manager=\"on\" role_override=\"administrator\" dirman_access=\"administrator\"]\r\n<pre>[private role=\"administrator\"][fileup][/private]</pre>\r\n&nbsp;", "Projets d\'établissements", "", "publish", "closed", "closed", "", "projets-detablissements", "", "", "2015-12-05 11:37:11", "2015-12-05 10:37:11", "", "0", "http://demo.ec-arlon.be/?page_id=14", "0", "page", "", "0");
INSERT INTO `wp_root_posts` VALUES("15", "1", "2015-11-06 18:51:51", "2015-11-06 17:51:51", "Projets d\'établissements", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-11-06 18:51:51", "2015-11-06 17:51:51", "", "14", "http://demo.ec-arlon.be/2015/11/06/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("16", "1", "2015-11-06 18:54:59", "2015-11-06 17:54:59", "", "Projets d\'établissements", "", "publish", "closed", "closed", "", "projets-detablissements", "", "", "2015-11-19 19:34:02", "2015-11-19 18:34:02", "", "0", "http://demo.ec-arlon.be/?p=16", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("17", "1", "2015-11-06 18:54:59", "2015-11-06 17:54:59", " ", "", "", "publish", "closed", "closed", "", "17", "", "", "2015-11-19 19:34:02", "2015-11-19 18:34:02", "", "0", "http://demo.ec-arlon.be/?p=17", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("18", "1", "2015-11-06 18:54:59", "2015-11-06 17:54:59", " ", "", "", "publish", "closed", "closed", "", "18", "", "", "2015-11-19 19:34:02", "2015-11-19 18:34:02", "", "0", "http://demo.ec-arlon.be/?p=18", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("19", "1", "2015-11-06 18:54:59", "2015-11-06 17:54:59", " ", "", "", "publish", "closed", "closed", "", "19", "", "", "2015-11-19 19:34:02", "2015-11-19 18:34:02", "", "0", "http://demo.ec-arlon.be/?p=19", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("20", "1", "2015-11-06 18:54:59", "2015-11-06 17:54:59", "", "Accueil", "", "publish", "closed", "closed", "", "20", "", "", "2015-11-19 19:34:02", "2015-11-19 18:34:02", "", "0", "http://demo.ec-arlon.be/?p=20", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("21", "1", "2015-11-06 18:58:46", "2015-11-06 17:58:46", "", "Udange", "", "publish", "closed", "closed", "", "udange", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=21", "14", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("22", "1", "2015-11-06 19:08:29", "2015-11-06 18:08:29", "[[\"\",\"Matin\",\"Apr\\u00e8s-midi\"],[\"<strong>Lundi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"<strong>Mardi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"<strong>Mercredi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"\"],[\"<strong>Jeudi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"<strong>Vendredi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"]]", "Horaires", "", "publish", "closed", "closed", "", "horaires", "", "", "2015-11-06 19:14:56", "2015-11-06 18:14:56", "", "0", "http://demo.ec-arlon.be/?post_type=tablepress_table&#038;p=22", "0", "tablepress_table", "application/json", "0");
INSERT INTO `wp_root_posts` VALUES("23", "1", "2015-11-06 19:10:40", "2015-11-06 18:10:40", "[[\"\",\"Matin\",\"Apr\\u00e8s-midi\"],[\"Lundi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Mardin\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Mercredi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Jeudi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Vendredi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"]]", "Horaires", "", "inherit", "closed", "closed", "", "22-revision-v1", "", "", "2015-11-06 19:10:40", "2015-11-06 18:10:40", "", "22", "http://demo.ec-arlon.be/2015/11/06/22-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("24", "1", "2015-11-06 19:11:23", "2015-11-06 18:11:23", "Les cours se donnent comme suit :\r\n\r\n[table id=1 /]\r\n\r\nL\'accès et la surveillance de la cour de l\'école se font à partir de 08:15 le matin et 13:15 l\'après midi.\r\n\r\nSi les enfants arrivent avant 08:15, ils doivent  obligatoirement  se rendre à la garderie.\r\n\r\nS\'ils ne sont pas inscrits à la cantine,  ils ne peuvent pas se présenter  à l\'école avant 13:15.", "Horaires", "", "inherit", "closed", "closed", "", "8-revision-v1", "", "", "2015-11-06 19:11:23", "2015-11-06 18:11:23", "", "8", "http://demo.ec-arlon.be/2015/11/06/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("25", "1", "2015-11-06 19:12:42", "2015-11-06 18:12:42", "[[\"\",\"Matin\",\"Apr\\u00e8s-midi\"],[\"Lundi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Mardi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Mercredi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Jeudi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Vendredi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"]]", "Horaires", "", "inherit", "closed", "closed", "", "22-revision-v1", "", "", "2015-11-06 19:12:42", "2015-11-06 18:12:42", "", "22", "http://demo.ec-arlon.be/2015/11/06/22-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("26", "1", "2015-11-06 19:12:53", "2015-11-06 18:12:53", "[[\"\",\"Matin\",\"Apr\\u00e8s-midi\"],[\"Lundi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Mardi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Mercredi\",\"08:30 \\t\\u00e0 \\t12:05\",\"\"],[\"Jeudi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"Vendredi\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"]]", "Horaires", "", "inherit", "closed", "closed", "", "22-revision-v1", "", "", "2015-11-06 19:12:53", "2015-11-06 18:12:53", "", "22", "http://demo.ec-arlon.be/2015/11/06/22-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("27", "1", "2015-11-06 19:13:34", "2015-11-06 18:13:34", "Les cours se donnent comme suit :\r\n\r\n[table id=1 /]\r\n\r\nL\'accès et la surveillance de la cour de l\'école se font à partir de 08:15 le matin et 13:15 l\'après midi.\r\n\r\nSi les enfants arrivent avant 08:15, ils doivent <strong>obligatoirement</strong> se rendre à la garderie.\r\n\r\nS\'ils ne sont pas inscrits à la cantine, <strong>ils ne peuvent pas se présenter</strong> à l\'école avant 13:15.", "Horaires", "", "inherit", "closed", "closed", "", "8-revision-v1", "", "", "2015-11-06 19:13:34", "2015-11-06 18:13:34", "", "8", "http://demo.ec-arlon.be/2015/11/06/8-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("28", "1", "2015-11-06 19:14:56", "2015-11-06 18:14:56", "[[\"\",\"Matin\",\"Apr\\u00e8s-midi\"],[\"<strong>Lundi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"<strong>Mardi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"<strong>Mercredi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"\"],[\"<strong>Jeudi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"],[\"<strong>Vendredi<\\/strong>\",\"08:30 \\t\\u00e0 \\t12:05\",\"13:30 \\t\\u00e0 \\t15:30\"]]", "Horaires", "", "inherit", "closed", "closed", "", "22-revision-v1", "", "", "2015-11-06 19:14:56", "2015-11-06 18:14:56", "", "22", "http://demo.ec-arlon.be/2015/11/06/22-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("29", "1", "2015-11-06 19:19:12", "2015-11-06 18:19:12", "Documents\r\n\r\n[fileaway type=\"table\"]", "Documents", "", "inherit", "closed", "closed", "", "12-revision-v1", "", "", "2015-11-06 19:19:12", "2015-11-06 18:19:12", "", "12", "http://demo.ec-arlon.be/2015/11/06/12-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("31", "1", "2015-11-06 19:21:25", "2015-11-06 18:21:25", "[fileaway type=\"table\"]", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-11-06 19:21:25", "2015-11-06 18:21:25", "", "14", "http://demo.ec-arlon.be/2015/11/06/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("30", "1", "2015-11-06 19:19:41", "2015-11-06 18:19:41", "Projets d\'établissements\r\n\r\n[fileaway type=\"table\"]", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-11-06 19:19:41", "2015-11-06 18:19:41", "", "14", "http://demo.ec-arlon.be/2015/11/06/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("32", "1", "2015-11-06 19:24:55", "2015-11-06 18:24:55", "Chers parents, nous avons de temps à autre des problèmes de serveur pour mettre les repas à jour. N\'oubliez pas que vous pouvez également consulter la version \"papier\" des menus aux valves de chaque école.\r\n\r\nEn vous remerciant pour votre compréhension.<strong><strong>\r\n</strong></strong>", "Menu de la semaine", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2015-11-06 19:24:55", "2015-11-06 18:24:55", "", "10", "http://demo.ec-arlon.be/2015/11/06/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("33", "1", "2015-11-06 19:30:28", "2015-11-06 18:30:28", "Chers parents, nous avons de temps à autre des problèmes de serveur pour mettre les repas à jour. N\'oubliez pas que vous pouvez également consulter la version \"papier\" des menus aux valves de chaque école.\n\nEn vous remerciant pour votre compréhension.<strong><strong>\n</strong></strong>\n\n&nbsp;\n<h3>Semaine du 26 au 30 octobre</h3>\n&nbsp;\n\n[table id=2 /]\n<h3>Semaine du 9 au 13 novembre</h3>", "Menu de la semaine", "", "inherit", "closed", "closed", "", "10-autosave-v1", "", "", "2015-11-06 19:30:28", "2015-11-06 18:30:28", "", "10", "http://demo.ec-arlon.be/2015/11/06/10-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("34", "1", "2015-11-06 19:26:06", "2015-11-06 18:26:06", "Chers parents, nous avons de temps à autre des problèmes de serveur pour mettre les repas à jour. N\'oubliez pas que vous pouvez également consulter la version \"papier\" des menus aux valves de chaque école.\r\n\r\nEn vous remerciant pour votre compréhension.<strong><strong>\r\n</strong></strong>\r\n\r\n&nbsp;\r\n<h3>Semaine du 26 au 30 octobre</h3>\r\n&nbsp;\r\n<h3>semaine du 9 au 13 novembre</h3>", "Menu de la semaine", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2015-11-06 19:26:06", "2015-11-06 18:26:06", "", "10", "http://demo.ec-arlon.be/2015/11/06/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("35", "1", "2015-11-06 19:27:59", "2015-11-06 18:27:59", "[[\"\",\"Potage\",\"Plat\",\"Dessert\"],[\"<strong>Lundi<\\/strong>\",\"Bouillon\",\"R\\u00f4ti de porc\\nPommes de terre\\nHaricots au beurre\",\"Fruit\"],[\"<strong>Mardi<\\/strong>\",\"Mange-tout\",\"Saucisse de poulet sauce proven\\u00e7ale\\nP\\u00e2tes\",\"Yaourt\"],[\"<strong>Mercredi<\\/strong>\",\"Oignon\",\"Poisson pan\\u00e9\\nRiz pilaf aux petits l\\u00e9gumes\",\"Friandise\"],[\"<strong>Jeudi<\\/strong>\",\"Brocoli\",\"Escalope de poulet croquante\\nPetits pois et ma\\u00efs\\nPommes de terre\",\"Friandise\"],[\"<strong>Vendredi<\\/strong>\",\"Poireaux\",\"Oiseau sans t\\u00eate (porc)\\nPur\\u00e9e\\nSalade\",\"Fruit\"]]", "Semaine du 26 au 30 octobre", "", "publish", "closed", "closed", "", "menu-de-la-semaine-1", "", "", "2015-11-06 20:05:47", "2015-11-06 19:05:47", "", "0", "http://demo.ec-arlon.be/?post_type=tablepress_table&#038;p=35", "0", "tablepress_table", "application/json", "0");
INSERT INTO `wp_root_posts` VALUES("36", "1", "2015-11-06 19:29:12", "2015-11-06 18:29:12", "[[\"\",\"Potage\",\"Plat\",\"Dessert\"],[\"<strong>Lundi<\\/strong>\",\"\",\"\",\"\"],[\"<strong>Mardi<\\/strong>\",\"\",\"\",\"\"],[\"<strong>Mercredi<\\/strong>\",\"\",\"\",\"\"],[\"<strong>Jeudi<\\/strong>\",\"\",\"\",\"\"],[\"<strong>Vendredi<\\/strong>\",\"\",\"\",\"\"]]", "Menu de la semaine 1", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2015-11-06 19:29:12", "2015-11-06 18:29:12", "", "35", "http://demo.ec-arlon.be/2015/11/06/35-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("66", "1", "2015-11-06 20:05:57", "2015-11-06 19:05:57", "Chers parents, nous avons de temps à autre des problèmes de serveur pour mettre les repas à jour. N\'oubliez pas que vous pouvez également consulter la version \"papier\" des menus aux valves de chaque école.\r\n\r\nEn vous remerciant pour votre compréhension.<strong><strong>\r\n</strong></strong>\r\n\r\n&nbsp;\r\n\r\n[table id=2 /]\r\n\r\n&nbsp;\r\n\r\n[table id=3 /]", "Menu de la semaine", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2015-11-06 20:05:57", "2015-11-06 19:05:57", "", "10", "http://demo.ec-arlon.be/2015/11/06/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("37", "1", "2015-11-06 19:29:26", "2015-11-06 18:29:26", "Chers parents, nous avons de temps à autre des problèmes de serveur pour mettre les repas à jour. N\'oubliez pas que vous pouvez également consulter la version \"papier\" des menus aux valves de chaque école.\r\n\r\nEn vous remerciant pour votre compréhension.<strong><strong>\r\n</strong></strong>\r\n\r\n&nbsp;\r\n<h3>Semaine du 26 au 30 octobre</h3>\r\n[table id=2 /]\r\n<h3>Semaine du 9 au 13 novembre</h3>", "Menu de la semaine", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2015-11-06 19:29:26", "2015-11-06 18:29:26", "", "10", "http://demo.ec-arlon.be/2015/11/06/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("38", "1", "2015-11-06 19:31:15", "2015-11-06 18:31:15", "[[\"\",\"Potage\",\"Plat\",\"Dessert\"],[\"<strong>Lundi<\\/strong>\",\"Bouillon\",\"R\\u00f4ti de porc\\nPommes de terre\\nHaricots au beurre\",\"Fruit\"],[\"<strong>Mardi<\\/strong>\",\"Mange-tout\",\"Saucisse de poulet sauce proven\\u00e7ale\\nP\\u00e2tes\",\"Yaourt\"],[\"<strong>Mercredi<\\/strong>\",\"Oignon\",\"Poisson pan\\u00e9\\nRiz pilaf aux petits l\\u00e9gumes\",\"Friandise\"],[\"<strong>Jeudi<\\/strong>\",\"Brocoli\",\"Escalope de poulet croquante\\nPetits pois et ma\\u00efs\\nPommes de terre\",\"Friandise\"],[\"<strong>Vendredi<\\/strong>\",\"Poireaux\",\"Oiseau sans t\\u00eate (porc)\\nPur\\u00e9e\\nSalade\",\"Fruit\"]]", "Menu de la semaine 1", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2015-11-06 19:31:15", "2015-11-06 18:31:15", "", "35", "http://demo.ec-arlon.be/2015/11/06/35-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("39", "1", "2015-11-06 19:31:43", "2015-11-06 18:31:43", "[[\"\",\"Potage\",\"Plat\",\"Dessert\"],[\"<strong>Lundi<\\/strong>\",\"Bouillon\",\"R\\u00f4ti de porc\\nPommes de terre\\nHaricots au beurre\",\"Fruit\"],[\"<strong>Mardi<\\/strong>\",\"Mange-tout\",\"Saucisse de poulet sauce proven\\u00e7ale\\nP\\u00e2tes\",\"Yaourt\"],[\"<strong>Mercredi<\\/strong>\",\"Oignon\",\"Poisson pan\\u00e9\\nRiz pilaf aux petits l\\u00e9gumes\",\"Friandise\"],[\"<strong>Jeudi<\\/strong>\",\"Brocoli\",\"Escalope de poulet croquante\\nPetits pois et ma\\u00efs\\nPommes de terre\",\"Friandise\"],[\"<strong>Vendredi<\\/strong>\",\"Poireaux\",\"Oiseau sans t\\u00eate (porc)\\nPur\\u00e9e\\nSalade\",\"Fruit\"]]", "Semaine du 9 au 13 novembre", "", "publish", "closed", "closed", "", "copie-de-menu-de-la-semaine-1", "", "", "2015-11-06 20:05:20", "2015-11-06 19:05:20", "", "0", "http://demo.ec-arlon.be/?post_type=tablepress_table&#038;p=39", "0", "tablepress_table", "application/json", "0");
INSERT INTO `wp_root_posts` VALUES("40", "1", "2015-11-06 19:31:56", "2015-11-06 18:31:56", "[[\"\",\"Potage\",\"Plat\",\"Dessert\"],[\"<strong>Lundi<\\/strong>\",\"Bouillon\",\"R\\u00f4ti de porc\\nPommes de terre\\nHaricots au beurre\",\"Fruit\"],[\"<strong>Mardi<\\/strong>\",\"Mange-tout\",\"Saucisse de poulet sauce proven\\u00e7ale\\nP\\u00e2tes\",\"Yaourt\"],[\"<strong>Mercredi<\\/strong>\",\"Oignon\",\"Poisson pan\\u00e9\\nRiz pilaf aux petits l\\u00e9gumes\",\"Friandise\"],[\"<strong>Jeudi<\\/strong>\",\"Brocoli\",\"Escalope de poulet croquante\\nPetits pois et ma\\u00efs\\nPommes de terre\",\"Friandise\"],[\"<strong>Vendredi<\\/strong>\",\"Poireaux\",\"Oiseau sans t\\u00eate (porc)\\nPur\\u00e9e\\nSalade\",\"Fruit\"]]", "Menu de la semaine 2", "", "inherit", "closed", "closed", "", "39-revision-v1", "", "", "2015-11-06 19:31:56", "2015-11-06 18:31:56", "", "39", "http://demo.ec-arlon.be/2015/11/06/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("63", "1", "2015-11-06 20:03:16", "2015-11-06 19:03:16", "Chers parents, nous avons de temps à autre des problèmes de serveur pour mettre les repas à jour. N\'oubliez pas que vous pouvez également consulter la version \"papier\" des menus aux valves de chaque école.\r\n\r\nEn vous remerciant pour votre compréhension.<strong><strong>\r\n</strong></strong>\r\n\r\n&nbsp;\r\n<h3>Semaine du 26 au 30 octobre</h3>\r\n&nbsp;\r\n\r\n[table id=2 /]\r\n\r\n&nbsp;\r\n\r\n[table id=3 /]", "Menu de la semaine", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2015-11-06 20:03:16", "2015-11-06 19:03:16", "", "10", "http://demo.ec-arlon.be/2015/11/06/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("41", "1", "2015-11-06 19:32:07", "2015-11-06 18:32:07", "Chers parents, nous avons de temps à autre des problèmes de serveur pour mettre les repas à jour. N\'oubliez pas que vous pouvez également consulter la version \"papier\" des menus aux valves de chaque école.\r\n\r\nEn vous remerciant pour votre compréhension.<strong><strong>\r\n</strong></strong>\r\n\r\n&nbsp;\r\n<h3>Semaine du 26 au 30 octobre</h3>\r\n&nbsp;\r\n\r\n[table id=2 /]\r\n<h3>Semaine du 9 au 13 novembre</h3>\r\n&nbsp;\r\n\r\n[table id=3 /]", "Menu de la semaine", "", "inherit", "closed", "closed", "", "10-revision-v1", "", "", "2015-11-06 19:32:07", "2015-11-06 18:32:07", "", "10", "http://demo.ec-arlon.be/2015/11/06/10-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("42", "1", "2015-11-06 19:41:19", "2015-11-06 18:41:19", "", "Barnich", "", "publish", "closed", "closed", "", "barnich", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=42", "1", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("43", "1", "2015-11-06 19:41:19", "2015-11-06 18:41:19", "", "Centre", "", "publish", "closed", "closed", "", "centre", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=43", "2", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("44", "1", "2015-11-06 19:41:19", "2015-11-06 18:41:19", "", "Fouches", "", "publish", "closed", "closed", "", "fouches", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=44", "3", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("45", "1", "2015-11-06 19:41:19", "2015-11-06 18:41:19", "", "Frassem", "", "publish", "closed", "closed", "", "frassem", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=45", "4", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("46", "1", "2015-11-06 19:41:19", "2015-11-06 18:41:19", "", "Freylange", "", "publish", "closed", "closed", "", "freylange", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=46", "5", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("47", "1", "2015-11-06 19:41:19", "2015-11-06 18:41:19", "", "Galgenberg", "", "publish", "closed", "closed", "", "galgenberg", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=47", "6", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("48", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Heinsch", "", "publish", "closed", "closed", "", "heinsch", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=48", "7", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("49", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Lilas", "", "publish", "closed", "closed", "", "lilas", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=49", "8", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("50", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Neufchâteau", "", "publish", "closed", "closed", "", "neufchateau", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=50", "9", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("51", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Schoppach", "", "publish", "closed", "closed", "", "schoppach", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=51", "10", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("52", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Sterpenich", "", "publish", "closed", "closed", "", "sterpenich", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=52", "11", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("53", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Stockem", "", "publish", "closed", "closed", "", "stockem", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=53", "12", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("54", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Toernich", "", "publish", "closed", "closed", "", "toernich", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=54", "13", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("55", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Waltzing", "", "publish", "closed", "closed", "", "waltzing", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=55", "15", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("56", "1", "2015-11-06 19:41:20", "2015-11-06 18:41:20", "", "Weyler", "", "publish", "closed", "closed", "", "weyler", "", "", "2015-11-19 18:47:46", "2015-11-19 17:47:46", "", "0", "http://demo.ec-arlon.be/?p=56", "16", "nav_menu_item", "", "0");
INSERT INTO `wp_root_posts` VALUES("57", "1", "2015-11-06 19:42:45", "2015-11-06 18:42:45", "Page d\'accueil", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 19:42:45", "2015-11-06 18:42:45", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("58", "1", "2015-11-06 19:43:30", "2015-11-06 18:43:30", "<dl><dt>\r\n<h4>Renseignements concernant les écoles communales:</h4>\r\n</dt><dt><strong>Coordinatrice enseignement</strong> : Mme SIMON</dt><dt>\r\nService Enseignement</dt><dt>Hôtel de Ville (étage B3)</dt><dt>Rue Paul Reuter, 8</dt><dt>6700 ARLON</dt><dt>Tél: 063 245 661</dt><dt>Tous les jours de 8h30 à 12h00 et de 13h00 à 16h00</dt></dl>", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 19:43:30", "2015-11-06 18:43:30", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("61", "1", "2015-11-06 19:45:13", "2015-11-06 18:45:13", "dsqdsq", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 19:45:13", "2015-11-06 18:45:13", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("59", "1", "2015-11-06 19:43:49", "2015-11-06 18:43:49", "<dl><dt>\r\n<h4>Renseignements concernant les écoles communales:</h4>\r\n</dt><dt><strong>Coordinatrice enseignement</strong> : Mme SIMON\r\n\r\n</dt><dt>Service Enseignement\r\n\r\n</dt><dt>Hôtel de Ville (étage B3)\r\n\r\n</dt><dt>Rue Paul Reuter, 8\r\n\r\n</dt><dt>6700 ARLON\r\n\r\n</dt><dt>Tél: 063 245 661\r\n\r\n</dt><dt>Tous les jours de 8h30 à 12h00 et de 13h00 à 16h00\r\n\r\n</dt></dl>", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 19:43:49", "2015-11-06 18:43:49", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("60", "1", "2015-11-06 19:44:50", "2015-11-06 18:44:50", "<dl><dt>dsqdqs\r\n<h4>Renseignements concernant les écoles communales:</h4>\r\n</dt><dt><strong>Coordinatrice enseignement</strong> : Mme SIMON</dt><dt>Service Enseignement</dt><dt>Hôtel de Ville (étage B3)</dt><dt>Rue Paul Reuter, 8</dt><dt>6700 ARLON</dt><dt>Tél: 063 245 661</dt><dt>Tous les jours de 8h30 à 12h00 et de 13h00 à 16h00</dt></dl>", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 19:44:50", "2015-11-06 18:44:50", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("62", "1", "2015-11-06 19:45:50", "2015-11-06 18:45:50", "<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 19:45:50", "2015-11-06 18:45:50", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("64", "1", "2015-11-06 20:05:20", "2015-11-06 19:05:20", "[[\"\",\"Potage\",\"Plat\",\"Dessert\"],[\"<strong>Lundi<\\/strong>\",\"Bouillon\",\"R\\u00f4ti de porc\\nPommes de terre\\nHaricots au beurre\",\"Fruit\"],[\"<strong>Mardi<\\/strong>\",\"Mange-tout\",\"Saucisse de poulet sauce proven\\u00e7ale\\nP\\u00e2tes\",\"Yaourt\"],[\"<strong>Mercredi<\\/strong>\",\"Oignon\",\"Poisson pan\\u00e9\\nRiz pilaf aux petits l\\u00e9gumes\",\"Friandise\"],[\"<strong>Jeudi<\\/strong>\",\"Brocoli\",\"Escalope de poulet croquante\\nPetits pois et ma\\u00efs\\nPommes de terre\",\"Friandise\"],[\"<strong>Vendredi<\\/strong>\",\"Poireaux\",\"Oiseau sans t\\u00eate (porc)\\nPur\\u00e9e\\nSalade\",\"Fruit\"]]", "Semaine du 9 au 13 novembre", "", "inherit", "closed", "closed", "", "39-revision-v1", "", "", "2015-11-06 20:05:20", "2015-11-06 19:05:20", "", "39", "http://demo.ec-arlon.be/2015/11/06/39-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("65", "1", "2015-11-06 20:05:47", "2015-11-06 19:05:47", "[[\"\",\"Potage\",\"Plat\",\"Dessert\"],[\"<strong>Lundi<\\/strong>\",\"Bouillon\",\"R\\u00f4ti de porc\\nPommes de terre\\nHaricots au beurre\",\"Fruit\"],[\"<strong>Mardi<\\/strong>\",\"Mange-tout\",\"Saucisse de poulet sauce proven\\u00e7ale\\nP\\u00e2tes\",\"Yaourt\"],[\"<strong>Mercredi<\\/strong>\",\"Oignon\",\"Poisson pan\\u00e9\\nRiz pilaf aux petits l\\u00e9gumes\",\"Friandise\"],[\"<strong>Jeudi<\\/strong>\",\"Brocoli\",\"Escalope de poulet croquante\\nPetits pois et ma\\u00efs\\nPommes de terre\",\"Friandise\"],[\"<strong>Vendredi<\\/strong>\",\"Poireaux\",\"Oiseau sans t\\u00eate (porc)\\nPur\\u00e9e\\nSalade\",\"Fruit\"]]", "Semaine du 26 au 30 octobre", "", "inherit", "closed", "closed", "", "35-revision-v1", "", "", "2015-11-06 20:05:47", "2015-11-06 19:05:47", "", "35", "http://demo.ec-arlon.be/2015/11/06/35-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("67", "1", "2015-11-06 20:09:19", "2015-11-06 19:09:19", "[fileaway type=\"table\"]\r\n\r\n&nbsp;\r\n\r\n[fileup]", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-11-06 20:09:19", "2015-11-06 19:09:19", "", "14", "http://demo.ec-arlon.be/2015/11/06/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("68", "1", "2015-11-06 20:14:01", "2015-11-06 19:14:01", "[fileup]", "Ajouter des documents", "", "trash", "closed", "closed", "", "ajouter-des-documents", "", "", "2015-11-06 20:22:46", "2015-11-06 19:22:46", "", "0", "http://demo.ec-arlon.be/?page_id=68", "0", "page", "", "0");
INSERT INTO `wp_root_posts` VALUES("69", "1", "2015-11-06 20:14:01", "2015-11-06 19:14:01", "[fileup]", "Ajouter des documents", "", "inherit", "closed", "closed", "", "68-revision-v1", "", "", "2015-11-06 20:14:01", "2015-11-06 19:14:01", "", "68", "http://demo.ec-arlon.be/2015/11/06/68-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("70", "1", "2015-11-06 20:14:29", "2015-11-06 19:14:29", "[fileaway type=\"table\"]\r\n\r\n&nbsp;", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-11-06 20:14:29", "2015-11-06 19:14:29", "", "14", "http://demo.ec-arlon.be/2015/11/06/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("74", "1", "2015-11-25 14:35:01", "2015-11-25 13:35:01", "<table border=\"2\">\n<thead>\n<tr>\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\n063/22.62.64\nDir.: Me SKA</td>\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\n063/22.14.94\nDir.: Me SKA</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\n063/22.17.94\nDir.: Mr NEY</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\nPrimaire: 063/21.80.08Maternelle: 063/22.22.74\nDir.: Mr NEY</td>\n</tr>\n</thead>\n<tbody>\n<tr>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\n063/22.58.35\nDir.: Me DUMONT</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\n063/23.71.84\nDir.: Me DUMONT</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\n063/22.52.40\nDir.: Mr SIMON</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\n063/22.44.21\nDir.: Mr SIMON</td>\n</tr>\n<tr>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\n063/22.52.40\nDir.: Mr BILLO</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\n063/22.52.40\nDir.: Mr BILLO</td>\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\n063/22.52.40\nDir.: Mr BILLO</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\n063/22.52.40\nDir.: Mr Thilmany</td>\n</tr>\n<tr>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\n063/22.62.58\nDir.: Me COLLIN</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\n063/22.52.40\nDir.: Me COLLIN</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\n063/22.52.40\nDir.: Me COLLIN</td>\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\n063/22.52.40\nDir.: Me BOURTON</td>\n</tr>\n</tbody>\n</table>\n&nbsp;\n<h4>Renseignements concernant les écoles communales</h4>\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\nService Enseignement\nHôtel de Ville (étage B3)\nRue Paul Reuter, 8\n6700 ARLON\nTél: 063 245 661\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-autosave-v1", "", "", "2015-11-25 14:35:01", "2015-11-25 13:35:01", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("73", "1", "2015-11-06 20:23:20", "2015-11-06 19:23:20", "[fileaway type=\"table\"]\r\n<pre>[private role=\"administrator\"][fileup][/private]</pre>\r\n&nbsp;", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-11-06 20:23:20", "2015-11-06 19:23:20", "", "14", "http://demo.ec-arlon.be/2015/11/06/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("75", "1", "2015-11-06 20:27:42", "2015-11-06 19:27:42", "<a href=\"http://google.com\" target=\"_blank\">Ecole maternelle du centre</a>\r\n\r\n<a href=\"http://google.com\" target=\"_blank\">Ecole d\'udange</a>\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 20:27:42", "2015-11-06 19:27:42", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("76", "1", "2015-11-06 20:27:56", "2015-11-06 19:27:56", "<ul>\r\n	<li><a href=\"http://google.com\" target=\"_blank\">Ecole maternelle du centre</a></li>\r\n	<li><a href=\"http://google.com\" target=\"_blank\">Ecole d\'udange</a></li>\r\n</ul>\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 20:27:56", "2015-11-06 19:27:56", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("77", "1", "2015-11-06 20:28:58", "2015-11-06 19:28:58", "[[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole rue de Neufch\\u00e2teau<\\/a>\\n063\\/22.62.64\\nDir.: Me SKA\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole de Stockem<\\/a>\\n063\\/22.62.58\\nDir.: Me SKA\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Frassem<\\/a>\\n063\\/22.52.40\\nDir.: Mr NEY\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Waltzing<\\/a>\\n063\\/22.52.40\\nDir.: Mr NEY\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Toernich<\\/a>\\n063\\/22.52.40\\nDir.: Me DUMONT\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Fouches<\\/a>\\n063\\/22.52.40\\nDir.: Me DUMONT\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: Mr SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole du Galgenberg<\\/a>\\n063\\/22.52.40\\nDir.: Mr SIMON\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Weyler<\\/a>\\n063\\/22.52.40\\nDir.: Mr BILLO\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole des Lilas<\\/a>\\n063\\/22.52.40\\nDir.: Mr BILLO\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Heinsch<\\/a>\\n063\\/22.52.40\\nDir.: Mr BILLO\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Schoppach<\\/a>\\n063\\/22.52.40\\nDir.: Mr Thilmany\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Me COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole d\'Udange<\\/a>\\n063\\/22.52.40\\nDir.: Me COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Freylange<\\/a>\\n063\\/22.52.40\\nDir.: Me COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole primaire autonome du centre<\\/a>\\n063\\/22.52.40\\nDir.: Me BOURTON\"]]", "Les écoles", "", "publish", "closed", "closed", "", "les-ecoles", "", "", "2015-11-25 14:08:54", "2015-11-25 13:08:54", "", "0", "http://demo.ec-arlon.be/?post_type=tablepress_table&#038;p=77", "0", "tablepress_table", "application/json", "0");
INSERT INTO `wp_root_posts` VALUES("87", "1", "2015-11-10 20:56:58", "2015-11-10 19:56:58", "[[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole rue de Neufch\\u00e2teau<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Schoppach<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole de Stockem<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Toernich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole d\'Udange<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Waltzing<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Weyler<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Freylange<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole du Galgenberg<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Heinsch<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole des Lilas<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Frassem<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Fouches<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"\"]]", "Les écoles", "", "inherit", "closed", "closed", "", "77-revision-v1", "", "", "2015-11-10 20:56:58", "2015-11-10 19:56:58", "", "77", "http://demo.ec-arlon.be/2015/11/10/77-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("78", "1", "2015-11-06 20:30:46", "2015-11-06 19:30:46", "[[\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"],[\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"],[\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"],[\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"]]", "Les écoles", "", "inherit", "closed", "closed", "", "77-revision-v1", "", "", "2015-11-06 20:30:46", "2015-11-06 19:30:46", "", "77", "http://demo.ec-arlon.be/2015/11/06/77-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("80", "1", "2015-11-06 20:32:40", "2015-11-06 19:32:40", "[table id=4 /]\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 20:32:40", "2015-11-06 19:32:40", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("79", "1", "2015-11-06 20:30:57", "2015-11-06 19:30:57", "<ul>\r\n	<li><a href=\"http://google.com\" target=\"_blank\">Ecole maternelle du centre</a></li>\r\n	<li><a href=\"http://google.com\" target=\"_blank\">Ecole d\'udange</a></li>\r\n</ul>\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 20:30:57", "2015-11-06 19:30:57", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("81", "1", "2015-11-06 20:34:40", "2015-11-06 19:34:40", "[[\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole d\'Udange<\\/a>\\n063.21.79.77\\nDir.: Mme DUMONT\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole primaire autonome du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme BOURTON\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole de Schoppach<\\/a>\\n063.22.14.95\\nDir.: M. THILMANY\"],[\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"],[\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"],[\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"]]", "Les écoles", "", "inherit", "closed", "closed", "", "77-revision-v1", "", "", "2015-11-06 20:34:40", "2015-11-06 19:34:40", "", "77", "http://demo.ec-arlon.be/2015/11/06/77-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("82", "1", "2015-11-06 20:35:34", "2015-11-06 19:35:34", "[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-06 20:35:34", "2015-11-06 19:35:34", "", "6", "http://demo.ec-arlon.be/2015/11/06/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("83", "1", "2015-11-06 21:24:50", "2015-11-06 20:24:50", "Echevinat et service de l’Enseignement\r\n\r\nRue Paul Reuter, 8 (étage B3)\r\n6700 Arlon\r\n063/245 684\r\n\r\n&nbsp;\r\n\r\nCentre Psycho Médico Social de la Communauté française (PMS)\r\n\r\nRue de Sesselich, 61\r\n6700 Arlon\r\n063/220 247\r\n\r\n&nbsp;\r\n\r\nCentre Provincial de Santé\r\n\r\nRue de Sesselich, 161\r\n6700 Arlon\r\n063/225 363\r\n\r\n&nbsp;\r\n\r\nComplexe Sportif de la Spetz\r\n\r\nCarrefour de la Spetz\r\n6700 Arlon\r\n063/217 506 (bureau) – 063/217 598 (piscine) – 063/225 528 (hall)\r\n\r\n&nbsp;\r\n\r\nMaison de la Culture\r\n\r\nParc des Expositions, 1\r\n6700 Arlon\r\n063/245 850\r\n\r\n&nbsp;\r\n\r\nHalte Garderie (enfants jusqu’à 6 ans)\r\n\r\nRue Paul Reuter, 22\r\n6700 Arlon\r\n063/219 948\r\n\r\n&nbsp;\r\n\r\nAccueil extra-scolaire (enfants de 2,5 à 12 ans)\r\n\r\nRenseignements et inscriptions :  063/576 705\r\n\r\nDu lundi au vendredi de 6h45 à 8h30 et de 15h45 à 19h.\r\nLe mercredi de 6h45 à 8h30 et de 12h à 19h.\r\n\r\n&nbsp;\r\n\r\nEthias (compagnie d’assurances)\r\n\r\nRue des Croisiers, 24\r\n4000 Liège\r\n04/220 31 11", "Adresses utiles", "", "publish", "closed", "closed", "", "adresses-utiles", "", "", "2015-11-06 21:26:57", "2015-11-06 20:26:57", "", "0", "http://demo.ec-arlon.be/?page_id=83", "0", "page", "", "0");
INSERT INTO `wp_root_posts` VALUES("84", "1", "2015-11-06 21:24:50", "2015-11-06 20:24:50", "Echevinat et service de l’Enseignement\r\n\r\nRue Paul Reuter, 8 (étage B3)\r\n6700 Arlon\r\n063/245 684\r\n\r\n&nbsp;\r\n\r\nCentre Psycho Médico Social de la Communauté française (PMS)\r\n\r\nRue de Sesselich, 61\r\n6700 Arlon\r\n063/220 247\r\n\r\n&nbsp;\r\n\r\nCentre Provincial de Santé\r\n\r\nRue de Sesselich, 161\r\n6700 Arlon\r\n063/225 363\r\n\r\n&nbsp;\r\n\r\nComplexe Sportif de la Spetz\r\n\r\nCarrefour de la Spetz\r\n6700 Arlon\r\n063/217 506 (bureau) – 063/217 598 (piscine) – 063/225 528 (hall)\r\n\r\n&nbsp;\r\n\r\nMaison de la Culture\r\n\r\nParc des Expositions, 1\r\n6700 Arlon\r\n063/245 850\r\n\r\n&nbsp;\r\n\r\nHalte Garderie (enfants jusqu’à 6 ans)\r\n\r\nRue Paul Reuter, 22\r\n6700 Arlon\r\n063/219 948\r\n\r\n&nbsp;\r\n\r\nAccueil extra-scolaire (enfants de 2,5 à 12 ans)\r\n\r\nRenseignements et inscriptions :  063/576 705\r\n\r\nDu lundi au vendredi de 6h45 à 8h30 et de 15h45 à 19h.\r\nLe mercredi de 6h45 à 8h30 et de 12h à 19h.\r\n\r\n&nbsp;\r\n\r\nEthias (compagnie d’assurances)\r\n\r\nRue des Croisiers, 24\r\n4000 Liège\r\n04/220 31 11", "Adresses utiles", "", "inherit", "closed", "closed", "", "83-revision-v1", "", "", "2015-11-06 21:24:50", "2015-11-06 20:24:50", "", "83", "http://demo.ec-arlon.be/2015/11/06/83-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("86", "1", "2015-11-06 22:14:28", "2015-11-06 21:14:28", "[[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Fouches<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Frassem<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Freylange<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole du Galgenberg<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Heinsch<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole des Lilas<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole rue de Neufch\\u00e2teau<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Schoppach<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole de Stockem<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Toernich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole d\'Udange<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Waltzing<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Weyler<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\"]]", "Les écoles", "", "inherit", "closed", "closed", "", "77-revision-v1", "", "", "2015-11-06 22:14:28", "2015-11-06 21:14:28", "", "77", "http://demo.ec-arlon.be/2015/11/06/77-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("85", "1", "2015-11-06 22:11:52", "2015-11-06 21:11:52", "[[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Fouches<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Frassem<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Mme COLLIN\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: M. SIMON\"]]", "Les écoles", "", "inherit", "closed", "closed", "", "77-revision-v1", "", "", "2015-11-06 22:11:52", "2015-11-06 21:11:52", "", "77", "http://demo.ec-arlon.be/2015/11/06/77-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("89", "1", "2015-11-19 18:48:38", "2015-11-19 17:48:38", "", "header", "", "inherit", "open", "closed", "", "header", "", "", "2015-11-19 18:48:38", "2015-11-19 17:48:38", "", "0", "http://demo.ec-arlon.be/wp-content/uploads/2015/11/header.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_root_posts` VALUES("90", "1", "2015-11-19 18:48:43", "2015-11-19 17:48:43", "http://demo.ec-arlon.be/wp-content/uploads/2015/11/cropped-header.jpg", "cropped-header.jpg", "", "inherit", "open", "closed", "", "cropped-header-jpg", "", "", "2015-11-19 18:48:43", "2015-11-19 17:48:43", "", "0", "http://demo.ec-arlon.be/wp-content/uploads/2015/11/cropped-header.jpg", "0", "attachment", "image/jpeg", "0");
INSERT INTO `wp_root_posts` VALUES("91", "1", "2015-11-25 14:08:54", "2015-11-25 13:08:54", "[[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole rue de Neufch\\u00e2teau<\\/a>\\n063\\/22.62.64\\nDir.: Me SKA\",\"<a href=\\\"http:\\/\\/google.com\\\" target=\\\"_blank\\\">Ecole de Stockem<\\/a>\\n063\\/22.62.58\\nDir.: Me SKA\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Frassem<\\/a>\\n063\\/22.52.40\\nDir.: Mr NEY\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Waltzing<\\/a>\\n063\\/22.52.40\\nDir.: Mr NEY\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Toernich<\\/a>\\n063\\/22.52.40\\nDir.: Me DUMONT\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Fouches<\\/a>\\n063\\/22.52.40\\nDir.: Me DUMONT\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Barnich\\/Sterpenich<\\/a>\\n063\\/22.52.40\\nDir.: Mr SIMON\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole du Galgenberg<\\/a>\\n063\\/22.52.40\\nDir.: Mr SIMON\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Weyler<\\/a>\\n063\\/22.52.40\\nDir.: Mr BILLO\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole des Lilas<\\/a>\\n063\\/22.52.40\\nDir.: Mr BILLO\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Heinsch<\\/a>\\n063\\/22.52.40\\nDir.: Mr BILLO\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Schoppach<\\/a>\\n063\\/22.52.40\\nDir.: Mr Thilmany\"],[\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole maternelle du centre<\\/a>\\n063\\/22.62.58\\nDir.: Me COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole d\'Udange<\\/a>\\n063\\/22.52.40\\nDir.: Me COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole de Freylange<\\/a>\\n063\\/22.52.40\\nDir.: Me COLLIN\",\"<a href=\\\"http:\\/\\/udange2.ec-arlon.be\\\" target=\\\"_blank\\\">Ecole primaire autonome du centre<\\/a>\\n063\\/22.52.40\\nDir.: Me BOURTON\"]]", "Les écoles", "", "inherit", "closed", "closed", "", "77-revision-v1", "", "", "2015-11-25 14:08:54", "2015-11-25 13:08:54", "", "77", "http://demo.ec-arlon.be/2015/11/25/77-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("92", "1", "2015-11-25 14:22:09", "2015-11-25 13:22:09", "<table>\r\n<tbody>\r\n<tr>\r\n<td>Test</td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td>tz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:22:09", "2015-11-25 13:22:09", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("93", "1", "2015-11-25 14:22:36", "2015-11-25 13:22:36", "<table>\r\n<tbody>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td>tz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:22:36", "2015-11-25 13:22:36", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("94", "1", "2015-11-25 14:22:59", "2015-11-25 13:22:59", "<table>\r\n<tbody>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td> <a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.62.58\r\nDir.: Me SKA</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td>tz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:22:59", "2015-11-25 13:22:59", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("96", "1", "2015-11-25 14:25:34", "2015-11-25 13:25:34", "<table border=\"2\">\r\n<tbody>\r\n<tr>\r\n<td>Ecole rue de\r\n\r\nNeufchâteau\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.62.58\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td>tz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:25:34", "2015-11-25 13:25:34", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("95", "1", "2015-11-25 14:23:36", "2015-11-25 13:23:36", "<table>\r\n<tbody>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole rue de </a>\r\n\r\n<a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.62.58\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td>tz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:23:36", "2015-11-25 13:23:36", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("97", "1", "2015-11-25 14:26:11", "2015-11-25 13:26:11", "<table border=\"2\">\r\n<thead>\r\n<tr>\r\n<td>Ecole rue de\r\n\r\nNeufchâteau\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.62.58\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td>tz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:26:11", "2015-11-25 13:26:11", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("98", "1", "2015-11-25 14:26:38", "2015-11-25 13:26:38", "<table border=\"2\">\r\n<thead>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.62.58\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n<td></td>\r\n</tr>\r\n<tr>\r\n<td></td>\r\n<td></td>\r\n<td>tz</td>\r\n<td>tz</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:26:38", "2015-11-25 13:26:38", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("100", "1", "2015-11-25 14:29:13", "2015-11-25 13:29:13", "<table border=\"2\">\r\n<thead>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.62.58\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.52.40\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/22.52.40\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.52.40\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/22.52.40\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/22.52.40\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.52.40\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:29:13", "2015-11-25 13:29:13", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("99", "1", "2015-11-25 14:28:04", "2015-11-25 13:28:04", "<table border=\"2\">\r\n<thead>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.62.58\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\n063/22.52.40\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.52.40\r\nDir.: Me DUMONT</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/22.52.40\r\nDir.: Me DUMONT</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.52.40\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/22.52.40\r\nDir.: Me COLLIN</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/22.52.40\r\nDir.: Me COLLIN</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.52.40\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n\r\n&nbsp;\r\n\r\n[table id=4 /]\r\n\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:28:04", "2015-11-25 13:28:04", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("102", "1", "2015-11-25 14:36:26", "2015-11-25 13:36:26", "<table border=\"2\">\r\n<thead>\r\n<tr>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.14.94\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.17.94\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\nPrimaire: 063/21.80.08Maternelle: 063/22.22.74\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.58.35\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/23.71.84\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.44.21\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/21.91.06\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/21.81.34\r\nDir.: Mr BILLO</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.50.35\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.14.95\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/21.79.77\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.62.58\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:36:26", "2015-11-25 13:36:26", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("101", "1", "2015-11-25 14:32:58", "2015-11-25 13:32:58", "<table border=\"2\">\r\n<thead>\r\n<tr>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.14.94\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.17.94\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\nPrimaire: 063/21.80.08\r\n\r\nMaternelle: 063/22.22.74\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.52.40\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/22.52.40\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.52.40\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.52.40\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/22.52.40\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/22.52.40\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.52.40\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:32:58", "2015-11-25 13:32:58", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("104", "1", "2015-11-25 14:39:04", "2015-11-25 13:39:04", "<table style=\"border-color: #000000;\" border=\"1\">\r\n<thead>\r\n<tr>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.14.94\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.17.94\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\nPrimaire: 063/21.80.08Maternelle: 063/22.22.74\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.58.35\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/23.71.84\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.44.21\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/21.91.06\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/21.81.34\r\nDir.: Mr BILLO</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.50.35\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.14.95\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/21.79.77\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.62.58\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:39:04", "2015-11-25 13:39:04", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("103", "1", "2015-11-25 14:38:13", "2015-11-25 13:38:13", "<table style=\"width: 25%;\">\r\n<thead>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td style=\"text-align: center;\"><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.14.94\r\nDir.: Me SKA</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.17.94\r\nDir.: Mr NEY</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\nPrimaire: 063/21.80.08Maternelle: 063/22.22.74\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.58.35\r\nDir.: Me DUMONT</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/23.71.84\r\nDir.: Me DUMONT</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.44.21\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/21.91.06\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/21.81.34\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.50.35\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.14.95\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/21.79.77\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.62.58\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:38:13", "2015-11-25 13:38:13", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("105", "1", "2015-11-25 14:39:15", "2015-11-25 13:39:15", "<table style=\"border-color: #000000;\" border=\"1\">\r\n<thead>\r\n<tr>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.14.94\r\nDir.: Me SKA</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.17.94\r\nDir.: Mr NEY</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\nPrimaire: 063/21.80.08\r\n\r\nMaternelle: 063/22.22.74\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.58.35\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/23.71.84\r\nDir.: Me DUMONT</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.44.21\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/21.91.06\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/21.81.34\r\nDir.: Mr BILLO</td>\r\n<td> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.50.35\r\nDir.: Mr BILLO</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.14.95\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/21.79.77\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/\r\nDir.: Me COLLIN</td>\r\n<td><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.62.58\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:39:15", "2015-11-25 13:39:15", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("106", "1", "2015-11-25 14:40:16", "2015-11-25 13:40:16", "<table>\r\n<thead>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td style=\"text-align: center;\"><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.14.94\r\nDir.: Me SKA</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.17.94\r\nDir.: Mr NEY</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\nPrimaire: 063/21.80.08Maternelle: 063/22.22.74\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.58.35\r\nDir.: Me DUMONT</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/23.71.84\r\nDir.: Me DUMONT</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.44.21\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/21.91.06\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/21.81.34\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.50.35\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.14.95\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/21.79.77\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.62.58\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:40:16", "2015-11-25 13:40:16", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("107", "1", "2015-11-25 14:40:34", "2015-11-25 13:40:34", "<table>\r\n<thead>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://google.com\" target=\"_blank\">Ecole rue de Neufchâteau</a>\r\n063/22.62.64\r\nDir.: Me SKA</td>\r\n<td style=\"text-align: center;\"><a href=\"http://google.com\" target=\"_blank\">Ecole de Stockem</a>\r\n063/22.14.94\r\nDir.: Me SKA</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Frassem</a>\r\n063/22.17.94\r\nDir.: Mr NEY</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Waltzing</a>\r\nPrimaire: 063/21.80.08 Maternelle: 063/22.22.74\r\nDir.: Mr NEY</td>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Toernich</a>\r\n063/22.58.35\r\nDir.: Me DUMONT</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Fouches</a>\r\n063/23.71.84\r\nDir.: Me DUMONT</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Barnich/Sterpenich</a>\r\n063/22.52.40\r\nDir.: Mr SIMON</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole du Galgenberg</a>\r\n063/22.44.21\r\nDir.: Mr SIMON</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Weyler</a>\r\n063/21.91.06\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole des Lilas</a>\r\n063/21.81.34\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"> <a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Heinsch</a>\r\n063/22.50.35\r\nDir.: Mr BILLO</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Schoppach</a>\r\n063/22.14.95\r\nDir.: Mr Thilmany</td>\r\n</tr>\r\n<tr>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole maternelle du centre</a>\r\n063/22.62.58\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole d\'Udange</a>\r\n063/21.79.77\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole de Freylange</a>\r\n063/\r\nDir.: Me COLLIN</td>\r\n<td style=\"text-align: center;\"><a href=\"http://udange2.ec-arlon.be\" target=\"_blank\">Ecole primaire autonome du centre</a>\r\n063/22.62.58\r\nDir.: Me BOURTON</td>\r\n</tr>\r\n</tbody>\r\n</table>\r\n&nbsp;\r\n<h4>Renseignements concernant les écoles communales</h4>\r\n<strong>Coordinatrice enseignement</strong> : Mme SIMON\r\nService Enseignement\r\nHôtel de Ville (étage B3)\r\nRue Paul Reuter, 8\r\n6700 ARLON\r\nTél: 063 245 661\r\nTous les jours de 8h30 à 12h00 et de 13h00 à 16h00", "Bienvenue sur le site des écoles communales d\'Arlon.", "", "inherit", "closed", "closed", "", "6-revision-v1", "", "", "2015-11-25 14:40:34", "2015-11-25 13:40:34", "", "6", "http://demo.ec-arlon.be/2015/11/25/6-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("108", "1", "2015-11-25 15:00:07", "2015-11-25 14:00:07", "[fileaway type=\"table\" makedir=\"true\" size=\"no\"]\r\n<pre>[private role=\"administrator\"][fileup][/private]</pre>\r\n&nbsp;", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-11-25 15:00:07", "2015-11-25 14:00:07", "", "14", "http://demo.ec-arlon.be/2015/11/25/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("110", "1", "2015-12-05 11:34:44", "2015-12-05 10:34:44", "[fileaway type=\"table\" makedir=\"true\" size=\"no\"]\n\n&nbsp;\n<pre>[private role=\"administrator\"][fileup][/private]</pre>\n&nbsp;", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-autosave-v1", "", "", "2015-12-05 11:34:44", "2015-12-05 10:34:44", "", "14", "http://demo.ec-arlon.be/2015/12/05/14-autosave-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("111", "1", "2015-12-05 11:32:41", "2015-12-05 10:32:41", "[fileaway type=\"table\" makedir=\"true\" size=\"no\"]\r\n\r\n[fileaway makedir=\"true\" size=\"no\"]\r\n<pre>[private role=\"administrator\"][fileup][/private]</pre>\r\n&nbsp;", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-12-05 11:32:41", "2015-12-05 10:32:41", "", "14", "http://demo.ec-arlon.be/2015/12/05/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("112", "1", "2015-12-05 11:33:42", "2015-12-05 10:33:42", "[fileaway type=\"table\" makedir=\"true\" size=\"no\"]\r\n\r\n[fileaway_values makedir=\"true\" paginate=\"true\" search=\"no\"]\r\n<pre>[private role=\"administrator\"][fileup][/private]</pre>\r\n&nbsp;", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-12-05 11:33:42", "2015-12-05 10:33:42", "", "14", "http://demo.ec-arlon.be/2015/12/05/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("114", "1", "2015-12-05 11:37:11", "2015-12-05 10:37:11", "[fileaway type=\"table\" makedir=\"true\" size=\"no\" manager=\"on\" role_override=\"administrator\" dirman_access=\"administrator\"]\r\n<pre>[private role=\"administrator\"][fileup][/private]</pre>\r\n&nbsp;", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-12-05 11:37:11", "2015-12-05 10:37:11", "", "14", "http://demo.ec-arlon.be/2015/12/05/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("113", "1", "2015-12-05 11:34:53", "2015-12-05 10:34:53", "[fileaway type=\"table\" makedir=\"true\" size=\"no\"]\r\n\r\n[fileaway type=\"table\" makedir=\"true\" size=\"no\" manager=\"on\" role_override=\"administrator\" dirman_access=\"administrator\"]\r\n<pre>[private role=\"administrator\"][fileup][/private]</pre>\r\n&nbsp;", "Projets d\'établissements", "", "inherit", "closed", "closed", "", "14-revision-v1", "", "", "2015-12-05 11:34:53", "2015-12-05 10:34:53", "", "14", "http://demo.ec-arlon.be/2015/12/05/14-revision-v1/", "0", "revision", "", "0");
INSERT INTO `wp_root_posts` VALUES("115", "1", "2015-12-05 11:43:25", "0000-00-00 00:00:00", "", "Brouillon auto", "", "auto-draft", "open", "closed", "", "", "", "", "2015-12-05 11:43:25", "0000-00-00 00:00:00", "", "0", "http://demo.ec-arlon.be/?post_type=tribe_events&p=115", "0", "tribe_events", "", "0");

/* INSERT TABLE DATA: wp_root_term_relationships */
INSERT INTO `wp_root_term_relationships` VALUES("1", "1", "0");
INSERT INTO `wp_root_term_relationships` VALUES("20", "2", "0");
INSERT INTO `wp_root_term_relationships` VALUES("19", "2", "0");
INSERT INTO `wp_root_term_relationships` VALUES("18", "2", "0");
INSERT INTO `wp_root_term_relationships` VALUES("17", "2", "0");
INSERT INTO `wp_root_term_relationships` VALUES("16", "2", "0");
INSERT INTO `wp_root_term_relationships` VALUES("21", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("42", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("43", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("44", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("45", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("46", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("47", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("48", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("49", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("50", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("51", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("52", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("53", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("54", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("55", "3", "0");
INSERT INTO `wp_root_term_relationships` VALUES("56", "3", "0");

/* INSERT TABLE DATA: wp_root_term_taxonomy */
INSERT INTO `wp_root_term_taxonomy` VALUES("1", "1", "category", "", "0", "0");
INSERT INTO `wp_root_term_taxonomy` VALUES("2", "2", "nav_menu", "", "0", "5");
INSERT INTO `wp_root_term_taxonomy` VALUES("3", "3", "nav_menu", "", "0", "16");

/* INSERT TABLE DATA: wp_root_terms */
INSERT INTO `wp_root_terms` VALUES("1", "Non classé", "non-classe", "0");
INSERT INTO `wp_root_terms` VALUES("2", "Menu", "menu", "0");
INSERT INTO `wp_root_terms` VALUES("3", "Ecoles", "ecoles", "0");

/* INSERT TABLE DATA: wp_root_usermeta */
INSERT INTO `wp_root_usermeta` VALUES("1", "1", "nickname", "Administrator");
INSERT INTO `wp_root_usermeta` VALUES("2", "1", "first_name", "");
INSERT INTO `wp_root_usermeta` VALUES("3", "1", "last_name", "");
INSERT INTO `wp_root_usermeta` VALUES("4", "1", "description", "");
INSERT INTO `wp_root_usermeta` VALUES("5", "1", "rich_editing", "true");
INSERT INTO `wp_root_usermeta` VALUES("6", "1", "comment_shortcuts", "false");
INSERT INTO `wp_root_usermeta` VALUES("7", "1", "admin_color", "fresh");
INSERT INTO `wp_root_usermeta` VALUES("8", "1", "use_ssl", "0");
INSERT INTO `wp_root_usermeta` VALUES("9", "1", "show_admin_bar_front", "true");
INSERT INTO `wp_root_usermeta` VALUES("10", "1", "wp_root_capabilities", "a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO `wp_root_usermeta` VALUES("11", "1", "wp_root_user_level", "10");
INSERT INTO `wp_root_usermeta` VALUES("12", "1", "dismissed_wp_pointers", "tp09_edit_drag_drop_sort");
INSERT INTO `wp_root_usermeta` VALUES("13", "1", "show_welcome_panel", "0");
INSERT INTO `wp_root_usermeta` VALUES("14", "1", "session_tokens", "a:2:{s:64:\"e03983c48a7f74f6398026c6f4629c15687ca38bc2e6e8d2ccc76fa41d0abc80\";a:4:{s:10:\"expiration\";i:1449665327;s:2:\"ip\";s:13:\"85.201.98.208\";s:2:\"ua\";s:73:\"Mozilla/5.0 (Windows NT 10.0; WOW64; rv:42.0) Gecko/20100101 Firefox/42.0\";s:5:\"login\";i:1448455727;}s:64:\"7b980a20467286e4ce86decb3f48c82bcbee6a0ae4eeac2d086266f379c89c9d\";a:4:{s:10:\"expiration\";i:1450520860;s:2:\"ip\";s:13:\"85.201.98.208\";s:2:\"ua\";s:73:\"Mozilla/5.0 (Windows NT 10.0; WOW64; rv:42.0) Gecko/20100101 Firefox/42.0\";s:5:\"login\";i:1449311260;}}");
INSERT INTO `wp_root_usermeta` VALUES("15", "1", "wp_root_dashboard_quick_press_last_post_id", "109");
INSERT INTO `wp_root_usermeta` VALUES("16", "1", "meta-box-order_dashboard", "a:4:{s:6:\"normal\";s:19:\"dashboard_right_now\";s:4:\"side\";s:18:\"dashboard_activity\";s:7:\"column3\";s:21:\"dashboard_quick_press\";s:7:\"column4\";s:17:\"dashboard_primary\";}");
INSERT INTO `wp_root_usermeta` VALUES("17", "1", "closedpostboxes_page", "a:0:{}");
INSERT INTO `wp_root_usermeta` VALUES("18", "1", "metaboxhidden_page", "a:0:{}");
INSERT INTO `wp_root_usermeta` VALUES("19", "1", "managenav-menuscolumnshidden", "a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}");
INSERT INTO `wp_root_usermeta` VALUES("20", "1", "metaboxhidden_nav-menus", "a:2:{i:0;s:12:\"add-post_tag\";i:1;s:15:\"add-post_format\";}");
INSERT INTO `wp_root_usermeta` VALUES("21", "1", "nav_menu_recently_edited", "2");
INSERT INTO `wp_root_usermeta` VALUES("22", "1", "wp_root_tablepress_user_options", "{\"user_options_db_version\":31,\"admin_menu_parent_page\":\"middle\",\"plugin_language\":\"auto\",\"message_first_visit\":true}");
INSERT INTO `wp_root_usermeta` VALUES("23", "1", "managetablepress_listcolumnshidden", "a:1:{i:0;s:22:\"table_last_modified_by\";}");
INSERT INTO `wp_root_usermeta` VALUES("24", "1", "closedpostboxes_tablepress_edit", "a:0:{}");
INSERT INTO `wp_root_usermeta` VALUES("25", "1", "metaboxhidden_tablepress_edit", "a:0:{}");
INSERT INTO `wp_root_usermeta` VALUES("26", "1", "wp_root_user-settings", "post_dfw=off&hidetb=1&wplink=0&libraryContent=browse");
INSERT INTO `wp_root_usermeta` VALUES("27", "1", "wp_root_user-settings-time", "1447957367");
INSERT INTO `wp_root_usermeta` VALUES("28", "1", "tribe_setDefaultNavMenuBoxes", "1");
INSERT INTO `wp_root_usermeta` VALUES("29", "1", "wpseo_ignore_tour", "1");

/* INSERT TABLE DATA: wp_root_users */
INSERT INTO `wp_root_users` VALUES("1", "Administrator", "$P$Bxxonb.4znU248EjElLPNtIPn5hHDi0", "administrator", "administrator@ec-arlon.be", "", "2015-11-06 17:49:30", "", "0", "Administrator");

/* INSERT TABLE DATA: wp_udange_bwg_album */
INSERT INTO `wp_udange_bwg_album` VALUES("1", "Galerie", "galerie", "", "", "/Cross 2010/thumb/cross 2010 arlon 005.jpg", "1", "1", "1");

/* INSERT TABLE DATA: wp_udange_bwg_album_gallery */
INSERT INTO `wp_udange_bwg_album_gallery` VALUES("15", "1", "0", "7", "4");
INSERT INTO `wp_udange_bwg_album_gallery` VALUES("14", "1", "0", "6", "3");
INSERT INTO `wp_udange_bwg_album_gallery` VALUES("13", "1", "0", "4", "2");
INSERT INTO `wp_udange_bwg_album_gallery` VALUES("12", "1", "0", "5", "1");

/* INSERT TABLE DATA: wp_udange_bwg_gallery */
INSERT INTO `wp_udange_bwg_gallery` VALUES("7", "Pompiers", "pompiers", "", "", "", "/Pompiers/thumb/pompier034.jpg", "7", "1", "1", "", "", "12", "");
INSERT INTO `wp_udange_bwg_gallery` VALUES("5", "Cross 2010", "cross-2010", "", "", "", "/Cross 2010/thumb/cross 2010 arlon 005.jpg", "5", "1", "1", "", "", "12", "");
INSERT INTO `wp_udange_bwg_gallery` VALUES("6", "Cross 2014", "cross-2014", "", "", "", "/Cross 2014/thumb/charlotte.jpg", "6", "1", "1", "", "", "12", "");
INSERT INTO `wp_udange_bwg_gallery` VALUES("3", "Slideshow", "slideshow", "", "", "", "/Slideshow/thumb/ss35.jpg", "3", "1", "1", "", "", "12", "");
INSERT INTO `wp_udange_bwg_gallery` VALUES("4", "Cross 2011", "cross-2011", "", "", "", "/Cross 2011/thumb/cross 2011 - 003.jpg", "4", "1", "1", "", "", "12", "");

/* INSERT TABLE DATA: wp_udange_bwg_image */
INSERT INTO `wp_udange_bwg_image` VALUES("6", "3", "ss35", "ss35", "/Slideshow/ss35.jpg", "/Slideshow/thumb/ss35.jpg", "Orientation: 1\n", "ss35", "07 November 2015, 12:14", "33 KB", "JPG", "260 x 150 px", "1", "2", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("7", "3", "ss34", "ss34", "/Slideshow/ss34.jpg", "/Slideshow/thumb/ss34.jpg", "Orientation: 1\n", "ss34", "07 November 2015, 12:14", "36 KB", "JPG", "260 x 150 px", "1", "1", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("95", "5", "cross 2010 arlon 005", "cross 2010 arlon 005", "/Cross 2010/cross 2010 arlon 005.jpg", "/Cross 2010/thumb/cross 2010 arlon 005.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 005", "16 November 2015, 18:57", "109 KB", "JPG", "640 x 480 px", "1", "33", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("96", "5", "cross 2010 arlon 006", "cross 2010 arlon 006", "/Cross 2010/cross 2010 arlon 006.jpg", "/Cross 2010/thumb/cross 2010 arlon 006.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 006", "16 November 2015, 18:57", "120 KB", "JPG", "640 x 480 px", "1", "32", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("97", "5", "cross 2010 arlon 007", "cross 2010 arlon 007", "/Cross 2010/cross 2010 arlon 007.jpg", "/Cross 2010/thumb/cross 2010 arlon 007.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 007", "16 November 2015, 18:57", "125 KB", "JPG", "640 x 480 px", "1", "31", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("98", "5", "cross 2010 arlon 008", "cross 2010 arlon 008", "/Cross 2010/cross 2010 arlon 008.jpg", "/Cross 2010/thumb/cross 2010 arlon 008.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 008", "16 November 2015, 18:57", "109 KB", "JPG", "640 x 480 px", "1", "30", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("57", "4", "cross 2011 - 006", "cross 2011 - 006", "/Cross 2011/cross 2011 - 006.jpg", "/Cross 2011/thumb/cross 2011 - 006.jpg", "Aperture: 4\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 006", "16 November 2015, 18:54", "76 KB", "JPG", "480 x 360 px", "1", "39", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("55", "4", "cross 2011 - 004", "cross 2011 - 004", "/Cross 2011/cross 2011 - 004.jpg", "/Cross 2011/thumb/cross 2011 - 004.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 004", "16 November 2015, 18:54", "101 KB", "JPG", "480 x 360 px", "1", "41", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("52", "4", "cross 2011 - 001", "cross 2011 - 001", "/Cross 2011/cross 2011 - 001.jpg", "/Cross 2011/thumb/cross 2011 - 001.jpg", "Aperture: 3.7\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 001", "16 November 2015, 18:54", "107 KB", "JPG", "480 x 360 px", "1", "44", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("53", "4", "cross 2011 - 002", "cross 2011 - 002", "/Cross 2011/cross 2011 - 002.jpg", "/Cross 2011/thumb/cross 2011 - 002.jpg", "Aperture: 4\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 002", "16 November 2015, 18:54", "93 KB", "JPG", "480 x 360 px", "1", "43", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("54", "4", "cross 2011 - 003", "cross 2011 - 003", "/Cross 2011/cross 2011 - 003.jpg", "/Cross 2011/thumb/cross 2011 - 003.jpg", "Aperture: 3.5\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 003", "16 November 2015, 18:54", "95 KB", "JPG", "480 x 360 px", "1", "42", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("72", "4", "cross 2011 - 021", "cross 2011 - 021", "/Cross 2011/cross 2011 - 021.jpg", "/Cross 2011/thumb/cross 2011 - 021.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 021", "16 November 2015, 18:54", "91 KB", "JPG", "360 x 480 px", "1", "24", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("71", "4", "cross 2011 - 020", "cross 2011 - 020", "/Cross 2011/cross 2011 - 020.jpg", "/Cross 2011/thumb/cross 2011 - 020.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 020", "16 November 2015, 18:54", "109 KB", "JPG", "480 x 360 px", "1", "25", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("70", "4", "cross 2011 - 019", "cross 2011 - 019", "/Cross 2011/cross 2011 - 019.jpg", "/Cross 2011/thumb/cross 2011 - 019.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 019", "16 November 2015, 18:54", "96 KB", "JPG", "480 x 360 px", "1", "26", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("69", "4", "cross 2011 - 018", "cross 2011 - 018", "/Cross 2011/cross 2011 - 018.jpg", "/Cross 2011/thumb/cross 2011 - 018.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 018", "16 November 2015, 18:54", "97 KB", "JPG", "480 x 360 px", "1", "27", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("68", "4", "cross 2011 - 017", "cross 2011 - 017", "/Cross 2011/cross 2011 - 017.jpg", "/Cross 2011/thumb/cross 2011 - 017.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 017", "16 November 2015, 18:54", "94 KB", "JPG", "480 x 360 px", "1", "28", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("67", "4", "cross 2011 - 016", "cross 2011 - 016", "/Cross 2011/cross 2011 - 016.jpg", "/Cross 2011/thumb/cross 2011 - 016.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 016", "16 November 2015, 18:54", "92 KB", "JPG", "480 x 360 px", "1", "29", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("66", "4", "cross 2011 - 015", "cross 2011 - 015", "/Cross 2011/cross 2011 - 015.jpg", "/Cross 2011/thumb/cross 2011 - 015.jpg", "Aperture: 3.5\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 015", "16 November 2015, 18:54", "69 KB", "JPG", "360 x 480 px", "1", "30", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("65", "4", "cross 2011 - 014", "cross 2011 - 014", "/Cross 2011/cross 2011 - 014.jpg", "/Cross 2011/thumb/cross 2011 - 014.jpg", "Aperture: 4\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 014", "16 November 2015, 18:54", "67 KB", "JPG", "360 x 480 px", "1", "31", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("64", "4", "cross 2011 - 013", "cross 2011 - 013", "/Cross 2011/cross 2011 - 013.jpg", "/Cross 2011/thumb/cross 2011 - 013.jpg", "Aperture: 4\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 013", "16 November 2015, 18:54", "71 KB", "JPG", "360 x 480 px", "1", "32", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("63", "4", "cross 2011 - 012", "cross 2011 - 012", "/Cross 2011/cross 2011 - 012.jpg", "/Cross 2011/thumb/cross 2011 - 012.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 012", "16 November 2015, 18:54", "75 KB", "JPG", "360 x 480 px", "1", "33", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("62", "4", "cross 2011 - 011", "cross 2011 - 011", "/Cross 2011/cross 2011 - 011.jpg", "/Cross 2011/thumb/cross 2011 - 011.jpg", "Aperture: 3.8\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 011", "16 November 2015, 18:54", "56 KB", "JPG", "360 x 480 px", "1", "34", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("61", "4", "cross 2011 - 010", "cross 2011 - 010", "/Cross 2011/cross 2011 - 010.jpg", "/Cross 2011/thumb/cross 2011 - 010.jpg", "Aperture: 3.8\nCamera: DMC-TZ7\nIso: 100\n", "cross 2011 - 010", "16 November 2015, 18:54", "92 KB", "JPG", "360 x 480 px", "1", "35", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("58", "4", "cross 2011 - 007", "cross 2011 - 007", "/Cross 2011/cross 2011 - 007.jpg", "/Cross 2011/thumb/cross 2011 - 007.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 007", "16 November 2015, 18:54", "85 KB", "JPG", "480 x 360 px", "1", "38", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("59", "4", "cross 2011 - 008", "cross 2011 - 008", "/Cross 2011/cross 2011 - 008.jpg", "/Cross 2011/thumb/cross 2011 - 008.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 008", "16 November 2015, 18:54", "103 KB", "JPG", "360 x 480 px", "1", "37", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("60", "4", "cross 2011 - 009", "cross 2011 - 009", "/Cross 2011/cross 2011 - 009.jpg", "/Cross 2011/thumb/cross 2011 - 009.jpg", "Aperture: 3.5\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 009", "16 November 2015, 18:54", "77 KB", "JPG", "360 x 480 px", "1", "36", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("83", "4", "cross 2011 - 037 ", "cross 2011 - 037", "/Cross 2011/cross 2011 - 037.jpg", "/Cross 2011/thumb/cross 2011 - 037.jpg", "Aperture: 4\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 037 ", "16 November 2015, 18:54", "74 KB", "JPG", "360 x 480 px", "1", "13", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("82", "4", "cross 2011 - 036 ", "cross 2011 - 036", "/Cross 2011/cross 2011 - 036.jpg", "/Cross 2011/thumb/cross 2011 - 036.jpg", "Aperture: 3.5\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 036 ", "16 November 2015, 18:54", "75 KB", "JPG", "360 x 480 px", "1", "14", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("81", "4", "cross 2011 - 030 ", "cross 2011 - 030", "/Cross 2011/cross 2011 - 030.jpg", "/Cross 2011/thumb/cross 2011 - 030.jpg", "Aperture: 3.5\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 030 ", "16 November 2015, 18:54", "67 KB", "JPG", "360 x 480 px", "1", "15", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("80", "4", "cross 2011 - 029 ", "cross 2011 - 029", "/Cross 2011/cross 2011 - 029.jpg", "/Cross 2011/thumb/cross 2011 - 029.jpg", "Aperture: 4.1\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 029 ", "16 November 2015, 18:54", "87 KB", "JPG", "480 x 360 px", "1", "16", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("79", "4", "cross 2011 - 028 ", "cross 2011 - 028", "/Cross 2011/cross 2011 - 028.jpg", "/Cross 2011/thumb/cross 2011 - 028.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 028 ", "16 November 2015, 18:54", "98 KB", "JPG", "480 x 360 px", "1", "17", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("78", "4", "cross 2011 - 027 ", "cross 2011 - 027", "/Cross 2011/cross 2011 - 027.jpg", "/Cross 2011/thumb/cross 2011 - 027.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 027 ", "16 November 2015, 18:54", "73 KB", "JPG", "360 x 480 px", "1", "18", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("77", "4", "cross 2011 - 026 ", "cross 2011 - 026", "/Cross 2011/cross 2011 - 026.jpg", "/Cross 2011/thumb/cross 2011 - 026.jpg", "Aperture: 3.5\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 026 ", "16 November 2015, 18:54", "80 KB", "JPG", "360 x 480 px", "1", "19", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("76", "4", "cross 2011 - 025 ", "cross 2011 - 025", "/Cross 2011/cross 2011 - 025.jpg", "/Cross 2011/thumb/cross 2011 - 025.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 025 ", "16 November 2015, 18:54", "79 KB", "JPG", "360 x 480 px", "1", "20", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("75", "4", "cross 2011 - 024 ", "cross 2011 - 024", "/Cross 2011/cross 2011 - 024.jpg", "/Cross 2011/thumb/cross 2011 - 024.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 024 ", "16 November 2015, 18:54", "93 KB", "JPG", "480 x 360 px", "1", "21", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("74", "4", "cross 2011 - 023", "cross 2011 - 023", "/Cross 2011/cross 2011 - 023.jpg", "/Cross 2011/thumb/cross 2011 - 023.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 023", "16 November 2015, 18:54", "107 KB", "JPG", "480 x 360 px", "1", "22", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("73", "4", "cross 2011 - 022", "cross 2011 - 022", "/Cross 2011/cross 2011 - 022.jpg", "/Cross 2011/thumb/cross 2011 - 022.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 022", "16 November 2015, 18:54", "94 KB", "JPG", "360 x 480 px", "1", "23", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("56", "4", "cross 2011 - 005", "cross 2011 - 005", "/Cross 2011/cross 2011 - 005.jpg", "/Cross 2011/thumb/cross 2011 - 005.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 005", "16 November 2015, 18:54", "95 KB", "JPG", "480 x 360 px", "1", "40", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("84", "4", "cross 2011 - 038 ", "cross 2011 - 038", "/Cross 2011/cross 2011 - 038.jpg", "/Cross 2011/thumb/cross 2011 - 038.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 038 ", "16 November 2015, 18:54", "88 KB", "JPG", "360 x 480 px", "1", "12", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("85", "4", "cross 2011 - 039 ", "cross 2011 - 039", "/Cross 2011/cross 2011 - 039.jpg", "/Cross 2011/thumb/cross 2011 - 039.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 039 ", "16 November 2015, 18:54", "90 KB", "JPG", "480 x 360 px", "1", "11", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("86", "4", "cross 2011 - 040 ", "cross 2011 - 040", "/Cross 2011/cross 2011 - 040.jpg", "/Cross 2011/thumb/cross 2011 - 040.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 040 ", "16 November 2015, 18:54", "96 KB", "JPG", "480 x 360 px", "1", "10", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("87", "4", "cross 2011 - 041 ", "cross 2011 - 041", "/Cross 2011/cross 2011 - 041.jpg", "/Cross 2011/thumb/cross 2011 - 041.jpg", "Aperture: 4\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 041 ", "16 November 2015, 18:54", "69 KB", "JPG", "360 x 480 px", "1", "9", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("88", "4", "cross 2011 - 042 ", "cross 2011 - 042", "/Cross 2011/cross 2011 - 042.jpg", "/Cross 2011/thumb/cross 2011 - 042.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 042 ", "16 November 2015, 18:54", "82 KB", "JPG", "360 x 480 px", "1", "8", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("89", "4", "cross 2011 - 043 ", "cross 2011 - 043", "/Cross 2011/cross 2011 - 043.jpg", "/Cross 2011/thumb/cross 2011 - 043.jpg", "Aperture: 3.5\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 043 ", "16 November 2015, 18:54", "69 KB", "JPG", "360 x 480 px", "1", "7", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("90", "4", "cross 2011 - 044 ", "cross 2011 - 044", "/Cross 2011/cross 2011 - 044.jpg", "/Cross 2011/thumb/cross 2011 - 044.jpg", "Aperture: 4\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 044 ", "16 November 2015, 18:54", "69 KB", "JPG", "360 x 480 px", "1", "6", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("91", "4", "cross 2011 - 045 ", "cross 2011 - 045", "/Cross 2011/cross 2011 - 045.jpg", "/Cross 2011/thumb/cross 2011 - 045.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\nOrientation: 1\n", "cross 2011 - 045 ", "16 November 2015, 18:54", "96 KB", "JPG", "480 x 360 px", "1", "5", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("92", "4", "cross 2011 - 046 ", "cross 2011 - 046", "/Cross 2011/cross 2011 - 046.jpg", "/Cross 2011/thumb/cross 2011 - 046.jpg", "Aperture: 3.3\nCamera: DMC-TZ7\nIso: 80\n", "cross 2011 - 046 ", "16 November 2015, 18:54", "67 KB", "JPG", "360 x 480 px", "1", "4", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("93", "4", "cross 2011 - 048 ", "cross 2011 - 048", "/Cross 2011/cross 2011 - 048.jpg", "/Cross 2011/thumb/cross 2011 - 048.jpg", "Aperture: 3.6\nCamera: DMC-TZ7\nIso: 320\nOrientation: 1\n", "cross 2011 - 048 ", "16 November 2015, 18:54", "99 KB", "JPG", "480 x 360 px", "1", "3", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("94", "4", "cross 2011 - 050 ", "cross 2011 - 050", "/Cross 2011/cross 2011 - 050.jpg", "/Cross 2011/thumb/cross 2011 - 050.jpg", "Aperture: 3.6\nCamera: DMC-TZ7\nIso: 320\nOrientation: 1\n", "cross 2011 - 050 ", "16 November 2015, 18:54", "95 KB", "JPG", "480 x 360 px", "1", "2", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("99", "5", "cross 2010 arlon 009", "cross 2010 arlon 009", "/Cross 2010/cross 2010 arlon 009.jpg", "/Cross 2010/thumb/cross 2010 arlon 009.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 009", "16 November 2015, 18:57", "104 KB", "JPG", "480 x 640 px", "1", "29", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("100", "5", "cross 2010 arlon 010", "cross 2010 arlon 010", "/Cross 2010/cross 2010 arlon 010.jpg", "/Cross 2010/thumb/cross 2010 arlon 010.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 010", "16 November 2015, 18:57", "112 KB", "JPG", "640 x 480 px", "1", "28", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("101", "5", "cross 2010 arlon 011", "cross 2010 arlon 011", "/Cross 2010/cross 2010 arlon 011.jpg", "/Cross 2010/thumb/cross 2010 arlon 011.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 011", "16 November 2015, 18:57", "109 KB", "JPG", "640 x 480 px", "1", "27", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("102", "5", "cross 2010 arlon 012", "cross 2010 arlon 012", "/Cross 2010/cross 2010 arlon 012.jpg", "/Cross 2010/thumb/cross 2010 arlon 012.jpg", "Aperture: 5.9\nCamera: FE4000,X920,X925\nIso: 160\nOrientation: 1\n", "cross 2010 arlon 012", "16 November 2015, 18:57", "94 KB", "JPG", "640 x 480 px", "1", "26", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("103", "5", "cross 2010 arlon 013", "cross 2010 arlon 013", "/Cross 2010/cross 2010 arlon 013.jpg", "/Cross 2010/thumb/cross 2010 arlon 013.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 013", "16 November 2015, 18:57", "103 KB", "JPG", "480 x 640 px", "1", "25", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("104", "5", "cross 2010 arlon 014", "cross 2010 arlon 014", "/Cross 2010/cross 2010 arlon 014.jpg", "/Cross 2010/thumb/cross 2010 arlon 014.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 014", "16 November 2015, 18:57", "107 KB", "JPG", "480 x 640 px", "1", "24", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("105", "5", "cross 2010 arlon 015", "cross 2010 arlon 015", "/Cross 2010/cross 2010 arlon 015.jpg", "/Cross 2010/thumb/cross 2010 arlon 015.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 015", "16 November 2015, 18:57", "112 KB", "JPG", "480 x 640 px", "1", "23", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("106", "5", "cross 2010 arlon 016", "cross 2010 arlon 016", "/Cross 2010/cross 2010 arlon 016.jpg", "/Cross 2010/thumb/cross 2010 arlon 016.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 016", "16 November 2015, 18:57", "92 KB", "JPG", "480 x 640 px", "1", "22", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("107", "5", "cross 2010 arlon 017", "cross 2010 arlon 017", "/Cross 2010/cross 2010 arlon 017.jpg", "/Cross 2010/thumb/cross 2010 arlon 017.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 017", "16 November 2015, 18:57", "115 KB", "JPG", "480 x 640 px", "1", "21", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("108", "5", "cross 2010 arlon 019", "cross 2010 arlon 019", "/Cross 2010/cross 2010 arlon 019.jpg", "/Cross 2010/thumb/cross 2010 arlon 019.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 019", "16 November 2015, 18:57", "105 KB", "JPG", "480 x 640 px", "1", "20", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("109", "5", "cross 2010 arlon 020", "cross 2010 arlon 020", "/Cross 2010/cross 2010 arlon 020.jpg", "/Cross 2010/thumb/cross 2010 arlon 020.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 020", "16 November 2015, 18:57", "117 KB", "JPG", "480 x 640 px", "1", "19", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("110", "5", "cross 2010 arlon 022", "cross 2010 arlon 022", "/Cross 2010/cross 2010 arlon 022.jpg", "/Cross 2010/thumb/cross 2010 arlon 022.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 022", "16 November 2015, 18:57", "94 KB", "JPG", "480 x 640 px", "1", "18", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("111", "5", "cross 2010 arlon 023", "cross 2010 arlon 023", "/Cross 2010/cross 2010 arlon 023.jpg", "/Cross 2010/thumb/cross 2010 arlon 023.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 023", "16 November 2015, 18:57", "112 KB", "JPG", "640 x 480 px", "1", "17", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("112", "5", "cross 2010 arlon 024", "cross 2010 arlon 024", "/Cross 2010/cross 2010 arlon 024.jpg", "/Cross 2010/thumb/cross 2010 arlon 024.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 024", "16 November 2015, 18:57", "233 KB", "JPG", "640 x 480 px", "1", "16", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("113", "5", "cross 2010 arlon 025", "cross 2010 arlon 025", "/Cross 2010/cross 2010 arlon 025.jpg", "/Cross 2010/thumb/cross 2010 arlon 025.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 025", "16 November 2015, 18:57", "103 KB", "JPG", "480 x 640 px", "1", "15", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("114", "5", "cross 2010 arlon 026", "cross 2010 arlon 026", "/Cross 2010/cross 2010 arlon 026.jpg", "/Cross 2010/thumb/cross 2010 arlon 026.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 026", "16 November 2015, 18:57", "93 KB", "JPG", "640 x 480 px", "1", "14", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("115", "5", "cross 2010 arlon 027", "cross 2010 arlon 027", "/Cross 2010/cross 2010 arlon 027.jpg", "/Cross 2010/thumb/cross 2010 arlon 027.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 027", "16 November 2015, 18:57", "108 KB", "JPG", "480 x 640 px", "1", "13", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("116", "5", "cross 2010 arlon 028", "cross 2010 arlon 028", "/Cross 2010/cross 2010 arlon 028.jpg", "/Cross 2010/thumb/cross 2010 arlon 028.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 028", "16 November 2015, 18:57", "94 KB", "JPG", "640 x 480 px", "1", "12", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("117", "5", "cross 2010 arlon 029", "cross 2010 arlon 029", "/Cross 2010/cross 2010 arlon 029.jpg", "/Cross 2010/thumb/cross 2010 arlon 029.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 029", "16 November 2015, 18:57", "93 KB", "JPG", "640 x 480 px", "1", "11", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("118", "5", "cross 2010 arlon 030", "cross 2010 arlon 030", "/Cross 2010/cross 2010 arlon 030.jpg", "/Cross 2010/thumb/cross 2010 arlon 030.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 030", "16 November 2015, 18:57", "101 KB", "JPG", "480 x 640 px", "1", "10", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("119", "5", "cross 2010 arlon 031", "cross 2010 arlon 031", "/Cross 2010/cross 2010 arlon 031.jpg", "/Cross 2010/thumb/cross 2010 arlon 031.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 031", "16 November 2015, 18:57", "113 KB", "JPG", "480 x 640 px", "1", "9", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("120", "5", "cross 2010 arlon 032", "cross 2010 arlon 032", "/Cross 2010/cross 2010 arlon 032.jpg", "/Cross 2010/thumb/cross 2010 arlon 032.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 032", "16 November 2015, 18:57", "99 KB", "JPG", "480 x 640 px", "1", "8", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("121", "5", "cross 2010 arlon 034", "cross 2010 arlon 034", "/Cross 2010/cross 2010 arlon 034.jpg", "/Cross 2010/thumb/cross 2010 arlon 034.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 034", "16 November 2015, 18:57", "108 KB", "JPG", "480 x 640 px", "1", "7", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("122", "5", "cross 2010 arlon 035", "cross 2010 arlon 035", "/Cross 2010/cross 2010 arlon 035.jpg", "/Cross 2010/thumb/cross 2010 arlon 035.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 035", "16 November 2015, 18:57", "90 KB", "JPG", "480 x 640 px", "1", "6", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("123", "5", "cross 2010 arlon 037", "cross 2010 arlon 037", "/Cross 2010/cross 2010 arlon 037.jpg", "/Cross 2010/thumb/cross 2010 arlon 037.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 037", "16 November 2015, 18:57", "86 KB", "JPG", "480 x 640 px", "1", "5", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("124", "5", "cross 2010 arlon 038", "cross 2010 arlon 038", "/Cross 2010/cross 2010 arlon 038.jpg", "/Cross 2010/thumb/cross 2010 arlon 038.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 038", "16 November 2015, 18:57", "99 KB", "JPG", "480 x 640 px", "1", "4", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("125", "5", "cross 2010 arlon 039", "cross 2010 arlon 039", "/Cross 2010/cross 2010 arlon 039.jpg", "/Cross 2010/thumb/cross 2010 arlon 039.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\n", "cross 2010 arlon 039", "16 November 2015, 18:57", "94 KB", "JPG", "480 x 640 px", "1", "3", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("126", "5", "cross 2010 arlon 040", "cross 2010 arlon 040", "/Cross 2010/cross 2010 arlon 040.jpg", "/Cross 2010/thumb/cross 2010 arlon 040.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 040", "16 November 2015, 18:57", "134 KB", "JPG", "640 x 480 px", "1", "2", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("127", "5", "cross 2010 arlon 041", "cross 2010 arlon 041", "/Cross 2010/cross 2010 arlon 041.jpg", "/Cross 2010/thumb/cross 2010 arlon 041.jpg", "Aperture: 2.6\nCamera: FE4000,X920,X925\nIso: 100\nOrientation: 1\n", "cross 2010 arlon 041", "16 November 2015, 18:57", "237 KB", "JPG", "640 x 480 px", "1", "1", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("128", "6", "charlotte", "charlotte", "/Cross 2014/charlotte.jpg", "/Cross 2014/thumb/charlotte.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 640\nOrientation: 1\n", "charlotte", "16 November 2015, 18:58", "63 KB", "JPG", "456 x 636 px", "1", "40", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("129", "6", "charlotte2", "charlotte2", "/Cross 2014/charlotte2.jpg", "/Cross 2014/thumb/charlotte2.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 640\nOrientation: 1\n", "charlotte2", "16 November 2015, 18:58", "100 KB", "JPG", "850 x 610 px", "1", "39", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("130", "6", "charlotte3", "charlotte3", "/Cross 2014/charlotte3.jpg", "/Cross 2014/thumb/charlotte3.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 640\nOrientation: 1\n", "charlotte3", "16 November 2015, 18:58", "84 KB", "JPG", "567 x 748 px", "1", "38", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("131", "6", "filles_2006", "filles_2006", "/Cross 2014/filles_2006.jpg", "/Cross 2014/thumb/filles_2006.jpg", "Aperture: 5.6\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "filles_2006", "16 November 2015, 18:58", "142 KB", "JPG", "850 x 567 px", "1", "37", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("132", "6", "garcons_2005", "garcons_2005", "/Cross 2014/garcons_2005.jpg", "/Cross 2014/thumb/garcons_2005.jpg", "Aperture: 5.6\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "garcons_2005", "16 November 2015, 18:58", "123 KB", "JPG", "850 x 529 px", "1", "36", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("133", "6", "garcons_2006", "garcons_2006", "/Cross 2014/garcons_2006.jpg", "/Cross 2014/thumb/garcons_2006.jpg", "Aperture: 5.6\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "garcons_2006", "16 November 2015, 18:58", "96 KB", "JPG", "850 x 316 px", "1", "35", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("134", "6", "groupe1", "groupe1", "/Cross 2014/groupe1.jpg", "/Cross 2014/thumb/groupe1.jpg", "Aperture: 4\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "groupe1", "16 November 2015, 18:58", "823 KB", "JPG", "1200 x 732 px", "1", "34", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("135", "6", "groupe2", "groupe2", "/Cross 2014/groupe2.jpg", "/Cross 2014/thumb/groupe2.jpg", "Aperture: 4\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "groupe2", "16 November 2015, 18:58", "861 KB", "JPG", "1200 x 732 px", "1", "33", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("136", "6", "guillaume", "guillaume", "/Cross 2014/guillaume.jpg", "/Cross 2014/thumb/guillaume.jpg", "Orientation: 1\n", "guillaume", "16 November 2015, 18:58", "109 KB", "JPG", "850 x 591 px", "1", "32", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("137", "6", "guillaume2", "guillaume2", "/Cross 2014/guillaume2.jpg", "/Cross 2014/thumb/guillaume2.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 800\nOrientation: 1\n", "guillaume2", "16 November 2015, 18:58", "628 KB", "JPG", "1200 x 845 px", "1", "31", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("138", "6", "guillaume3", "guillaume3", "/Cross 2014/guillaume3.jpg", "/Cross 2014/thumb/guillaume3.jpg", "Aperture: 3.5\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "guillaume3", "16 November 2015, 18:58", "116 KB", "JPG", "567 x 732 px", "1", "30", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("139", "6", "img_0921_small", "img_0921_small", "/Cross 2014/img_0921_small.jpg", "/Cross 2014/thumb/img_0921_small.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 250\nOrientation: 1\n", "img_0921_small", "16 November 2015, 18:58", "118 KB", "JPG", "850 x 571 px", "1", "29", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("140", "6", "img_0942_2", "img_0942_2", "/Cross 2014/img_0942_2.jpg", "/Cross 2014/thumb/img_0942_2.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 500\nOrientation: 1\n", "img_0942_2", "16 November 2015, 18:58", "85 KB", "JPG", "759 x 579 px", "1", "28", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("141", "6", "img_0964_small", "img_0964_small", "/Cross 2014/img_0964_small.jpg", "/Cross 2014/thumb/img_0964_small.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 320\nOrientation: 1\n", "img_0964_small", "16 November 2015, 18:58", "106 KB", "JPG", "850 x 640 px", "1", "27", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("142", "6", "img_0994_small", "img_0994_small", "/Cross 2014/img_0994_small.jpg", "/Cross 2014/thumb/img_0994_small.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 320\nOrientation: 1\n", "img_0994_small", "16 November 2015, 18:58", "126 KB", "JPG", "850 x 599 px", "1", "26", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("143", "6", "img_1010_small", "img_1010_small", "/Cross 2014/img_1010_small.jpg", "/Cross 2014/thumb/img_1010_small.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 1250\nOrientation: 1\n", "img_1010_small", "16 November 2015, 18:58", "87 KB", "JPG", "567 x 770 px", "1", "25", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("144", "6", "img_1010_small2", "img_1010_small2", "/Cross 2014/img_1010_small2.jpg", "/Cross 2014/thumb/img_1010_small2.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 1250\nOrientation: 1\n", "img_1010_small2", "16 November 2015, 18:58", "87 KB", "JPG", "567 x 770 px", "1", "24", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("145", "6", "img_1013_small", "img_1013_small", "/Cross 2014/img_1013_small.jpg", "/Cross 2014/thumb/img_1013_small.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 800\nOrientation: 1\n", "img_1013_small", "16 November 2015, 18:58", "92 KB", "JPG", "850 x 693 px", "1", "23", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("146", "6", "img_1057_small", "img_1057_small", "/Cross 2014/img_1057_small.jpg", "/Cross 2014/thumb/img_1057_small.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 400\nOrientation: 1\n", "img_1057_small", "16 November 2015, 18:58", "122 KB", "JPG", "850 x 618 px", "1", "22", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("147", "6", "img_1061_small", "img_1061_small", "/Cross 2014/img_1061_small.jpg", "/Cross 2014/thumb/img_1061_small.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 250\nOrientation: 1\n", "img_1061_small", "16 November 2015, 18:58", "101 KB", "JPG", "567 x 870 px", "1", "21", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("148", "6", "img_1092_small", "img_1092_small", "/Cross 2014/img_1092_small.jpg", "/Cross 2014/thumb/img_1092_small.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 500\nOrientation: 1\n", "img_1092_small", "16 November 2015, 18:58", "133 KB", "JPG", "850 x 581 px", "1", "20", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("149", "6", "img_1100_small", "img_1100_small", "/Cross 2014/img_1100_small.jpg", "/Cross 2014/thumb/img_1100_small.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 500\nOrientation: 1\n", "img_1100_small", "16 November 2015, 18:58", "111 KB", "JPG", "850 x 610 px", "1", "19", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("150", "6", "img_1106_small", "img_1106_small", "/Cross 2014/img_1106_small.jpg", "/Cross 2014/thumb/img_1106_small.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 400\nOrientation: 1\n", "img_1106_small", "16 November 2015, 18:58", "132 KB", "JPG", "850 x 598 px", "1", "18", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("151", "6", "img_1109_small", "img_1109_small", "/Cross 2014/img_1109_small.jpg", "/Cross 2014/thumb/img_1109_small.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 200\nOrientation: 1\n", "img_1109_small", "16 November 2015, 18:58", "89 KB", "JPG", "526 x 850 px", "1", "17", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("152", "6", "img_1115_small", "img_1115_small", "/Cross 2014/img_1115_small.jpg", "/Cross 2014/thumb/img_1115_small.jpg", "Aperture: 4\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "img_1115_small", "16 November 2015, 18:58", "94 KB", "JPG", "547 x 850 px", "1", "16", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("153", "6", "img_1138_small", "img_1138_small", "/Cross 2014/img_1138_small.jpg", "/Cross 2014/thumb/img_1138_small.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "img_1138_small", "16 November 2015, 18:58", "88 KB", "JPG", "565 x 850 px", "1", "15", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("154", "6", "img_1169_small", "img_1169_small", "/Cross 2014/img_1169_small.jpg", "/Cross 2014/thumb/img_1169_small.jpg", "Aperture: 16\nCamera: Canon EOS 6D\nIso: 400\nOrientation: 1\n", "img_1169_small", "16 November 2015, 18:58", "150 KB", "JPG", "850 x 768 px", "1", "14", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("155", "6", "img_1179_small", "img_1179_small", "/Cross 2014/img_1179_small.jpg", "/Cross 2014/thumb/img_1179_small.jpg", "Aperture: 5.6\nCamera: Canon EOS 6D\nIso: 400\nOrientation: 1\n", "img_1179_small", "16 November 2015, 18:58", "117 KB", "JPG", "534 x 850 px", "1", "13", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("156", "6", "img_1183_small", "img_1183_small", "/Cross 2014/img_1183_small.jpg", "/Cross 2014/thumb/img_1183_small.jpg", "Aperture: 10\nCamera: Canon EOS 6D\nIso: 400\nOrientation: 1\n", "img_1183_small", "16 November 2015, 18:58", "596 KB", "JPG", "848 x 1200 px", "1", "12", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("157", "6", "img_1189_small", "img_1189_small", "/Cross 2014/img_1189_small.jpg", "/Cross 2014/thumb/img_1189_small.jpg", "Aperture: 4\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "img_1189_small", "16 November 2015, 18:58", "188 KB", "JPG", "850 x 465 px", "1", "11", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("158", "6", "img_1192_small", "img_1192_small", "/Cross 2014/img_1192_small.jpg", "/Cross 2014/thumb/img_1192_small.jpg", "Aperture: 4\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "img_1192_small", "16 November 2015, 18:58", "209 KB", "JPG", "850 x 471 px", "1", "10", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("159", "6", "jordan", "jordan", "/Cross 2014/jordan.jpg", "/Cross 2014/thumb/jordan.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 320\nOrientation: 1\n", "jordan", "16 November 2015, 18:58", "99 KB", "JPG", "525 x 850 px", "1", "9", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("160", "6", "la fine quipe", "la fine quipe", "/Cross 2014/la fine quipe.jpg", "/Cross 2014/thumb/la fine quipe.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 250\nOrientation: 1\n", "la fine quipe", "16 November 2015, 18:58", "113 KB", "JPG", "850 x 622 px", "1", "8", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("161", "6", "les_petites_droles", "les_petites_droles", "/Cross 2014/les_petites_droles.jpg", "/Cross 2014/thumb/les_petites_droles.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "les_petites_droles", "16 November 2015, 18:58", "103 KB", "JPG", "850 x 567 px", "1", "7", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("162", "6", "martin", "martin", "/Cross 2014/martin.jpg", "/Cross 2014/thumb/martin.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 800\nOrientation: 1\n", "martin", "16 November 2015, 18:58", "133 KB", "JPG", "850 x 603 px", "1", "6", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("163", "6", "matho", "matho", "/Cross 2014/matho.jpg", "/Cross 2014/thumb/matho.jpg", "Aperture: 3.2\nCamera: Canon EOS 6D\nIso: 125\nOrientation: 1\n", "matho", "16 November 2015, 18:58", "133 KB", "JPG", "850 x 584 px", "1", "5", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("164", "6", "mesdames", "mesdames", "/Cross 2014/mesdames.jpg", "/Cross 2014/thumb/mesdames.jpg", "Orientation: 1\n", "mesdames", "16 November 2015, 18:58", "119 KB", "JPG", "850 x 545 px", "1", "4", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("165", "6", "mesdames2", "mesdames2", "/Cross 2014/mesdames2.jpg", "/Cross 2014/thumb/mesdames2.jpg", "Aperture: 3.5\nCamera: Canon EOS 6D\nIso: 100\nOrientation: 1\n", "mesdames2", "16 November 2015, 18:58", "112 KB", "JPG", "850 x 567 px", "1", "3", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("166", "6", "nora_charlotte", "nora_charlotte", "/Cross 2014/nora_charlotte.jpg", "/Cross 2014/thumb/nora_charlotte.jpg", "Aperture: 2.8\nCamera: Canon EOS 6D\nIso: 640\nOrientation: 1\n", "nora_charlotte", "16 November 2015, 18:58", "101 KB", "JPG", "850 x 567 px", "1", "2", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("167", "6", "oscar", "oscar", "/Cross 2014/oscar.jpg", "/Cross 2014/thumb/oscar.jpg", "Orientation: 1\n", "oscar", "16 November 2015, 18:58", "93 KB", "JPG", "567 x 728 px", "1", "1", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("168", "7", "pompier034", "pompier034", "/Pompiers/pompier034.jpg", "/Pompiers/thumb/pompier034.jpg", "Aperture: 2.8\nCamera: Digimax L60\nIso: 50\nCopyright: Copyright 2005\nOrientation: 1\n", "pompier034", "16 November 2015, 18:59", "79 KB", "JPG", "480 x 360 px", "1", "6", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("169", "7", "pompier035", "pompier035", "/Pompiers/pompier035.jpg", "/Pompiers/thumb/pompier035.jpg", "Aperture: 2.8\nCamera: Digimax L60\nIso: 50\nCopyright: Copyright 2005\nOrientation: 1\n", "pompier035", "16 November 2015, 18:59", "105 KB", "JPG", "480 x 360 px", "1", "5", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("170", "7", "pompier036", "pompier036", "/Pompiers/pompier036.jpg", "/Pompiers/thumb/pompier036.jpg", "Aperture: 2.8\nCamera: Digimax L60\nIso: 50\nCopyright: Copyright 2005\nOrientation: 1\n", "pompier036", "16 November 2015, 18:59", "100 KB", "JPG", "480 x 360 px", "1", "4", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("171", "7", "pompier037", "pompier037", "/Pompiers/pompier037.jpg", "/Pompiers/thumb/pompier037.jpg", "Aperture: 4.9\nCamera: Digimax L60\nIso: 50\nCopyright: Copyright 2005\nOrientation: 1\n", "pompier037", "16 November 2015, 18:59", "74 KB", "JPG", "480 x 360 px", "1", "3", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("172", "7", "pompier038", "pompier038", "/Pompiers/pompier038.jpg", "/Pompiers/thumb/pompier038.jpg", "Aperture: 2.8\nCamera: Digimax L60\nIso: 50\nCopyright: Copyright 2005\nOrientation: 1\n", "pompier038", "16 November 2015, 18:59", "85 KB", "JPG", "480 x 360 px", "1", "2", "1", "0", "0", "0", "0", "");
INSERT INTO `wp_udange_bwg_image` VALUES("173", "7", "pompier039", "pompier039", "/Pompiers/pompier039.jpg", "/Pompiers/thumb/pompier039.jpg", "Aperture: 2.8\nCamera: Digimax L60\nIso: 200\nCopyright: Copyright 2005\nOrientation: 1\n", "pompier039", "16 November 2015, 18:59", "97 KB", "JPG", "480 x 360 px", "1", "1", "1", "0", "0", "0", "0", "");

/* INSERT TABLE DATA: wp_udange_bwg_option */
INSERT INTO `wp_udange_bwg_option` VALUES("1", "wp-content/uploads", "vertical", "vertical", "0", "100", "5", "30", "180", "90", "300", "300", "1", "none", "5", "30", "hover", "120", "90", "1", "150", "1", "800", "1", "1", "800", "1", "5", "1", "fade", "5", "800", "500", "0", "0", "1", "1", "90", "0", "top-right", "0", "bottom-right", "0", "", "800", "500", "fade", "5", "1", "70", "1", "1", "1", "0", "0", "1", "0", "0", "0", "0", "1", "1", "1", "none", "bottom-left", "90", "90", "http://udange2.ec-arlon.be/wp-content/plugins/photo-gallery/images/watermark.png", "web-dorado.com", "https://web-dorado.com", "20", "arial", "FFFFFF", "30", "none", "middle-center", "15", "http://udange2.ec-arlon.be/wp-content/plugins/photo-gallery/images/watermark.png", "web-dorado.com", "20", "arial", "FFFFFF", "30", "0", "0", "0", "0", "0", "0", "thumbnail", "0", "0", "0", "180", "0", "10", "open_lightbox", "1", "0", "0", "0", "0", "0", "0", "1200", "1200", "1", "0", "0", "0", "0", "30", "", "0", "1", "1", "1", "1", "1", "0", "", "5", "300", "300", "5", "0.75", "0", "0", "800", "1", "1", "1", "manage_options", "", "", "0", "0", "0");

/* INSERT TABLE DATA: wp_udange_bwg_shortcode */
INSERT INTO `wp_udange_bwg_shortcode` VALUES("1", " gallery_type=\"image_browser\" theme_id=\"1\" gallery_id=\"1\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" search_box_width=\"180\" image_browser_width=\"800\" image_browser_title_enable=\"0\" image_browser_description_enable=\"1\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" watermark_type=\"none\" watermark_link=\"https%3A%2F%2Fweb-dorado.com\"");
INSERT INTO `wp_udange_bwg_shortcode` VALUES("2", " gallery_type=\"album_extended_preview\" theme_id=\"1\" album_id=\"1\" sort_by=\"order\" order_by=\"asc\" show_search_box=\"0\" show_sort_images=\"0\" search_box_width=\"180\" extended_albums_per_page=\"30\" extended_album_height=\"150\" extended_album_description_enable=\"1\" extended_album_view_type=\"thumbnail\" extended_album_mosaic_hor_ver=\"vertical\" extended_album_resizable_mosaic=\"0\" extended_album_mosaic_total_width=\"100\" extended_album_thumb_width=\"120\" extended_album_thumb_height=\"90\" extended_album_image_column_number=\"5\" extended_album_images_per_page=\"30\" extended_album_image_title=\"none\" extended_album_image_thumb_width=\"180\" extended_album_image_thumb_height=\"90\" extended_album_enable_page=\"1\" extended_album_load_more_image_count=\"30\" extended_albums_per_page_load_more=\"30\" show_tag_box=\"0\" thumb_click_action=\"open_lightbox\" thumb_link_target=\"1\" popup_fullscreen=\"0\" popup_autoplay=\"0\" popup_width=\"800\" popup_height=\"500\" popup_effect=\"fade\" popup_interval=\"5\" popup_enable_filmstrip=\"1\" popup_filmstrip_height=\"70\" popup_enable_ctrl_btn=\"1\" popup_enable_fullscreen=\"1\" popup_enable_info=\"1\" popup_info_always_show=\"0\" popup_info_full_width=\"0\" popup_enable_rate=\"0\" popup_enable_comment=\"1\" popup_hit_counter=\"0\" popup_enable_facebook=\"1\" popup_enable_twitter=\"1\" popup_enable_google=\"1\" popup_enable_pinterest=\"0\" popup_enable_tumblr=\"0\" show_tag_box=\"0\" watermark_type=\"none\" watermark_link=\"https%3A%2F%2Fweb-dorado.com\"");

/* INSERT TABLE DATA: wp_udange_bwg_theme */
INSERT INTO `wp_udange_bwg_theme` VALUES("1", "Theme 1", "4", "0", "0", "0", "none", "CCCCCC", "FFFFFF", "FFFFFF", "0", "0px 0px 0px #888888", "100", "center", "scale", "1.1", "1", "CCCCCC", "segoe ui", "bottom", "16", "bold", "2px", "0px 0px 0px #888888", "bottom", "center", "0", "12", "segoe ui", "666666", "bold", "1", "solid", "E3E3E3", "0", "0", "3px 6px", "FFFFFF", "100", "0", "1", "0", "000000", "70", "000000", "bottom", "center", "20", "10", "7", "100", "FFFFFF", "14", "100", "000000", "65", "4", "100", "000000", "2", "16px", "none", "FFFFFF", "0", "FFFFFF", "10", "20", "20", "-10", "-10", "FFFFFF", "000000", "80", "20px", "0", "none", "FFFFFF", "", "FFFFFF", "40", "40", "20", "CCCCCC", "left", "400", "000000", "CCCCCC", "segoe ui", "12", "616161", "666666", "1", "none", "3px", "3px 10px", "333333", "666666", "1", "none", "0", "2px", "1", "solid", "383838", "14", "10", "12", "CCCCCC", "top", "3B3B3B", "20", "FFFFFF", "0 1px", "1", "solid", "000000", "0", "80", "0", "FFFFFF", "fa-chevron", "000000", "segoe ui", "16", "bold", "0", "CCCCCC", "segoe ui", "bottom", "16", "bold", "2px", "0px 0px 0px #888888", "4", "0", "0", "0", "none", "CCCCCC", "FFFFFF", "FFFFFF", "0", "0px 0px 0px #888888", "100", "center", "scale", "1.1", "0", "2", "0", "0", "0", "none", "CCCCCC", "FFFFFF", "FFFFFF", "0", "", "100", "left", "scale", "1.1", "0", "000000", "segoe ui", "20", "bold", "0", "FFFFFF", "0", "0 0 0 0", "0 0 5px 0", "10", "1", "solid", "E0E0E0", "FFFFFF", "0", "1", "solid", "E8E8E8", "5px", "FFFFFF", "0", "1", "solid", "E8E8E8", "5px", "1", "none", "CCCCCC", "000000", "segoe ui", "16", "bold", "2", "2px", "1", "none", "CCCCCC", "000000", "segoe ui", "14", "normal", "2px", "F2D22E", "12", "4", "0", "0", "none", "CCCCCC", "FFFFFF", "0", "100", "center", "scale", "1.1", "0", "4", "0", "0", "none", "CCCCCC", "FFFFFF", "0", "100", "center", "scale", "1.1", "CCCCCC", "segoe ui", "16", "bold", "2px", "0px 0px 0px #888888", "000000", "100", "000000", "20px", "0", "none", "FFFFFF", "0px 0px 0px #000000", "FFFFFF", "40", "20", "40", "CCCCCC", "top", "1", "solid", "000000", "0", "0 1px", "0", "FFFFFF", "80", "3B3B3B", "FFFFFF", "20", "16", "segoe ui", "FFFFFF", "70", "5px", "000000", "0 0 0 0", "14", "segoe ui", "FFFFFF", "70", "0", "000000", "5px 10px 5px 10px", "12", "12", "5px", "F2D22E", "3", "FFFFFF", "1", "000000", "60", "fa-chevron", "2px", "0", "0", "1", "solid", "F5F5F5", "FFFFFF", "", "80", "center", "FFFFFF", "5px auto 10px auto", "0", "0", "none", "000000", "right", "16", "segoe ui", "000000", "B3AFAF", "0", "20", "2px auto", "4px", "0", "1", "none", "F5F5F5", "EBEBEB", "", "80", "center", "0px 5px 0px 5px", "8px 8px 8px 8px", "0", "1", "none", "FFFFFF", "EBEBEB", "center", "15", "segoe ui", "000000", "4px", "0", "2", "none", "F7F7F7", "F5F5F5", "90", "top", "right", "000000", "70", "1", "none", "000000", "5px", "5px", "15px", "FFFFFF", "segoe ui", "bold", "18", "FFFFFF", "segoe ui", "normal", "14", "bottom", "right", "star", "F9D062", "20", "5", "15px", "F7B50E", "bottom", "left", "000000", "70", "1", "none", "000000", "5px", "5px", "0 5px", "FFFFFF", "segoe ui", "normal", "14", "12", "CCCCCC", "segoe ui", "000000", "segoe ui", "16", "bold", "0", "CCCCCC", "segoe ui", "bottom", "16", "bold", "2px", "0px 0px 0px #888888", "4", "0", "0", "0", "none", "CCCCCC", "FFFFFF", "FFFFFF", "0", "0px 0px 0px #888888", "100", "center", "scale", "1.1", "0", "000000", "0", "100", "000000", "20px", "0", "none", "FFFFFF", "FFFFFF", "40", "20", "20", "40", "CCCCCC", "fa-chevron", "0.5", "Arial", "2", "solid", "5D204F", "000000", "0", "0", "5", "bold", "14", "white", "100", "5px", "1", "1");
INSERT INTO `wp_udange_bwg_theme` VALUES("2", "Theme 2", "4", "4", "0", "5", "none", "FFFFFF", "E8E8E8", "FFFFFF", "0", "0px 0px 0px #888888", "100", "center", "rotate", "2deg", "1", "CCCCCC", "segoe ui", "bottom", "16", "bold", "5px", "", "bottom", "center", "0", "12", "segoe ui", "666666", "bold", "1", "none", "E3E3E3", "0", "0", "3px 6px", "FCFCFC", "100", "0", "1", "0", "000000", "70", "000000", "bottom", "center", "20", "10", "7", "80", "FFFFFF", "14", "100", "000000", "80", "4", "95", "000000", "0", "16px", "none", "FFFFFF", "", "FFFFFF", "10", "20", "20", "-10", "-10", "FFFFFF", "000000", "80", "20px", "2", "none", "FFFFFF", "", "FFFFFF", "40", "40", "20", "FFFFFF", "left", "400", "000000", "CCCCCC", "arial", "12", "333333", "666666", "1", "none", "3px", "3px 10px", "333333", "666666", "1", "none", "0", "3px", "1", "solid", "2B2B2B", "14", "10", "12", "FFFFFF", "top", "2B2B2B", "20", "FFFFFF", "0 1px", "1", "none", "000000", "0", "80", "0", "FFFFFF", "fa-chevron", "000000", "segoe ui", "14", "normal", "0", "CCCCCC", "segoe ui", "bottom", "16", "bold", "5px", "", "4", "4", "0", "1", "none", "000000", "E8E8E8", "FFFFFF", "100", "", "100", "center", "rotate", "2deg", "1", "2", "4", "0", "4", "none", "E8E8E8", "E8E8E8", "FFFFFF", "100", "", "100", "left", "rotate", "2deg", "0", "000000", "segoe ui", "16", "bold", "0", "FFFFFF", "0", "0", "0 0 5px 0", "10", "1", "none", "CCCCCC", "FFFFFF", "0", "0", "none", "CCCCCC", "0", "FFFFFF", "0", "1", "none", "CCCCCC", "5px", "1", "none", "CCCCCC", "000000", "segoe ui", "16", "bold", "2", "2px", "1", "none", "CCCCCC", "000000", "segoe ui", "14", "normal", "2px", "FFC933", "12", "4", "2px", "1", "none", "CCCCCC", "FFFFFF", "0", "80", "center", "rotate", "2deg", "0", "4", "2px", "1", "none", "CCCCCC", "FFFFFF", "0", "80", "center", "rotate", "2deg", "CCCCCC", "segoe ui", "16", "bold", "2px", "0px 0px 0px #888888", "000000", "100", "000000", "20px", "0", "none", "FFFFFF", "", "FFFFFF", "40", "20", "40", "DBDBDB", "bottom", "1", "none", "000000", "0", "0 1px", "0", "FFFFFF", "80", "303030", "FFFFFF", "20", "16", "segoe ui", "FFFFFF", "70", "5px", "000000", "5px 10px 5px 10px", "14", "segoe ui", "FFFFFF", "70", "0", "000000", "5px 10px 5px 10px", "10", "10", "10px", "292929", "1", "292929", "2", "FFC933", "60", "fa-chevron", "2px", "4px", "0", "1", "none", "CCCCCC", "E8E8E8", "", "70", "center", "FFFFFF", "5px auto 10px auto", "0", "0", "none", "000000", "right", "16", "segoe ui", "000000", "A1A1A1", "0", "20", "2px auto", "4px", "2px", "1", "none", "E8E8E8", "E8E8E8", "", "80", "center", "24px 0px 0px 0px", "8px 8px 8px 8px", "0", "1", "none", "FFFFFF", "E8E8E8", "center", "14", "segoe ui", "000000", "4px", "0", "1", "solid", "EDEDED", "FFFFFF", "90", "top", "right", "000000", "70", "1", "none", "000000", "5px", "5px", "15px", "FFFFFF", "segoe ui", "bold", "18", "FFFFFF", "segoe ui", "normal", "14", "bottom", "right", "star", "F9D062", "20", "5", "15px", "F7B50E", "bottom", "left", "000000", "70", "1", "none", "000000", "5px", "5px", "0 5px", "FFFFFF", "segoe ui", "normal", "14", "12", "CCCCCC", "segoe ui", "000000", "segoe ui", "14", "normal", "0", "CCCCCC", "segoe ui", "bottom", "16", "bold", "5px", "", "4", "4", "0", "1", "none", "000000", "E8E8E8", "FFFFFF", "100", "", "100", "center", "rotate", "2deg", "1", "000000", "0", "100", "000000", "20px", "0", "none", "FFFFFF", "FFFFFF", "40", "20", "20", "40", "CCCCCC", "fa-chevron", "0.5", "Arial", "2", "solid", "5D204F", "000000", "0", "0", "5", "bold", "14", "white", "100", "5px", "0", "1");

/* INSERT TABLE DATA: wp_udange_comments */
INSERT INTO `wp_udange_comments` VALUES("1", "1", "Monsieur WordPress", "", "https://wordpress.org/", "", "2015-11-06 21:08:41", "2015-11-06 20:08:41", "Bonjour, ceci est un commentaire.\nPour supprimer un commentaire, connectez-vous et affichez les commentaires de cet article. Vous pourrez alors les modifier ou les supprimer.", "0", "post-trashed", "", "", "0", "0");

/* INSERT TABLE DATA: wp_udange_contactformmaker */
INSERT INTO `wp_udange_contactformmaker` VALUES("1", "A mailing list", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"33\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%33 - map_33%</div></div></div><div wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\" disabled=\"yes\" style=\"opacity: 0.4;\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"32\" class=\"wdform_row\" style=\"opacity: 1;\">%32 - custom_32%</div><div wdid=\"2\" class=\"wdform_row\" style=\"opacity: 1;\">%2 - Your Name:%</div><div wdid=\"4\" class=\"wdform_row\" style=\"opacity: 1;\">%4 - E-mail:%</div><div wdid=\"28\" class=\"wdform_row\" style=\"opacity: 1;\">%28 - Type the characters you see here:%</div><div wdid=\"30\" class=\"wdform_row\">%30 - type_submit_reset_30%</div></div><div class=\"wdform_column\"><div wdid=\"5\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%5 - Website:%</div><div wdid=\"9\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%9 - Address:%</div><div wdid=\"27\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"31\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%31 - custom_31%</div><div wdid=\"29\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"26\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%26 - Which topic best describes your question?%</div><div wdid=\"16\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%16 - Company address:%</div><div wdid=\"25\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%25 - When is the best time to contact you:%</div><div wdid=\"15\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%15 - Company:%</div><div wdid=\"8\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%8 - Mobile:%</div><div wdid=\"6\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"3\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%3 - Name:%</div><div wdid=\"23\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%23 - Message:%</div><div wdid=\"22\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%22 - Subject:%</div><div wdid=\"24\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%24 - Issue type:%</div><div wdid=\"7\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%7 - Phone:%</div></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "1", "<p>%Your Name:% joined the mailing list from IP: %ip%</p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for joining</h1>\r\n</div>\r\n<p>%all%</p>", "34", "1", "33#**id**#map_33#**label**#type_map#****#32#**id**#custom_32#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#5#**id**#Website:#**label**#type_text#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#31#**id**#custom_31#**label**#type_editor#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#15#**id**#Company:#**label**#type_text#****#8#**id**#Mobile:#**label**#type_phone#****#6#**id**#Phone number:#**label**#type_text#****#3#**id**#Name:#**label**#type_name#****#23#**id**#Message:#**label**#type_textarea#****#22#**id**#Subject:#**label**#type_text#****#24#**id**#Issue type:#**label**#type_own_select#****#7#**id**#Phone:#**label**#type_phone#****#", "33#**id**#map_33#**label**#type_map#****#32#**id**#custom_32#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#5#**id**#Website:#**label**#type_text#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#31#**id**#custom_31#**label**#type_editor#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#15#**id**#Company:#**label**#type_text#****#8#**id**#Mobile:#**label**#type_phone#****#6#**id**#Phone number:#**label**#type_text#****#3#**id**#Name:#**label**#type_name#****#23#**id**#Message:#**label**#type_textarea#****#22#**id**#Subject:#**label**#type_text#****#24#**id**#Issue type:#**label**#type_own_select#****#7#**id**#Phone:#**label**#type_phone#****#", "0", "", "", "", "33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*-74.0059731*:*w_center_x*:*40.7143528*:*w_center_y*:*-74.005973*:*w_long*:*40.714353*:*w_lat*:*12*:*w_zoom*:*580*:*w_width*:*200*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<hr>*:*w_editor*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<h1 data-mce-style=\"color: #000000;\" style=\"color: #000000;\">Join the mailing list</h1>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*E-mail:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*true*:*w_first_val*:*no*:*w_required*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Mobile:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*77*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Message:*:*w_field_label*:*120*:*w_field_label_size*:*top*:*w_field_label_pos*:*290*:*w_size_w*:*150*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Subject:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Issue type:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Phone:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "33,1,5,9,10,11,12,13,14,27,31,29,26,16,17,18,19,20,21,25,15,8,6,3,23,22,24,7,", "", "", "", "", "", "", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("2", "Contact Form 1", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"></div></div><div wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"3\" class=\"wdform_row\" style=\"opacity: 1;\">%3 - Name:%</div><div wdid=\"4\" class=\"wdform_row\">%4 - E-mail:%</div><div wdid=\"7\" class=\"wdform_row\">%7 - Phone:%</div><div wdid=\"8\" class=\"wdform_row\" style=\"opacity: 1;\">%8 - Mobile:%</div><div wdid=\"15\" class=\"wdform_row\" style=\"opacity: 1;\">%15 - Company:%</div><div wdid=\"22\" class=\"wdform_row\">%22 - Subject:%</div><div wdid=\"26\" class=\"wdform_row\" style=\"opacity: 1;\">%26 - Which topic best describes your question?%</div><div wdid=\"23\" class=\"wdform_row\">%23 - Details:%</div><div wdid=\"25\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%25 - When is the best time to contact you:%</div><div wdid=\"27\" class=\"wdform_row\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"28\" class=\"wdform_row\" style=\"opacity: 1;\">%28 - Type the characters you see here:%</div><div wdid=\"30\" class=\"wdform_row\">%30 - type_submit_reset_30%</div><div wdid=\"31\" class=\"wdform_row\" style=\"opacity: 1;\">%31 - custom_31%</div><div wdid=\"2\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%2 - Your Name:%</div><div wdid=\"5\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%5 - Website:%</div><div wdid=\"6\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"16\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%16 - Company address:%</div><div wdid=\"9\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%9 - Address:%</div><div wdid=\"24\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%24 - Issue type:%</div><div wdid=\"29\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"33\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%33 - map_33%</div><div wdid=\"32\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%32 - custom_32%</div></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "3#**id**#Name:#**label**#type_name#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#7#**id**#Phone:#**label**#type_phone#****#8#**id**#Mobile:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#22#**id**#Subject:#**label**#type_text#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#23#**id**#Details:#**label**#type_textarea#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#32#**id**#custom_32#**label**#type_editor#****#", "3#**id**#Name:#**label**#type_name#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#7#**id**#Phone:#**label**#type_phone#****#8#**id**#Mobile:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#22#**id**#Subject:#**label**#type_text#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#23#**id**#Details:#**label**#type_textarea#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#32#**id**#custom_32#**label**#type_editor#****#", "0", "", "", "", "1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<h2 style=\"font-size: 30px; font-family: Bitter, Georgia, serif; clear: both; line-height: 1.3; margin: 25px 0px;\">Contact Us</h2><div style=\"color: rgb(20, 20, 18); font-family: Source Sans Pro, Helvetica, sans-serif; font-size: 16px; line-height: 24px;\">You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.</div>*:*w_editor*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*180*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*E-mail:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*360*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Phone:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Mobile:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Subject:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*yes*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*customLeftMargin*:*w_class*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Details:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*360*:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Issue type:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*44.497928*:*w_center_x*:*40.1525306*:*w_center_y*:*44.497928*:*w_long*:*40.152531*:*w_lat*:*12*:*w_zoom*:*300*:*w_width*:*400*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<p><strong>Sample Company, Inc.</strong></p><p>1412 South Main Expressway</p><p>Sugar Land, TX 98765</p><p>Phone: 123-987-6543</p><p>Fax: 123-987-6542</p>*:*w_editor*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "25,2,5,6,16,17,18,19,20,21,9,10,11,12,13,14,24,29,33,32,", "", "", "", "", "%Subject:%", "%Subject:%", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("3", "Contact Form 2", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column ui-sortable\"><div wdid=\"33\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 1;\">%33 - map_33%</div><div wdid=\"32\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 1;\">%32 - custom_32%</div><div wdid=\"2\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 1;\">%2 - Votre nom :%</div><div style=\"\" wdid=\"4\" class=\"wdform_row ui-sortable-handle\">%4 - E-mail:%</div><div style=\"\" wdid=\"22\" class=\"wdform_row ui-sortable-handle\">%22 - Sujet :%</div><div style=\"\" wdid=\"23\" class=\"wdform_row ui-sortable-handle\">%23 - Message:%</div><div style=\"\" wdid=\"30\" class=\"wdform_row ui-sortable-handle\">%30 - type_submit_reset_30%</div></div><div class=\"wdform_column ui-sortable\"></div><div class=\"wdform_column ui-sortable\"></div></div><div style=\"opacity: 0.4;\" disabled=\"yes\" wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column ui-sortable\"><div disabled=\"yes\" wdid=\"7\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%7 - Phone:%</div><div disabled=\"yes\" wdid=\"24\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%24 - Issue type:%</div></div><div class=\"wdform_column ui-sortable\"><div disabled=\"yes\" wdid=\"5\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%5 - Website:%</div><div disabled=\"yes\" wdid=\"9\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%9 - Address:%</div><div disabled=\"yes\" wdid=\"27\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"3\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%3 - Name:%</div><div wdid=\"8\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%8 - Mobile:%</div><div wdid=\"25\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%25 - When is the best time to contact you:%</div><div wdid=\"28\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%28 - Type the characters you see here:%</div><div wdid=\"6\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"15\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%15 - Company:%</div><div wdid=\"26\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%26 - Which topic best describes your question?%</div><div wdid=\"16\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%16 - Company address:%</div><div wdid=\"29\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"31\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%31 - custom_31%</div></div><div class=\"wdform_column ui-sortable\"></div><div class=\"wdform_column ui-sortable\"></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Your Name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Your Name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "33#**id**#map_33#**label**#type_map#****#32#**id**#custom_32#**label**#type_editor#****#2#**id**#Votre nom :#**label**#type_text#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#22#**id**#Sujet :#**label**#type_text#****#23#**id**#Message:#**label**#type_textarea#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#7#**id**#Phone:#**label**#type_phone#****#24#**id**#Issue type:#**label**#type_own_select#****#5#**id**#Website:#**label**#type_text#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#3#**id**#Name:#**label**#type_name#****#8#**id**#Mobile:#**label**#type_phone#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#6#**id**#Phone number:#**label**#type_text#****#15#**id**#Company:#**label**#type_text#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#31#**id**#custom_31#**label**#type_editor#****#", "33#**id**#map_33#**label**#type_map#****#32#**id**#custom_32#**label**#type_editor#****#2#**id**#Votre nom :#**label**#type_text#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#22#**id**#Sujet :#**label**#type_text#****#23#**id**#Message:#**label**#type_textarea#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#7#**id**#Phone:#**label**#type_phone#****#24#**id**#Issue type:#**label**#type_own_select#****#5#**id**#Website:#**label**#type_text#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#3#**id**#Name:#**label**#type_name#****#8#**id**#Mobile:#**label**#type_phone#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#6#**id**#Phone number:#**label**#type_text#****#15#**id**#Company:#**label**#type_text#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#31#**id**#custom_31#**label**#type_editor#****#", "0", "", "", "", "33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*5.81730440300305*:*w_center_x*:*49.673347289840684*:*w_center_y*:*5.817390*:*w_long*:*49.673236*:*w_lat*:*16*:*w_zoom*:*580*:*w_width*:*200*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<div style=\"color: rgb(20, 20, 18); font-family: Source Sans Pro, Helvetica, sans-serif; font-size: 16px; line-height: 24px;\"><div id=\"contact_usage\">Le formulaire ci-dessous est destiné uniquement à contacter la direction.</div></div>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Votre nom :*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*250*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*E-mail:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*250*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Sujet :*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*250*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Message:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*290*:*w_size_w*:*180*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Envoyer*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<hr>*:*w_editor*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Phone:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Issue type:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*77*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Mobile:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***1***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "1,7,24,5,9,10,11,12,13,14,27,3,8,25,28,6,15,26,16,17,18,19,20,21,29,31,", "", "", "", "", "%Subject:%", "%Subject:%", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("4", "Contact Form 3", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"></div></div><div wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\" disabled=\"yes\" style=\"opacity: 0.4;\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"32\" class=\"wdform_row\" style=\"opacity: 1;\">%32 - custom_32%</div><div wdid=\"3\" class=\"wdform_row\" style=\"opacity: 1;\">%3 - Enter your name:%</div><div wdid=\"4\" class=\"wdform_row\">%4 - Enter your E-mail:%</div><div wdid=\"7\" class=\"wdform_row\">%7 - Home Phone:%</div><div wdid=\"8\" class=\"wdform_row\" style=\"opacity: 1;\">%8 - Work Phone:%</div><div wdid=\"15\" class=\"wdform_row\" style=\"opacity: 1;\">%15 - Company:%</div><div wdid=\"22\" class=\"wdform_row\">%22 - Message Subject:%</div><div wdid=\"23\" class=\"wdform_row\">%23 - Enter your Message:%</div><div wdid=\"26\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%26 - Which topic best describes your question?%</div><div wdid=\"25\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%25 - When is the best time to contact you:%</div><div wdid=\"27\" class=\"wdform_row\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"28\" class=\"wdform_row\" style=\"opacity: 1;\">%28 - Type the characters you see here:%</div><div wdid=\"30\" class=\"wdform_row\">%30 - type_submit_reset_30%</div><div wdid=\"31\" class=\"wdform_row\" style=\"opacity: 1;\">%31 - custom_31%</div><div wdid=\"2\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%2 - Your Name:%</div><div wdid=\"5\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%5 - Website:%</div><div wdid=\"6\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"16\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%16 - Company address:%</div><div wdid=\"9\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%9 - Address:%</div><div wdid=\"24\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%24 - Issue type:%</div><div wdid=\"29\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"33\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%33 - map_33%</div></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Enter your name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Enter your name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "32#**id**#custom_32#**label**#type_editor#****#3#**id**#Enter your name:#**label**#type_name#****#4#**id**#Enter your E-mail:#**label**#type_submitter_mail#****#7#**id**#Home Phone:#**label**#type_phone#****#8#**id**#Work Phone:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#22#**id**#Message Subject:#**label**#type_text#****#23#**id**#Enter your Message:#**label**#type_textarea#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#", "32#**id**#custom_32#**label**#type_editor#****#3#**id**#Enter your name:#**label**#type_name#****#4#**id**#Enter your E-mail:#**label**#type_submitter_mail#****#7#**id**#Home Phone:#**label**#type_phone#****#8#**id**#Work Phone:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#22#**id**#Message Subject:#**label**#type_text#****#23#**id**#Enter your Message:#**label**#type_textarea#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#", "0", "", "", "", "1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<h2 style=\"font-size: 30px; font-family: Bitter, Georgia, serif; clear: both; line-height: 1.3; margin: 25px 0px;\">Contact Us</h2><div style=\"color: rgb(20, 20, 18); font-family: Source Sans Pro, Helvetica, sans-serif; font-size: 16px; line-height: 24px;\">You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.</div>*:*w_editor*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<p><strong>Sample Company, Inc.</strong></p><p>1412 South Main Expressway</p><p>Sugar Land, TX 98765</p><p>Phone: 123-987-6543</p><p>Fax: 123-987-6542</p>*:*w_editor*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Enter your name:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*180*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*Enter your E-mail:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Home Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Work Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Message Subject:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Enter your Message:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size_w*:*300*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*yes*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*customLeftMargin*:*w_class*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Issue type:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*44.497928*:*w_center_x*:*40.1525306*:*w_center_y*:*44.497928*:*w_long*:*40.152531*:*w_lat*:*12*:*w_zoom*:*300*:*w_width*:*400*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "1,26,25,2,5,6,16,17,18,19,20,21,9,10,11,12,13,14,24,29,33,", "", "", "", "", "%Message Subject:%", "%Message Subject:%", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("5", "Contact Form 4", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"></div></div><div wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\" disabled=\"yes\" style=\"opacity: 0.4;\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"32\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%32 - custom_32%</div><div wdid=\"3\" class=\"wdform_row\" style=\"opacity: 1;\">%3 - Enter your name:%</div><div wdid=\"4\" class=\"wdform_row\">%4 - Enter your E-mail:%</div><div wdid=\"7\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%7 - Home Phone:%</div><div wdid=\"8\" class=\"wdform_row\" style=\"opacity: 1;\">%8 - Work Phone:%</div><div wdid=\"15\" class=\"wdform_row\" style=\"opacity: 1;\">%15 - Company:%</div><div wdid=\"16\" class=\"wdform_row\" style=\"opacity: 1;\">%16 - Company address:%</div><div wdid=\"22\" class=\"wdform_row\">%22 - Message Subject:%</div><div wdid=\"23\" class=\"wdform_row\">%23 - Enter your Message:%</div><div wdid=\"26\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%26 - Which topic best describes your question?%</div><div wdid=\"25\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%25 - When is the best time to contact you:%</div><div wdid=\"27\" class=\"wdform_row\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"28\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%28 - Type the characters you see here:%</div><div wdid=\"30\" class=\"wdform_row\">%30 - type_submit_reset_30%</div><div wdid=\"31\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%31 - custom_31%</div><div wdid=\"2\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%2 - Your Name:%</div><div wdid=\"5\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%5 - Website:%</div><div wdid=\"6\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"9\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%9 - Address:%</div><div wdid=\"24\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%24 - Issue type:%</div><div wdid=\"29\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"33\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%33 - map_33%</div></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Enter your name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Enter your name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "32#**id**#custom_32#**label**#type_editor#****#3#**id**#Enter your name:#**label**#type_name#****#4#**id**#Enter your E-mail:#**label**#type_submitter_mail#****#7#**id**#Home Phone:#**label**#type_phone#****#8#**id**#Work Phone:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#22#**id**#Message Subject:#**label**#type_text#****#23#**id**#Enter your Message:#**label**#type_textarea#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#", "32#**id**#custom_32#**label**#type_editor#****#3#**id**#Enter your name:#**label**#type_name#****#4#**id**#Enter your E-mail:#**label**#type_submitter_mail#****#7#**id**#Home Phone:#**label**#type_phone#****#8#**id**#Work Phone:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#22#**id**#Message Subject:#**label**#type_text#****#23#**id**#Enter your Message:#**label**#type_textarea#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#", "0", "", "", "", "1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<h2 style=\"font-size: 30px; font-family: Bitter, Georgia, serif; clear: both; line-height: 1.3; margin: 25px 0px;\">Contact Us</h2><div style=\"color: rgb(20, 20, 18); font-family: Source Sans Pro, Helvetica, sans-serif; font-size: 16px; line-height: 24px;\">You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.</div>*:*w_editor*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<p><strong>Sample Company, Inc.</strong></p><p>1412 South Main Expressway</p><p>Sugar Land, TX 98765</p><p>Phone: 123-987-6543</p><p>Fax: 123-987-6542</p>*:*w_editor*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Enter your name:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*180*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*Enter your E-mail:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Home Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Work Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Message Subject:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Enter your Message:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size_w*:*200*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*yes*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*customLeftMargin*:*w_class*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Issue type:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*44.497928*:*w_center_x*:*40.1525306*:*w_center_y*:*44.497928*:*w_long*:*40.152531*:*w_lat*:*12*:*w_zoom*:*300*:*w_width*:*400*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "1,32,7,26,25,28,31,2,5,6,9,10,11,12,13,14,24,29,33,", "", "", "", "%Message Subject:%", "%Message Subject:%", "", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("6", "Contact Form 5", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column ui-sortable\"><div disabled=\"yes\" wdid=\"32\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%32 - custom_32%</div><div wdid=\"33\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 1;\">%33 - map_33%</div></div><div class=\"wdform_column ui-sortable\"></div></div><div wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column ui-sortable\"><div wdid=\"2\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%2 - Your Name:%</div><div wdid=\"3\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 1;\">%3 - Name:%</div><div wdid=\"4\" class=\"wdform_row ui-sortable-handle\">%4 - E-mail:%</div><div style=\"\" wdid=\"22\" class=\"wdform_row ui-sortable-handle\">%22 - Subject:%</div><div disabled=\"yes\" wdid=\"7\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%7 - Home Phone:%</div><div disabled=\"yes\" wdid=\"8\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%8 - Mobile:%</div><div disabled=\"yes\" wdid=\"5\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%5 - Website:%</div><div disabled=\"yes\" wdid=\"25\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%25 - When is the best time to contact you:%</div><div wdid=\"9\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%9 - Address:%</div><div wdid=\"28\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%28 - Type the characters you see here:%</div><div wdid=\"6\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"15\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%15 - Company:%</div><div wdid=\"26\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%26 - Which topic best describes your question?%</div><div wdid=\"16\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%16 - Company address:%</div><div wdid=\"29\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"31\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%31 - custom_31%</div></div><div class=\"wdform_column ui-sortable\"><div disabled=\"yes\" wdid=\"24\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%24 - Topic:%</div><div wdid=\"23\" class=\"wdform_row ui-sortable-handle\">%23 - Message:%</div><div disabled=\"yes\" wdid=\"27\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"30\" class=\"wdform_row ui-sortable-handle\">%30 - type_submit_reset_30%</div></div><div class=\"wdform_column ui-sortable\"></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "32#**id**#custom_32#**label**#type_editor#****#33#**id**#map_33#**label**#type_map#****#2#**id**#Your Name:#**label**#type_text#****#3#**id**#Name:#**label**#type_name#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#22#**id**#Subject:#**label**#type_text#****#7#**id**#Home Phone:#**label**#type_phone#****#8#**id**#Mobile:#**label**#type_phone#****#5#**id**#Website:#**label**#type_text#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#6#**id**#Phone number:#**label**#type_text#****#15#**id**#Company:#**label**#type_text#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#31#**id**#custom_31#**label**#type_editor#****#24#**id**#Topic:#**label**#type_own_select#****#23#**id**#Message:#**label**#type_textarea#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#", "32#**id**#custom_32#**label**#type_editor#****#33#**id**#map_33#**label**#type_map#****#2#**id**#Your Name:#**label**#type_text#****#3#**id**#Name:#**label**#type_name#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#22#**id**#Subject:#**label**#type_text#****#7#**id**#Home Phone:#**label**#type_phone#****#8#**id**#Mobile:#**label**#type_phone#****#5#**id**#Website:#**label**#type_text#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#6#**id**#Phone number:#**label**#type_text#****#15#**id**#Company:#**label**#type_text#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#31#**id**#custom_31#**label**#type_editor#****#24#**id**#Topic:#**label**#type_own_select#****#23#**id**#Message:#**label**#type_textarea#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#", "0", "", "", "", "32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<h2 style=\"font-size: 30px; font-family: Bitter, Georgia, serif; clear: both; line-height: 1.3; margin: 25px 0px;\">Contact Us</h2><div style=\"color: rgb(20, 20, 18); font-family: Source Sans Pro, Helvetica, sans-serif; font-size: 16px; line-height: 24px;\">You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.</div>*:*w_editor*:**:*new_field*:*33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*-74.0059731*:*w_center_x*:*40.7143528*:*w_center_y*:*-74.005973*:*w_long*:*40.714353*:*w_lat*:*7*:*w_zoom*:*580*:*w_width*:*200*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<hr>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*77*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*E-mail:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*160*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Subject:*:*w_field_label*:*70*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Home Phone:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Mobile:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*160*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***1***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Topic:*:*w_field_label*:*70*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Message:*:*w_field_label*:*120*:*w_field_label_size*:*top*:*w_field_label_pos*:*250*:*w_size_w*:*300*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "32,2,7,8,5,25,9,10,11,12,13,14,28,6,15,26,16,17,18,19,20,21,29,31,24,27,", "", "", "", "", "%Subject:%", "%Subject:%", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("7", "Contact Form 6", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"></div></div><div wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\" disabled=\"yes\" style=\"opacity: 0.4;\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"32\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%32 - custom_32%</div><div wdid=\"3\" class=\"wdform_row\" style=\"opacity: 1;\">%3 - Name:%</div><div wdid=\"4\" class=\"wdform_row\">%4 - E-mail Address:%</div><div wdid=\"26\" class=\"wdform_row\" style=\"opacity: 1;\">%26 - Which topic best describes your question?%</div><div wdid=\"23\" class=\"wdform_row\">%23 - Enter your Message:%</div><div wdid=\"7\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%7 - Home Phone:%</div><div wdid=\"8\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%8 - Work Phone:%</div><div wdid=\"15\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%15 - Company:%</div><div wdid=\"16\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%16 - Company address:%</div><div wdid=\"22\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%22 - Message Subject:%</div><div wdid=\"25\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%25 - When is the best time to contact you:%</div><div wdid=\"27\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"28\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%28 - Type the characters you see here:%</div><div wdid=\"30\" class=\"wdform_row\">%30 - type_submit_reset_30%</div><div wdid=\"31\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%31 - custom_31%</div><div wdid=\"2\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%2 - Your Name:%</div><div wdid=\"5\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%5 - Website:%</div><div wdid=\"6\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"9\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%9 - Address:%</div><div wdid=\"24\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%24 - Issue type:%</div><div wdid=\"29\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"33\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%33 - map_33%</div></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "32#**id**#custom_32#**label**#type_editor#****#3#**id**#Name:#**label**#type_name#****#4#**id**#E-mail Address:#**label**#type_submitter_mail#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#23#**id**#Enter your Message:#**label**#type_textarea#****#7#**id**#Home Phone:#**label**#type_phone#****#8#**id**#Work Phone:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#22#**id**#Message Subject:#**label**#type_text#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#", "32#**id**#custom_32#**label**#type_editor#****#3#**id**#Name:#**label**#type_name#****#4#**id**#E-mail Address:#**label**#type_submitter_mail#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#23#**id**#Enter your Message:#**label**#type_textarea#****#7#**id**#Home Phone:#**label**#type_phone#****#8#**id**#Work Phone:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#22#**id**#Message Subject:#**label**#type_text#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#", "0", "", "", "", "1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<h2 style=\"font-size: 30px; font-family: Bitter, Georgia, serif; clear: both; line-height: 1.3; margin: 25px 0px;\">Contact Us</h2><div style=\"color: rgb(20, 20, 18); font-family: Source Sans Pro, Helvetica, sans-serif; font-size: 16px; line-height: 24px;\">You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.</div>*:*w_editor*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<p><strong>Sample Company, Inc.</strong></p><p>1412 South Main Expressway</p><p>Sugar Land, TX 98765</p><p>Phone: 123-987-6543</p><p>Fax: 123-987-6542</p>*:*w_editor*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Name:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*180*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*E-mail Address:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*yes*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*customLeftMargin*:*w_class*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Enter your Message:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size_w*:*200*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Home Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Work Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Message Subject:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Issue type:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*44.497928*:*w_center_x*:*40.1525306*:*w_center_y*:*44.497928*:*w_long*:*40.152531*:*w_lat*:*12*:*w_zoom*:*300*:*w_width*:*400*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "1,32,7,8,15,16,17,18,19,20,21,22,25,27,28,31,2,5,6,9,10,11,12,13,14,24,29,33,", "", "", "", "", "", "", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("8", "Contact Form 7", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"></div></div><div wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\" style=\"opacity: 1;\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"3\" class=\"wdform_row\" style=\"opacity: 1;\">%3 - Enter your name:%</div><div wdid=\"4\" class=\"wdform_row\">%4 - Enter your E-mail:%</div><div wdid=\"22\" class=\"wdform_row\">%22 - Message Subject:%</div><div wdid=\"26\" class=\"wdform_row\" style=\"opacity: 1;\">%26 - CMS:%</div><div wdid=\"24\" class=\"wdform_row\" style=\"opacity: 1;\">%24 - Product:%</div><div wdid=\"8\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%8 - Work Phone:%</div><div wdid=\"15\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%15 - Company:%</div><div wdid=\"25\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%25 - When is the best time to contact you:%</div><div wdid=\"28\" class=\"wdform_row\" style=\"opacity: 1;\">%28 - Type the characters you see here:%</div><div wdid=\"31\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%31 - custom_31%</div><div wdid=\"2\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%2 - Your Name:%</div><div wdid=\"5\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%5 - Website:%</div><div wdid=\"6\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"16\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%16 - Company address:%</div><div wdid=\"9\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%9 - Address:%</div><div wdid=\"29\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"33\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%33 - map_33%</div><div wdid=\"32\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%32 - custom_32%</div><div wdid=\"7\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%7 - Home Phone:%</div></div><div class=\"wdform_column\"><div wdid=\"23\" class=\"wdform_row\">%23 - Enter your Message:%</div><div wdid=\"27\" class=\"wdform_row\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"30\" class=\"wdform_row\">%30 - type_submit_reset_30%</div></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Enter your name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Enter your name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "3#**id**#Enter your name:#**label**#type_name#****#4#**id**#Enter your E-mail:#**label**#type_submitter_mail#****#22#**id**#Message Subject:#**label**#type_text#****#26#**id**#CMS:#**label**#type_radio#****#24#**id**#Product:#**label**#type_own_select#****#8#**id**#Work Phone:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#32#**id**#custom_32#**label**#type_editor#****#7#**id**#Home Phone:#**label**#type_phone#****#23#**id**#Enter your Message:#**label**#type_textarea#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#", "3#**id**#Enter your name:#**label**#type_name#****#4#**id**#Enter your E-mail:#**label**#type_submitter_mail#****#22#**id**#Message Subject:#**label**#type_text#****#26#**id**#CMS:#**label**#type_radio#****#24#**id**#Product:#**label**#type_own_select#****#8#**id**#Work Phone:#**label**#type_phone#****#15#**id**#Company:#**label**#type_text#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#31#**id**#custom_31#**label**#type_editor#****#2#**id**#Your Name:#**label**#type_text#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#33#**id**#map_33#**label**#type_map#****#32#**id**#custom_32#**label**#type_editor#****#7#**id**#Home Phone:#**label**#type_phone#****#23#**id**#Enter your Message:#**label**#type_textarea#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#", "0", "", "", "", "1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<h2 style=\"font-size: 30px; font-family: Bitter, Georgia, serif; clear: both; line-height: 1.3; margin: 25px 0px;\">Contact Us</h2><div style=\"color: rgb(20, 20, 18); font-family: Source Sans Pro, Helvetica, sans-serif; font-size: 16px; line-height: 24px;\">You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.</div>*:*w_editor*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Enter your name:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*155*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*Enter your E-mail:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*310*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Message Subject:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*310*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*CMS:*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*hor*:*w_flow*:*Joomla***WordPress***Drupal*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*yes*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*customLeftMargin*:*w_class*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Product:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*310*:*w_size*:*Select product***Contact Form Maker***Dripping Menu***Folder Menu***Form Maker***Other*:*w_choices*:*true***false***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Work Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*360*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*44.497928*:*w_center_x*:*40.1525306*:*w_center_y*:*44.497928*:*w_long*:*40.152531*:*w_lat*:*11*:*w_zoom*:*300*:*w_width*:*400*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<p><strong>Sample Company, Inc.</strong></p><p>1412 South Main Expressway</p><p>Sugar Land, TX 98765</p><p>Phone: 123-987-6543</p><p>Fax: 123-987-6542</p>*:*w_editor*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Home Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*300*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Enter your Message:*:*w_field_label*:*200*:*w_field_label_size*:*top*:*w_field_label_pos*:*200*:*w_size_w*:*300*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "8,15,25,31,2,5,6,16,17,18,19,20,21,9,10,11,12,13,14,29,33,32,7,", "", "", "", "", "%Message Subject:%", "%Message Subject:%", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("9", "Contact Form 8", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\" style=\"opacity: 1;\">%2 - Your Name:%</div><div wdid=\"7\" class=\"wdform_row\" style=\"opacity: 1;\">%7 - Phone:%</div></div><div class=\"wdform_column\"><div wdid=\"4\" class=\"wdform_row\">%4 - E-mail:%</div><div wdid=\"5\" class=\"wdform_row\" style=\"opacity: 1;\">%5 - Website:%</div></div></div><div wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"22\" class=\"wdform_row\">%22 - Subject:%</div><div wdid=\"23\" class=\"wdform_row\">%23 - Message:%</div><div wdid=\"32\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%32 - custom_32%</div><div wdid=\"28\" class=\"wdform_row\" style=\"opacity: 1;\">%28 - Type the characters you see here:%</div><div wdid=\"30\" class=\"wdform_row\">%30 - type_submit_reset_30%</div></div><div class=\"wdform_column\"><div wdid=\"9\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%9 - Address:%</div><div wdid=\"27\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%27 - Send a copy of this message to yourself:%</div><div wdid=\"3\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%3 - Name:%</div><div wdid=\"8\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%8 - Mobile:%</div><div wdid=\"25\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%25 - When is the best time to contact you:%</div><div wdid=\"6\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div wdid=\"15\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%15 - Company:%</div><div wdid=\"26\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%26 - Which topic best describes your question?%</div><div wdid=\"16\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%16 - Company address:%</div><div wdid=\"29\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"31\" class=\"wdform_row\" disabled=\"yes\" style=\"opacity: 0.4;\">%31 - custom_31%</div><div wdid=\"24\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%24 - Issue type:%</div><div wdid=\"33\" class=\"wdform_row\" style=\"opacity: 0.4;\" disabled=\"yes\">%33 - map_33%</div></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Your Name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Your Name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "2#**id**#Your Name:#**label**#type_text#****#7#**id**#Phone:#**label**#type_phone#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#5#**id**#Website:#**label**#type_text#****#22#**id**#Subject:#**label**#type_text#****#23#**id**#Message:#**label**#type_textarea#****#32#**id**#custom_32#**label**#type_editor#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#3#**id**#Name:#**label**#type_name#****#8#**id**#Mobile:#**label**#type_phone#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#6#**id**#Phone number:#**label**#type_text#****#15#**id**#Company:#**label**#type_text#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#31#**id**#custom_31#**label**#type_editor#****#24#**id**#Issue type:#**label**#type_own_select#****#33#**id**#map_33#**label**#type_map#****#", "2#**id**#Your Name:#**label**#type_text#****#7#**id**#Phone:#**label**#type_phone#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#5#**id**#Website:#**label**#type_text#****#22#**id**#Subject:#**label**#type_text#****#23#**id**#Message:#**label**#type_textarea#****#32#**id**#custom_32#**label**#type_editor#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#3#**id**#Name:#**label**#type_name#****#8#**id**#Mobile:#**label**#type_phone#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#6#**id**#Phone number:#**label**#type_text#****#15#**id**#Company:#**label**#type_text#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#31#**id**#custom_31#**label**#type_editor#****#24#**id**#Issue type:#**label**#type_own_select#****#33#**id**#map_33#**label**#type_map#****#", "0", "", "", "", "2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Phone:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*E-mail:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*180*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<hr>*:*w_editor*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Subject:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*480*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Message:*:*w_field_label*:*120*:*w_field_label_size*:*top*:*w_field_label_pos*:*480*:*w_size_w*:*250*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:**:*w_editor*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*77*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Mobile:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***1***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Issue type:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*-74.0059731*:*w_center_x*:*40.7143528*:*w_center_y*:*-74.005973*:*w_long*:*40.714353*:*w_lat*:*11*:*w_zoom*:*200*:*w_width*:*200*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "32,9,10,11,12,13,14,27,3,8,25,6,15,26,16,17,18,19,20,21,29,31,24,33,", "", "", "", "", "%Subject:%", "%Subject:%", "1", "1", "1", "1");
INSERT INTO `wp_udange_contactformmaker` VALUES("10", "Contact Form 9", "", "<div class=\"wdform-page-and-images\" style=\"display:table; border-top:0px solid black;\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"false\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column ui-sortable\"></div><div class=\"wdform_column ui-sortable\"></div></div><div style=\"opacity: 0.4;\" disabled=\"yes\" wdid=\"1\" type=\"type_section_break\" class=\"wdform_tr_section_break\">%1 - custom_1%</div><div class=\"wdform_section\"><div class=\"wdform_column ui-sortable\"><div wdid=\"2\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 1;\">%2 - Your Name:%</div><div wdid=\"3\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%3 - Name:%</div><div wdid=\"4\" class=\"wdform_row ui-sortable-handle\">%4 - E-mail:%</div><div wdid=\"5\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%5 - Website:%</div><div wdid=\"6\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%6 - Phone number:%</div><div style=\"opacity: 0.4;\" disabled=\"yes\" wdid=\"7\" class=\"wdform_row ui-sortable-handle\">%7 - Phone:%</div><div wdid=\"8\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%8 - Mobile:%</div><div wdid=\"9\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%9 - Address:%</div><div wdid=\"15\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%15 - Company:%</div><div wdid=\"16\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%16 - Company address:%</div><div disabled=\"yes\" wdid=\"24\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%24 - Issue type:%</div><div wdid=\"22\" class=\"wdform_row ui-sortable-handle\">%22 - Subject:%</div><div wdid=\"23\" class=\"wdform_row ui-sortable-handle\">%23 - Message:%</div><div wdid=\"25\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%25 - When is the best time to contact you:%</div><div wdid=\"26\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%26 - Which topic best describes your question?%</div><div style=\"opacity: 0.4;\" disabled=\"yes\" wdid=\"27\" class=\"wdform_row ui-sortable-handle\">%27 - Send a copy of this message to yourself:%</div><div disabled=\"yes\" wdid=\"28\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\">%28 - Type the characters you see here:%</div><div wdid=\"29\" class=\"wdform_row ui-sortable-handle\" style=\"opacity: 0.4;\" disabled=\"yes\">%29 - Type the characters you see here%</div><div wdid=\"30\" class=\"wdform_row ui-sortable-handle\">%30 - type_submit_reset_30%</div><div wdid=\"31\" class=\"wdform_row ui-sortable-handle\" disabled=\"yes\" style=\"opacity: 0.4;\">%31 - custom_31%</div></div><div class=\"wdform_column ui-sortable\"><div wdid=\"32\" class=\"wdform_row ui-sortable-handle\">%32 - custom_32%</div><div wdid=\"33\" class=\"wdform_row ui-sortable-handle\">%33 - map_33%</div></div><div class=\"wdform_column ui-sortable\"></div></div><div valign=\"top\" class=\"wdform_footer\" style=\"width: 100%;\"><div style=\"width: 100%;\"><div style=\"width: 100%; display: table;\"><div style=\"display: table-row-group;\"><div id=\"form_id_temppage_nav1\" style=\"display: table-row;\"></div></div></div></div></div></div></div>", "4", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Thank you for contacting us</h1>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>", "", "3", "<p>%Your Name:% sent you a message from IP: %ip%</p>\r\n<p> </p>\r\n<p>%all%</p>", "<div class=\"content_head\" style=\"color: #565759;\">\r\n<h1>Dear %Your Name:%</h1>\r\n<h2>Thank you for contacting us</h2>\r\n</div>\r\n<p>We have received your message and will respond to you within 24 hours (Monday-Friday).</p>\r\n<p>For urgent inquiries, please contact us using phone numbers down below.</p>\r\n<p>Phone: 123-987-6543</p>\r\n<p>Fax: 123-987-6542</p>\r\n<p> </p>\r\n<p> </p>\r\n<p>%all%</p>", "34", "1", "2#**id**#Your Name:#**label**#type_text#****#3#**id**#Name:#**label**#type_name#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#7#**id**#Phone:#**label**#type_phone#****#8#**id**#Mobile:#**label**#type_phone#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#15#**id**#Company:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#22#**id**#Subject:#**label**#type_text#****#23#**id**#Message:#**label**#type_textarea#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#32#**id**#custom_32#**label**#type_editor#****#33#**id**#map_33#**label**#type_map#****#", "2#**id**#Your Name:#**label**#type_text#****#3#**id**#Name:#**label**#type_name#****#4#**id**#E-mail:#**label**#type_submitter_mail#****#5#**id**#Website:#**label**#type_text#****#6#**id**#Phone number:#**label**#type_text#****#7#**id**#Phone:#**label**#type_phone#****#8#**id**#Mobile:#**label**#type_phone#****#9#**id**#Street Address#**label**#type_address#****#10#**id**#Street Address Line 2#**label**#type_address#****#11#**id**#City#**label**#type_address#****#12#**id**#State / Province / Region#**label**#type_address#****#13#**id**#Postal / Zip Code#**label**#type_address#****#14#**id**#Country#**label**#type_address#****#15#**id**#Company:#**label**#type_text#****#16#**id**#Street Address#**label**#type_address#****#18#**id**#City#**label**#type_address#****#20#**id**#Postal / Zip Code#**label**#type_address#****#24#**id**#Issue type:#**label**#type_own_select#****#22#**id**#Subject:#**label**#type_text#****#23#**id**#Message:#**label**#type_textarea#****#25#**id**#When is the best time to contact you:#**label**#type_checkbox#****#26#**id**#Which topic best describes your question?#**label**#type_radio#****#27#**id**#Send a copy of this message to yourself:#**label**#type_send_copy#****#28#**id**#Type the characters you see here:#**label**#type_captcha#****#29#**id**#Type the characters you see here#**label**#type_recaptcha#****#30#**id**#type_submit_reset_30#**label**#type_submit_reset#****#31#**id**#custom_31#**label**#type_editor#****#32#**id**#custom_32#**label**#type_editor#****#33#**id**#map_33#**label**#type_map#****#", "0", "", "", "", "1*:*id*:*type_section_break*:*type*:*custom_1*:*w_field_label*:*<h2 style=\"font-size: 30px; font-family: Bitter, Georgia, serif; clear: both; line-height: 1.3; margin: 25px 0px;\">Contact Us</h2><div style=\"color: rgb(20, 20, 18); font-family: Source Sans Pro, Helvetica, sans-serif; font-size: 16px; line-height: 24px;\">You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.</div>*:*w_editor*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Your Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*3*:*id*:*type_name*:*type*:*Name:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*****:*w_first_val*:*****:*w_title*:*Title***First***Last***Middle*:*w_mini_labels*:*77*:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*E-mail:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*someone@example.com*:*w_first_val*:*someone@example.com*:*w_title*:*yes*:*w_required*:**:*w_unique*:**:*w_class*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Website:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*example.com*:*w_first_val*:*example.com*:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Phone number:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*7*:*id*:*type_phone*:*type*:*Phone:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*8*:*id*:*type_phone*:*type*:*Mobile:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*100*:*w_size*:*****:*w_first_val*:*****:*w_title*:*Area Code***Phone Number*:*w_mini_labels*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*9*:*id*:*type_address*:*type*:*Address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*15*:*id*:*type_text*:*type*:*Company:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*16*:*id*:*type_address*:*type*:*Company address:*:*w_field_label*:*100*:*w_field_label_size*:*top*:*w_field_label_pos*:*280*:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***yes***no***yes***no***yes***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*24*:*id*:*type_own_select*:*type*:*Issue type:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:*(Select a Topic)***Pre-Sales Question***Product Support***Site Suggestions***Other*:*w_choices*:*true***false***false***false***false*:*w_choices_checked*:*false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*wdform_select*:*w_class*:**:*new_field*:*22*:*id*:*type_text*:*type*:*Subject:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*180*:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:**:*new_field*:*23*:*id*:*type_textarea*:*type*:*Message:*:*w_field_label*:*120*:*w_field_label_size*:*top*:*w_field_label_pos*:*290*:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*25*:*id*:*type_checkbox*:*type*:*When is the best time to contact you:*:*w_field_label*:*100*:*w_field_label_size*:*left*:*w_field_label_pos*:*ver*:*w_flow*:*Morning***Afternoon***Evening*:*w_choices*:*false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*26*:*id*:*type_radio*:*type*:*Which topic best describes your question?*:*w_field_label*:*280*:*w_field_label_size*:*top*:*w_field_label_pos*:*ver*:*w_flow*:*Product Support***Site Suggestions***Marketing & Sponsorship Opportunities***Referral Programs***Other*:*w_choices*:*false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:**:*w_class*:**:*new_field*:*27*:*id*:*type_send_copy*:*type*:*Send a copy of this message to yourself:*:*w_field_label*:*260*:*w_field_label_size*:*left*:*w_field_label_pos*:*false*:*w_first_val*:*no*:*w_required*:**:*new_field*:*28*:*id*:*type_captcha*:*type*:*Type the characters you see here:*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*29*:*id*:*type_recaptcha*:*type*:*Type the characters you see here*:*w_field_label*:*250*:*w_field_label_size*:*top*:*w_field_label_pos*:**:*w_public*:**:*w_private*:*red*:*w_theme*:**:*w_class*:**:*new_field*:*30*:*id*:*type_submit_reset*:*type*:*type_submit_reset_30*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*31*:*id*:*type_editor*:*type*:*custom_31*:*w_field_label*:*<p><span style=\"color: rgb(153, 0, 0); font-family: Arial, Helvetica, sans-serif; font-size: 15px; line-height: normal; background-color: rgb(244, 244, 244);\">* Indicates required fields</span></p>*:*w_editor*:**:*new_field*:*32*:*id*:*type_editor*:*type*:*custom_32*:*w_field_label*:*<p><strong>Sample Company, Inc.</strong></p><p>1412 South Main Expressway</p><p>Sugar Land, TX 98765</p><p>Phone: 123-987-6543</p><p>Fax: 123-987-6542</p>*:*w_editor*:**:*new_field*:*33*:*id*:*type_map*:*type*:*map_33*:*w_field_label*:*44.497928*:*w_center_x*:*40.1525306*:*w_center_y*:*44.497928*:*w_long*:*40.152531*:*w_lat*:*12*:*w_zoom*:*300*:*w_width*:*400*:*w_height*:**:*w_info*:*wdform_map*:*w_class*:**:*new_field*:*", "1", "1", "*", "4", "", "4", "*4*", "1", "", "", "", "", "1,3,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,24,25,26,27,28,29,31,", "", "", "", "", "%Subject:%", "%Subject:%", "1", "1", "1", "1");

/* INSERT TABLE DATA: wp_udange_contactformmaker_submits */
INSERT INTO `wp_udange_contactformmaker_submits` VALUES("1", "3", "2", "Thibault", "1", "2015-11-06 20:55:21", "85.201.98.208");
INSERT INTO `wp_udange_contactformmaker_submits` VALUES("2", "3", "4", "thibault.ceulemans@outlook.com", "1", "2015-11-06 20:55:21", "85.201.98.208");
INSERT INTO `wp_udange_contactformmaker_submits` VALUES("3", "3", "22", "Test", "1", "2015-11-06 20:55:21", "85.201.98.208");
INSERT INTO `wp_udange_contactformmaker_submits` VALUES("4", "3", "23", "test", "1", "2015-11-06 20:55:21", "85.201.98.208");

/* INSERT TABLE DATA: wp_udange_contactformmaker_themes */
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("1", "Theme 01 blue", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EFEF;\r\nborder: 1px solid #013D7C;\r\nborder-radius: 5px;\r\ncolor: #013D7C;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\ninput[type=\"radio\"]\r\n{\r\nborder:none !important;\r\noutline:none !important;\r\n}\r\ninput[type=\"checkbox\"]\r\n{\r\nborder:none !important;\r\noutline:none !important;\r\n}\r\na.ui-spinner-button\r\n{\r\nborder-radius:0px !important;\r\nbackground: none!important;\r\n}\r\n\r\na.ui-slider-handle {\r\nwidth: 13px;\r\nheight: 13px;\r\ntop: -4px;\r\nborder: 0px;\r\nborder-radius: 13px;\r\nbackground: #FAFAFA;\r\nborder: 3px solid #B1B1B1;\r\noutline: none;\r\n}\r\n\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #F5F5F5 !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n	color: #000;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\n\r\n\r\n.ui-slider-range {\r\n	background: #8A8A8A !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #fff;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px solid #000 !important;\r\npadding-left:10px;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n\r\n.sel-imul {\r\n	display: none;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 0px;\r\n	padding: 0px 0px 0px 2px;\r\n	font-size: 13px;\r\n	height: 22px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #F8F8F8;\r\n	border: 0px solid #D3D3D3;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 23px;\r\n	width: 30px;\r\n	background: url([SITE_ROOT]/images/09/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 0px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	position: absolute;\r\n	border-radius: 0px;\r\n	height: 23px;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/10/01/upload.png) no-repeat;\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\ncolor: #FFF;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 38px;\r\nline-height: 35px;\r\nbackground:url([SITE_ROOT]/images/10/next.png) no-repeat right #013D7C;\r\npadding: 0px 36px 0 20px;\r\nvertical-align: middle;\r\nfont-size: 18px;\r\nborder-top-right-radius: 7px;\r\nborder-bottom-right-radius: 7px;\r\n}\r\n.previous-page div.wdform-page-button {\r\ncolor: #A2A2A2;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 37px;\r\nline-height: 35px;\r\nbackground:url([SITE_ROOT]/images/09/previous.png) no-repeat left #F1F1F1;\r\npadding: 0 20px 0 36px;\r\nvertical-align: middle;\r\nfont-size: 18px;\r\nborder-top-left-radius: 7px;\r\nborder-bottom-left-radius: 7px;\r\n}\r\n.button-submit {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	line-height: 35px;\r\n	background: #013D7C;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 35px;\r\n	font-family: Segoe UI;\r\n		border: 1px solid transparent;\r\n	margin: 5px;\r\n}\r\n.button-reset {\r\n	color: #787878;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	line-height: 35px;\r\n	background: #F0EFEF;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 35px;\r\n	font-family: Segoe UI;\r\n	float: right;\r\n	border: 1px solid transparent;\r\n	margin: 5px;\r\n}\r\n.wdform_page {\r\n	background: #FFFFFF;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 50px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_section_break2 {\r\n	color: #013D7C;\r\n	display: inline-block;\r\n	text-align: left;\r\n	font-size: 23px;\r\nmargin: 16px 10px 40px 0px;\r\n}\r\n\r\n.wdform_section_break {\r\n	color: #013D7C;\r\n	font-size: 23px;\r\nmargin: 16px 0px;\r\n}\r\n\r\n.wdform_section {\r\n	display: inline-block;\r\n}\r\nselect {\r\n	padding: 2px;\r\n	height: 26px;\r\n	border: 1px solid #B7B7B7;\r\nbackground: #F8F8F8;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	outline: none;\r\n}\r\nselect {\r\n	outline: none;\r\n}\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n\r\n\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/03/date.png) no-repeat !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 22px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n\r\n\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #8A8A8A;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 0px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\ncolor: #013E7D;\r\nbackground-color: #FFF;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 29px;\r\ntext-align: center;\r\nvertical-align: bottom;\r\npadding: 5px 25px 0px 25px;\r\nfont-size: 16px;\r\nfont-weight:bold;\r\n}\r\n.page_active {\r\ncolor: #FFF;\r\ncursor: pointer;\r\nbackground-color: #013E7D;\r\ndisplay: inline-block;\r\nvertical-align: bottom;\r\nheight: 29px;\r\ntext-align: center;\r\nfont-size: 20px;\r\npadding: 5px 25px 0px 25px;\r\nline-height: 26px;\r\nfont-weight:bold;\r\n}\r\n.page_percentage_active {\r\npadding: 0px;\r\nmargin: 0px;\r\nborder-spacing: 0px;\r\nheight: 16px;\r\nline-height: 16px;\r\nfont-size: 15px;\r\nfloat: left;\r\ntext-align: right !important;\r\nz-index: 1;\r\nposition: relative;\r\nvertical-align: middle;\r\nbackground: #013E7F;\r\ncolor: #fff;\r\nborder-top-left-radius: 5px;\r\nborder-bottom-left-radius: 5px;\r\n}\r\n.page_percentage_deactive {\r\nheight: 16px;\r\nline-height: 16px;\r\nbackground-color: #F1F1F1;\r\ntext-align: left !important;\r\nmargin-bottom: 1px;\r\nborder-radius: 5px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n}\r\n\r\n.wdform_percentage_text {\r\nmargin: 3px 5px 3px 9px;\r\ncolor: #FFF;\r\nfont-size: 12px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #6E6E6E;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 27px;\r\n	height: 27px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #4D792C;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 31px;\r\n	color: #fff;\r\n	border: 2px solid #68943B;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("2", "Theme 01 purple", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EFEF;\r\nborder: 1px solid #6C005E;\r\nborder-radius: 5px;\r\ncolor: #6C005E;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\ninput[type=\"radio\"]\r\n{\r\nborder:none !important;\r\noutline:none !important;\r\n}\r\ninput[type=\"checkbox\"]\r\n{\r\nborder:none !important;\r\noutline:none !important;\r\n}\r\na.ui-spinner-button\r\n{\r\nborder-radius:0px !important;\r\nbackground: none!important;\r\n}\r\n\r\na.ui-slider-handle {\r\nwidth: 13px;\r\nheight: 13px;\r\ntop: -4px;\r\nborder: 0px;\r\nborder-radius: 13px;\r\nbackground: #FAFAFA;\r\nborder: 3px solid #B1B1B1;\r\noutline: none;\r\n}\r\n\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #F5F5F5 !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n	color: #000;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\n\r\n\r\n.ui-slider-range {\r\n	background: #8A8A8A !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #fff;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px solid #000 !important;\r\npadding-left:10px;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n\r\n.sel-imul {\r\n	display: none;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 0px;\r\n	padding: 0px 0px 0px 2px;\r\n	font-size: 13px;\r\n	height: 22px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #F8F8F8;\r\n	border: 0px solid #D3D3D3;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 23px;\r\n	width: 30px;\r\n	background: url([SITE_ROOT]/images/09/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 0px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	position: absolute;\r\n	border-radius: 0px;\r\n	height: 23px;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/10/02/upload.png) no-repeat;\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\ncolor: #FFF;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 38px;\r\nline-height: 35px;\r\nbackground:url([SITE_ROOT]/images/10/next.png) no-repeat right #6C005E;\r\npadding: 0px 36px 0 20px;\r\nvertical-align: middle;\r\nfont-size: 18px;\r\nborder-top-right-radius: 7px;\r\nborder-bottom-right-radius: 7px;\r\n}\r\n.previous-page div.wdform-page-button {\r\ncolor: #A2A2A2;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 37px;\r\nline-height: 35px;\r\nbackground:url([SITE_ROOT]/images/09/previous.png) no-repeat left #F1F1F1;\r\npadding: 0 20px 0 36px;\r\nvertical-align: middle;\r\nfont-size: 18px;\r\nborder-top-left-radius: 7px;\r\nborder-bottom-left-radius: 7px;\r\n}\r\n.button-submit {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	line-height: 35px;\r\n	background: #6C005E;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 35px;\r\n	font-family: Segoe UI;\r\n		border: 1px solid transparent;\r\n	margin: 5px;\r\n}\r\n.button-reset {\r\n	color: #787878;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	line-height: 35px;\r\n	background: #F0EFEF;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 35px;\r\n	font-family: Segoe UI;\r\n	float: right;\r\n	border: 1px solid transparent;\r\n	margin: 5px;\r\n}\r\n.wdform_page {\r\n	background: #FFFFFF;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 50px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_section_break2 {\r\n	color: #6C005E;\r\n	display: inline-block;\r\n	text-align: left;\r\n	font-size: 23px;\r\nmargin: 16px 10px 40px 0px;\r\n}\r\n\r\n.wdform_section_break {\r\n	color: #6C005E;\r\n	font-size: 23px;\r\nmargin: 16px 0px;\r\n}\r\n\r\n.wdform_section {\r\n	display: inline-block;\r\n}\r\nselect {\r\n	padding: 2px;\r\n	height: 26px;\r\n	border: 1px solid #B7B7B7;\r\nbackground: #F8F8F8;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	outline: none;\r\n}\r\nselect {\r\n	outline: none;\r\n}\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n\r\n\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/03/date.png) no-repeat !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 22px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n\r\n\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #8A8A8A;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 0px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\ncolor: #6C005E;\r\nbackground-color: #FFF;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 29px;\r\ntext-align: center;\r\nvertical-align: bottom;\r\npadding: 5px 25px 0px 25px;\r\nfont-size: 16px;\r\nfont-weight:bold;\r\n}\r\n.page_active {\r\ncolor: #FFF;\r\ncursor: pointer;\r\nbackground-color: #6C005E;\r\ndisplay: inline-block;\r\nvertical-align: bottom;\r\nheight: 29px;\r\ntext-align: center;\r\nfont-size: 20px;\r\npadding: 5px 25px 0px 25px;\r\nline-height: 26px;\r\nfont-weight:bold;\r\n}\r\n.page_percentage_active {\r\npadding: 0px;\r\nmargin: 0px;\r\nborder-spacing: 0px;\r\nheight: 16px;\r\nline-height: 16px;\r\nfont-size: 15px;\r\nfloat: left;\r\ntext-align: right !important;\r\nz-index: 1;\r\nposition: relative;\r\nvertical-align: middle;\r\nbackground: #6C005E;\r\ncolor: #fff;\r\nborder-top-left-radius: 5px;\r\nborder-bottom-left-radius: 5px;\r\n}\r\n.page_percentage_deactive {\r\nheight: 16px;\r\nline-height: 16px;\r\nbackground-color: #F1F1F1;\r\ntext-align: left !important;\r\nmargin-bottom: 1px;\r\nborder-radius: 5px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n}\r\n\r\n.wdform_percentage_text {\r\nmargin: 3px 5px 3px 9px;\r\ncolor: #FFF;\r\nfont-size: 12px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #6E6E6E;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 27px;\r\n	height: 27px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #4D792C;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 31px;\r\n	color: #fff;\r\n	border: 2px solid #68943B;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("3", "Theme 01 black", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EFEF;\r\nborder: 1px solid #000000;\r\nborder-radius: 5px;\r\ncolor: #000000;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\ninput[type=\"radio\"]\r\n{\r\nborder:none !important;\r\noutline:none !important;\r\n}\r\ninput[type=\"checkbox\"]\r\n{\r\nborder:none !important;\r\noutline:none !important;\r\n}\r\na.ui-spinner-button\r\n{\r\nborder-radius:0px !important;\r\nbackground: none!important;\r\n}\r\n\r\na.ui-slider-handle {\r\nwidth: 13px;\r\nheight: 13px;\r\ntop: -4px;\r\nborder: 0px;\r\nborder-radius: 13px;\r\nbackground: #FAFAFA;\r\nborder: 3px solid #B1B1B1;\r\noutline: none;\r\n}\r\n\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #F5F5F5 !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n	color: #000;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\n\r\n\r\n.ui-slider-range {\r\n	background: #8A8A8A !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #fff;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px solid #000 !important;\r\npadding-left:10px;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n\r\n.sel-imul {\r\n	display: none;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 0px;\r\n	padding: 0px 0px 0px 2px;\r\n	font-size: 13px;\r\n	height: 22px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #F8F8F8;\r\n	border: 0px solid #D3D3D3;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 23px;\r\n	width: 30px;\r\n	background: url([SITE_ROOT]/images/09/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 0px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	position: absolute;\r\n	border-radius: 0px;\r\n	height: 23px;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/10/02/upload.png) no-repeat;\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\ncolor: #FFF;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 38px;\r\nline-height: 35px;\r\nbackground:url([SITE_ROOT]/images/10/next.png) no-repeat right #000;\r\npadding: 0px 36px 0 20px;\r\nvertical-align: middle;\r\nfont-size: 18px;\r\nborder-top-right-radius: 7px;\r\nborder-bottom-right-radius: 7px;\r\n}\r\n.previous-page div.wdform-page-button {\r\ncolor: #A2A2A2;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 37px;\r\nline-height: 35px;\r\nbackground:url([SITE_ROOT]/images/09/previous.png) no-repeat left #F1F1F1;\r\npadding: 0 20px 0 36px;\r\nvertical-align: middle;\r\nfont-size: 18px;\r\nborder-top-left-radius: 7px;\r\nborder-bottom-left-radius: 7px;\r\n}\r\n.button-submit {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	line-height: 35px;\r\n	background: #000;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 35px;\r\n	font-family: Segoe UI;\r\n		border: 1px solid transparent;\r\n	margin: 5px;\r\n}\r\n.button-reset {\r\n	color: #787878;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	line-height: 35px;\r\n	background: #F0EFEF;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 35px;\r\n	font-family: Segoe UI;\r\n	float: right;\r\n	border: 1px solid transparent;\r\n	margin: 5px;\r\n}\r\n.wdform_page {\r\n	background: #FFFFFF;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 50px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_section_break2 {\r\n	color: #000;\r\n	display: inline-block;\r\n	text-align: left;\r\n	font-size: 23px;\r\nmargin: 16px 10px 40px 0px;\r\n}\r\n\r\n.wdform_section_break {\r\n	color: #000;\r\n	font-size: 23px;\r\nmargin: 16px 0px;\r\n}\r\n\r\n.wdform_section {\r\n	display: inline-block;\r\n}\r\nselect {\r\n	padding: 2px;\r\n	height: 26px;\r\n	border: 1px solid #B7B7B7;\r\nbackground: #F8F8F8;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	outline: none;\r\n}\r\nselect {\r\n	outline: none;\r\n}\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n\r\n\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/03/date.png) no-repeat !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 22px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n\r\n\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #8A8A8A;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 0px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\ncolor: #000;\r\nbackground-color: #FFF;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 29px;\r\ntext-align: center;\r\nvertical-align: bottom;\r\npadding: 5px 25px 0px 25px;\r\nfont-size: 16px;\r\nfont-weight:bold;\r\n}\r\n.page_active {\r\ncolor: #FFF;\r\ncursor: pointer;\r\nbackground-color: #000;\r\ndisplay: inline-block;\r\nvertical-align: bottom;\r\nheight: 29px;\r\ntext-align: center;\r\nfont-size: 20px;\r\npadding: 5px 25px 0px 25px;\r\nline-height: 26px;\r\nfont-weight:bold;\r\n}\r\n.page_percentage_active {\r\npadding: 0px;\r\nmargin: 0px;\r\nborder-spacing: 0px;\r\nheight: 16px;\r\nline-height: 16px;\r\nfont-size: 15px;\r\nfloat: left;\r\ntext-align: right !important;\r\nz-index: 1;\r\nposition: relative;\r\nvertical-align: middle;\r\nbackground: #000;\r\ncolor: #fff;\r\nborder-top-left-radius: 5px;\r\nborder-bottom-left-radius: 5px;\r\n}\r\n.page_percentage_deactive {\r\nheight: 16px;\r\nline-height: 16px;\r\nbackground-color: #F1F1F1;\r\ntext-align: left !important;\r\nmargin-bottom: 1px;\r\nborder-radius: 5px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n}\r\n\r\n.wdform_percentage_text {\r\nmargin: 3px 5px 3px 9px;\r\ncolor: #FFF;\r\nfont-size: 12px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #6E6E6E;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 27px;\r\n	height: 27px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #4D792C;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 31px;\r\n	color: #fff;\r\n	border: 2px solid #68943B;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}", "1");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("4", "Theme 01 transparent (black button)", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EFEF;\r\nborder: 1px solid #000000;\r\nborder-radius: 5px;\r\ncolor: #000000;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\ninput[type=\"radio\"]\r\n{\r\nborder:none !important;\r\noutline:none !important;\r\n}\r\ninput[type=\"checkbox\"]\r\n{\r\nborder:none !important;\r\noutline:none !important;\r\n}\r\na.ui-spinner-button\r\n{\r\nborder-radius:0px !important;\r\nbackground: none!important;\r\n}\r\n\r\na.ui-slider-handle {\r\nwidth: 13px;\r\nheight: 13px;\r\ntop: -4px;\r\nborder: 0px;\r\nborder-radius: 13px;\r\nbackground: #FAFAFA;\r\nborder: 3px solid #B1B1B1;\r\noutline: none;\r\n}\r\n\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #F5F5F5 !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n	color: #000;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\n\r\n\r\n.ui-slider-range {\r\n	background: #8A8A8A !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #fff;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px solid #000 !important;\r\npadding-left:10px;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n\r\n.sel-imul {\r\n	display: none;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 0px;\r\n	padding: 0px 0px 0px 2px;\r\n	font-size: 13px;\r\n	height: 22px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #F8F8F8;\r\n	border: 0px solid #D3D3D3;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 23px;\r\n	width: 30px;\r\n	background: url([SITE_ROOT]/images/09/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 0px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	position: absolute;\r\n	border-radius: 0px;\r\n	height: 23px;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/10/02/upload.png) no-repeat;\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\ncolor: #FFF;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 38px;\r\nline-height: 35px;\r\nbackground:url([SITE_ROOT]/images/10/next.png) no-repeat right #000;\r\npadding: 0px 36px 0 20px;\r\nvertical-align: middle;\r\nfont-size: 18px;\r\nborder-top-right-radius: 7px;\r\nborder-bottom-right-radius: 7px;\r\n}\r\n.previous-page div.wdform-page-button {\r\ncolor: #A2A2A2;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 37px;\r\nline-height: 35px;\r\nbackground:url([SITE_ROOT]/images/09/previous.png) no-repeat left #F1F1F1;\r\npadding: 0 20px 0 36px;\r\nvertical-align: middle;\r\nfont-size: 18px;\r\nborder-top-left-radius: 7px;\r\nborder-bottom-left-radius: 7px;\r\n}\r\n.button-submit {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	line-height: 35px;\r\n	background: #000;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 35px;\r\n	font-family: Segoe UI;\r\n		border: 1px solid transparent;\r\n	margin: 5px;\r\n}\r\n.button-reset {\r\n	color: #787878;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	line-height: 35px;\r\n	background: #F0EFEF;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 35px;\r\n	font-family: Segoe UI;\r\n	float: right;\r\n	border: 1px solid transparent;\r\n	margin: 5px;\r\n}\r\n.wdform_page {\r\n	background: transparent;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 50px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_section_break2 {\r\n	color: #000;\r\n	display: inline-block;\r\n	text-align: left;\r\n	font-size: 23px;\r\nmargin: 16px 10px 40px 0px;\r\n}\r\n\r\n.wdform_section_break {\r\n	color: #000;\r\n	font-size: 23px;\r\nmargin: 16px 0px;\r\n}\r\n\r\n.wdform_section {\r\n	display: inline-block;\r\n}\r\nselect {\r\n	padding: 2px;\r\n	height: 26px;\r\n	border: 1px solid #B7B7B7;\r\nbackground: #F8F8F8;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	padding:0 3px !important;\r\n	background: #F8F8F8;\r\nborder:1px solid #B7B7B7;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	outline: none;\r\n}\r\nselect {\r\n	outline: none;\r\n}\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n\r\n\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/03/date.png) no-repeat !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 22px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n\r\n\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #8A8A8A;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 0px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\ncolor: #000;\r\nbackground-color: #FFF;\r\ncursor: pointer;\r\ndisplay: inline-block;\r\nheight: 29px;\r\ntext-align: center;\r\nvertical-align: bottom;\r\npadding: 5px 25px 0px 25px;\r\nfont-size: 16px;\r\nfont-weight:bold;\r\n}\r\n.page_active {\r\ncolor: #FFF;\r\ncursor: pointer;\r\nbackground-color: #000;\r\ndisplay: inline-block;\r\nvertical-align: bottom;\r\nheight: 29px;\r\ntext-align: center;\r\nfont-size: 20px;\r\npadding: 5px 25px 0px 25px;\r\nline-height: 26px;\r\nfont-weight:bold;\r\n}\r\n.page_percentage_active {\r\npadding: 0px;\r\nmargin: 0px;\r\nborder-spacing: 0px;\r\nheight: 16px;\r\nline-height: 16px;\r\nfont-size: 15px;\r\nfloat: left;\r\ntext-align: right !important;\r\nz-index: 1;\r\nposition: relative;\r\nvertical-align: middle;\r\nbackground: #000;\r\ncolor: #fff;\r\nborder-top-left-radius: 5px;\r\nborder-bottom-left-radius: 5px;\r\n}\r\n.page_percentage_deactive {\r\nheight: 16px;\r\nline-height: 16px;\r\nbackground-color: #F1F1F1;\r\ntext-align: left !important;\r\nmargin-bottom: 1px;\r\nborder-radius: 5px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n}\r\n\r\n.wdform_percentage_text {\r\nmargin: 3px 5px 3px 9px;\r\ncolor: #FFF;\r\nfont-size: 12px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #6E6E6E;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 27px;\r\n	height: 27px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #4D792C;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 31px;\r\n	color: #fff;\r\n	border: 2px solid #68943B;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("5", "Theme 02 blue", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EFEF;\r\nborder: 1px solid #ADC0DB;\r\nmargin-bottom: 10px;\r\ncolor: #ADC0DB;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 10px;\r\n	border: 2px solid #fff;\r\n	background: #A4A4A4;\r\n}\r\n.ui-slider-range {\r\n	background: #A4A4A4 !important;\r\n}\r\n.ui-slider-horizontal .ui-slider-handle {\r\n	top: -8px !important;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 10px;\r\n	border: 2px solid #fff;\r\n	background: #A4A4A4;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n	content: url([SITE_ROOT]/images/02/bg.png);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #285485!important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #285485!important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #285485!important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #285485!important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #285485!important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #285485!important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-state-hover {\r\n	background: #285485!important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-slider {\r\n	background: #fff !important;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #ccc !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 4px;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 22px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 0px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 22px;\r\n	width: 29px;\r\n	background: url([SITE_ROOT]/images/02/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/02/01/upload.png);\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\n	color: #285485;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 33px;\r\n	background: url([SITE_ROOT]/images/02/01/next.png) top right #708EB4;\r\n	padding: 0px 30px 0 15px;\r\n	vertical-align: middle;\r\n	font-weight: 600;\r\n	font-size: 16px;\r\n}\r\n .next-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/02/01/next.png) top right #144077;\r\n}\r\n.previous-page div.wdform-page-button {\r\n	color: #285485;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 36px;\r\n	background: url([SITE_ROOT]/images/02/01/previous.png) top left #708EB4;\r\n	padding: 0px 15px 0 30px;\r\n	vertical-align: middle;\r\n	font-weight: 600;\r\n	font-size: 16px;\r\n}\r\n .previous-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/02/01/previous.png) top left #144077;\r\n}\r\n.button-submit {\r\n	background: url([SITE_ROOT]/images/02/bg.png) #708EB4;\r\n	cursor: pointer;\r\n	font-size: 16px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #285485;\r\n	margin: 5px;\r\n	border: 0px;\r\n	font-family: Segoe UI;\r\n	font-weight: 600;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #ADC0DB;\r\n	padding: 15px 15px 15px 50px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 1px solid #C5C5C5;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/02/bg.png) #708EB4;\r\n	text-align: left;\r\n	padding: 10px;\r\n	border-radius: 0px;\r\n	-moz-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	-webkit-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	width: 466px;\r\n	text-align: center;\r\nfont-size:18px;\r\nfont-family: Segoe UI;\r\ncolor:#0E3F76;\r\n}\r\n\r\n.wdform_section_break\r\n{\r\nmargin: 16px 10px 16px 0px;\r\ntext-align: left;\r\nfont-size: 18px;\r\nfont-family: Segoe UI;\r\ncolor:#0E3F76;\r\n}\r\n.wdform_section {\r\n	display: table-row\r\n}\r\nselect {\r\n	border-radius: 4px;\r\n	height: 26px;\r\n	overflow: hidden;\r\n	border: 0px solid #ccc;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"] {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"] {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/02/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/02/01/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n} \r\n.wdform-calendar-button:focus {\r\n outline:none; \r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 11px;\r\n	height: 10px;\r\n	background: #A7A7A7;\r\n	border-radius: 0px;\r\n	top: 1px;\r\n	left: 1px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: rgb(158, 0, 0);\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 4px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n	color: #2564A3;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding-top: 5px;\r\n	padding: 5px 30px 0px 30px;\r\n	font-weight: bold;\r\n}\r\n.page_deactive:nth-child(even) {\r\n	background-color: #DCDADB;\r\n}\r\n.page_deactive:nth-child(odd) {\r\n	background-color: #D1CDCE;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	cursor: pointer;\r\n	background-color: #0E3F77;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 18px;\r\n	padding: 5px 30px 0px 30px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 17px;\r\n	line-height: 17px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #0e3f77; /* Old browsers */\r\n	background: -moz-linear-gradient(left, #0e3f77 0%, #0f437d 49%, #2f72b5 84%, #165ba9 99%); /* FF3.6+ */\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #0e3f77), color-stop(49%, #0f437d), color-stop(84%, #2f72b5), color-stop(99%, #165ba9)); /* Chrome,Safari4+ */\r\n	background: -webkit-linear-gradient(left, #0e3f77 0%, #0f437d 49%, #2f72b5 84%, #165ba9 99%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(left, #0e3f77 0%, #0f437d 49%, #2f72b5 84%, #165ba9 99%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(left, #0e3f77 0%, #0f437d 49%, #2f72b5 84%, #165ba9 99%); /* IE10+ */\r\n	background: linear-gradient(to right, #0e3f77 0%, #0f437d 49%, #2f72b5 84%, #165ba9 99%); /* W3C */\r\n	vertical-align: middle;\r\n}\r\n.page_percentage_deactive {\r\n	height: 17px;\r\n	line-height: 17px;\r\n	background-color: #CCCCCC;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: -2px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: bold;\r\nfont-size: 13px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 17px;\r\n	height: 17px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("6", "Theme 02 yellow", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #EADEB4;\r\nborder: 1px solid #E3E2E4;\r\nmargin-bottom: 10px;\r\ncolor: #E3E2E4;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 10px;\r\n	border: 2px solid #fff;\r\n	background: #A4A4A4;\r\n}\r\n.ui-slider-range {\r\n	background: #A4A4A4 !important;\r\n}\r\n.ui-slider-horizontal .ui-slider-handle {\r\n	top: -8px !important;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 10px;\r\n	border: 2px solid #fff;\r\n	background: #A4A4A4;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n	content: url([SITE_ROOT]/images/02/bg.png);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #ECBD00 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #ECBD00 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #ECBD00 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #ECBD00 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #ECBD00 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #ECBD00 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-state-hover {\r\n	background: #ECBD00 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-slider {\r\n	background: #fff !important;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #ccc !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 4px;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 22px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 0px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 22px;\r\n	width: 29px;\r\n	background: url([SITE_ROOT]/images/02/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/02/02/upload.png);\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\n	color: #4D4A3C;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 33px;\r\n	background: url([SITE_ROOT]/images/02/next.png) top right #CFAB1A;\r\n	padding: 0px 30px 0 15px;\r\n	vertical-align: middle;\r\n	font-weight: 600;\r\n	font-size: 16px;\r\n}\r\n.next-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/02/next.png) top right  #A08104;\r\n}\r\n.previous-page div.wdform-page-button {\r\n	color: #4D4A3C;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 36px;\r\n	background: url([SITE_ROOT]/images/02/previous.png) top left #CFAB1A;\r\n	padding: 0px 15px 0 30px;\r\n	vertical-align: middle;\r\n	font-weight: 600;\r\n	font-size: 16px;\r\n}\r\n.previous-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/02/previous.png) top left  #A08104;\r\n}\r\n.button-submit {\r\n	background: url([SITE_ROOT]/images/02/bg.png) #CFAB1A;\r\n	cursor: pointer;\r\n	font-size: 16px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #4D4A3C;\r\n	margin: 5px;\r\n	border: 0px;\r\n	font-family: Segoe UI;\r\n	font-weight: 600;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #E2DED7;\r\n	padding: 15px 15px 15px 50px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 1px solid #CFCFCF;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/02/bg.png) #CFAB1A;\r\n	text-align: left;\r\n	padding: 10px;\r\n	border-radius: 0px;\r\n	-moz-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	-webkit-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	width: 466px;\r\n	text-align: center;\r\nfont-size: 18px;\r\nfont-family: Segoe UI;\r\ncolor: #292929;\r\nfont-weight: 600;\r\n}\r\n\r\n.wdform_section_break\r\n{\r\nmargin: 16px 10px 16px 0px;\r\ntext-align: left;\r\nfont-size: 18px;\r\nfont-family: Segoe UI;\r\ncolor: #292929;\r\n}\r\n.wdform_section {\r\n	display: table-row\r\n}\r\nselect {\r\n	border-radius: 4px;\r\n	height: 26px;\r\n	overflow: hidden;\r\n	border: 0px solid #ccc;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"] {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"] {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/02/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/02/02/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n}\r\n.wdform-calendar-button:focus {\r\n outline:none; \r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 11px;\r\n	height: 10px;\r\n	background: #A7A7A7;\r\n	border-radius: 0px;\r\n	top: 1px;\r\n	left: 1px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: rgb(158, 0, 0);\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 4px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #3F3927;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding-top: 5px;\r\n	padding: 5px 30px 0px 30px;\r\n	font-weight: bold;\r\n}\r\n.page_deactive:nth-child(even) {\r\n	background-color: #DCDADB;\r\n}\r\n.page_deactive:nth-child(odd) {\r\n	background-color: #D1CDCE;\r\n}\r\n.page_active {\r\n	color: #3F3927;\r\n	cursor: pointer;\r\n	background-color: #ECBD00;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 18px;\r\n	padding: 5px 30px 0px 30px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 17px;\r\n	line-height: 17px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #ECBD00 ; /* Old browsers */\r\n	background: -moz-linear-gradient(left, #ECBD00 0%, #F5C403 49%, #F8C90B 84%, #FFCC00 99%); /* FF3.6+ */\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #ECBD00 ), color-stop(49%, #F5C403 ), color-stop(84%, #F8C90B ), color-stop(99%, #FFCC00 )); /* Chrome,Safari4+ */\r\n	background: -webkit-linear-gradient(left, #ECBD00 0%, #F5C403 49%, #F8C90B 84%, #FFCC00 99%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(left, #ECBD00 0%, #F5C403 49%, #F8C90B 84%, #FFCC00 99%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(left, #ECBD00 0%, #F5C403 49%, #F8C90B 84%, #FFCC00 99%); /* IE10+ */\r\n	background: linear-gradient(to right, #ECBD00 0%, #F5C403 49%, #F8C90B 84%, #FFCC00 99%); /* W3C */\r\n	vertical-align: middle;\r\n}\r\n.page_percentage_deactive {\r\n	height: 17px;\r\n	line-height: 17px;\r\n	background-color: #D9D7D8;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: -2px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #292929;\r\n	font-weight: bold;\r\nfont-size:13px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 17px;\r\n	height: 17px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("7", "Theme 02 violet", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #C9ADEF;\r\nborder: 1px solid #E3E2E4;\r\nmargin-bottom: 10px;\r\ncolor: #E3E2E4;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 10px;\r\n	border: 2px solid #fff;\r\n	background: #A4A4A4;\r\n}\r\n.ui-slider-range {\r\n	background: #A4A4A4 !important;\r\n}\r\n.ui-slider-horizontal .ui-slider-handle {\r\n	top: -8px !important;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 10px;\r\n	border: 2px solid #fff;\r\n	background: #A4A4A4;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n	content: url([SITE_ROOT]/images/02/bg.png);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #5C00DA !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #5C00DA !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #5C00DA !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #5C00DA !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #5C00DA !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #5C00DA !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-state-hover {\r\n	background: #5C00DA !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-slider {\r\n	background: #fff !important;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #ccc !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 4px;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 22px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 0px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 22px;\r\n	width: 29px;\r\n	background: url([SITE_ROOT]/images/02/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/02/02/upload.png);\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\n	color: #4D4A3C;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 33px;\r\n	background: url([SITE_ROOT]/images/02/next.png) top right #5C00DA;\r\n	padding: 0px 30px 0 15px;\r\n	vertical-align: middle;\r\n	font-weight: 600;\r\n	font-size: 16px;\r\n}\r\n.next-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/02/next.png) top right #3D0886;\r\n}.previous-page div.wdform-page-button {\r\n	color: #4D4A3C;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 36px;\r\n	background: url([SITE_ROOT]/images/02/previous.png) top left #5C00DA;\r\n	padding: 0px 15px 0 30px;\r\n	vertical-align: middle;\r\n	font-weight: 600;\r\n	font-size: 16px;\r\n}\r\n.previous-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/02/previous.png)  top left #3D0886;\r\n}\r\n.button-submit {\r\n	background: url([SITE_ROOT]/images/02/bg.png) #5C00DA;\r\n	cursor: pointer;\r\n	font-size: 16px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #4D4A3C;\r\n	margin: 5px;\r\n	border: 0px;\r\n	font-family: Segoe UI;\r\n	font-weight: 600;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #E3E2E4;\r\n	padding: 15px 15px 15px 50px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 1px solid #CFCFCF;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/02/bg.png) #5C00DA;\r\n	text-align: left;\r\n	padding: 10px;\r\n	border-radius: 0px;\r\n	-moz-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	-webkit-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	width: 466px;\r\n	text-align: center;\r\nfont-size: 18px;\r\nfont-family: Segoe UI;\r\ncolor: #292929;\r\nfont-weight: 600;\r\n}\r\n\r\n.wdform_section_break\r\n{\r\nmargin: 16px 10px 16px 0px;\r\ntext-align: left;\r\nfont-size: 18px;\r\nfont-family: Segoe UI;\r\ncolor: #292929;\r\n}\r\n.wdform_section {\r\n	display: table-row\r\n}\r\nselect {\r\n	border-radius: 4px;\r\n	height: 26px;\r\n	overflow: hidden;\r\n	border: 0px solid #ccc;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"] {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"] {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/02/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/02/03/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n}\r\n.wdform-calendar-button:focus {\r\n outline:none; \r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 11px;\r\n	height: 10px;\r\n	background: #A7A7A7;\r\n	border-radius: 0px;\r\n	top: 1px;\r\n	left: 1px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: rgb(158, 0, 0);\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 4px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #3F3927;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding-top: 5px;\r\n	padding: 5px 30px 0px 30px;\r\n	font-weight: bold;\r\n}\r\n.page_deactive:nth-child(even) {\r\n	background-color: #DCDADB;\r\n}\r\n.page_deactive:nth-child(odd) {\r\n	background-color: #D1CDCE;\r\n}\r\n.page_active {\r\n	color: #FFF;\r\n	cursor: pointer;\r\n	background-color: #5C00DA;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 18px;\r\n	padding: 5px 30px 0px 30px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 17px;\r\n	line-height: 17px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #5C00DA ; /* Old browsers */\r\n	background: -moz-linear-gradient(left, #5C00DA 0%, #5C00DB 49%, #6600F0 84%, #7917FF 99%); /* FF3.6+ */\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #5C00DA ), color-stop(49%, #5C00DB ), color-stop(84%, #6600F0 ), color-stop(99%, #7917FF )); /* Chrome,Safari4+ */\r\n	background: -webkit-linear-gradient(left, #5C00DA 0%, #5C00DB 49%, #6600F0 84%, #7917FF 99%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(left, #5C00DA 0%, #5C00DB 49%, #6600F0 84%, #7917FF 99%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(left, #5C00DA 0%, #5C00DB 49%, #6600F0 84%, #7917FF 99%); /* IE10+ */\r\n	background: linear-gradient(to right, #5C00DA 0%, #5C00DB 49%, #6600F0 84%, #7917FF 99%); /* W3C */\r\n	vertical-align: middle;\r\n}\r\n.page_percentage_deactive {\r\n	height: 17px;\r\n	line-height: 17px;\r\n	background-color: #D9D7D8;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: -2px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #fff;\r\n	font-weight: bold;\r\nfont-size:13px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 17px;\r\n	height: 17px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("8", "Theme 02 transparent (aquamarine button)", ".radio-div input[type=\"radio\"],\r\n.checkbox-div input[type=\"checkbox\"]\r\n{\r\nvisibility: hidden;\r\n}\r\n.wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #EAF9F3;\r\nborder: 1px solid #4D4A58;\r\nmargin-bottom: 10px;\r\ncolor: #4D4A58;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 10px;\r\n	border: 2px solid #fff;\r\n	background: #A4A4A4;\r\n}\r\n.ui-slider-range {\r\n	background: #A4A4A4 !important;\r\n}\r\n.ui-slider-horizontal .ui-slider-handle {\r\n	top: -8px !important;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 10px;\r\n	border: 2px solid #fff;\r\n	background: #A4A4A4;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n	content: url([SITE_ROOT]/images/02/bg.png);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #CEECE2 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #CEECE2 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #CEECE2 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #CEECE2 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #CEECE2 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #CEECE2 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-state-hover {\r\n	background: #CEECE2 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-slider {\r\n	background: #fff !important;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #ccc !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 4px;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 22px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 0px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 22px;\r\n	width: 29px;\r\n	background: url([SITE_ROOT]/images/02/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/02/02/upload.png);\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\n	color: #4D4A3C;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 33px;\r\n	background: url([SITE_ROOT]/images/02/next.png) top right #94FFD5;\r\n	padding: 0px 30px 0 15px;\r\n	vertical-align: middle;\r\n	font-weight: 600;\r\n	font-size: 16px;\r\n}\r\n.next-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/02/next.png) top right  #E4F3E2;\r\n}\r\n.previous-page div.wdform-page-button {\r\n	color: #4D4A3C;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 36px;\r\n	background: url([SITE_ROOT]/images/02/previous.png) top left #94FFD5;\r\n	padding: 0px 15px 0 30px;\r\n	vertical-align: middle;\r\n	font-weight: 600;\r\n	font-size: 16px;\r\n}\r\n.previous-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/02/previous.png) top left  #E4F3E2;\r\n}\r\n.button-submit {\r\n	background: url([SITE_ROOT]/images/02/bg.png) #94FFD5;\r\n	cursor: pointer;\r\n	font-size: 16px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #4D4A3C;\r\n	margin: 5px;\r\n	border: 0px;\r\n	font-family: Segoe UI;\r\n	font-weight: 600;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: transparent;\r\n	padding: 15px 15px 15px 50px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 1px solid #CFCFCF;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/02/bg.png) #CFAB1A;\r\n	text-align: left;\r\n	padding: 10px;\r\n	border-radius: 0px;\r\n	-moz-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	-webkit-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	width: 466px;\r\n	text-align: center;\r\nfont-size: 18px;\r\nfont-family: Segoe UI;\r\ncolor: #292929;\r\nfont-weight: 600;\r\n}\r\n\r\n.wdform_section_break\r\n{\r\nmargin: 16px 10px 16px 0px;\r\ntext-align: left;\r\nfont-size: 18px;\r\nfont-family: Segoe UI;\r\ncolor: #292929;\r\n}\r\n.wdform_section {\r\n	display: table-row\r\n}\r\nselect {\r\n	border-radius: 4px;\r\n	height: 26px;\r\n	overflow: hidden;\r\n	border: 0px solid #ccc;\r\n	padding: 2px;\r\n	outline: none;\r\nbackground: #E9E9E9;\r\n}\r\ninput[type=\"text\"] {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\nbackground: #E9E9E9;\r\n}\r\ninput[type=\"password\"] {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\nbackground: #E9E9E9;\r\n}\r\ntextarea {\r\n	border-radius: 4px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\nbackground: #E9E9E9;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/02/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/02/02/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n}\r\n.wdform-calendar-button:focus {\r\n outline:none; \r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 11px;\r\n	height: 10px;\r\n	background: #A7A7A7;\r\n	border-radius: 0px;\r\n	top: 1px;\r\n	left: 1px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: rgb(158, 0, 0);\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 4px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #3F3927;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding-top: 5px;\r\n	padding: 5px 30px 0px 30px;\r\n	font-weight: bold;\r\n}\r\n.page_deactive:nth-child(even) {\r\n	background-color: #EEEEEE;\r\n}\r\n.page_deactive:nth-child(odd) {\r\n	background-color: #EEEEEE;\r\n}\r\n.page_active {\r\n	color: #3F3927;\r\n	cursor: pointer;\r\n	background-color: #CEECE2;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 18px;\r\n	padding: 5px 30px 0px 30px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 17px;\r\n	line-height: 17px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #95D3BE ; /* Old browsers */\r\n	background: -moz-linear-gradient(left, #80CEB4 0%, #95D6C1 49%, #95D3BE 84%, #B3E7D6 99%); /* FF3.6+ */\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #80CEB4 ), color-stop(49%, #95D6C1 ), color-stop(84%, #95D3BE ), color-stop(99%, #B3E7D6 )); /* Chrome,Safari4+ */\r\n	background: -webkit-linear-gradient(left, #80CEB4 0%, #95D6C1 49%, #95D3BE 84%, #B3E7D6 99%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(left, #80CEB4 0%, #95D6C1 49%, #95D3BE 84%, #B3E7D6 99%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(left, #80CEB4 0%, #95D6C1 49%, #95D3BE 84%, #B3E7D6 99%); /* IE10+ */\r\n	background: linear-gradient(to right, #80CEB4 0%, #95D6C1 49%, #95D3BE 84%, #B3E7D6 99%); /* W3C */\r\n	vertical-align: middle;\r\n}\r\n.page_percentage_deactive {\r\n	height: 17px;\r\n	line-height: 17px;\r\n	background-color: #E0DFE0;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: -2px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #292929;\r\n	font-weight: bold;\r\nfont-size:13px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 17px;\r\n	height: 17px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("9", "Theme 03 green", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EEEF;\r\nborder: 1px solid #3A620A;\r\nmargin-bottom: 10px;\r\ncolor: #3A620A;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 0px;\r\n	border: 1px solid #39680B;\r\n	background: #C9FD9C;\r\n	height: 13px;\r\n	width: 13px;\r\n}\r\n.ui-slider-horizontal .ui-slider-handle {\r\n	top: -5px !important;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover {\r\n	background: #4A8C08!important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active {\r\n	background: #4A8C08!important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus {\r\n	background: #4A8C08!important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover {\r\n	background: #4A8C08!important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:active {\r\n	background: #4A8C08!important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:focus {\r\n	background: #4A8C08!important;\r\n	color: #fff;\r\n}\r\nui-state-hover {\r\n	background: #4A8C08!important;\r\n	color: #fff;\r\n}\r\n.ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #C9FD9C !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #fff;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 0px;\r\n	padding: 0px 0px 0px 2px;\r\n	font-size: 13px;\r\n	height: 23px;\r\n	line-height: 23px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 0px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 23px;\r\n	width: 30px;\r\n	background: url([SITE_ROOT]/images/03/01/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 0px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	position: absolute;\r\n	border-radius: 0px;\r\n	height: 23px;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	}\r\n.file-picker {\r\n	width: 32px;\r\n	height: 25px;\r\n	background: url([SITE_ROOT]/images/03/upload.png);\r\n	display: inline-block;\r\n}\r\ndiv.wdform-page-button {\r\n	color: #414141;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 36px;\r\n	background-color: #ACABAB;\r\npadding: 2px 15px;\r\nvertical-align: middle;\r\nborder: none;\r\nfont-size: 15px;\r\n}\r\n\r\n\r\n.button-submit {\r\n	background: #3A620A;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #fff;\r\n	border: 2px solid #4A8C08;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 1px 1px #44740E;\r\n	font-family: Segoe UI;\r\n	}\r\n.button-reset {\r\n	background: #D8D6D7;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 2px solid #fff;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px 1px #969495;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_page {\r\n	background: #CDD9C3;\r\n	padding-top: 15px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/03/01/bg.png);\r\n	text-align: left;\r\n	padding: 10px 20px 10px 50px;\r\n	border-radius: 0px;\r\n	-moz-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	-webkit-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	width: 466px;\r\n	text-align: right;\r\n	color: #000;\r\nfont-size: 18px;\r\n}\r\n\r\n.wdform_section_break\r\n{\r\nmargin: 16px 15px;\r\ntext-align: left;\r\nfont-size: 18px;\r\ncolor: #555;\r\n}\r\n.wdform_section {\r\n	display: inline-block;\r\n	padding: 0px 15px;\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	padding: 2px;\r\n	height: 26px;\r\n	overflow: hidden;\r\n	border: 0px solid #ccc;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/03/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/03/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n}\r\n.wdform-calendar-button:focus {\r\n outline:none; \r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 9px;\r\n	height: 8px;\r\n	background: #A7A7A7;\r\n	border-radius: 0px;\r\n	top: 2px;\r\n	left: 2px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	margin-top: 15px;\r\n	background-color: #DFDFDF;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #A8A8A8;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 0px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	color: #fff;\r\n	background-color: #42810e;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding-top: 5px;\r\n	padding: 5px 25px 0px 25px;\r\n	font-size: 12px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	background-color: #36690c;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 33px;\r\n	text-align: center;\r\n	font-size: 21px;\r\n	padding: 5px 20px 0px 20px;\r\n	margin-bottom: -13px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 18px;\r\n	line-height: 20px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #62983A; /* Old browsers */\r\n	background: -moz-linear-gradient(left, #61b217 0%, #62983a 39%, #62983a 100%); /* FF3.6+ */\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #61b217), color-stop(39%, #62983a), color-stop(100%, #62983a)); /* Chrome,Safari4+ */\r\n	background: -webkit-linear-gradient(left, #61b217 0%, #62983a 39%, #62983a 100%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(left, #61b217 0%, #62983a 39%, #62983a 100%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(left, #61b217 0%, #62983a 39%, #62983a 100%); /* IE10+ */\r\n	background: linear-gradient(to right, #61b217 0%, #62983a 39%, #62983a 100%); /* W3C */\r\n	vertical-align: middle;\r\n}\r\n.page_percentage_deactive {\r\n	height: 18px;\r\n	line-height: 20px;\r\n	background-color: #DFDFDF;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: center!important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px -34px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: normal;\r\n	font-size: 12px;\r\nline-height: 18px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 20px;\r\n	height: 20px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_percentage_arrow {\r\n	display: inline-block;\r\n	width: 34px;\r\n	height: 18px;\r\n	background: url([SITE_ROOT]/images/03/01/percentage_arrow.png);\r\n	position: relative;\r\n	left: -1px;\r\ntop:0px;\r\n	z-index: 0;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #4D792C;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 31px;\r\n	color: #fff;\r\n	border: 2px solid #68943B;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("10", "Theme 03 red", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EEEF;\r\nborder: 1px solid #811919;\r\nmargin-bottom: 10px;\r\ncolor: #811919;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 0px;\r\n	border: 1px solid #39680B;\r\n	background: #C9FD9C;\r\n	height: 13px;\r\n	width: 13px;\r\n}\r\n.ui-slider-horizontal .ui-slider-handle {\r\n	top: -5px !important;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover {\r\n	background: #5D0000 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active {\r\n	background: #5D0000 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus {\r\n	background: #5D0000 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover {\r\n	background: #5D0000 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:active {\r\n	background: #5D0000 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:focus {\r\n	background: #5D0000 !important;\r\n	color: #fff;\r\n}\r\nui-state-hover {\r\n	background: #5D0000 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #942323 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #fff;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 0px;\r\n	padding: 0px 0px 0px 2px;\r\n	font-size: 13px;\r\n	height: 23px;\r\n	line-height: 23px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 0px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 23px;\r\n	width: 30px;\r\n	background: url([SITE_ROOT]/images/03/02/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 0px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	position: absolute;\r\n	border-radius: 0px;\r\n	height: 23px;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	}\r\n.file-picker {\r\n	width: 32px;\r\n	height: 25px;\r\n	background: url([SITE_ROOT]/images/03/upload.png);\r\n	display: inline-block;\r\n}\r\ndiv.wdform-page-button {\r\n	color: #414141;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 36px;\r\n	background-color: #ACABAB;\r\npadding: 2px 15px;\r\nvertical-align: middle;\r\nborder: none;\r\nfont-size: 15px;\r\n}\r\n\r\n.button-submit {\r\nbackground: #811919;\r\ncursor: pointer;\r\nfont-size: 17px;\r\nmin-width: 80px;\r\nmin-height: 34px;\r\ncolor: #fff;\r\nborder: 2px solid #9E1919;\r\nmargin: 5px;\r\nbox-shadow: 0px 0px 1px 1px #811818;\r\nfont-family: Segoe UI;\r\n	}\r\n.button-reset {\r\n	background: #D8D6D7;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 2px solid #fff;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px 1px #969495;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_page {\r\n	background: #F0EEEF;\r\n	padding-top: 15px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/03/02/bg.png);\r\n	text-align: left;\r\n	padding: 10px 20px 10px 50px;\r\n	border-radius: 0px;\r\n	-moz-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	-webkit-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	width: 466px;\r\n	text-align: right;\r\n	color: #fff;\r\nfont-size: 18px;\r\n}\r\n\r\n.wdform_section_break\r\n{\r\nmargin: 16px 15px;\r\ntext-align: left;\r\ncolor: #555;\r\nfont-size: 18px;\r\n}\r\n.wdform_section {\r\n	display: inline-block;\r\n	padding: 0px 15px;\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	padding: 2px;\r\n	height: 26px;\r\n	overflow: hidden;\r\n	border: 0px solid #ccc;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/03/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/03/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n}\r\n.wdform-calendar-button:focus {\r\n outline:none; \r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 9px;\r\n	height: 8px;\r\n	background: #A7A7A7;\r\n	border-radius: 0px;\r\n	top: 2px;\r\n	left: 2px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	margin-top: 15px;\r\n	background-color: #DFDFDF;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #A8A8A8;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 0px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	color: #fff;\r\n	background-color: #640B0B;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding-top: 5px;\r\n	padding: 5px 25px 0px 25px;\r\n	font-size: 12px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	background-color: #942323;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 33px;\r\n	text-align: center;\r\n	font-size: 21px;\r\n	padding: 5px 20px 0px 20px;\r\n	margin-bottom: -13px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 18px;\r\n	line-height: 20px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #752D2D ; /* Old browsers */\r\n	background: -moz-linear-gradient(left, #9A0B0B  0%, #7B2828 39%, #752D2D 100%); /* FF3.6+ */\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #9A0B0B ), color-stop(39%, #7B2828 ), color-stop(100%, #752D2D )); /* Chrome,Safari4+ */\r\n	background: -webkit-linear-gradient(left, #9A0B0B 0%, #7B2828 39%, #752D2D 100%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(left, #9A0B0B 0%, #7B2828 39%, #752D2D 100%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(left, #9A0B0B 0%, #7B2828 39%, #752D2D 100%); /* IE10+ */\r\n	background: linear-gradient(to right, #9A0B0B 0%, #7B2828 39%, #752D2D 100%); /* W3C */\r\n	vertical-align: middle;\r\n}\r\n.page_percentage_deactive {\r\n	height: 18px;\r\n	line-height: 20px;\r\n	background-color: #DFDFDF;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: center!important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px -34px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: normal;\r\n	font-size: 12px;\r\nline-height:18px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 20px;\r\n	height: 20px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_percentage_arrow {\r\n	display: inline-block;\r\n	width: 34px;\r\n	height: 18px;\r\n	background: url([SITE_ROOT]/images/03/02/percentage_arrow.png);\r\n	position: relative;\r\n	left: -1px;\r\ntop:0px;\r\n	z-index: 0;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #4D792C;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 31px;\r\n	color: #fff;\r\n	border: 2px solid #68943B;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("11", "Theme 03 dark cyan", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EEEF;\r\nborder: 1px solid #0B7A97;\r\nmargin-bottom: 10px;\r\ncolor: #0B7A97;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 0px;\r\n	border: 1px solid #39680B;\r\n	background: #C9FD9C;\r\n	height: 13px;\r\n	width: 13px;\r\n}\r\n.ui-slider-horizontal .ui-slider-handle {\r\n	top: -5px !important;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover {\r\n	background: #0C6177 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active {\r\n	background: #0C6177 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus {\r\n	background: #0C6177 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover {\r\n	background: #0C6177 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:active {\r\n	background: #0C6177 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:focus {\r\n	background: #0C6177 !important;\r\n	color: #fff;\r\n}\r\nui-state-hover {\r\n	background: #0C6177 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #2796B3 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #fff;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 0px;\r\n	padding: 0px 0px 0px 2px;\r\n	font-size: 13px;\r\n	height: 23px;\r\n	line-height: 23px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 0px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 23px;\r\n	width: 30px;\r\n	background: url([SITE_ROOT]/images/03/03/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 0px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	position: absolute;\r\n	border-radius: 0px;\r\n	height: 23px;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	}\r\n.file-picker {\r\n	width: 32px;\r\n	height: 25px;\r\n	background: url([SITE_ROOT]/images/03/upload.png);\r\n	display: inline-block;\r\n}\r\ndiv.wdform-page-button {\r\n	color: #414141;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 36px;\r\n	background-color: #ACABAB;\r\npadding: 2px 15px;\r\nvertical-align: middle;\r\nborder: none;\r\nfont-size: 15px;\r\n}\r\n\r\n.button-submit {\r\nbackground: #0B7A97;\r\ncursor: pointer;\r\nfont-size: 17px;\r\nmin-width: 80px;\r\nmin-height: 34px;\r\ncolor: #fff;\r\nborder: 2px solid #18627C;\r\nmargin: 5px;\r\nbox-shadow: 0px 0px 1px 1px #56B4D5;\r\nfont-family: Segoe UI;\r\n}\r\n.button-reset {\r\n	background: #D8D6D7;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 2px solid #fff;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px 1px #969495;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_page {\r\n	background: #F0EEEF;\r\n	padding-top: 15px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/03/03/bg.png);\r\n	text-align: left;\r\n	padding: 10px 20px 10px 50px;\r\n	border-radius: 0px;\r\n	-moz-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	-webkit-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	width: 466px;\r\n	text-align: right;\r\n	color: #fff;\r\nfont-size:18px;\r\n}\r\n\r\n.wdform_section_break\r\n{\r\nmargin: 16px 15px;\r\ntext-align: left;\r\ncolor: #555;\r\nfont-size:18px;\r\n}\r\n.wdform_section {\r\n	display: inline-block;\r\n	padding: 0px 15px;\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	padding: 2px;\r\n	height: 26px;\r\n	overflow: hidden;\r\n	border: 0px solid #ccc;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/03/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/03/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n}\r\n.wdform-calendar-button:focus {\r\n outline:none; \r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 9px;\r\n	height: 8px;\r\n	background: #A7A7A7;\r\n	border-radius: 0px;\r\n	top: 2px;\r\n	left: 2px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	margin-top: 15px;\r\n	background-color: #DFDFDF;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #A8A8A8;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 0px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	color: #fff;\r\n	background-color: #0C6177;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding-top: 5px;\r\n	padding: 5px 25px 0px 25px;\r\n	font-size: 12px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	background-color: #2796B3;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 33px;\r\n	text-align: center;\r\n	font-size: 21px;\r\n	padding: 5px 20px 0px 20px;\r\n	margin-bottom: -13px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 18px;\r\n	line-height: 20px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #752D2D ; /* Old browsers */\r\n	background: -moz-linear-gradient(left, #0E6378 0%, #2C7487 39%, #2D7587 100%); /* FF3.6+ */\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #0E6378 ), color-stop(39%, #2C7487 ), color-stop(100%, #2D7587 )); /* Chrome,Safari4+ */\r\n	background: -webkit-linear-gradient(left, #0E6378 0%, #2C7487 39%, #2D7587 100%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(left, #0E6378 0%, #2C7487 39%, #2D7587 100%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(left, #0E6378 0%, #2C7487 39%, #2D7587 100%); /* IE10+ */\r\n	background: linear-gradient(to right, #0E6378 0%, #2C7487 39%, #2D7587 100%); /* W3C */\r\n	vertical-align: middle;\r\n}\r\n.page_percentage_deactive {\r\n	height: 18px;\r\n	line-height: 20px;\r\n	background-color: #DFDFDF;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: center!important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px -34px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: normal;\r\n	font-size: 12px;\r\nline-height:18px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 20px;\r\n	height: 20px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_percentage_arrow {\r\n	display: inline-block;\r\n	width: 34px;\r\n	height: 18px;\r\n	background: url([SITE_ROOT]/images/03/03/percentage_arrow.png);\r\n	position: relative;\r\n	left: -1px;\r\ntop:0px;\r\n	z-index: 0;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #4D792C;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 31px;\r\n	color: #fff;\r\n	border: 2px solid #68943B;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("12", "Theme 03 transparent (salmon button)", ".radio-div input[type=\"radio\"],\r\n.checkbox-div input[type=\"checkbox\"]\r\n{\r\nvisibility: hidden;\r\n}\r\n.wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #D8D6D7;\r\nborder: 1px solid #D8D6D7;\r\nmargin-bottom: 10px;\r\ncolor: #D8D6D7;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	border-radius: 0px;\r\n	border: 1px solid #39680B;\r\n	background: #C9FD9C;\r\n	height: 13px;\r\n	width: 13px;\r\n}\r\n.ui-slider-horizontal .ui-slider-handle {\r\n	top: -5px !important;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #E9E9E9;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover {\r\n	background: #FA8072 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active {\r\n	background: #FA8072 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus {\r\n	background: #FA8072 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover {\r\n	background: #FA8072 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:active {\r\n	background: #FA8072 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:focus {\r\n	background: #FA8072 !important;\r\n	color: #fff;\r\n}\r\nui-state-hover {\r\n	background: #FA8072 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #C9FD9C !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #fff;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	border-radius: 0px;\r\n	padding: 0px 0px 0px 2px;\r\n	font-size: 13px;\r\n	height: 23px;\r\n	line-height: 23px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 0px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 23px;\r\n	width: 30px;\r\n	background: url([SITE_ROOT]/images/03/01/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 0px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	position: absolute;\r\n	border-radius: 0px;\r\n	height: 23px;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	}\r\n.file-picker {\r\n	width: 32px;\r\n	height: 25px;\r\n	background: url([SITE_ROOT]/images/03/upload.png);\r\n	display: inline-block;\r\n}\r\ndiv.wdform-page-button {\r\n	color: #414141;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 36px;\r\n	line-height: 36px;\r\n	background-color: #ACABAB;\r\npadding: 2px 15px;\r\nvertical-align: middle;\r\nborder: none;\r\nfont-size: 15px;\r\n}\r\n\r\n\r\n.button-submit {\r\nbackground: #FA8072;\r\ncursor: pointer;\r\nfont-size: 17px;\r\nmin-width: 80px;\r\nmin-height: 34px;\r\ncolor: #fff;\r\nborder: 2px solid #FFABA1;\r\nmargin: 5px;\r\nbox-shadow: 0px 0px 1px 1px #FF9689;\r\nfont-family: Segoe UI;\r\n	}\r\n.button-reset {\r\n	background: #D8D6D7;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 2px solid #fff;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px 1px #969495;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_page {\r\n	background: transparent;\r\n	padding-top: 15px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/03/01/bg.png);\r\n	text-align: left;\r\n	padding: 10px 20px 10px 50px;\r\n	border-radius: 0px;\r\n	-moz-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	-webkit-box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	box-shadow: 7px -9px 20px -5px rgba(0, 0, 0, 0.23), -7px 9px 20px -5px rgba(0, 0, 0, 0.23);\r\n	width: 466px;\r\n	text-align: right;\r\n	color: #000;\r\nfont-size: 18px;\r\n}\r\n\r\n.wdform_section_break\r\n{\r\nmargin: 16px 15px;\r\ntext-align: left;\r\nfont-size: 18px;\r\ncolor: #555;\r\n}\r\n.wdform_section {\r\n	display: inline-block;\r\n	padding: 0px 15px;\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	padding: 2px;\r\n	height: 26px;\r\n	overflow: hidden;\r\n	border: 0px solid #ccc;\r\n	padding: 2px;\r\n	outline: none;\r\nbackground: #ECECEC;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\nbackground: #ECECEC;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\nbackground: #ECECEC;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 25px;\r\n	border: 0px solid #ccc;\r\n	padding:0 3px !important;\r\nbackground: #ECECEC;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border-color: #FFB471;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/03/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/03/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 22px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n}\r\n.wdform-calendar-button:focus {\r\n outline:none; \r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #A7A7A7;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 9px;\r\n	height: 8px;\r\n	background: #A7A7A7;\r\n	border-radius: 0px;\r\n	top: 2px;\r\n	left: 2px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	margin-top: 15px;\r\n	background-color: #DFDFDF;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #A8A8A8;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n	border-radius: 0px;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	color: #fff;\r\n	background-color: #FF9A8E;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding-top: 5px;\r\n	padding: 5px 25px 0px 25px;\r\n	font-size: 12px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	background-color: #FA8072;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 33px;\r\n	text-align: center;\r\n	font-size: 21px;\r\n	padding: 5px 20px 0px 20px;\r\n	margin-bottom: -13px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 18px;\r\n	line-height: 20px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #FF8F83; /* Old browsers */\r\n	background: -moz-linear-gradient(left, #F7B4AC 0%, #F89F95 39%, #FF8F83 100%); /* FF3.6+ */\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #F7B4AC), color-stop(39%, #F89F95), color-stop(100%, #FF8F83)); /* Chrome,Safari4+ */\r\n	background: -webkit-linear-gradient(left, #F7B4AC 0%, #F89F95 39%, #FF8F83 100%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(left, #F7B4AC 0%, #F89F95 39%, #FF8F83 100%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(left, #F7B4AC 0%, #F89F95 39%, #FF8F83 100%); /* IE10+ */\r\n	background: linear-gradient(to right, #F7B4AC 0%, #F89F95 39%, #FF8F83 100%); /* W3C */\r\n	vertical-align: middle;\r\n}\r\n.page_percentage_deactive {\r\n	height: 18px;\r\n	line-height: 20px;\r\n	background-color: #DFDFDF;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: center!important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px -34px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: normal;\r\n	font-size: 12px;\r\nline-height: 18px;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 20px;\r\n	height: 20px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_percentage_arrow {\r\n	display: inline-block;\r\n	width: 34px;\r\n	height: 18px;\r\n	background: url([SITE_ROOT]/images/03/04/percentage_arrow.png);\r\n	position: relative;\r\n	left: -1px;\r\ntop:0px;\r\n	z-index: 0;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #4D792C;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 31px;\r\n	color: #fff;\r\n	border: 2px solid #68943B;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("13", "Theme 04 dark orange", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EFEF;\r\nborder: 1px solid #F6CE9D;\r\nmargin-bottom: 10px;\r\ncolor: #F6CE9D;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	width: 15px;\r\n	height: 15px;\r\n	top: -5px;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n@font-face {\r\n	font-family: ArTarumianHandes;\r\n	src: url([SITE_ROOT]/css/HANDES.ttf);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #EDE5DA;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #E2B983 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #E2B983 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #E2B983 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #E2B983 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #E2B983 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #E2B983 !important;\r\n	color: #fff;\r\n}\r\nui-state-hover {\r\n	background: #E2B983 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #E5E5E5 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 20px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 20px;\r\n	width: 22px;\r\n	background: url([SITE_ROOT]/images/04/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text] {\r\n	margin: 0px;\r\n}\r\ninput[type=password] {\r\n	margin: 0px;\r\n}\r\ninput[type=url] {\r\n	margin: 0px;\r\n}\r\ninput[type=email] {\r\n	margin: 0px;\r\n}\r\ninput.text {\r\n	margin: 0px;\r\n}\r\ninput.title {\r\n	margin: 0px;\r\n}\r\ntextarea {\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 45px;\r\n	height: 44px;\r\n	background: url([SITE_ROOT]/images/04/upload.png);\r\n	display: inline-block;\r\n}\r\ndiv.wdform-page-button {\r\n	color: #424242;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 39px;\r\n	line-height: 35px;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-weight: 400;\r\n	font-size: 20px;\r\n	border: 1px solid #959595;\r\n	border-radius: 5px;\r\n}\r\ndiv.wdform-page-button:hover {\r\n	color: #69512F;\r\n	border: 1px solid #D89E5F;\r\n	background: #C8A470; /* Old browsers */\r\n	background: -moz-linear-gradient(bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* FF3.6+ */\r\n	background: -webkit-linear-gradient(bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* IE10+ */\r\n	background: linear-gradient(to bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* W3C */\r\n	box-shadow: 0px 0px 5px 0px rgb(221, 221, 221) inset;\r\n}\r\n.button-submit {\r\n	color: #424242 !important;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 39px;\r\n	line-height: 32px;\r\n	padding: 0px 20px 5px;\r\n	vertical-align: middle;\r\n	font-weight: 400 !important;\r\n	font-size: 20px;\r\n	border: 1px solid #959595;\r\n	border-radius: 5px;\r\n	font-family: Segoe UI;\r\nbackground:transparent;\r\n}\r\n.button-submit:hover {\r\n	color: #69512F;\r\n	border: 1px solid #D89E5F;\r\n	background: #C8A470; /* Old browsers */\r\n	background: -moz-linear-gradient(bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* FF3.6+ */\r\n	background: -webkit-linear-gradient(bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* Chrome10+,Safari5.1+ */\r\n	background: -o-linear-gradient(bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* Opera 11.10+ */\r\n	background: -ms-linear-gradient(bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* IE10+ */\r\n	background: linear-gradient(to bottom, #DFC091 0%, #CFAE7B 49%, #C19C67 84%, #AA824E 95%); /* W3C */\r\n	box-shadow: 0px 0px 5px 0px rgb(221, 221, 221) inset;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #F6CE9D;\r\n	padding: 15px 15px 15px 50px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/04/01/bg.png) no-repeat;\r\n	text-align: left;\r\n	border-radius: 0px;\r\n	width: 300px;\r\n	padding: 13px;\r\n	text-align: center;\r\nfont-size: 18px;\r\n}\r\n.wdform_section_break\r\n{\r\nmargin: 16px 10px 16px 0px;\r\ntext-align: left;\r\nfont-size: 18px;\r\n}\r\n.wdform_section {\r\n	display: table-row\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	height: 24px;\r\n	overflow: hidden;\r\n	padding: 2px;\r\nborder: 1px solid #ccc;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus {\r\n	border-color: #E2B983;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus {\r\n	border-color: #E2B983;\r\n	outline: none;\r\n}\r\ntextarea:focus {\r\n	border-color: #E2B983;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 14px;\r\n	height: 14px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	border-radius: 7px;\r\n	position: relative;\r\n	display: inline-block;\r\n	box-shadow: 0px 3px 8px 1px rgb(213, 213, 213) inset;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/02/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 2px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/04/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 20px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 14px;\r\n	height: 14px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	border-radius: 7px;\r\n	position: relative;\r\n	display: inline-block;\r\n	box-shadow: 0px 3px 8px 1px rgb(213, 213, 213) inset;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 10px;\r\n	height: 10px;\r\n	background: #DAA157;\r\n	background: -moz-linear-gradient(bottom, #F8DCB2 0%, #E7C187 49%, #E6BE86 84%, #DAA157 95%);\r\n	background: -webkit-linear-gradient(bottom, #F8DCB2 0%, #E7C187 49%, #E6BE86 84%, #DAA157 95%);\r\n	background: -o-linear-gradient(bottom, #F8DCB2 0%, #E7C187 49%, #E6BE86 84%, #DAA157 95%);\r\n	background: -ms-linear-gradient(bottom, #F8DCB2 0%, #E7C187 49%, #E6BE86 84%, #DAA157 95%);\r\n	background: linear-gradient(to bottom, #F8DCB2 0%, #E7C187 49%, #E6BE86 84%, #DAA157 95%);\r\n	box-shadow: 0px 0px 5px 0px rgb(214, 214, 214) inset;\r\n	border-radius: 7px;\r\n	top: 1px;\r\n	left: 1px;\r\n	border: 1px solid #C0A77E;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding: 5px 20px 0px 20px;\r\n	font-weight: bold;\r\n	background-color: #E2B983;\r\n	margin-left: 1px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	cursor: pointer;\r\n	background-color: #AA824E;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 16px;\r\n	padding: 5px 20px 0px 20px;\r\n	margin-left: 1px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 23px;\r\n	line-height: 23px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #AA824E;\r\n	vertical-align: middle;\r\n	font-family: ArTarumianHandes;\r\n}\r\n.page_percentage_deactive {\r\n	height: 23px;\r\n	line-height: 23px;\r\n	background-color: #E2B983;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: bold;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 20px;\r\n	height: 20px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_percentage_arrow {\r\n	display: inline-block;\r\n	width: 20px;\r\n	height: 23px;\r\n	background-color: #AA824E;\r\n	position: relative;\r\n	left: -14px;\r\n	z-index: 0;\r\n	vertical-align: middle;\r\n	-moz-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-webkit-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-o-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-ms-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("14", "Theme 04 light blue", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EFEF;\r\nborder: 1px solid #CEE4E4;\r\nmargin-bottom: 10px;\r\ncolor: #CEE4E4;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	width: 15px;\r\n	height: 15px;\r\n	top: -5px;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n@font-face {\r\n	font-family: ArTarumianHandes;\r\n	src: url([SITE_ROOT]/css/HANDES.ttf);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #EDE5DA;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #678B94 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #678B94 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #678B94 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #678B94 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #678B94 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #678B94 !important;\r\n	color: #fff;\r\n}\r\nui-state-hover {\r\n	background: #678B94 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #E5E5E5 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 20px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 20px;\r\n	width: 22px;\r\n	background: url([SITE_ROOT]/images/04/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text] {\r\n	margin: 0px;\r\n}\r\ninput[type=password] {\r\n	margin: 0px;\r\n}\r\ninput[type=url] {\r\n	margin: 0px;\r\n}\r\ninput[type=email] {\r\n	margin: 0px;\r\n}\r\ninput.text {\r\n	margin: 0px;\r\n}\r\ninput.title {\r\n	margin: 0px;\r\n}\r\ntextarea {\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 45px;\r\n	height: 44px;\r\n	background: url([SITE_ROOT]/images/04/upload.png);\r\n	display: inline-block;\r\n}\r\ndiv.wdform-page-button {\r\n	color: #424242;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 39px;\r\n	line-height: 35px;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-weight: 400;\r\n	font-size: 20px;\r\n	border: 1px solid #959595;\r\n	border-radius: 5px;\r\n}\r\ndiv.wdform-page-button:hover {\r\ncolor: #fff;\r\nborder: 1px solid #88A1A6;\r\nbackground: #86A0A7 ;\r\nbackground: -moz-linear-gradient(bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbackground: -webkit-linear-gradient(bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbackground: -o-linear-gradient(bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbackground: -ms-linear-gradient(bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbackground: linear-gradient(to bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(221, 221, 221) inset;\r\n}\r\n.button-submit {\r\n	color: #767676 !important;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 39px;\r\n	line-height: 32px;\r\n	padding: 0px 20px 5px;\r\n	vertical-align: middle;\r\n	font-weight: 400 !important;\r\n	font-size: 20px;\r\n	border: 1px solid #959595;\r\n	border-radius: 5px;\r\n	font-family: Segoe UI;\r\nbackground:transparent;\r\n}\r\n.button-submit:hover {\r\ncolor: #fff !important;\r\nborder: 1px solid #88A1A6;\r\nbackground: #86A0A7 ;\r\nbackground: -moz-linear-gradient(bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbackground: -webkit-linear-gradient(bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbackground: -o-linear-gradient(bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbackground: -ms-linear-gradient(bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbackground: linear-gradient(to bottom, #A0C5CF 0%, #95B3BB 49%, #869AA0 84%, #86A0A7 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(221, 221, 221) inset;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #CEE4E4;\r\n	padding: 15px 15px 15px 50px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/04/02/bg.png) no-repeat;\r\n	text-align: left;\r\n	border-radius: 0px;\r\n	width: 300px;\r\npadding: 5px;\r\n	text-align: center;\r\nfont-size: 16px;\r\n}\r\n.wdform_section_break\r\n{\r\nmargin: 16px 10px 16px 0px;\r\ntext-align: left;\r\nfont-size: 18px;\r\n}\r\n.wdform_section {\r\n	display: table-row\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	height: 24px;\r\n	overflow: hidden;\r\n	padding: 2px;\r\nborder: 1px solid #ccc;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus {\r\n	border-color: #678B94;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus {\r\n	border-color: #678B94;\r\n	outline: none;\r\n}\r\ntextarea:focus {\r\n	border-color: #678B94;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 14px;\r\n	height: 14px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	border-radius: 7px;\r\n	position: relative;\r\n	display: inline-block;\r\n	box-shadow: 0px 3px 8px 1px rgb(213, 213, 213) inset;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/02/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 2px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/04/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 20px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 14px;\r\n	height: 14px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	border-radius: 7px;\r\n	position: relative;\r\n	display: inline-block;\r\n	box-shadow: 0px 3px 8px 1px rgb(213, 213, 213) inset;\r\n}\r\n.radio-div label {\r\ncursor: pointer;\r\n-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\nfilter: alpha(opacity=0);\r\nopacity: 0;\r\ncontent: \"\";\r\nposition: absolute;\r\nwidth: 10px;\r\nheight: 10px;\r\nbackground: #63929E ;\r\nbackground: -moz-linear-gradient(bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbackground: -webkit-linear-gradient(bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbackground: -o-linear-gradient(bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbackground: -ms-linear-gradient(bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbackground: linear-gradient(to bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(214, 214, 214) inset;\r\nborder-radius: 7px;\r\ntop: 1px;\r\nleft: 1px;\r\nborder: 1px solid #678B94;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding: 5px 20px 0px 20px;\r\n	font-weight: bold;\r\n	background-color: #88B4BD;\r\n	margin-left: 1px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	cursor: pointer;\r\n	background-color: #678B94;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 16px;\r\n	padding: 5px 20px 0px 20px;\r\n	margin-left: 1px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 23px;\r\n	line-height: 23px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #678B94;\r\n	vertical-align: middle;\r\n	font-family: ArTarumianHandes;\r\n}\r\n.page_percentage_deactive {\r\n	height: 23px;\r\n	line-height: 23px;\r\n	background-color: #88B4BD;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: bold;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 20px;\r\n	height: 20px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_percentage_arrow {\r\n	display: inline-block;\r\n	width: 20px;\r\n	height: 23px;\r\n	background-color: #678B94;\r\n	position: relative;\r\n	left: -14px;\r\n	z-index: 0;\r\n	vertical-align: middle;\r\n	-moz-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-webkit-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-o-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-ms-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("15", "Theme 04 red", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #F0EFEF;\r\nborder: 1px solid #CEE4E4;\r\nmargin-bottom: 10px;\r\ncolor: #CEE4E4;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	width: 15px;\r\n	height: 15px;\r\n	top: -5px;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n@font-face {\r\n	font-family: ArTarumianHandes;\r\n	src: url([SITE_ROOT]/css/HANDES.ttf);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #EDE5DA;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #8A6B63 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #8A6B63 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #8A6B63 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #8A6B63 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #8A6B63 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #8A6B63 !important;\r\n	color: #fff;\r\n}\r\nui-state-hover {\r\n	background: #8A6B63 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #E5E5E5 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 20px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 20px;\r\n	width: 22px;\r\n	background: url([SITE_ROOT]/images/04/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text] {\r\n	margin: 0px;\r\n}\r\ninput[type=password] {\r\n	margin: 0px;\r\n}\r\ninput[type=url] {\r\n	margin: 0px;\r\n}\r\ninput[type=email] {\r\n	margin: 0px;\r\n}\r\ninput.text {\r\n	margin: 0px;\r\n}\r\ninput.title {\r\n	margin: 0px;\r\n}\r\ntextarea {\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 45px;\r\n	height: 44px;\r\n	background: url([SITE_ROOT]/images/04/upload.png);\r\n	display: inline-block;\r\n}\r\ndiv.wdform-page-button {\r\n	color: #424242;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 39px;\r\n	line-height: 35px;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-weight: 400;\r\n	font-size: 20px;\r\n	border: 1px solid #959595;\r\n	border-radius: 5px;\r\n}\r\ndiv.wdform-page-button:hover {\r\ncolor: #fff;\r\nborder: 1px solid #C09F97;\r\nbackground: #86A0A7;\r\nbackground: -moz-linear-gradient(bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbackground: -webkit-linear-gradient(bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbackground: -o-linear-gradient(bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbackground: -ms-linear-gradient(bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbackground: linear-gradient(to bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(221, 221, 221) inset;\r\n}\r\n.button-submit {\r\n	color: #767676 !important;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 39px;\r\n	line-height: 32px;\r\n	padding: 0px 20px 5px;\r\n	vertical-align: middle;\r\n	font-weight: 400 !important;\r\n	font-size: 20px;\r\n	border: 1px solid #959595;\r\n	border-radius: 5px;\r\n	font-family: Segoe UI;\r\nbackground:transparent;\r\n}\r\n.button-submit:hover {\r\ncolor: #fff !important;\r\nborder: 1px solid #C09F97;\r\nbackground: #86A0A7;\r\nbackground: -moz-linear-gradient(bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbackground: -webkit-linear-gradient(bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbackground: -o-linear-gradient(bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbackground: -ms-linear-gradient(bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbackground: linear-gradient(to bottom, #E0B8AF 0%, #CAA298 49%, #BD9E96 84%, #B6958E 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(221, 221, 221) inset;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #E0D0CD;\r\n	padding: 15px 15px 15px 50px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\nmargin: 16px 10px 16px 0px;\r\ndisplay: inline-block;\r\nbackground: url([SITE_ROOT]/images/04/03/bg.png) no-repeat;\r\ntext-align: left;\r\nborder-radius: 0px;\r\nwidth: 300px;\r\npadding: 5px 10px;\r\ntext-align: center;\r\nfont-size: 18px;\r\n}\r\n.wdform_section_break\r\n{\r\nmargin: 16px 10px 16px 0px;\r\ntext-align: left;\r\nfont-size: 18px;\r\n}\r\n.wdform_section {\r\n	display: table-row\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	height: 24px;\r\n	overflow: hidden;\r\n	padding: 2px;\r\nborder: 1px solid #ccc;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus {\r\n	border-color: #8A6B63;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus {\r\n	border-color: #8A6B63;\r\n	outline: none;\r\n}\r\ntextarea:focus {\r\n	border-color: #8A6B63;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 14px;\r\n	height: 14px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	border-radius: 7px;\r\n	position: relative;\r\n	display: inline-block;\r\n	box-shadow: 0px 3px 8px 1px rgb(213, 213, 213) inset;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/02/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 2px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/04/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 20px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 14px;\r\n	height: 14px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	border-radius: 7px;\r\n	position: relative;\r\n	display: inline-block;\r\n	box-shadow: 0px 3px 8px 1px rgb(213, 213, 213) inset;\r\n}\r\n.radio-div label {\r\ncursor: pointer;\r\n-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\nfilter: alpha(opacity=0);\r\nopacity: 0;\r\ncontent: \"\";\r\nposition: absolute;\r\nwidth: 10px;\r\nheight: 10px;\r\nbackground: #B98476 ;\r\nbackground: -moz-linear-gradient(bottom, #CA9B8F 0%, #DBACA0 49%, #B98476 84%, #A38279 95%);\r\nbackground: -webkit-linear-gradient(bottom, #CA9B8F 0%, #DBACA0 49%, #B98476 84%, #A38279 95%);\r\nbackground: -o-linear-gradient(bottom, #CA9B8F 0%, #DBACA0 49%, #B98476 84%, #A38279 95%);\r\nbackground: -ms-linear-gradient(bottom, #CA9B8F 0%, #DBACA0 49%, #B98476 84%, #A38279 95%);\r\nbackground: linear-gradient(to bottom, #CA9B8F 0%, #DBACA0 49%, #B98476 84%, #A38279 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(214, 214, 214) inset;\r\nborder-radius: 7px;\r\ntop: 1px;\r\nleft: 1px;\r\nborder: 1px solid #9B766D;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding: 5px 20px 0px 20px;\r\n	font-weight: bold;\r\n	background-color: #CCAAA3;\r\n	margin-left: 1px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	cursor: pointer;\r\n	background-color: #8A6B63;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 16px;\r\n	padding: 5px 20px 0px 20px;\r\n	margin-left: 1px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 23px;\r\n	line-height: 23px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #8A6B63;\r\n	vertical-align: middle;\r\n	font-family: ArTarumianHandes;\r\n}\r\n.page_percentage_deactive {\r\n	height: 23px;\r\n	line-height: 23px;\r\n	background-color: #CCAAA3;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: bold;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 20px;\r\n	height: 20px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_percentage_arrow {\r\n	display: inline-block;\r\n	width: 20px;\r\n	height: 23px;\r\n	background-color: #8A6B63;\r\n	position: relative;\r\n	left: -14px;\r\n	z-index: 0;\r\n	vertical-align: middle;\r\n	-moz-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-webkit-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-o-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-ms-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("16", "Theme 04 transparent (gray button)", ".radio-div input[type=\"radio\"],\r\n.checkbox-div input[type=\"checkbox\"]\r\n{\r\nvisibility: hidden;\r\n}\r\n.wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #FFFFFF;\r\nborder: 1px solid #A6A6A6;\r\nmargin-bottom: 10px;\r\ncolor: #A6A6A6;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	width: 15px;\r\n	height: 15px;\r\n	top: -5px;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n@font-face {\r\n	font-family: ArTarumianHandes;\r\n	src: url([SITE_ROOT]/css/HANDES.ttf);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #EDE5DA;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #B3B3B3 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #B3B3B3 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #B3B3B3 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #B3B3B3 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #B3B3B3 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #B3B3B3 !important;\r\n	color: #fff;\r\n}\r\nui-state-hover {\r\n	background: #B3B3B3 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #E5E5E5 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 20px;\r\n	line-height: 22px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 20px;\r\n	width: 22px;\r\n	background: url([SITE_ROOT]/images/04/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: 0px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text] {\r\n	margin: 0px;\r\n}\r\ninput[type=password] {\r\n	margin: 0px;\r\n}\r\ninput[type=url] {\r\n	margin: 0px;\r\n}\r\ninput[type=email] {\r\n	margin: 0px;\r\n}\r\ninput.text {\r\n	margin: 0px;\r\n}\r\ninput.title {\r\n	margin: 0px;\r\n}\r\ntextarea {\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 45px;\r\n	height: 44px;\r\n	background: url([SITE_ROOT]/images/04/upload.png);\r\n	display: inline-block;\r\n}\r\ndiv.wdform-page-button {\r\n	color: #424242;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 39px;\r\n	line-height: 35px;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-weight: 400;\r\n	font-size: 20px;\r\n	border: 1px solid #959595;\r\n	border-radius: 5px;\r\n}\r\ndiv.wdform-page-button:hover {\r\ncolor: #fff;\r\nborder: 1px solid #919191;\r\nbackground: #7A7A7A ;\r\nbackground: -moz-linear-gradient(bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbackground: -webkit-linear-gradient(bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbackground: -o-linear-gradient(bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbackground: -ms-linear-gradient(bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbackground: linear-gradient(to bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(221, 221, 221) inset;\r\n}\r\n.button-submit {\r\n	color: #767676 !important;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 39px;\r\n	line-height: 32px;\r\n	padding: 0px 20px 5px;\r\n	vertical-align: middle;\r\n	font-weight: 400 !important;\r\n	font-size: 20px;\r\n	border: 1px solid #959595;\r\n	border-radius: 5px;\r\n	font-family: Segoe UI;\r\nbackground:transparent;\r\n}\r\n.button-submit:hover {\r\ncolor: #fff !important;\r\nborder: 1px solid #919191;\r\nbackground: #7A7A7A ;\r\nbackground: -moz-linear-gradient(bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbackground: -webkit-linear-gradient(bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbackground: -o-linear-gradient(bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbackground: -ms-linear-gradient(bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbackground: linear-gradient(to bottom, #C7C7C7 0%, #A0A0A0 49%, #7A7A7A 84%, #858585 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(221, 221, 221) inset;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 18px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: transparent;\r\n	padding: 15px 15px 15px 50px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	padding-right: 30px !important;\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: url([SITE_ROOT]/images/04/02/bg.png) no-repeat;\r\n	text-align: left;\r\n	border-radius: 0px;\r\n	width: 300px;\r\npadding: 5px;\r\n	text-align: center;\r\nfont-size: 16px;\r\n}\r\n.wdform_section_break\r\n{\r\nmargin: 16px 10px 16px 0px;\r\ntext-align: left;\r\nfont-size: 18px;\r\n}\r\n.wdform_section {\r\n	display: table-row\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	height: 24px;\r\n	overflow: hidden;\r\n	padding: 2px;\r\nborder: 1px solid #ccc;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	border: 1px solid #ccc;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus {\r\n	border-color: #B3B3B3;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus {\r\n	border-color: #B3B3B3;\r\n	outline: none;\r\n}\r\ntextarea:focus {\r\n	border-color: #B3B3B3;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 14px;\r\n	height: 14px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	border-radius: 7px;\r\n	position: relative;\r\n	display: inline-block;\r\n	box-shadow: 0px 3px 8px 1px rgb(213, 213, 213) inset;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \"\";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/02/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 2px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/04/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 20px;\r\n	height: 24px;\r\n	position: relative;\r\n	left: -22px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 14px;\r\n	height: 14px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n	border-radius: 7px;\r\n	position: relative;\r\n	display: inline-block;\r\n	box-shadow: 0px 3px 8px 1px rgb(213, 213, 213) inset;\r\n}\r\n.radio-div label {\r\ncursor: pointer;\r\n-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\nfilter: alpha(opacity=0);\r\nopacity: 0;\r\ncontent: \"\";\r\nposition: absolute;\r\nwidth: 10px;\r\nheight: 10px;\r\nbackground: #63929E ;\r\nbackground: -moz-linear-gradient(bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbackground: -webkit-linear-gradient(bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbackground: -o-linear-gradient(bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbackground: -ms-linear-gradient(bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbackground: linear-gradient(to bottom, #84B8C5 0%, #75A1AC 49%, #63929E 84%, #377483 95%);\r\nbox-shadow: 0px 0px 5px 0px rgb(214, 214, 214) inset;\r\nborder-radius: 7px;\r\ntop: 1px;\r\nleft: 1px;\r\nborder: 1px solid #678B94;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.5;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding: 5px 20px 0px 20px;\r\n	font-weight: bold;\r\n	background-color: #C0C0C0;\r\n	margin-left: 1px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	cursor: pointer;\r\n	background-color: #A8A8A8;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 16px;\r\n	padding: 5px 20px 0px 20px;\r\n	margin-left: 1px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 23px;\r\n	line-height: 23px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	background: #678B94;\r\n	vertical-align: middle;\r\n	font-family: ArTarumianHandes;\r\n}\r\n.page_percentage_deactive {\r\n	height: 23px;\r\n	line-height: 23px;\r\n	background-color: #88B4BD;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #FFFFFF;\r\n	font-weight: bold;\r\n}\r\n.wdform_percentage_title {\r\n	color: #000000;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 20px;\r\n	height: 20px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_percentage_arrow {\r\n	display: inline-block;\r\n	width: 20px;\r\n	height: 23px;\r\n	background-color: #678B94;\r\n	position: relative;\r\n	left: -14px;\r\n	z-index: 0;\r\n	vertical-align: middle;\r\n	-moz-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-webkit-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-o-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	-ms-transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n	transform: scale(1) rotate(0deg) translateX(0px) translateY(0px) skewX(-25deg) skewY(0deg);\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("17", "Theme 05 blue", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #0E7297;\r\nborder: 1px solid #A0CBDB;\r\nmargin-bottom: 10px;\r\ncolor: #A0CBDB;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	width: 14px;\r\n	height: 14px;\r\n	top: -6px;\r\n	border: 2px solid #ccc;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n	content: url([SITE_ROOT]/images/05/01/nextbg_hover.png) url([SITE_ROOT]/images/05/01/previousbg_hover.png);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #CECECE;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #00B4F6 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #00B4F6 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #00B4F6 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #00B4F6 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #00B4F6 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #00B4F6 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\nui-state-hover {\r\n	background: #00B4F6 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\nborder-radius: 0px;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #E5E5E5 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 20px;\r\n	line-height: 20px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 22px;\r\n	width: 27px;\r\n	background: url([SITE_ROOT]/images/05/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: -1px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/05/01/upload.png) no-repeat;\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 32px;\r\n	line-height: 28px;\r\n	background: url([SITE_ROOT]/images/05/01/nextbg.png) no-repeat;\r\n	padding: 0px 20px 0 0;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	margin-right: 20px;\r\n	margin-left: 20px;\r\n	width: 90px;\r\n}\r\n.next-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/05/01/nextbg_hover.png) no-repeat;\r\n	width: 113px;\r\n}\r\n.previous-page div.wdform-page-button {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 32px;\r\n	line-height: 28px;\r\n	background: url([SITE_ROOT]/images/05/01/previousbg.png) no-repeat;\r\n	padding: 0px 0 0 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	margin-right: 20px;\r\n	margin-left: 20px;\r\n	width: 90px;\r\n}\r\n.previous-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/05/01/previousbg_hover.png) no-repeat;\r\n	width: 113px;\r\n}\r\n.button-submit {\r\n	background: url([SITE_ROOT]/images/05/01/submit.png) no-repeat;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 32px;\r\n	color: #fff;\r\n	margin: 5px;\r\n	border: 0px;\r\n	font-family: Segoe UI;\r\n	font-weight: 500;\r\n	padding: 0 12px 0 24px;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #A0CBDB;\r\n	padding:15px 20px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 0px;\r\n	background: #006A91;\r\n	border-radius: 0px;\r\npadding: 6px 10px 15px;\r\ntext-align: center;\r\nfont-size: 18px;\r\ncolor: #fff;\r\nbox-shadow: 0px 3px 5px #4B4B4B;\r\n}\r\n\r\n.wdform-field-section-break2:after {\r\n	content: \" \";\r\n	position: relative;\r\n	width: 97.7%;\r\n	right: 0px;\r\n	bottom: 20px;\r\n	height: 4px;\r\n	-webkit-box-shadow: 0 2px 3px #444141;\r\n	-moz-box-shadow: 0 2px 3px #444141;\r\n	box-shadow: 0 2px 3px #444141;\r\n	display: inline-block;\r\n}\r\n\r\n.wdform_section_break {\r\n	margin: 16px 0px;\r\n	border-radius: 0px;\r\n	text-align: left;\r\nfont-size: 18px;\r\ncolor: #3F3F3F;\r\n}\r\n.wdform_section {\r\n	display: table-row;\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	overflow: hidden;\r\nborder: 1px solid transparent;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border: 1px solid #006A91;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border: 1px solid #006A91;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border: 1px solid #006A91;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #026994;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \" \";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/03/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/05/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 20px;\r\n	height: 21px;\r\n	position: relative;\r\n	left: -19px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #026994;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \" \";\r\n	position: absolute;\r\n	width: 9px;\r\n	height: 8px;\r\n	background: #026994;\r\n	border-radius: 0px;\r\n	top: 2px;\r\n	left: 2px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding: 5px 25px 0px 25px;\r\n	font-weight: bold;\r\n	background-color: #006A91;\r\n	margin-left: 1px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	cursor: pointer;\r\n	background-color: #01B4F6;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 16px;\r\n	padding: 5px 25px 0px 25px;\r\n	margin-left: 1px;\r\n	line-height: 25px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 27px;\r\n	line-height: 27px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	vertical-align: middle;\r\n	background: #018ABE;\r\n	background: -moz-linear-gradient(left, #0079A6 0%, #018ABE 39%, #00B6FA 100%);\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #0079A6), color-stop(39%, #018ABE ), color-stop(100%, #00B6FA ));\r\n	background: -webkit-linear-gradient(left, #0079A6 0%, #018ABE 39%, #00B6FA 100%);\r\n	background: -o-linear-gradient(left, #0079A6 0%, #018ABE 39%, #00B6FA 100%);\r\n	background: -ms-linear-gradient(left, #0079A6 0%, #018ABE 39%, #00B6FA 100%);\r\n	background: linear-gradient(to right, #0079A6 0%, #018ABE 39%, #00B6FA 100%);\r\n	border-top-right-radius: 9px;\r\n	border-bottom-right-radius: 9px;\r\n	box-shadow: 2px 0px 7px #9E9B9B;\r\n}\r\n.page_percentage_deactive {\r\n	height: 27px;\r\n	line-height: 27px;\r\n	background-color: #C4D5DF;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #ffffff;\r\n	font-weight: bold;\r\n}\r\n.wdform_percentage_title {\r\n	color: #6E6E6E;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 27px;\r\n	height: 27px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("18", "Theme 05 green", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #007326;\r\nborder: 1px solid #B6E4CF;\r\nmargin-bottom: 10px;\r\ncolor: #B6E4CF;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	width: 14px;\r\n	height: 14px;\r\n	top: -6px;\r\n	border: 2px solid #ccc;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n	content: url([SITE_ROOT]/images/05/02/nextbg_hover.png) url([SITE_ROOT]/images/05/02/previousbg_hover.png);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #CECECE;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #018D08 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #018D08 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #018D08 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #018D08 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #018D08 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #018D08 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\nui-state-hover {\r\n	background: #018D08 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\nborder-radius: 0px;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #E5E5E5 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 20px;\r\n	line-height: 20px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 22px;\r\n	width: 27px;\r\n	background: url([SITE_ROOT]/images/05/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: -1px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/05/02/upload.png) no-repeat;\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 32px;\r\n	line-height: 28px;\r\n	background: url([SITE_ROOT]/images/05/02/nextbg.png) no-repeat;\r\n	padding: 0px 20px 0 0;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	margin-right: 20px;\r\n	margin-left: 20px;\r\n	width: 90px;\r\n}\r\n.next-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/05/02/nextbg_hover.png) no-repeat;\r\n	width: 113px;\r\n}\r\n.previous-page div.wdform-page-button {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 32px;\r\n	line-height: 28px;\r\n	background: url([SITE_ROOT]/images/05/02/previousbg.png) no-repeat;\r\n	padding: 0px 0 0 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	margin-right: 20px;\r\n	margin-left: 20px;\r\n	width: 90px;\r\n}\r\n.previous-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/05/02/previousbg_hover.png) no-repeat;\r\n	width: 113px;\r\n}\r\n.button-submit {\r\n	background: url([SITE_ROOT]/images/05/02/submit.png) no-repeat;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 32px;\r\n	color: #fff;\r\n	margin: 5px;\r\n	border: 0px;\r\n	font-family: Segoe UI;\r\n	font-weight: 500;\r\n	padding: 0 12px 0 24px;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #B6E4CF;\r\n	padding: 15px 20px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2{\r\n	margin: 16px 0px;\r\n	background: #0D7A31;\r\n	border-radius: 0px;\r\npadding: 6px 10px 15px;\r\ntext-align: center;\r\nfont-size: 18px;\r\ncolor: #fff;\r\nbox-shadow: 0px 3px 5px #4B4B4B;\r\n}\r\n\r\n.wdform-field-section-break2:after {\r\n	content: \" \";\r\n	position: relative;\r\n	width: 97.7%;\r\n	right: 0px;\r\n	bottom: 20px;\r\n	height: 4px;\r\n	-webkit-box-shadow: 0 2px 3px #444141;\r\n	-moz-box-shadow: 0 2px 3px #444141;\r\n	box-shadow: 0 2px 3px #444141;\r\n	display: inline-block;\r\n}\r\n\r\n.wdform_section_break{\r\n	margin: 16px 0px;\r\n	border-radius: 0px;\r\n	text-align: left;\r\nfont-size: 18px;\r\n}\r\n.wdform_section {\r\n	display: table-row;\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	overflow: hidden;\r\nborder: 1px solid transparent;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border: 1px solid #0D7A31;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border: 1px solid #0D7A31;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border: 1px solid #0D7A31;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #0D7A31;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \" \";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/03/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/05/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 20px;\r\n	height: 21px;\r\n	position: relative;\r\n	left: -19px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #0D7A31;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \" \";\r\n	position: absolute;\r\n	width: 9px;\r\n	height: 8px;\r\n	background: #0D7A31;\r\n	border-radius: 0px;\r\n	top: 2px;\r\n	left: 2px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding: 5px 25px 0px 25px;\r\n	font-weight: bold;\r\n	background-color: #018D08;\r\n	margin-left: 1px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	cursor: pointer;\r\n	background-color: #00AC0A;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 16px;\r\n	padding: 5px 25px 0px 25px;\r\n	margin-left: 1px;\r\n	line-height: 25px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 27px;\r\n	line-height: 27px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	vertical-align: middle;\r\n	background: #018F08 ;\r\n	background: -moz-linear-gradient(left, #018D08 0%, #018F08 39%, #00BE0A 100%);\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #018D08 ), color-stop(39%, #018F08 ), color-stop(100%, #00BE0A ));\r\n	background: -webkit-linear-gradient(left, #018D08 0%, #018F08 39%, #00BE0A 100%);\r\n	background: -o-linear-gradient(left, #018D08 0%, #018F08 39%, #00BE0A 100%);\r\n	background: -ms-linear-gradient(left, #018D08 0%, #018F08 39%, #00BE0A 100%);\r\nbackground: linear-gradient(to right, #018D08 0%, #018F08 39%, #00BE0A 100%);\r\n	border-top-right-radius: 9px;\r\n	border-bottom-right-radius: 9px;\r\n	box-shadow: 2px 0px 7px #9E9B9B;\r\n}\r\n.page_percentage_deactive {\r\n	height: 27px;\r\n	line-height: 27px;\r\n	background-color: #CEE0D3;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #ffffff;\r\n	font-weight: bold;\r\n}\r\n.wdform_percentage_title {\r\n	color: #6E6E6E;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 27px;\r\n	height: 27px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("19", "Theme 05 pink", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #B05785;\r\nborder: 1px solid #F6E2ED;\r\nmargin-bottom: 10px;\r\ncolor: #F6E2ED;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	width: 14px;\r\n	height: 14px;\r\n	top: -6px;\r\n	border: 2px solid #ccc;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: #fff !important;\r\n	margin: 7px 0px;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n	content: url([SITE_ROOT]/images/05/03/nextbg_hover.png) url([SITE_ROOT]/images/05/03/previousbg_hover.png);\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #CECECE;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 0px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #B05785 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #B05785 !important;\r\n	color: #fff;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #B05785 !important;\r\n	color: #fff;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #B05785 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #B05785 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #B05785 !important;\r\n	color: #fff;\r\noutline:none;\r\n}\r\nui-state-hover {\r\n	background: #B05785 !important;\r\n	color: #fff;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\nborder-radius: 0px;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #E5E5E5 !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	padding: 2px 0px 2px 2px;\r\n	font-size: 13px;\r\n	height: 20px;\r\n	line-height: 20px;\r\n	overflow: hidden;\r\n	background: #fff;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 22px;\r\n	width: 27px;\r\n	background: url([SITE_ROOT]/images/05/01.png) 50% 50% no-repeat;\r\n	position: absolute;\r\n	top: -1px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 41px;\r\n	height: 32px;\r\n	background: url([SITE_ROOT]/images/05/02/upload.png) no-repeat;\r\n	display: inline-block;\r\n}\r\n.next-page div.wdform-page-button {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 32px;\r\n	line-height: 28px;\r\n	background: url([SITE_ROOT]/images/05/03/nextbg.png) no-repeat;\r\n	padding: 0px 20px 0 0;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	margin-right: 20px;\r\n	margin-left: 20px;\r\n	width: 90px;\r\n}\r\n.next-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/05/03/nextbg_hover.png) no-repeat;\r\n	width: 113px;\r\n}\r\n.previous-page div.wdform-page-button {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 32px;\r\n	line-height: 28px;\r\n	background: url([SITE_ROOT]/images/05/03/previousbg.png) no-repeat;\r\n	padding: 0px 0 0 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	margin-right: 20px;\r\n	margin-left: 20px;\r\n	width: 90px;\r\n}\r\n.previous-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/05/03/previousbg_hover.png) no-repeat;\r\n	width: 113px;\r\n}\r\n.button-submit {\r\n	background: url([SITE_ROOT]/images/05/03/submit.png) no-repeat;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 0px;\r\n	min-width: 80px;\r\n	min-height: 32px;\r\n	color: #fff;\r\n	margin: 5px;\r\n	border: 0px;\r\n	font-family: Segoe UI;\r\n	font-weight: 500;\r\n	padding: 0 12px 0 24px;\r\n}\r\n.button-reset {\r\n	background: transparent;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	min-width: 80px;\r\n	min-height: 34px;\r\n	color: #787878;\r\n	border: 0px;\r\n	margin: 5px;\r\n	font-family: Segoe UI;\r\n	text-decoration: underline;\r\n}\r\n.wdform_page {\r\n	background: #F6E2ED;\r\n	padding: 15px 20px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform-field-section-break {\r\n	text-align: center;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 0px;\r\n	background: #B05785;\r\n	border-radius: 0px;\r\npadding: 6px 10px 15px;\r\ntext-align: center;\r\nfont-size: 18px;\r\ncolor: #fff;\r\nbox-shadow: 0px 3px 5px #4B4B4B;\r\n}\r\n\r\n.wdform-field-section-break2:after {\r\n	content: \" \";\r\n	position: relative;\r\n	width: 97.7%;\r\n	right: 0px;\r\n	bottom: 20px;\r\n	height: 4px;\r\n	-webkit-box-shadow: 0 2px 3px #444141;\r\n	-moz-box-shadow: 0 2px 3px #444141;\r\n	box-shadow: 0 2px 3px #444141;\r\n	display: inline-block;\r\n\r\n}\r\n\r\n.wdform_section_break {\r\n	margin: 16px 0px;\r\n	border-radius: 0px;\r\n	text-align: left;\r\nfont-size: 18px;\r\n}\r\n.wdform_section {\r\n	display: table-row;\r\n}\r\nselect {\r\n	border-radius: 0px;\r\n	height: 22px;\r\n	overflow: hidden;\r\nborder: 1px solid transparent;\r\n	padding: 2px;\r\n	outline: none;\r\n}\r\ninput[type=\"text\"]{\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"password\"]{\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ntextarea {\r\n	border-radius: 0px;\r\n	border: 1px solid transparent;\r\n	height: 20px;\r\n	padding:0 3px !important;\r\n}\r\ninput[type=\"text\"]:focus{\r\n	border: 1px solid #B05785;\r\n	outline: none;\r\n}\r\ninput[type=\"password\"]:focus{\r\n	border: 1px solid #B05785;\r\n	outline: none;\r\n}\r\ntextarea:focus{\r\n	border: 1px solid #B05785;\r\n	outline: none;\r\n}\r\n\r\n.input_deactive {\r\n	color: #999999;\r\n	font-style: italic;\r\n}\r\n.input_active {\r\n	color: #000000;\r\n	font-style: normal;\r\n}\r\n.am_pm_select {\r\n	width: 30px;\r\n	vertical-align: middle;\r\n}\r\n.checkbox-div input[type=checkbox] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.checkbox-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #B05785;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n}\r\n.checkbox-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \" \";\r\n	position: absolute;\r\n	width: 16px;\r\n	height: 13px;\r\n	background: url([SITE_ROOT]/images/03/checkbox.png);\r\n	border-radius: 0px;\r\n	top: -3px;\r\n	left: 1px;\r\n}\r\n.checkbox-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .checkbox-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.checkbox-div input[type=checkbox]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.wdform-calendar-button,\r\n.wdform-calendar-button:hover {\r\n  display:inline-block;\r\n	background: transparent url([SITE_ROOT]/images/05/date.png) no-repeat left 50% !important;\r\n	border: 0px;\r\n	color: transparent;\r\n	width: 20px;\r\n	height: 21px;\r\n	position: relative;\r\n	left: -19px;\r\n	vertical-align: top;\r\n	outline: none;\r\n}\r\n.radio-div input[type=radio] {\r\n	position : absolute;\r\n	z-index: -1;\r\n}\r\n.forlabs {\r\n	float: right;\r\n	margin-right: 20px;\r\n}\r\n.radio-div {\r\n	width: 13px;\r\n	height: 12px;\r\n	background: transparent;\r\n	border: 1px solid #B05785;\r\n	border-radius: 0px;\r\n	position: relative;\r\n	display: inline-block;\r\n	top: 2px;\r\n}\r\n.radio-div label {\r\n	cursor: pointer;\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=0)\";\r\n	filter: alpha(opacity=0);\r\n	opacity: 0;\r\n	content: \" \";\r\n	position: absolute;\r\n	width: 9px;\r\n	height: 8px;\r\n	background: #B05785;\r\n	border-radius: 0px;\r\n	top: 2px;\r\n	left: 2px;\r\n}\r\n.radio-div label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div .wdform-ch-rad-label:hover {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.wdform-ch-rad-label:hover + .radio-div label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=30)\";\r\n	filter: alpha(opacity=30);\r\n	opacity: 0.3;\r\n}\r\n.radio-div input[type=radio]:checked + label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\";\r\n	filter: alpha(opacity=100);\r\n	opacity: 1;\r\n}\r\n.if-ie-div-label {\r\n	-ms-filter: \"progid:DXImageTransform.Microsoft.Alpha(Opacity=100)\" !important;\r\n	filter: alpha(opacity=100) !important;\r\n	opacity: 1 !important;\r\n}\r\n.wdform-ch-rad-label {\r\n	display: inline;\r\n	margin: -4px 5px 5px 5px;\r\n	float: left;\r\n	color: #000;\r\n	cursor: pointer\r\n}\r\ntextarea {\r\n	padding-top: 5px;\r\n}\r\n.wdform-date {\r\n  display:inline-block;\r\n	width: 105px\r\n}\r\n.wdform_footer {\r\n	padding-top: 5px;\r\n	margin-top: 15px;\r\n}\r\n.page-numbers {\r\n	vertical-align: middle;\r\n}\r\n.time_box {\r\n	text-align: right;\r\n	width: 30px;\r\n	vertical-align: middle\r\n}\r\n.mini_label {\r\n	font-size: 10px;\r\n	font-family: \"Lucida Grande\", Tahoma, Arial, Verdana, sans-serif;\r\n	color: #000;\r\n}\r\n.wdform-label {\r\n	border: none;\r\n	color: #000;\r\n	vertical-align: top;\r\n	line-height: 17px;\r\n}\r\n.wdform_colon {\r\n	color: #000\r\n}\r\n.wdform_separator {\r\n	font-style: bold;\r\n	vertical-align: middle;\r\n	color: #000;\r\n}\r\n.wdform_line {\r\n	color: #000\r\n}\r\n.wdform-required {\r\n	border: none;\r\n	color: red;\r\n	vertical-align: top;\r\n}\r\n.captcha_img {\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	cursor: pointer;\r\n}\r\n.captcha_refresh {\r\n	width: 30px;\r\n	height: 30px;\r\n	border-width: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n	cursor: pointer;\r\n	background-image: url([SITE_ROOT]/images/refresh_black.png);\r\n}\r\n.captcha_input {\r\n	height: 20px;\r\n	border-width: 1px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	vertical-align: middle;\r\n}\r\n.file_upload {\r\n	border: 0px solid white;\r\n	border-radius: 0px;\r\n	margin: 0px;\r\n	padding: 0px;\r\n	color: black;\r\n	background-color: white;\r\n}\r\n.page_deactive {\r\n	font-size: 12px;\r\n color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 20px;\r\n	text-align: center;\r\n	vertical-align: bottom;\r\n	padding: 5px 25px 0px 25px;\r\n	font-weight: bold;\r\n	background-color: #D7639F;\r\n	margin-left: 1px;\r\n}\r\n.page_active {\r\n	color: #fff;\r\n	cursor: pointer;\r\n	background-color: #E47DB3;\r\n	display: inline-block;\r\n	vertical-align: bottom;\r\n	height: 25px;\r\n	text-align: center;\r\n	font-size: 16px;\r\n	padding: 5px 25px 0px 25px;\r\n	margin-left: 1px;\r\n	line-height: 25px;\r\n}\r\n.page_percentage_active {\r\n	padding: 0px;\r\n	margin: 0px;\r\n	border-spacing: 0px;\r\n	height: 27px;\r\n	line-height: 27px;\r\n	font-size: 15px;\r\n	float: left;\r\n	text-align: right !important;\r\n	z-index: 1;\r\n	position: relative;\r\n	vertical-align: middle;\r\n	background: #D863A0 ;\r\n	background: -moz-linear-gradient(left, #D7639F 0%, #D863A0 39%, #F173B4 100%);\r\n	background: -webkit-gradient(linear, left top, right top, color-stop(0%, #D7639F ), color-stop(39%, #D863A0 ), color-stop(100%, #F173B4 ));\r\n	background: -webkit-linear-gradient(left, #D7639F 0%, #D863A0 39%, #F173B4 100%);\r\n	background: -o-linear-gradient(left, #D7639F 0%, #D863A0 39%, #F173B4 100%);\r\n	background: -ms-linear-gradient(left, #D7639F 0%, #D863A0 39%, #F173B4 100%);\r\nbackground: linear-gradient(to right, #D7639F 0%, #D863A0 39%, #F173B4 100%);\r\n	border-top-right-radius: 9px;\r\n	border-bottom-right-radius: 9px;\r\n	box-shadow: 2px 0px 7px #9E9B9B;\r\n}\r\n.page_percentage_deactive {\r\n	height: 27px;\r\n	line-height: 27px;\r\n	background-color: #D6CAD2;\r\n	text-align: left !important;\r\n	margin-bottom: 1px;\r\n}\r\n.page_numbers {\r\n	font-size: 14px;\r\n	color: #000;\r\n}\r\n.phone_area_code {\r\n	width: 50px;\r\n}\r\n.phone_number {\r\n	width: 100px;\r\n}\r\nbutton {\r\n	cursor: pointer;\r\n}\r\n.other_input {\r\n	border-radius: 0px;\r\n	border-width: 1px;\r\n	height: 16px;\r\n	font-size: 12px;\r\n	padding: 1px;\r\n	margin: 1px;\r\n	margin-left: 25px;\r\n	z-index: 100;\r\n	position: absolute;\r\n}\r\n.wdform_page_navigation {\r\n	text-align: right !important;\r\n	margin-bottom: 0px;\r\n}\r\n.wdform_percentage_text {\r\n	margin: 3px 5px 3px 9px;\r\n	color: #ffffff;\r\n	font-weight: bold;\r\n}\r\n.wdform_percentage_title {\r\n	color: #6E6E6E;\r\n	font-style: italic;\r\n	margin: 0px 0px 0px 40px;\r\n	display: inline-block;\r\n	line-height: 27px;\r\n	height: 27px;\r\n	vertical-align: middle;\r\n}\r\n.wdform_button button {\r\n	background: #0E4D92;\r\n	cursor: pointer;\r\n	font-size: 17px;\r\n	border-radius: 4px;\r\n	min-width: 80px;\r\n	min-height: 27px;\r\n	color: #fff;\r\n	border: 2px solid #0E3F77;\r\n	margin: 5px;\r\n	box-shadow: 0px 0px 2px #c9c9c9;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_button button:active {\r\n	border: 2px solid #0B2D52;\r\n	background: #0E3F77;\r\n}", "0");
INSERT INTO `wp_udange_contactformmaker_themes` VALUES("20", "Theme 06 turquoise", ".wdform-page-and-images .other_input\r\n{\r\nmax-width: none;\r\n}\r\nbutton,\r\ninput,\r\nselect,\r\ntextarea\r\n{\r\nfont-size:14px;\r\n}\r\n.warning,\r\n.error\r\n{\r\nbackground-color: #B1EBE9;\r\nborder: 1px solid #018580;\r\nmargin-bottom: 10px;\r\ncolor: #018580;\r\npadding: 5px;\r\n}\r\n.warning *,\r\n.error *\r\n{\r\nmargin:0;\r\n}\r\n.recaptcha_input_area input\r\n{\r\nheight:initial !important;\r\n}\r\na.ui-slider-handle {\r\n	width: 16px;\r\n	height: 16px;\r\n	top: -6px;\r\n	border: 0px;\r\n	border-radius: 13px;\r\n	background: #fff;\r\n	border: 1px solid #ccc;\r\n}\r\n.ui-slider {\r\n	height: 6px;\r\n	background: transparent !important;\r\n	margin: 7px 0px;\r\nborder:1px solid #ABAAAA !important;\r\n}\r\n.wdform_grading input {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell input[type=\"text\"] {\r\n	width: 100px;\r\n}\r\n.wdform-matrix-cell select {\r\n	width: 60px;\r\n}\r\n.wdform_section .wdform_column:last-child {\r\n	padding-right: 0px !important;\r\n}\r\n.wdform_preload {\r\n	display: none;\r\n}\r\n.wdform_grading {\r\n	padding: 3px 0px;\r\n}\r\n.wdform-matrix-table {\r\n	display: table;\r\n	border-spacing: 0px;\r\n}\r\n.wdform-matrix-column {\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-matrix-cell {\r\n	text-align: center;\r\n	display: table-cell;\r\n	padding: 6px 10px;\r\n}\r\n.wdform-matrix-head>div {\r\n	display: table-cell;\r\n	text-align: center;\r\n}\r\n.wdform-matrix-head {\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row0 {\r\n	background: #DFDFDF;\r\n	display: table-row;\r\n}\r\n.wdform-matrix-row1 {\r\n	background: #CECECE;\r\n	display: table-row;\r\n}\r\n.selected-text {\r\n	text-align: left;\r\n}\r\n.wdform-quantity {\r\n	width: 30px;\r\n	margin: 2px 0px;\r\n}\r\n.wdform_scale_rating label {\r\n	vertical-align: middle;\r\n}\r\n.ui-corner-all {\r\n	border-radius: 3px;\r\n}\r\n.ui-widget-content {\r\n	border: 0px;\r\n	background: transparent;\r\n}\r\na.ui-spinner-button:hover{\r\n	background: #029A95 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:active{\r\n	background: #029A95 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-spinner-button:focus{\r\n	background: #029A95 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:hover{\r\n	background: #029A95 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:active{\r\n	background: #029A95 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\na.ui-slider-handle:focus{\r\n	background: #029A95 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\nui-state-hover {\r\n	background: #029A95 !important;\r\n	color: #fff;\r\n	outline: none;\r\n}\r\n.ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-content .ui-state-default{\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-widget-header .ui-state-default {\r\n	border: 1px solid #d3d3d3;\r\n	background: #DFDDDD;\r\n	font-weight: normal;\r\n	color: #555555;\r\n}\r\n.ui-slider-range {\r\n	background: #ccc !important;\r\n}\r\n.wdform_map {\r\n	border: 6px solid #DCDCDC;\r\n}\r\n.wdform-page-and-images {\r\n	width: 100%;\r\n	border: 0px !important;\r\n}\r\n.paypal-property {\r\n	display: inline-block;\r\n	margin-right: 15px;\r\n	vertical-align: middle;\r\n}\r\n.sel-wrap {\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	width:100%;\r\n}\r\n.sel-wrap select {\r\n	position: absolute;\r\n z-index:-1;\r\n width: 0px !important;\r\n}\r\n.sel-imul {\r\n	display: inline-block;\r\n}\r\n.sel-imul .sel-selected {\r\n	cursor: pointer;\r\n	position: relative;\r\n	display: inline-block;\r\n	padding: 2px 0px 2px 4px;\r\n	font-size: 13px;\r\n	height: 23px;\r\n	line-height: 20px;\r\n	overflow: hidden;\r\n	background: transparent;\r\n	background-position: right 2px center;\r\n	width: 100%;\r\n	border: 1px solid #ABAAAA;\r\n	border-radius: 7px;\r\n	color: #4C4C4C;\r\n}\r\n.sel-imul.act .sel-selected {\r\n	background: #fff;\r\n}\r\n.sel-selected .sel-arraw {\r\n	height: 25px;\r\n	width: 28px;\r\n	background: url([SITE_ROOT]/images/06/01.png) no-repeat 0% 50%;\r\n	position: absolute;\r\n	top: -1px;\r\n	right: 0px;\r\n	padding: 2px;\r\n}\r\n.sel-imul .sel-options {\r\n	background: #fff;\r\n	border: 1px solid #dbdbdb;\r\n	border-top: none;\r\n	position: absolute;\r\n	width: inherit;\r\n	display: none;\r\n	z-index: 10;\r\n	max-height: 200px;\r\n	overflow-y: auto;\r\n	overflow-x: hidden;\r\n}\r\n.sel-options .sel-option {\r\n	padding: 3px 4px;\r\n	font-size: 13px;\r\n	border: 1px solid #fff;\r\n	border-right: none;\r\n	border-left: none;\r\n	text-align: left;\r\n}\r\n.sel-options .sel-option:hover {\r\n	border-color: #dbdbdb;\r\n	cursor: pointer;\r\n}\r\n.sel-options .sel-option.sel-ed {\r\n	background: #dbdbdb;\r\n	border-color: #dbdbdb;\r\n}\r\ninput[type=text]{\r\n	margin: 0px;\r\n}\r\ninput[type=password]{\r\n	margin: 0px;\r\n}\r\ninput[type=url]{\r\n	margin: 0px;\r\n}\r\ninput[type=email]{\r\n	margin: 0px;\r\n}\r\ninput.text{\r\n	margin: 0px;\r\n}\r\ninput.title{\r\n	margin: 0px;\r\n}\r\ntextarea{\r\n	margin: 0px;\r\n}\r\nselect {\r\n	margin: 0px;\r\n}\r\n.form-error {\r\n	border-color: red !important;\r\n}\r\n.form-error:focus {\r\n	border-color: red !important;\r\n}\r\n\r\n.wdform-field {\r\n	display: table-cell;\r\n	padding: 5px 0px;\r\n}\r\n.wdform-label-section{\r\n	text-align: left;\r\n	display: table-cell;\r\n}\r\n.wdform-element-section {\r\n	text-align: left;\r\n	display: table-cell;\r\n	min-width: 140px;\r\n}\r\n.file-upload input {\r\n	position: absolute;\r\n	visibility: hidden;\r\n}\r\n.file-upload-status {\r\n	margin-left: 10px;\r\n	max-width: 200px;\r\n	font-weight: bold;\r\n	font-size: 16px;\r\n	color: #888;\r\n	background: #fff;\r\n	position: absolute;\r\n	border-radius: 4px;\r\n	height: 24px;\r\n	border: 1px solid #ccc;\r\n	padding-left: 5px;\r\n	padding-right: 5px;\r\n	white-space: nowrap;\r\n	overflow: hidden;\r\n	direction: rtl;\r\n	padding-top: 3px;\r\n	margin-top: 2px;\r\n}\r\n.file-picker {\r\n	width: 66px;\r\n	height: 49px;\r\n	background: url([SITE_ROOT]/images/06/upload.png) no-repeat;\r\n	display: inline-block;\r\n}\r\n.next-page\r\n{\r\n        width:inherit !important;\r\n}\r\n.next-page div.wdform-page-button {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 35px;\r\n	line-height: 32px;\r\n	background: url([SITE_ROOT]/images/06/next.png) no-repeat right #019993;\r\n 	padding: 0px 36px 0 20px ;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	margin-right: 20px;\r\n	margin-left: 20px;\r\n	border: 1px solid #018580;\r\n\r\n}\r\n.next-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/06/next.png) no-repeat right #00C5BD;\r\n}\r\n.previous-page\r\n{\r\n        width:inherit !important;\r\n}\r\n.previous-page div.wdform-page-button {\r\n	color: #A2A2A2;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 35px;\r\n	line-height: 35px;\r\n	background: url([SITE_ROOT]/images/06/previous.png) no-repeat left #F0EFEF;\r\n	padding: 0 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	margin-right: 20px;\r\n	margin-left: 20px;\r\n	border: 1px solid #959595;\r\n}\r\n.previous-page div.wdform-page-button:hover {\r\n	background: url([SITE_ROOT]/images/06/previous.png) no-repeat left #E8E8E8;\r\n}\r\n.previous-page div.wdform-page-button:before {\r\n	content: \" \";\r\n	background: url([SITE_ROOT]/images/06/previous.png) no-repeat left;\r\n	height: 19px;\r\n	width: 20px;\r\n	display: inline-block;\r\n	vertical-align: middle;\r\n	top: -2px;\r\n	position: relative;\r\n}\r\n.button-submit {\r\n	color: #ffffff;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 35px;\r\n	line-height: 35px;\r\n	background: #019993;\r\n	padding: 0px 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	border: 1px solid #018580;\r\n}\r\n.button-submit:hover {\r\n	background: #00C5BD;\r\n}\r\n.button-reset {\r\n	color: #A2A2A2;\r\n	cursor: pointer;\r\n	display: inline-block;\r\n	height: 35px;\r\n	line-height: 35px;\r\n	background: #F0EFEF;\r\n	padding: 0 20px;\r\n	vertical-align: middle;\r\n	font-size: 18px;\r\n	border: 1px solid #959595;\r\n	margin-left: 5px;\r\n}\r\n.button-reset:hover {\r\n	background: #E8E8E8;\r\n}\r\n.wdform_page {\r\n	background: #B1EBE9;\r\n	padding: 15px;\r\n	border-radius: 0px;\r\n	font-family: Segoe UI;\r\n}\r\n.wdform_column {\r\n	float: left;\r\n	border-spacing: 2px;\r\n	border-collapse: separate !important;\r\n}\r\n.wdform_column>div {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_column>.wdform_row:last-child {\r\n	border-bottom: 0px solid #E7E7E7;\r\n}\r\n.wdform_section_break2 {\r\n	margin: 16px 10px 16px 0px;\r\n	display: inline-block;\r\n	background: #029A95;\r\n	color: #ffffff !important;\r\n	font-size: 16px;\r\n	text-align: left;\r\npadding: 7px 30px 10px;\r\n}\r\n\r\n.wdform_section_break2 p{\r\n	color: #ffffff !important;\r\n	\r\n}\r\n\r\n.wdform_section_break2:after {\r\n	content: \" \" ;\r\n	position: relative;\r\n	width: 16px;\r\n	height: 13px;\r\n	top: -3px;\r\n	left: 1px;\r\n	box-shadow: 0